
; Listing11i1.s	- Vollbild-Farbscrolling PAL

	SECTION	COPPERADVANCED,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"		; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001010000000	; nur Copper DMA

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)

Start:
	bsr.w	MakeCop				; Copperlist erstellen

	lea	$dff000,a5
	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Copper
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$12c00,d2			; warte auf Zeile $12c
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $12c
	bne.s	WarteY1

	btst	#2,$16(a5)			; rechte Maustaste gedrckt?
	beq.s	Mouse2				; wenn ja ColorScrollPAL nicht ausfhren

	bsr.s	ColorScrollPAL		; Scrollen von Farben

Mouse2:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$12c00,d2			; warte auf Zeile $12c
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $12c
	beq.s	WarteY2

	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse
	rts

*****************************************************************************
;	Routine die die Copperlist erstellt
*****************************************************************************

;	   .__ _  __..... .   .    .
;	-\-'_ \\// _`-/-- -  -    -
;	  \(-)____(-)/// /  /    /
;	  -'_/V""V\_`- _  _    _
;	    \ \    /__ _  _    _
;	     \ \,,/__ _  _    _
;	        \/-Mo!

MakeCop:
	lea	Copperlist,a0			; Adresse der zu erledigenden Copperlist
	move.l	#$1f07fffe,d0		; WAIT-Anweisung, erste Zeile $1f
								; dh WAIT starten
	move.l	#$0007fffe,d1		; Letzte NTSC-Zeile der Copperlist
								; dh endgltiges WAIT
	bsr.w	MakeColors			; Mache dieses Stck Copperliste
								; von $1f bis $ff, dh der NTSC-Teil

	move.l	#$ffdffffe,(a0)+	; Wait Besonders, um auf das Ende 
								; des NTSC-Bereichs zu warten.
	move.l	#$0007fffe,d0		; Erste Zeile des PAL-Bereichs (WAIT)
								; dh WAIT starten
	move.l	#$3707fffe,d1		; Letzte Zeile am unteren Bildschirmrand
								; dh endgltiges WAIT
	bsr.s	MakeColors2			; Mache das PAL-Stck der Copperlist
	move.l	#$fffffffe,(a0)+	; Ende Copperlist
	rts


*****************************************************************************
; SubRoutine, die die Copperliste erstellt - in a0 die Adresse der
; Copperliste, in d0 die erste Wartezeit, in d1 die letzte
*****************************************************************************

;	  _    _  _ ___
;	(( _ \--/ _ ) )
;	\_\(/__\)/_/
;	 \-'_/VV\_`-/
;	 \\_\'  `/_/   
;	  \ \\..//
;	   \ `\/'

MakeColors:
	lea	ColorTab(pc),a1			; Adresse Farbtabelle
MakeColors2:
	move.l	d0,(a0)+			; Gebe das WAIT in die coplist ein
	move.w	#$0180,(a0)+		; Gebe das Register COLOR00 ein 
	move.w	(a1)+,(a0)+			; Und die Farbe von der Tabelle
	cmp.l	#EndColorTab,a1		; sind wir bei der letzten Farbe der Tabelle?
	bne.s	LabelOk				; Noch nicht? dann geh nicht
	lea	ColorTab(pc),a1			; ansonsten von der ersten Farbe beginnen
LabelOk:
	addi.l	#$01000000,d0		; Erhhe die Y-Position von WAIT
	cmp.l	d0,d1				; Haben wir bis zum letzten Mal gewartet?
	bne.s	MakeColors2			; Wenn noch nicht, machen Sie eine andere Zeile
	rts


*****************************************************************************
; Routine die die Farben bewegt
*****************************************************************************

;	 \  /
;	  oO
;	 \__/

ColorScrollPAL:
	move.l	PointerColTab(pc),a0	; PointerColTab in a0
	lea	Copperlist+6,a1			; Adresse der ersten Farbe in der Copperlist
	move.l	#225-1,d0			; 225 Farben im Bereich NTSC bewegen
	bsr.s	Scroll				; Scrollen durch den NTSC-Teil des Bildschirms
	addq.w	#4,a1				; berspringen Sie die spezielle Wartezeit am Ende
								; der NTSC Zone ($ffdffffe)
	moveq	#54-1,d0			; 54 Farben im Bereich PAL bewegen
	bsr.s	Scroll				; Scrollen durch den PAL-Teil des Bildschirms

	lea.l	PointerColTab(pc),a0	; PointerColTab in a0
	addq.l	#2,(a0)				; Eine Farbe fr die nchste vorrcken
								; routinemige Ausfhrung
	cmp.l	#EndColorTab,(a0)	; sind wir bei der letzten Farbe 
								; der Tabelle angekommen??
	bne.s	DoNotStartAgain		; Wenn wir noch nicht aus der Routine sind
	move.l  #ColorTab,(a0)		; Ansonsten fange von der Tabelle 
								; von vorne an
DoNotStartAgain:
	rts

*****************************************************************************
; Subroutine, die die Farben verschiebt; die Anzahl der Farben muss in d0 
; eingegeben werden, die Farbtabellenadresse in a0
; und die Farben in Copperlist in a1
*****************************************************************************

Scroll:
	move.w	(a0)+,(a1)			; Kopiere die Farbe aus der Tabelle in die
								; Copperlist
	cmp.l	#EndColorTab,a0		; haben wir die letzte Farbe 
								; von der Tabelle kopiert?
	bne.s	Okay				; Wenn noch nicht, weiter machen
	lea	ColorTab(pc),a0			; ColorTab in a0 - von der ersten 
								; Tabellenfarbe starten
Okay:
	addq.w	#8,a1				; Gehe zur nchsten Farbe in Copperlist
	dbra	d0,Scroll			; d0 = Anzahl der einzugebenden Farben
	rts


;	Tabelle mit RGB-Farben

ColorTab:
	dc.w	$000,$100,$200,$300,$400,$500,$600,$700
	dc.w	$800,$900,$a00,$b00,$c00,$d00,$e00,$f00
	dc.w	$e00,$d00,$c00,$b00,$a00,$900,$800,$700
	dc.w	$600,$500,$400,$300,$200,$100,$000,$010
	dc.w	$020,$030,$040,$050,$060,$070,$080,$090
	dc.w	$0a0,$0b0,$0c0,$0d0,$0e0,$0f0,$0e0,$0d0
	dc.w	$0c0,$0b0,$0a0,$090,$080,$070,$060,$050
	dc.w	$040,$030,$020,$010,$000,$001,$002,$003
	dc.w	$004,$005,$006,$007,$008,$009,$00a,$00b
	dc.w	$00c,$00d,$00e,$00f,$00e,$00d,$00c,$00b
	dc.w	$00a,$009,$008,$007,$006,$005,$004,$003
	dc.w	$002,$001
EndColorTab:

;	Dies ist der Zeiger auf die ColorTabel-Tabelle

PointerColTab:
	dc.l	ColorTab+2

*****************************************************************************
; Copperliste vollstndig aus der MakeCop-Routine erstellt; auf diese Weise
; mache einfach einen BSS-Abschnitt!
*****************************************************************************

	SECTION	COPPERLIST,BSS_C

Copperlist:
	ds.b	225*8				; Platz fr die Flche NTSC
	ds.b	4					; Platz fr die $ffdffffe
	ds.b	55*8				; Platz fr die Flche PAL
	ds.b	4					; Platz fr das Ende von Copperlist $fffffffe

	end
             