
; Listing11h.s	Verwenden von COP2LC ($dff084), um eine dynamische Copperliste zu erstellen,
; Das ist eine Copperliste, die bei jedem Frame zwischen 2 Copperlisten wechselt
; um die Glaubwrdigkeit eine Nuance "zu erhhen".
; Rechtsklick, um den Unterschied zu sehen!

	SECTION	COPPERADVANCED,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s" ; speichern Sie Interrupt, DMA und so weiter.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001110000000	; nur Copper und Bitplane DMA

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)

Start:
	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

;	Zeiger alle Sprites auf das Sprite null

	move.l	#SpriteNull,d0		; Adresse von Sprite in d0
	lea	SpritePointers,a1		; Zeiger in Copperlist
	moveq	#8-1,d1				; alle 8 Sprite
NulLoop:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	addq.w	#8,a1
	dbra	d1,NulLoop

	bsr.w	InitCops			; Erstelle die 2 Copperlisten zum "Tauschen"

	lea	$dff000,a5
	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper		
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$13000,d2			; warte auf Zeile $130 (304)
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $130 (304)
	bne.s	WarteY1

	btst	#2,$16(a6)			; rechte Maustaste gedrckt?
	beq.s	NotSwap				; Wenn nicht tauschen (netter Unsinn!)

	movem.l	CoppPointer1(pc),d0-d1	; Stellen Sie die Adressen von den 2 Copperlisten 
								; in d0 und in d1 mit nur einem MOVEM ein
	move.l	d0,CoppPointer2		; Ordnung umtauschen ...
	move.l	d1,CoppPointer1		; ...
	move.w	d1,Cop2lcl			; Und schreiben Sie die andere copperliste2
	swap	d1					; als nchstes zu springen
	move.w	d1,Cop2lch			; die COPJMP2 ($dff08a)

NotSwap:
	bsr.w	PrintCharacter		; Drucke jeweils ein Zeichen

	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$13000,d2			; warte auf Zeile $130 (304)
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $130 (304)
	beq.s	WarteY2

	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse
	rts							; Exit


CoppPointer1:
		dc.l	ColInt1
CoppPointer2:
		dc.l	ColInt2

*****************************************************************************
* Routine, die die 2 Copperlisten erstellt, die angezeigt werden sollen		*
* abwechselnd auf COP2LC zeigen und mit COPJMP2 starten					    *
*****************************************************************************

;	  _________________
;	 /                 \
;	 \   ___     ___   /
;	__\  (__)   (__)  /__
;	\__\___  ` '  ___/__/
;	     \ \...../ /
;	      \_______/gm


COLSTART	equ	$660			; Startfarbe = gelb
COLTENDENCE	equ	$001			; Trend (Mehrwert bei jedem Wait)

InitCops:
	move.l	#$4407fffe,d0		; Wait - Beginne mit der horizontalen Zeile $44
	move.l	#$1800000,d1		; COLOR00
	move.w	#COLSTART,d2		; Color beim Start
	move.w	#COLTENDENCE,d3		; Zieltrend ($001/$010/$100)
	moveq	#2-1,d5				; 2 Copperlisten zu tun
	lea	ColInt1,a1				; erste Copperlist
MakeCop:
	move.w	d2,d1				; Kopie colstart in d1 (in $180xxxx!)
	move.l	d0,(a1)+			; Setzen des WAIT in coplist
	move.l	d1,(a1)+			; Setzen des $180xxxx (COLOR00) in coplist
	add.l	#$05000000,d0		; wait 5 Zeilen unter dem nchsten Mal
	move.l	d0,(a1)+			; Setzen wait
	move.l	d1,(a1)+			; Setzen des $180xxxx (COLOR00)
	add.l	#$05000000,d0		; wait 5 Zeilen weiter unten
	move.w	d2,d4				; Kopie des colstart in d4
	and.w	#$00f,d4			; Whle nur die BLAUE Komponente
	cmp.w	#$00f,d4			; ist es maximal?
	beq.s	EndCop				; wenn ja, EndCop!
	move.w	d2,d4				; Ansonsten sehen wir das Grn:
	and.w	#$0f0,d4			; Whle nur die grne Komponente.
	cmp.w	#$0f0,d4			; ist es maximal?
	beq.s	EndCop				; wenn ja, EndCop!
	move.w	d2,d4
	and.w	#$f00,d4			; Whle nur die rote Komponente.
	cmp.w	#$f00,d4			; ist es maximal?
	beq.s	EndCop				; wenn ja, ENDCOP!
	add.w	d3,d2				; COLTENDENCE zu COLORSTART hinzufgen
	bra.s	MakeCop				; Und es geht weiter...
EndCop:
	move.l	#$fffffffe,d0		; Ende Copperlist in d0
	move.w	d2,d1				; Kopie COLORSTART in d1
	move.l	d0,(a1)+			; Ende Copperlist
	move.l	#$4907fffe,d0
	move.l	#$1800000,d1
	move.w	#COLSTART,d2
	move.w	#COLTENDENCE,d3
	lea	ColInt2,a1
	dbf	d5,MakeCop
	rts


*****************************************************************************
;			Druck Routine 
*****************************************************************************

PrintCharacter:
	movem.l	d2/a0/a2-a3,-(sp)
	move.l	PointerText(pc),a0	; Adresse des zu druckenden Textes in a0
	moveq	#0,d2				; lschen d2
	move.b	(a0)+,d2			; Nchstes Zeichen in d2
	cmp.b	#$ff,d2				; Ende des Textsignals? ($ff)
	beq.s	EndText				; Wenn ja, beende ohne zu drucken
	tst.b	d2					; Zeilenende-Signal? ($00)
	bne.s	NotEndLine			; Wenn nicht, nicht beenden

	add.l	#40*7,PointerBitplane	; Gehen wir zum Kopf
	addq.l	#1,PointerText		; erste Zeichenzeile nach
								; (berspringe die NULL)
	move.b	(a0)+,d2			; erstes Zeichen der Zeile nach
								; (berspringe die NULL)

NotEndLine:
	sub.b	#$20,d2				; ZHLE 32 VOM ASCII-WERT DES BUCHSTABEN WEG
								; SOMIT VERWANDELN WIR Z.B. DAS LEERZEICHEN
								; (Das $20 entspricht), IN $00, DAS
								; AUSRUFUNGSZEICHEN ($21) IN $01...
	lsl.w	#3,d2				; MULTIPLIZIERE DIE ERHALTENE ZAHL MIT 8,
								; da die Charakter ja 8 Pixel hoch sind
	move.l	d2,a2
	add.l	#Font,a2			; FINDEN SIE DAS GEWNSCHTE ZEICHEN IN DER SCHRIFTART...

	move.l	PointerBitplane(pc),a3 ; Adresse der Ziel-Bitplane in a3

								; WIR DRUCKEN DAS ZEICHEN ZEILENWEISE
	move.b	(a2)+,(a3)			; Drucke Zeile 1 des Zeichens
	move.b	(a2)+,40(a3)		; Drucke Zeile 2  " "
	move.b	(a2)+,40*2(a3)		; Drucke Zeile 3  " "
	move.b	(a2)+,40*3(a3)		; Drucke Zeile 4  " "
	move.b	(a2)+,40*4(a3)		; Drucke Zeile 5  " "
	move.b	(a2)+,40*5(a3)		; Drucke Zeile 6  " "
	move.b	(a2)+,40*6(a3)		; Drucke Zeile 7  " "
	move.b	(a2)+,40*7(a3)		; Drucke Zeile 8  " "

	addq.l	#1,PointerBitplane	; wir bewegen uns 8 Bits vorwrts (NCHSTES ZEICHEN)
	addq.l	#1,PointerText		; nchstes zu druckendes Zeichen

EndText:
	movem.l	(sp)+,d2/a0/a2-a3
	rts


PointerText:
	dc.l	Text

PointerBitplane:
	dc.l	Bitplane

;	$00 fr "Zeilenende" - $ff fr "Textende"

		; Anzahl der Zeichen pro Zeile: 40
Text:	     ;		  1111111111222222222233333333334
             ;   1234567890123456789012345678901234567890
	dc.b	'                                        ',0 ; 1
	dc.b	'    Questo listato utilizza il COP2LC   ',0 ; 2	Dieses Listing verwendet den COP2LC
	dc.b	'                                        ',0 ; 3
	dc.b	'    ($dff084) per far saltare, ad una   ',0 ; 4	($dff084) springen, von einer
	dc.b	'                                        ',0 ; 5
	dc.b	'    certa linea video, ad un altra      ',0 ; 6	bestimmten Videozeile zu einer anderen
	dc.b	'                                        ',0 ; 7
	dc.b	'    Copperlist. Al termine di questa    ',0 ; 8	Copperlist. Am Ende davon
	dc.b	'                                        ',0 ; 9
	dc.b	'    riparte sempre e comunque la        ',0 ; 10	immer und in jedem Fall die
	dc.b	'                                        ',0 ; 11
	dc.b	'    Copperlist 1 (in $dff180). Dunque   ',0 ; 12   Copperlist 1 (in $dff180). So
	dc.b	'                                        ',0 ; 13
	dc.b	'    basta cambiare solo la cop2 a cui   ',0 ; 14	ndere einfach den cop2 an dem
	dc.b	'                                        ',0 ; 15
	dc.b	'    puntare ogni frame, per DynamiCop!  ',0 ; 16   Punkt in jeden frame, fr DynamiCop!
	dc.b	'                                        ',0 ; 17
	dc.b	'    Il tasto destro ferma lo scambio.   ',$ff ; 18 Die rechte Taste stoppt den Austausch.

	even

; Die FONT-Zeichen 8x8 (im CHIP von der CPU und nicht vom Blitter kopiert,)
; So kann es auch im FAST RAM sein. In der Tat wre es besser!

Font:
	incbin	"/Sources/nice.fnt"

****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; Sprite
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$0038			; DDFSTRT
	dc.w	$94,$00d0			; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD
				; 5432109876543210
	dc.w	$100,%0001001000000000	; 1 Bitplane LOWRES 320x256

Bplpointers:
	dc.w	$e0,0,$e2,0			; erste	 Bitplane

	dc.w	$180,COLSTART		; COLOR00 - Farbe "Anfang"
	dc.w	$182,$ff0			; COLOR01 - Schrift

	;dc.w	$2ce1,$fffe			; Wait mindestens Y=$2c X=$d7

	dc.w	$84					; Register COP2LCH (Adresse Copper 2!)
Cop2lch:
	dc.w	0
	dc.w	$86					; Register COP2LCL
Cop2lcl:
	dc.w	0

	dc.w	$8a,$000			; COPJMP2 - Starte Copperliste 2

****************************************************************************

; Platz fr die Copperlist 1
ColInt1:
	dcb.l	2*60,0

****************************************************************************

; Platz fr die Copperlist 2
ColInt2:
	dcb.l	2*60,0
	
*****************************************************************************

	SECTION	LEEREPLANE,BSS_C

Bitplane:
	ds.b	40*256				; Bitplane lowres 320x256

SpriteNull:						; Null-Sprite-Zeiger in Copperlist
	ds.l	1					; in nicht verwendeten Zeigern

	end
