
; Listing11g5.s -  Verwendung der Coppereigenschaft, einen "MOVE"
; durchzufhren erfordert horizontal 8 Pixel.
; rechte Taste, um das "Seil" herunter zu bringen.

	SECTION	COPPERADVANCED,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s" ; speichern Sie Interrupt, DMA und so weiter.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001010000000	; Copper DMA aktivieren

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)

Start:
	bsr.w	MakeCopper			; Erstellen der Copperlist...

	lea	$dff000,a5
	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Copper
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$13000,d2			; warte auf Zeile $130 (304)
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $130 (304)
	bne.s	WarteY1

	btst	#2,$16(a5)			; rechte Maustaste gedrckt?
	bne.s	DoNotGoDown
	addq.b	#1,WaitLine			; Wenn ja, lass alles runter!

DoNotGoDown:
	bsr.w	MoveCopper			; Rolle das Seil...
	
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$13000,d2			; warte auf Zeile $130 (304)
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; warte auf Zeile $130 (304)
	beq.s	WarteY2

	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse
	rts							; Exit


******************************************************************************
; Routine, die die Copperliste erstellt. Um eine horizontale Zeile zu 
; ziehen sind 52 Copper-MOVEs erforderlich. In diesem Fall nehmen wir
; alternativ 32 MOVE pro Farbe, damit sie keine exakte Zeile beenden,
; aber die 2 Farben "kreuzen" sich in horizontalen Punkten anders.
; Dies erzeugt ein Gefhl der "Welle".
******************************************************************************
;	               ______________
;	              /              \
;	  ..::;::..  /  HaI CaPiTo?!  \
;	  ________) \_ ______________/
;	 l_`--'\)  / /
;	 /______)\  \/
;	( \)  /
;	 \________/
;	   T____T xCz

NUMBERWEAVES	equ	8
OVERALLCOPEF	equ	NUMBERWEAVES*(32*2)


MakeCopper:
	lea	CopBuf,a0				; Adresse Buffer in CopList
	moveq	#NUMBERWEAVES-1,d6	; Anzahl der Webarten
Main0:
	lea	Colors1(pc),a1			; Tabelle Colors1
	moveq	#32-1,d7			; 32 COLOR00 fr Farben von Colors1
Cop0:
	move.w	#$0180,(a0)+		; Register COLOR00
	move.w	(a1)+,(a0)+			; Farbwert von Tabelle Colors1
	dbra	d7,Cop0				; mache die ganze "Zeile" (nicht 1 ganze ...)
	lea	Colors2(pc),a1			; Tabelle Colors2
	moveq	#32-1,d7			; 32 COLOR00 fr Farben von Colors2
Cop1:
	move.w	#$0180,(a0)+		; Register COLOR00
	move.w	(a1)+,(a0)+			; Wert COLOR00 aus der Tabelle Colors2
	dbra	d7,Cop1				; mache die ganze "Zeile" (nicht 1 ganze ...)
	dbra	d6,Main0			; mache alle "Webarten".
	rts


Colors1:
	dc.w	$003,$001,$002,$003,$004,$005,$006,$007
	dc.w	$008,$009,$00a,$00b,$00c,$00d,$00e,$10f
	dc.w	$10f,$00e,$00d,$00c,$00b,$00a,$009,$008
	dc.w	$007,$006,$005,$004,$003,$002,$001,$003

Colors2:
	dc.w	$010,$010,$020,$030,$040,$050,$060,$070
	dc.w	$080,$090,$0a0,$0b0,$0c0,$0d0,$0e0,$0f0
	dc.w	$0f0,$0e0,$0d0,$0c0,$0b0,$0a0,$090,$080
	dc.w	$070,$060,$050,$040,$030,$020,$010,$010


******************************************************************************
; Routine die die Farben dreht ...
******************************************************************************

;	   _
;	 _( )_
;	(_-O-_)
;	  (_)

MoveCopper:
	lea	CopBuf,a0				; Buffer in Copperlist
	move.w	#(OVERALLCOPEF*4)-2,d6	; Offset, um die letzte Farbe zu finden
	move.w	0(a0,d6.w),d0		; letzte Farbe in d0 (a0 + Offset!)
	move.w	d6,d5				; Kopie
	subq.w	#4,d5				; vorheriger Farboffset in d5
	move.w	#OVERALLCOPEF-1,d7
Sync0:
	move.w	0(a0,d5.w),0(a0,d6.w)	; vorherige Farbe in der "danach" Farbe
	subq.w	#4,d6				; Berechne den nchsten Farboffset
	subq.w	#4,d5				; Berechne den nchsten Farboffset
	dbra	d7,Sync0			; Laufen Sie fr den gesamten "Knoten"
	move.w	d0,2(a0)			; lege die letzte Farbe, die wir gespeichert hatten,
								; als erste Farbe, um den Zyklus nicht zu unterbrechen.
	rts

******************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$100,$200			; BPLCON0 - keine Bitplanes
	dc.w	$180,$003			; COLOR00 - dunkelblau
WaitLine:
	dc.w	$4001,$fffe			; warte auf Zeile $40.
CopBuf:
	dcb.l	OVERALLCOPEF,0		; Platz fr den Cop-Effekt
	dc.w	$180,3				; COLOR00 - dunkelblau
	dc.w	$ffff,$fffe			; Ende Copperlist

	end

Eine andere Verwendung der Besonderheit des Copper sich 8 Pixel vorwrts zu
bewegen ist folgender. Wir knnen sehen, das wir diesen Effekt auch
erhalten wenn Dutzende von COLOR00 unten platziert sind. Dadurch ndern sie
die Wartezeit vor "ihnen" um alle nach unten zu verschieben.

