
; Listing11g4.s	- Horizontaler Bildlaufeffekt von Farben mit dem Copper

	SECTION	COPPERADVANCED,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s" ; speichern Sie Interrupt, DMA und so weiter.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001010000000	; Copper DMA aktivieren

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)

Start:
	lea	$dff000,a5
	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Copper
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$13000,d2			; warte auf Zeile $130 (304)
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos. 
	cmp.l   d2,d0				; warte auf Zeile $130 (304)
	bne.s	WarteY1

	btst	#2,$dff016			; rechte Maustaste gedrckt?
	beq.s	Mouse2				; Wenn nicht, dann LineCop ausfhren

	bsr.s	LineCop				; Copperlinien-Effekt
	
Mouse2:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$13000,d2			; warte auf Zeile $130 (304)
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; whlen Sie nur die Bits der vertikalen Pos. 
	cmp.l   d2,d0				; warte auf Zeile $130 (304)
	beq.s	WarteY2

	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse
	rts

; Diese Routine fgt Farben zyklisch aus der Tabelle in die beiden Zeilen 
; bestehend aus 54 "dc.l $1800000" ein. Der Effekt ist wie immer mglich da 
; der Copper eine aus 2 Wrtern gebildete Anweisung liest und die notwendige 
; Zeit zum Lesen von 4 Pixel pro Word bentigt, das heit 8 Pixel fr jede 
; vollstndige Anweisung. 
; Wenn wir das fr einem 320 Pixel breiten Bildschirm berechnen, knnen wir
; die Farbe tatschlich 40-mal horizontal ndern (320/8 = 40).
; In diesem Fall gehen wir jedoch von der vertikalen Overscan-Position aus.
; Das ist auerhalb der Rnder des Monitors (die Wartezeit betrgt 
; dc.w $2901,$fffe), und Sie kommen auf der anderen Seite nach rechts raus.
; Theoretisch wrden wir einen 54 * 8 = 432 Pixel breiten (Monitor erlaubt)
; machen. Beachten Sie, dass wir uns auf 8 Pixel LOWRES beziehen. Bei HIRES
; bleibt die Gre unverndert und erscheint natrlich in 16 Pixel Abstand.
; 
; 

;	      /////////
;	     /       /_____________________
;	    / ___ __//                     \
;	   / ______//  eY! fig sta rutin!   \
;	 _/ /   \\\_ _____________________/
;	(_  \____/_/ / /
;	 \ _       \ \/
;	  \/    (__)
;	  /        |
;	 /_____ (o)|
;	   T T`----'
;	   l_! xCz

LineCop:
	lea	TableColors(pc),a0		; Adresse Farbtabelle
	lea	EndTableColors(pc),a3	; Ende Farbtabelle
	lea	EffInCop,a1				; horizontale Bar Adresse 1
	lea	EffInCop2,a2			; horizontale Bar Adresse 2
	moveq	#54-1,d3			; Anzahl der horizontalen Farben
	addq.l	#2,ColBarAltOffset	; Niedriger Balken - Farben  
								; nach links scrollen
	subq.l	#2,ColBarBasOffset	; Hoher Balken - Farben  
									; nach rechts scrollen
	move.l	ColBarAltOffset(pc),d0	; Start Offset (1)
	add.l	d0,a0				; Finden der richtigen Farbe in der Farbtabelle
								; entsprechend dem aktuellen Offset
	cmp.w	#-1,(a0)			; sind wir am Ende der Tabelle? 
								; (angedeutet mit einem dc.w -1)
	bne.s	CSkip				; wenn nicht, mach weiter
	clr.l	ColBarAltOffset		; sonst wieder von der
	lea	TableColors(pc),a0		; ersten Farbe gehen
CSkip:
	move.l	ColBarBasOffset(pc),d1	; Start Offset (2)
	sub.l	d1,a3				; finden der richtigen Farbe
	cmp.w	#-1,-(a3)			; sind wir am Ende der Tabelle?
	bne.s	PutColors			; wenn noch nicht, dann weitermachen
	move.l	#EndTableColors-TableColors,ColBarBasOffset ; andernfalls
								; Neustart ab Ende der Tabelle
								; (seit diese Bar rckwrts fliet!)
	lea	EndTableColors-2(pc),a3
PutColors:
	addq.w	#2,a1				; berspringe die dc.w $180
	addq.w	#2,a2				; berspringe die dc.w $180
	move.w	(a0)+,(a1)+			; Trage die Farbe in die Coplist ein (Balken 1)
	move.w	(a3),(a2)+			; Trage die Farbe in die Coplist ein (Balken 2)

	cmp.w	#-1,(a0)			; Sind wir am Ende der Farbtabelle? (Bar1)
	bne.s	NoEnd				; wenn nicht, mach weiter
	lea 	TableColors(pc),a0	; ansonsten erneut starten (bar1)
NoEnd:
	cmp.w	#-1,-(a3)			; befinden wir uns am Anfang des Farbregisters? (Bar2)
	bne.s	NoEnd2				; wenn nicht, mach weiter
	lea 	EndTableColors-2(pc),a3	; ansonsten fange am Ende an (bar2)
NoEnd2:
	dbra	d3,PutColors
	rts

*** *** *** *** *** *** *** *** *** ***


ColBarAltOffset:
	dc.l	0

ColBarBasOffset:
	dc.l	0
	

; HINWEIS: Um das Ende (und den Anfang) der Tabelle anzugeben, wird berprft
; wenn Sie bei dc.w -1 angekommen sind.

	dc.w 	-1					; Ende Tabelle
TableColors:
	dc.w	$f0f,$f0e,$f0d,$f0c,$f0b,$f0a,$f09,$f08,$f07,$f06
	dc.w	$f05,$f04,$f03,$f02,$f01,$f00,$f10,$f20,$f30,$f40
	dc.w	$f50,$f60,$f70,$f80,$f90,$fa0,$fb0,$fc0,$fd0,$fe0
	dc.w	$ff0,$ef0,$df0,$cf0,$bf0,$af0,$9f0,$8f0,$7f0,$6f0
	dc.w	$5f0,$4f0,$3f0,$2f0,$1f0,$0f0,$0f1,$0f2,$0f3,$0f4
	dc.w	$0f5,$0f6,$0f7,$0f8,$0f9,$0fa,$0fb,$0fc,$0fd,$0fe
	dc.w	$0ff,$0ef,$0df,$0cf,$0bf,$0af,$09f,$08f,$07f,$06f
	dc.w	$05f,$04f,$03f,$02f,$01f,$00f,$10f,$20f,$30f,$40f
	dc.w	$50f,$60f,$70f,$80f,$90f,$a0f,$b0f,$c0f,$d0f,$e0f
EndTableColors:
	dc.w	-1					; Ende Tabelle

*****************************************************************************

	SECTION GRAPHIC,CODE_C

Copperlist:
	dc.w	$100,$200			; BPLCON0 - 0 Bitplanes
	dc.w	$180,$000			; COLOR00 schwarz

	dc.w	$2901,$fffe			; warte auf Zeile $29
EffInCop2:
	dcb.l	54,$1800000			; 54 COLOR00 unten in Schritten von 8
								; Pixel vorwrts jedes Mal, wenn sie die 
								; volle Zeile fllen

	dc.w	$2a01,$fffe			; warte auf Zeile $2a
	dc.w	$180,$000			; COLOR00 schwarz
	
	dc.w	$ffdf,$fffe			; Wait speziell, um in den PAL-Bereich zu gehen

	dc.w	$2a01,$fffe			; warte auf Zeile $2a+$ff
EffInCop:
	dcb.l	54,$1800000			; 54 COLOR00 unten in Schritten von 8
								; Pixel vorwrts jedes Mal, wenn sie die 
								; volle Zeile fllen

	dc.w	$2b07,$fffe			; warte auf Zeile $ff+$2b
	dc.w	$180,$000			; COLOR00 schwarz

	dc.w	$ffff,$fffe			; Ende Copperlist

	end