
; Listing11g2.s -  Verwendung der Coppereigenschaft, einen "MOVE"
; durchzufhren erfordert horizontal 8 Pixel.
; optimiert Rock'n Roll (im Original 52 COLOR00 Register)

	SECTION	COPPERADVANCED,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; speichern Sie Interrupt, DMA und so weiter.
*****************************************************************************

; Mit DMASET entscheiden wir, welche DMA-Kanle geffnet und welche geschlossen werden sollen

			;5432109876543210
DMASET	equ	%1000001010000000	; Copper DMA aktivieren

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)

Start:
	bsr.w	MakeIt				; Copperlist vorbereiten

	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Copper								
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	btst	#$06,$bfe001		; Maus gedrckt?
	bne.s	Mouse

	rts

*************************************************************************
* Diese Routine erstellt eine Copperliste mit 45 COLOR00 Registern fr	*
* eine Zeile, also, da jeder move in der Copperliste 8 Pixel (lowres)	*
* der auszufhrenden Zeit dauert, wird COLOR00							*
* 45-mal HORIZONTAL in Schritten von 8 Pixeln gendert					*
*************************************************************************

;	  .:::::.
;	 ::::::
;	 |     |
;	C| _   _ l)
;	/ _(_)_ \
;	\_\_____/_/
;	 l_`---'_!
;	  `-----'xCz


LINSTART	equ	$8031fffe		; ndern von "$80", um in einer
								; anderen vertikalen Zeile zu starten.
LINES		equ	25*3			; Anzahl der zu erledigenden Zeilen.

MakeIt:
	lea	CopBuf,a1				; Adressraum in Copperlist
	move.l	#LINSTART,d0		; erstes "wait"
	move.w	#LINES-1,d1			; Anzahl der zu erledigenden Zeilen
	move.w	#$180,d3			; Word fr Register COLOR00 in Copperlist
	move.l	#$01000000,d4		; Wert, der zum Wait zur nchsten Zeile
								; hinzugefgt werden soll.
Colcon1:
	lea	Cols(pc),a0				; Adresstabelle mit Farben in a0
	move.w	#45-1,d2			; 45 color pro Zeile	
	
	move.l	d0,(a1)+			; Setzen des WAIT in der Copperlist
Colcon2:
	move.w	d3,(a1)+			; Setzen des Registers COLOR00 ($180)
	move.w	(a0)+,(a1)+			; Setze den Wert von COLOR00 (aus der Tabelle)
	dbra	d2,Colcon2			; Fhre eine ganze Zeile aus
	add.l	d4,d0				; "WAIT" machen eine Zeile darunter (+$01000000)
	dbra	d1,Colcon1			; Wiederholen Sie dies fr die Anzahl
	rts							; der zu erledigenden Zeilen


; Tabelle mit den 45 Farben einer horizontalen Zeile.

Cols:
	dc.w	$2ab,$2ba,$2c9,$2d8,$2e7,$2f6,$4e7,$6d8,$8c9,$aba
	dc.w	$caa,$d9a,$e8a,$f7a,$f6b,$f5c,$d6d,$b6e,$96f,$76f
	dc.w	$56f,$36f,$26f,$27e,$28d,$29c,$2ab,$2ba,$2c9,$2d8
	dc.w	$2e7,$2f6,$4e7,$6d8,$8c9,$aba,$caa,$d9a,$e8a,$f7a
	dc.w	$f6b,$f5c,$d6d,$b6e,$96f

*****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$100,$200			; BPLCON0 - keine Bitplanes
	dc.w	$180,$003			; COLOR00 - blau
CopBuf:
	dcb.w	(45*2)*LINES+(2*LINES),0	; Platz fr die Copperlist.
	dc.w	$180,$003			; COLOR00 - blau
	dc.w	$ffff,$fffe			; Ende Copperlist

	end

In diesem Fall haben wir den Effekt "bunter" gemacht, nichts Besonderes.