
; Listing11g1.s -  Verwendung der Coppereigenschaft,  einen "MOVE"
; durchzufhren erfordert horizontal 8 Pixel.

	SECTION	COPPERADVANCED,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; speichern von Interrupt, DMA und so weiter.
*****************************************************************************

; Mit DMASET entscheiden wir, welche DMA-Kanle geffnet und welche geschlossen werden sollen

			;5432109876543210
DMASET	equ	%1000001010000000	; Copper DMA aktivieren

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)

Start:
	bsr.w	MakeIt				; Copperlist vorbereiten

	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Copper								
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse

	rts

*************************************************************************
* Diese Routine erstellt eine Copperliste mit 39 COLOR00 Registern fr  *
* eine Zeile, also, da jeder move in der Copperliste 8 Pixel (lowres)   *
* der auszufhrenden Zeit dauert, wird COLOR00						    *
* 39-mal HORIZONTAL in Schritten von 8 Pixeln gendert				    *
*************************************************************************

;	   .:::::.
;	  ::::::
;	  |   |
;	 C|     l)
;	 /__ (_) __\
;	/ \ \___/ / \
;	\__\_   _/__/
;	  \_`---'_/xCz
;	    

LINSTART	equ	$a041fffe		; ndern von "$a0", um in einer
								; anderen vertikalen Zeile zu starten.
LINES		equ	25				; Anzahl der zu erledigenden Zeilen.

MakeIt:
	lea	CopBuf,a1
	move.l	#LINSTART,d0		; erstes "wait"
	move.w	#LINES-1,d1			; Anzahl der zu erledigenden Zeilen
Colcon1:
	lea	Cols(pc),a0				; Adresse der Tabele mit den Farben in a0
	move.w	#39-1,d2			; 39 Farben pro Zeile
	move.l	d0,(a1)+			; setzen des WAIT in der Copperlist
Colcon2:
	move.w	#$0180,(a1)+		; setzen des Registers COLOR00
	move.w	(a0)+,(a1)+			; Setze den Wert von COLOR00 (aus der Tabelle)
	dbra	d2,Colcon2			; Fhre eine ganze Zeile aus
	add.l	#$01000000,d0		; "WAIT" machen eine Zeile darunter
	dbra	d1,Colcon1			; Wiederholen Sie dies fr die Anzahl 
	rts							; der zu erledigenden Zeilen


; Tabelle mit den 39 Farben einer horizontalen Zeile.

Cols:
	dc.w	$000,$111,$222,$333,$444,$555,$666,$777
	dc.w	$888,$999,$aaa,$bbb,$ccc,$ddd,$eee,$fff
	dc.w	$fff,$fff,$fff,$fff,$fff,$fff,$fff,$fff
	dc.w	$eee,$ddd,$ccc,$bbb,$aaa,$999,$888,$777
	dc.w	$666,$555,$444,$333,$222,$111,$000

*****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$100,$200			; BPLCON0 - keine Bitplanes
	dc.w	$180,$003			; COLOR00 - blau
CopBuf:
	dcb.w	80*LINES,0			; Bereich, in dem die Copperlist erstellt wird

	dc.w	$180,$003			; COLOR00 - blau
	dc.w	$ffff,$fffe			; Ende Copperlist

	end

In diesem Listing wird gezeigt, wie eine Zeile mit COLOR00 (oder einer anderen)
mit WAIT MOVE eingefgt wird. Es dauert einige Zeit, um jeden einzelnen move
auszufhren. Genau gesagt 8 Pixel lowres. In der Tat, wenn Sie die Auflsung
hires einstellen, ndert sich nichts, nur Sie knnen ber "16" Pixel-hires
sprechen... (aber es ist nutzlos) Wenn Sie wollen, knnen Sie mit einem "Klick"
die horizontale Breite mit einem Lineal messen und Sie werden bemerken das es
immer das gleiche ist. Auerdem ist es eine ntzliche Tatsache fr Effekte wie
Plasma oder das in diesem Beispiel gezeigte. Es ist eine Einschrnkung in dem
Sinne, dass wenn man die ganze Palette wechseln will braucht jede Zeile "etwas
Zeit" und es wrde sich nicht vollstndig in der mittleren Zeile oder sogar in
der darunter liegenden Zeile ndern.
