
; Listing11c.s - Verwendung von COPER- und VERTB-Interrupt per Level 3 ($6c).

	SECTION	INTERRUPT,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup2.s"	; speichern Sie Interrupt, DMA und so weiter.
*****************************************************************************


; Mit DMASET entscheiden wir, welche DMA-Kanle geffnet und welche geschlossen werden sollen

			;5432109876543210
DMASET	equ	%1000001010000000	; Copper DMA aktivieren

WAITDISK	equ	30				; 50-150 zur Rettung (je nach Fall)

Start:
	move.l	BaseVBR(pc),a0	    ; in a0 ist der Wert des VBR
	move.l	#MyInt6c,$6c(a0)	; ich lege meinen Interrupt-Level 3 fest

	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Copper								
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

	movem.l	d0-d7/a0-a6,-(sp)
	bsr.w	mt_init				; initialisieren der Musik Routine
	movem.l	(sp)+,d0-d7/a0-a6

	move.w	#$c030,$9a(a5)		; INTENA - Interrupt "VERTB" aktivieren 
								; und "COPER" per Level 3 ($6c)

Mouse:
	btst	#6,$bfe001			; Maus gedrckt? (Der Prozessor 
	bne.s	Mouse				; unterbricht die Schleife zu jedem vertical blank
								; um die Musik zu spielen!).						

	bsr.w	mt_end				; Ende der Wiederholung!

	rts							; Exit

*****************************************************************************
*	INTERRUPTROUTINE  $6c (Level 3) -  VERTB und COPER benutzt.
*****************************************************************************

;	,;)))(((;,
;	'__  __`
;	|,-.  ,-.l
;	(  )(  )
;	`-'_)`-'
;	|  ___   |
;	l__   __!
;	 T`----'T xCz
;	 '      `

MyInt6c:
	btst.b	#5,$dff01f			; INTREQR - ist Bit 5, VERTB zurckgesetzt?
	beq.s	NoIntVertb			; Wenn ja, ist es kein "echter" VERTB Interrupt!
	movem.l	d0-d7/a0-a6,-(sp)	; Register speichern auf dem stack
	bsr.w	mt_music			; Musik spielen
	movem.l	(sp)+,d0-d7/a0-a6	; Register vom stack nehmen
NoIntVertb:
	btst.b	#4,$dff01f			; INTREQR - ist COPER zurckgesetzt?
	beq.s	NoIntCoper			; wenn ja, ist es kein COPER int!
	move.w	#$f00,$dff180		; int COPER, dann COLOR00 = rot
NoIntCoper:
			 ;6543210
	move.w	#%1110000,$dff09c	; INTREQ - Lschen Flag BLIT,VERTB,COPER
								; da der 680x0 es nicht von selbst lscht!!!
	rte							; Ende vom Interrupt BLIT,VERTB,COPER

*****************************************************************************
;	Wiederholungsroutine protracker/soundtracker/noisetracker
;
	include	"/Sources/music.s"
*****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$100,$200			; BPLCON0 - keine Bitplanes
	dc.w	$180,$00e			; COLOR00 blau
	dc.w	$a007,$fffe			; WAIT - warte auf Zeile $a0
	dc.w	$9c,$8010			; INTREQ - Fordern Sie einen COPER-Interrupt an,
								; wodurch das COLOR00 mit einem "move.w" gendert wird.
	dc.w	$ffff,$fffe			; Ende der Copperlist

*****************************************************************************
;				MUSIK
*****************************************************************************

mt_data:
	dc.l	mt_data1

mt_data1:
	incbin	"/Sources/mod.yellowcandy"

	end

Dieses Mal haben wir auch den Copperlist-Interrupt namens COPER ausgenutzt. Dies
ist ntzlich fr die Durchfhrung von Operationen auf einer bestimmten Videozeile.
Tatschlich knnen Sie von der Copperlist aus auch auf das INTREQ-Register
($dff09c) zugreifen und in diesem Fall setzen wir nur Bit 4, COPER zusammen mit
Bit 15 Set/Clr.
In diesem Fall setzen wir nur ein "move.w #$f00,$dff180", das ist nicht viel fr
eine Routine, aber bedenken Sie den Nutzen, wenn es viele Dinge zu tun gibt,
und es sich lohnt keine Zeit zu verschwenden, um in einer Schleife den 
vertical blank mit dem Prozessor zu vergleichen.
