
; Listing10g3.s		Vorhangeffekt
; rechte Taste um die Figur zu sehen, links zum Verlassen.

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"	; entferne das ; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001111000000	; Copper, Bitplane, Blitter DMA


Start:
	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer
	moveq	#3-1,d1				; Anzahl der Bitplanes (hier sind es 3)
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*256,d0			; + Bitplane Lnge (hier 256 Zeilen hoch)
	addq.w	#8,a1
	dbra	d1,PointBp

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse1:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse1				; wenn nicht, gehe zurck zu Mouse1

	moveq	#16-1,d6			; fr jede Pixelspalte wiederholen

	move.w	#%1000000000000000,d5	; Wert der Maske am Anfang.
								; Es passiert nur das Pixel
								; auf der linken Seite des Wortes.

ShowLoop:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$13000,d2			; Warte auf Zeile $130 (304)
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile $130 (304)
	bne.s	WarteY1

	bsr.s	BlitAnd				; zeichne die Figur

	asr.w	#1,d5				; Berechne die Maske fr den nchsten
								; Blitt Ein Pixel mehr passieren
								; als Inhalt
	dbra	d6,ShowLoop
	
Mouse2:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse2				; wenn nicht, gehe zurck zu Mouse2

	moveq	#16-1,d6			; fr jede Pixelspalte wiederholen
ClearLoop:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$13000,d2			; Warte auf Zeile $130 (304)
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile $130 (304)
	bne.s	WarteY2

	lsr.w	#1,d5				; Berechne die Maske fr den nchsten
								; Blitt Ein Pixel weniger passieren
								; als Inhalt						

	bsr.s	BlitAnd				; zeichne die Figur

	dbra	d6,ClearLoop

Ende:
	rts


;****************************************************************************
; Diese Routine fhrt eine UND-Verknpfung zwischen einer Figur, ber Kanal A
; und einem konstanten Wert, der in BLTBDAT geladen ist durch. Das Ergebnis 
; wird auf dem Bildschirm gezeichnet.
; d5 - enthlt den konstanten Wert (Maske), der in BLTBDAT geladen werden soll
;****************************************************************************

;	    ____
;	  .'_  _`.
;	  |/ \/ \|
;	  || oo ||
;	  ||    ||
;	 _|\_/\_/|_
;	(|-.____.-|)
;	 `._ -- _.'
;	   |_  _|
;	     `'

BlitAnd:
	lea	Bitplane+100*40+4,a0	; Zeiger Ziel in a0
	lea	Figur,a1				; Zeiger Quelle

	moveq	#3-1,d7				; wiederhole es fr jede Ebene
PlaneLoop:
	btst	#6,2(a5)
WaitBlit2:
	btst	#6,2(a5)			; warte auf das Ende des Blitters
	bne.s	WaitBlit2

	move.l	#$ffffffff,$44(a5)	; BLTAFWM = $ffff es passiert alles
								; BLTALWM = $ffff es passiert alles
	move.w	d5,$72(a5)			; schreibt Maske in BLTBDAT
	move.l	#$09c00000,$40(a5)	; BLTCON0 Verwende die Kanle A und D
								; D=A AND B
								; BLTCON1 (keine Spezialmodi)
	move.l	#$00000004,$64(a5)	; BLTAMOD=0
								; BLTDMOD=40-36=4 wie immer

	move.l	a1,$50(a5)			; BLTAPT (an der Quellfigur fixiert)
	move.l	a0,$54(a5)			; BLTDPT (Bildschirm)
	move.w	#(64*45)+18,$58(a5)	; BLTSIZE (Blitter starten!)

	lea	40*256(a0),a0			; zeigt auf die nchste Zielebene
	lea	2*18*45(a1),a1			; zeigt auf die nchste Quellebene
								; Jede Bitplane ist 18 Wrter breit und 
								; 45 Zeilen hoch
	dbra	d7,PlaneLoop

	rts

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; WERT MODULO 0
	dc.w	$10a,0				; BEIDE MODULO MIT GLEICHEN WERT.

	dc.w	$100,$3200			; BPLCON0 - 3 Bitplanes lowres
		
Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane
	dc.w	$e4,$0000,$e6,$0000
	dc.w	$e8,$0000,$ea,$0000

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$475			; COLOR01
	dc.w	$0184,$fff			; COLOR02
	dc.w	$0186,$ccc			; COLOR03
	dc.w	$0188,$999			; COLOR04
	dc.w	$018a,$232			; COLOR05
	dc.w	$018c,$777			; COLOR06
	dc.w	$018e,$444			; COLOR07

	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

; Dies sind die Daten, aus denen die Figur des Bobs besteht.
; Der Bob ist im normalen Format, 288 Pixel breit (18 Wrter)
; 45 Zeilen hoch, 3 Bitebenen

Figur:
	incbin	"/Sources/copmon.raw"

;****************************************************************************

	SECTION	LEEREPLANE,BSS_C

Bitplane:
		ds.b	40*256			; 3 Bitplanes
		ds.b	40*256
		ds.b	40*256

	end

;****************************************************************************

In diesem Beispiel machen wir einen "Vorhang"-Effekt, dh wir zeichnen eine Figur
als wre es ein venezianischer Vorhang, der geffnet oder geschlossen wird.
Starte es zuerst um es zu betrachten, um zu verstehen, was es ist, dann lies die
Erklrung nochmal!
Diesen Effekt erhalten wir durch eine Technik, die der im Beispiel Listing9h3.s
verwendeten Technik hnlich ist, um ein Bild jeweils eine Spalte zu zeichnen.
Um den Effekt zu erhalten, wird ein AND zwischen der Figur und einem Maskenwert
gemacht, der nur einige Spalten von Pixeln auswhlt. Im Gegensatz zum Beispiel
Listing9h3.s, knnen wir BLTAFWM / BLTALWM nicht verwenden, um die Maske zu 
erhalten, weil wir die Maske auf alle Wrter in der Figur anwenden mssen, nicht
nur am Anfang und am Ende. Dazu machen wir ein AND zwischen dem Kanal A und
Kanal B, wir halten Kanal B deaktiviert und verwenden BLTBDAT als Maske. Die
Maske wird so variiert, bis das Bild fortlaufend durchgehend angezeigt wird und
dann wird es wieder gendert, um allmhlich das ganze Bild zu lschen.      
