
; Listing10g2.s		Beispiel fr ODER zwischen einem aktivierten Kanal und 
; einem deaktivierten Kanal
; rechte Taste um den Blitt zu starten, links um zu beenden.

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"	; entferne das ; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001111000000	; Copper, Bitplane, Blitter DMA


Start:
	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer
	moveq	#1-1,d1				; Anzahl der Bitplanes (hier ist es 1)
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*256,d0			; + Bitplane Lnge (hier 256 Zeilen hoch)
	addq.w	#8,a1
	dbra	d1,PointBp

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

	lea	Figur,a0
	lea	Bitplane+20,a1
	bsr.s	Copy				; mache die Kopie Figur 2

Mouse1:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse1				; wenn nicht, gehe zurck zu Mouse1

	bsr.s	BlitOr				; Fhre das ODER zwischen den 2 Figuren aus

Mouse2:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse2				; wenn nicht, gehe zurck zu Mouse2
	rts


;****************************************************************************
; Diese Routine kopiert die Figur auf den Bildschirm.
; Es braucht als Parameter
; a0 - Quelladresse
; a1 - Zieladresse
;****************************************************************************

Copy:
	btst	#6,2(a5)			; DMACONR
WaitBlit1:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit1

	move.l	#$ffffffff,$44(a5)	; Maske
	move.l	#$09f00000,$40(a5)	; BLTCON0 und BLTCON1 (A+D)
								; normale Kopie
	move.w	#0,$64(a5)			; BLTAMOD (=0)
	move.w	#30,$66(a5)			; BLTDMOD (40-10=30)
	move.l	a0,$50(a5)			; BLTAPT Zeiger Quelle
	move.l	a1,$54(a5)			; BLTDPT Zeiger Ziel
	move.w	#(64*71)+5,$58(a5)	; BLTSIZE (Blitter starten !)
								; Breite 5 Word
	rts							; Hhe 71 Zeilen

;****************************************************************************
; Diese Routine fhrt das ODER zwischen einer Figur, die durch den Kanal B 
; gelesen wird und dem konstanten Wert, der in BLTADAT enthalten ist durch.
;****************************************************************************

;	  |\__/,|   (`\
;	  |_ _  |.--.) )
;	  ( T   )     /
;	 (((^_(((/(((_>

BlitOr:
	btst	#6,2(a5)			; DMACONR
WaitBlit2:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit2

	move.l	#$ffffffff,$44(a5)	; Maske
	move.l	#$05fc0000,$40(a5)	; BLTCON0 und BLTCON1
								; benutze die Kanle B und D
								; fhrt das OR zwischen A und B durch (LF = $fc)
	move.w	#0,$62(a5)			; BLTBMOD (=0)
	move.w	#30,$66(a5)			; BLTDMOD (40-10=30)
	move.w	#$cccc,$74(a5)		; Wert des OR in BLTADAT

	move.l	#Figur,$4c(a5)		; BLTBPT Zeiger Quelle
	move.l	#Bitplane+100*40+10,$54(a5)	; BLTDPT Zeiger Ziel
	move.w	#(64*71)+5,$58(a5)	; BLTSIZE (Blitter starten!)
								; Breite 5 Word 
	rts							; Hhe 71 Zeilen

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

	dc.w	$100,$1200			; BPLCON0 - 1 Bitplane lowres

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$aaa			; COLOR01

	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

Figur:
	dc.w	$ffff,$ffff,$ffff,$ffff,$fe00,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,$3800,0,0
	dc.w	0,$0003,$ff80,0,0,0,$001f,$fff0,0,0
	dc.w	0,$01ff,$ffff,0,0,0,$0fff,$ffff,$e000,0
	dc.w	0,$ffff,$ffff,$fe00,0,$0007,$ffff,$ffff,$ffc0,0
	dc.w	$007f,$ffff,$ffff,$fffc,0,$03ff,$ffff,$ffff,$ffff,$8000
	dc.w	$3fff,$ffff,$ffff,$ffff,$f800,$7fff,$ffff,$ffff,$ffff,$fc00
	dc.w	$3fff,$ffff,$ffff,$ffff,$f800,$03ff,$ffff,$ffff,$ffff,$8000
	dc.w	$007f,$ffff,$ffff,$fffc,0,$0007,$ffff,$ffff,$ffc0,0
	dc.w	0,$ffff,$ffff,$fe00,0,0,$0fff,$ffff,$e000,0
	dc.w	0,$01ff,$ffff,0,0,0,$001f,$fff0,0,0
	dc.w	0,$0003,$ff80,0,0,0,0,$3800,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	$ffff,$ffff,$ffff,$ffff,$fe00

;****************************************************************************

	SECTION	LEEREPLANE,BSS_C

Bitplane:
	ds.b	40*256

	end

;****************************************************************************

In diesem Beispiel fhren wir ein ODER zwischen einer Figur, die durch den 
Kanal B gelesen wird und einem konstanten Wert der im BLTADAT-Register enthalten 
ist durch.
Aus diesem Grund haben wir die Kanle B und D aktiviert und programmieren das 
LF-Byte so, dass ein OR zwischen den Quellen A und B durchgefhrt wird.                                                                                                                                                                                                             Zhler
