
; Listing10b1.s		Beispiel fr OR zwischen 2 Kanlen
; Rechte Taste um den Blitt zu starten, links um zu beenden.

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"	; entferne das ; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001111000000	; Bitplane, Copper, blitter DMA


Start:
	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer
	moveq	#1-1,d1				; Anzahl der Bitplanes
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*256,d0			; + Bitplane Lnge (hier 256 Zeilen hoch)
	addq.w	#8,a1
	dbra	d1,PointBp

	lea	$dff000,a5				; CUSTOM REGISTER in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

	lea	Figur1,a0
	lea	Bitplane,a1
	bsr.s	Copy				; mach eine Kopie Figur 1

	lea	Figur2,a0
	lea	Bitplane+20,a1
	bsr.s	Copy				; mach eine Kopie Figur 2

Mouse1:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse1				; wenn nicht, gehe zurck zu mouse1:

	bsr.s	BlitOR				; ODER zwischen den 2 Figuren ausfhren

Mouse2:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse2				; wenn nicht, gehe zurck zu Mouse2:
	rts


;****************************************************************************
; Diese Routine kopiert die Figur auf dem Bildschirm.
; Es braucht als Parameter
; a0 - Quelladresse
; a1 - Zieladresse
;****************************************************************************

Copy:
	btst	#6,2(a5)			; DMACONR
WaitBlit:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit

	move.l	#$ffffffff,$44(a5)	; Maske
	move.l	#$09f00000,$40(a5)	; BLTCON0 und BLTCON1 (A+D)
								; normale Kopie
	move.w	#0,$64(a5)			; BLTAMOD (=0)
	move.w	#30,$66(a5)			; BLTDMOD (40-10=30)
	move.l	a0,$50(a5)			; BLTAPT  Zeiger Quelle
	move.l	a1,$54(a5)			; BLTDPT  Zeiger Ziel
	move.w	#(64*71)+5,$58(a5)	; BLTSIZE (Blitter starten !)
								; Breite 5 word, Hhe 71 Zeilen
	rts							

;****************************************************************************
; diese Routine macht das ODER zwischen 2 Figuren mit den Kanlen A und B
;****************************************************************************

;	           /#\    ...
;	          /   \  :   :
;	         / /\  \c o o 
;	        /%/  \  (  ^  )    /)OO
;	       (  u  / __\ O / \   \)(/
;	       UUU_ ( /)  `-'`  \  /%/
;	        /  \| /   <  :\  )/ /
;	       /  . \::.   >.( \ ' /
;	      /  /\   '::./|. ) \#/
;	     /  /  \    ': ). )
;	 __ %,/    \   / (.  )
;	(  \% /     /  /  ) .'
;	 \_ /     /  /   `:'
;	  \_/     /  /
;	         /\./
;	        /.%
;	       / %
;	      (  %
;	       \ ~\
;	        \__)

BlitOR:
	btst	#6,2(a5)			; DMACONR
WaitBlit2:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit2

	move.l	#$ffffffff,$44(a5)	; Maske
	move.l	#$0dfc0000,$40(a5)	; BLTCON0 und BLTCON1
								; benutze die Kanle A, B und D
								; fhre ein ODER zwischen A und B aus (LF=$FC)
	move.w	#0,$64(a5)			; BLTAMOD (=0)
	move.w	#0,$62(a5)			; BLTBMOD (=0)
	move.w	#30,$66(a5)			; BLTDMOD (40-10=30)

	move.l	#Figur1,$50(a5)		; BLTBPT  Zeiger Quelle
	move.l	#Figur2,$4c(a5)		; BLTAPT  Zeiger Quelle
	move.l	#Bitplane+100*40+10,$54(a5)	; BLTDPT  Zeiger Ziel
	move.w	#(64*71)+5,$58(a5)	; BLTSIZE (Blitter starten !)
								; Breite 5 word, Hhe 71 Zeilen
	rts							

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

	dc.w	$100,$1200			; BPLCON0 - 1 Bitplane lowres

Bplpointers:
	dc.w 	$e0,$0000,$e2,$0000	; erste Bitplane

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$aaa			; COLOR01

	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

Figur1:
	dc.w	$ffc0,0,0,$0007,$fe00,$8000,0,$1000,0,$0200
	dc.w	$8000,0,$3800,0,$0200,$8000,0,$3800,0,$0200
	dc.w	$8000,0,$3800,0,$0200,$8000,0,$3800,0,$0200
	dc.w	$8000,0,$7c00,0,$0200,$8000,0,$7c00,0,$0200
	dc.w	$8000,0,$7c00,0,$0200,$8000,0,$fe00,0,$0200
	dc.w	$8000,0,$fe00,0,$0200,$8000,0,$fe00,0,$0200
	dc.w	$8000,0,$fe00,0,$0200,$8000,$0001,$ff00,0,$0200
	dc.w	$8000,$0001,$ff00,0,$0200,$8000,$0001,$ff00,0,$0200
	dc.w	$8000,$0003,$ff80,0,$0200,$8000,$0003,$ff80,0,$0200
	dc.w	$8000,$0003,$ff80,0,$0200,$8000,$0003,$ff80,0,$0200
	dc.w	$8000,$0007,$ffc0,0,$0200,$8000,$0007,$ffc0,0,$0200
	dc.w	$8000,$0007,$ffc0,0,$0200,$8000,$000f,$ffe0,0,$0200
	dc.w	$8000,$000f,$ffe0,0,$0200,$8000,$000f,$ffe0,0,$0200
	dc.w	$8000,$000f,$ffe0,0,$0200,$8000,$001f,$fff0,0,$0200
	dc.w	$8000,$001f,$fff0,0,$0200,$8000,$001f,$fff0,0,$0200
	dc.w	$8000,$003f,$fff8,0,$0200,$8000,$003f,$fff8,0,$0200
	dc.w	$8000,$003f,$fff8,0,$0200,$8000,$003f,$fff8,0,$0200
	dc.w	$8000,$007f,$fffc,0,$0200,$8000,$007f,$fffc,0,$0200
	dc.w	$8000,$007f,$fffc,0,$0200,$8000,$003f,$fff8,0,$0200
	dc.w	$8000,$003f,$fff8,0,$0200,$8000,$003f,$fff8,0,$0200
	dc.w	$8000,$003f,$fff8,0,$0200,$8000,$001f,$fff0,0,$0200
	dc.w	$8000,$001f,$fff0,0,$0200,$8000,$001f,$fff0,0,$0200
	dc.w	$8000,$000f,$ffe0,0,$0200,$8000,$000f,$ffe0,0,$0200
	dc.w	$8000,$000f,$ffe0,0,$0200,$8000,$000f,$ffe0,0,$0200
	dc.w	$8000,$0007,$ffc0,0,$0200,$8000,$0007,$ffc0,0,$0200
	dc.w	$8000,$0007,$ffc0,0,$0200,$8000,$0003,$ff80,0,$0200
	dc.w	$8000,$0003,$ff80,0,$0200,$8000,$0003,$ff80,0,$0200
	dc.w	$8000,$0003,$ff80,0,$0200,$8000,$0001,$ff00,0,$0200
	dc.w	$8000,$0001,$ff00,0,$0200,$8000,$0001,$ff00,0,$0200
	dc.w	$8000,0,$fe00,0,$0200,$8000,0,$fe00,0,$0200
	dc.w	$8000,0,$fe00,0,$0200,$8000,0,$fe00,0,$0200
	dc.w	$8000,0,$7c00,0,$0200,$8000,0,$7c00,0,$0200
	dc.w	$8000,0,$7c00,0,$0200,$8000,0,$3800,0,$0200
	dc.w	$8000,0,$3800,0,$0200,$8000,0,$3800,0,$0200
	dc.w	$8000,0,$3800,0,$0200,$8000,0,$1000,0,$0200
	dc.w	$ffc0,0,0,$0007,$fe00

Figur2:
	dc.w	$ffff,$ffff,$ffff,$ffff,$fe00,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,$3800,0,0
	dc.w	0,$0003,$ff80,0,0,0,$001f,$fff0,0,0
	dc.w	0,$01ff,$ffff,0,0,0,$0fff,$ffff,$e000,0
	dc.w	0,$ffff,$ffff,$fe00,0,$0007,$ffff,$ffff,$ffc0,0
	dc.w	$007f,$ffff,$ffff,$fffc,0,$03ff,$ffff,$ffff,$ffff,$8000
	dc.w	$3fff,$ffff,$ffff,$ffff,$f800,$7fff,$ffff,$ffff,$ffff,$fc00
	dc.w	$3fff,$ffff,$ffff,$ffff,$f800,$03ff,$ffff,$ffff,$ffff,$8000
	dc.w	$007f,$ffff,$ffff,$fffc,0,$0007,$ffff,$ffff,$ffc0,0
	dc.w	0,$ffff,$ffff,$fe00,0,0,$0fff,$ffff,$e000,0
	dc.w	0,$01ff,$ffff,0,0,0,$001f,$fff0,0,0
	dc.w	0,$0003,$ff80,0,0,0,0,$3800,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,0,0,0,0,0
	dc.w	0,0,0,0,0,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	$8000,0,0,0,$0200,$8000,0,0,0,$0200
	dc.w	$ffff,$ffff,$ffff,$ffff,$fe00

;****************************************************************************

	SECTION	LEEREPLANE,BSS_C

Bitplane:
	ds.b	40*256

	end

;****************************************************************************

In diesem Beispiel sehen wir das ODER zwischen zwei Figuren. Es ist ein 
einfacher Blitt, welcher das OR zwischen den 2 Kanlen A und B unter Verwendung
des Wertes von LF wie in der Lektion berechnet durchfhrt. Als bung knnen Sie
zum Lesen den Kanal C anstelle von B nehmen.
Folgende nderungen sind vorzunehmen:
Ersetzen Sie die Modulo- und Zeigerregister von Kanal B durch diejenigen von C
und aktivieren sie den Kanal C anstatt B. Weiterhin berechnen Sie den LF-Wert,
um das OR zwischen A und C durchzufhren. Die Berechnung von LF ist einfach:
Schauen sie sich einfach die Tabelle Abb. 27 an und stellen sie die Minterms
so ein, das sie den Kombinationen mit A = 1 und C = 1 entsprechen. Sie erhalten
LF = $FA. Wiederholen Sie diese bung, um das ODER zwischen den Kanlen B
und C zu bilden.