
; Listing9h1.s		Beispiel fr die Verwendung der Maske
; Drcken Sie die linke und rechte Maustaste abwechselnd, um 
; verschiedene Blitts mit verschiedenen Masken zu sehen.

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"		; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	EQU	%1000001111000000	; Bitplane, Copper, Blitter DMA ; $83C0


Start:	
	move.l	#Bitplane,d0		; Zeiger auf das Bild
	lea	Bplpointers,a1			; Bitplanepointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

; Parameter vorbereiten
	move.w	#$ffff,d0				; erste Wortmaske - alle Bits bergeben
	move.w	#$ffff,d1				; letzte Wortmaske - alle Bits bergeben
	lea	Bitplane+2,a0				; Adresse Ziel
	bsr.w	Copy

Mouse2:
	btst	#2,$dff016				; rechte Maustaste gedrckt?
	bne.s	Mouse2					; Wenn nicht, gehe zurck zu Mouse2:

; Parameter vorbereiten
	moveq	#$0000,d0				; erste Wortmaske - alles lschen
	move.w	#$ffff,d1				; letzte Wortmaske - alle Bits bergeben
	move.l	#Bitplane+30*40+2,a0	; Adresse Ziel
	bsr.s	Copy

Mouse3:
	btst	#6,$bfe001				; linke Maustaste gedrckt?
	bne.s	Mouse3					; Wenn nicht, gehe zurck zu Mouse3:

; Parameter vorbereiten
	move.w	#%1010101010101010,d0	; erste Wortmaske - ein bisschen ja und nein
	move.w	#%0000000000000001,d1	; letzte Wortmaske - nur etwas mehr nach rechts
	lea	Bitplane+60*40+2,a0			; Adresse Ziel
	bsr.s	Copy

Mouse4:
	btst	#2,$dff016				; rechte Maustaste gedrckt?
	bne.s	Mouse4					; Wenn nicht, gehe zurck zu Mouse4:

; Parameter vorbereiten
	moveq	#$0000,d0				; erste Wortmaske - alles lschen
	moveq	#$0000,d1				; letzte Wortmaske - alles lschen
	lea	Bitplane+90*40+2,a0			; Adresse Ziel
	bsr.s	Copy

Mouse5:
	btst	#6,$bfe001				; linke Maustaste gedrckt?
	bne.s	Mouse5					; Wenn nicht, gehe zurck zu Mouse5:

; Parameter vorbereiten
	move.w	#%1111000011110000,d0	; erste Wortmaske - 4 Bits ja und 4 nein
	move.w	#%0000011010011100,d1	; letzte Wortmaske - nur die Bits 2,3,4,7,9 und 10
	lea	Bitplane+120*40+2,a0		; Adresse Ziel
	bsr.s	Copy

Mouse6:
	btst	#2,$dff016				; rechte Maustaste gedrckt?
	bne.s	Mouse6					; Wenn nicht, gehe zurck zu Mouse6:

; Parameter vorbereiten
	move.w	#%0000000001111111,d0	; erste Wortmaske - lsche die linken 9 Bits
	move.w	#%1111111000000000,d1	; letzte Wortmaske - lsche die 9 am weitesten
									; rechts stehenden Bits
	lea	Bitplane+150*40+2,a0		; Adresse Ziel
	bsr.s	Copy

Mouse:
	btst	#6,$bfe001
	bne.s	Mouse

	rts

;****************************************************************************
; Diese Routine kopiert die Figur auf den Bildschirm.
;
; a0 - Zieladresse
; d0.w - erste Wortmaske
; d1.w - letzte Wortmaske
;****************************************************************************

;	    .....        ___
;	 .:::::::::.  /\////
;	:::_  _:. \  _/
;	:|   ,  l: / /
;	:\ \/\___T /:/ /
;	::\_______/:: /
;	 __|  l__/ :/
;	 /_,       _/
;	/ (___X___)
;	\  j      |
;	 \ \   .  |
;	  \ \_____|
;	   \ \__" \
;	   (_,_,)  \
;	   |  T   \
;	   |    l_  _)
;	   |    |   /
;	  _l____l__/
;	 (_____)\  \
;	         \__)

Copy:
	btst	#6,2(a5)			; DMACONR
WaitBlit1:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit1

	move.w	d0,$44(a5)			; BLTAFWM Maskenwert laden
	move.w	d1,$46(a5)			; BLTALWM Maskenwert laden
	move.w	#$09f0,$40(a5)		; BLTCON0 (Kopie A nach D)
	move.w	#$0000,$42(a5)		; BLTCON1 wir erklren es spter
	move.w	#0,$64(a5)			; BLTAMOD (=0)
	move.w	#34,$66(a5)			; BLTDMOD (40-6=34)
	move.l	#Figur,$50(a5)		; BLTAPT  (an der Quellfigur fixiert)
	move.l	a0,$54(a5)			; BLTDPT  Adresse Ziel
	move.w	#(64*7)+3,$58(a5)	; BLTSIZE (Blitter starten !)
								; Breite 3 Worte
	rts							; Hhe 7 Zeilen (1 Ebene)

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD
	dc.w	$100,$1200			; BPLCON0 - 1 Bitplane Lowres

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$eee			; COLOR01

	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

; Wir definieren im Binrformat die Zahl, die 3 Wrter breit und 7 Zeilen hoch ist

Figur:
;		    0123456789012345  0123456789012345  0123456789012345
	dc.w	%1111111111000000,%0000001111000000,%0000001111111111
	dc.w	%1111111111000000,%0000111111110000,%0000001111111111
	dc.w	%1111111111000000,%0011111111111100,%0000001111111111
	dc.w	%1111111111111111,%1111111111111111,%1111111111111111
	dc.w	%1111111111000000,%0011111111111100,%0000001111111111
	dc.w	%1111111111000000,%0000111111110000,%0000001111111111
	dc.w	%1111111111000000,%0000001111000000,%0000001111111111

;****************************************************************************

	SECTION	LEEREPLANE,BSS_C	

Bitplane:
	ds.b	40*256				; Bitplane lowres

	end

;****************************************************************************

In diesem Beispiel zeigen wir, wie die Masken den Blitt beeinflussen. Wir
haben eine Figur (eine Bitebene), die mehrmals auf den Bildschirm an
verschiedenen Positionen kopiert wird. Jede Kopie wird jedoch mit
verschiedenen Masken durchgefhrt, wodurch die Effekte auftreten, die Sie
sehen. Wir haben eine Routine verwendet, die die Werte als Parameter fr die
Masken und die Zieladresse des Blitts verwendet. Auf diese Weise fhren wir
alle Kopien mit einer einzigen Routine aus und ndern nur die Werte der
Parameter. Die Parameter werden ber die 68000-Register an die Routine
bergeben. Um die Wirkung der verschiedenen Werte der Masken zu verstehen,
lesen Sie die Kommentare im Listing.