
; Listing9f3.s		In diesem Listing wird ein Bild von 16 * 15 Pixeln, 
; mit 2 Bitplanes geblittet, 
; ausfllen des Bildschirms (320 * 256 Lowres 2 Bitplanes).
; Timing mit VBlank
; gezeichnet nur eine Kachel pro Frame.

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"		; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	EQU	%1000001111000000	; Bitplane, Copper, Blitter DMA ; $83C0


Start:
	move.l	#Bitplane1,d0		; Zeiger Bitplane1
	lea	Bplpointer1,a1			; Bitplanepointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

;	Lass uns die zweite Bitebene setzen

	move.l	#Bitplane2,d0		; Zeiger Bitplane2
	lea	Bplpointer2,a1			; Bitplanepointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

	bsr.s	FillMem				; den "Kachel" -Bildschirm 
								; mit dem Blitter fllen.
Mouse:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse				; Wenn nicht, gehe zurck zu Mouse:
	rts							; Ausgang

;	  .---^---^---.
;	  |           |
;	  |           |
;	  |    --- |
;	 _| ___   ___ l_
;	/__ `(___)' __\
;	\ \_/\_____/\_/ /
;	 \____`---'____/
;	    T`-----'T
;	    l_______| xCz

FillMem:
	lea	Bitplane1,a0			; erste Bitplane
	lea	Bitplane2,a1			; zweite Bitplane
	lea	GfxData1,a3				; Figur plane 1
	lea	GfxData2,a4				; Figur plane 2

	btst	#6,2(a5)			; DMACONR
WaitBlit1:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit1

	move.l	#$ffffffff,$44(a5)	; BLTAFWM und BLTALWM wir werden es spter erklren
	move.w	#38,$66(a5)			; BLTDMOD (40-2=38), tatschlich alle
								; "Kacheln" sind 16 Pixel breit,
								; das sind 2 Bytes, die wir entfernen mssen
								; auf die gesamte Breite einer Zeile,
								; die ist 40, und das Ergebnis ist 40-2 = 38!
	move.w	#$0000,$42(a5)		; BLTCON1 - wir werden es spter erklren
	move.w	#$09f0,$40(a5)		; BLTCON0 (Kanal A+D)

	moveq	#16-1,d7			; 16 Kacheln um am Ende 
								; anzukommen, tatschlich
								; die Kacheln sind 15 Pixel hoch,
								; 1 Pixel "Abstand" zwischen einer und
								; der anderen, unter jeder, macht eine
								; Gre von 16 Pixeln pro Kachel,
								; deshalb 256/16 = 16 Kacheln.
MakeAllTheRows:
	moveq	#20-1,d6			; 20 Blcke pro Zeile, tatschlich
								; die Kacheln sind 16 Pixel breit,
								; das sind 2 Bytes, daraus abgeleitet
								; fr eine horizontale Zeile
								; sind das 320/16 = 20
MakeALineLoop:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$10800,d2			; Warte auf Zeile $108
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile $108
	bne.s	WarteY1
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile $108
	beq.s	WarteY2

; Blittet die erste Bitebene einer Kachel

	move.l	a0,$54(a5)			; BLTDPT - Ziel (Bitplane 1)
	move.l	a3,$50(a5)			; BLTAPT - Quelle (Figur 1)
	move.w	#(15*64)+1,$58(a5)	; BLTSIZE - Hhe 15 Zeilen,
								; Breite 1 Word
								; Um die erste Bitplane zu machen

	btst	#6,2(a5)			; DMACONR
WaitBlit2:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit2

; Blittet die zweite Bitebene einer Kachel

	move.l	a1,$54(a5)			; BLTDPT - Ziel (Bitplane 2)
	move.l	a4,$50(a5)			; BLTAPT - Quelle (fig2)
	move.w	#(15*64)+1,$58(a5)	; BLTSIZE - Hhe 15 Zeilen,
								; Breite 1 Word
								; Um die zweite Bitplane zu machen

	btst	#6,2(a5)			; DMACONR
WaitBlit3:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit3

	addq.w	#2,a0				; berspringt 1 Wort (16 Pixel) in der Bitebene 1,
								; in "vorwrts" fr die nchste Kachel
	addq.w	#2,a1				; berspringt 1 Wort (16 Pixel) in der Bitebene 2
	dbra	d6,MakeALineLoop	; und Schleife bis alle fertig gezeichnet sind
								; Blittet alle 20 Kacheln einer Zeile
 
	lea	15*40(a0),a0			; berspringt 15 Zeilen in der Bitebene 1.
								; Wir haben a0 bereits mit addq #2,a0 (in jeder 
								; Schleife) erhht und haben bereits eine Zeile 
								; bersprungen bevor wir hier angekommen sind.
								; Daher werden 16 Zeilen bersprungen und wir haben
								; zwischen einer Kachel und der anderen einen 
								; "Streifen" Hintergrund, da die Kacheln
								; nur 15 Pixel hoch sind.
	lea	15*40(a1),a1			; berspringt 15 Zeilen in der Bitebene 2
	dbra	d7,MakeAllTheRows	; mache alle 16 Zeilen

 	rts	

;******************************************************************************

		SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

	dc.w	$100,$2200			; BPLCON0 - 2 Bitplanes lowres

	dc.w	$180,$000			; COLOR00
	dc.w	$182,$FED			; COLOR01
	dc.w	$184,$33a			; COLOR02
	dc.w	$186,$888			; COLOR03

Bplpointer1:
	dc.w	$e0,0,$e2,0			; erste Bitplane
Bplpointer2:
	dc.w	$e4,0,$e6,0			; zweite Bitplane

	dc.l	$ffff,$fffe			; Ende Copperlist

******************************************************************************

; Abbildung, bestehend aus 2 Bitebenen. Breite = 1 Wort, Hhe = 15 Zeilen

GfxData1:
	dc.w	%1111111111111100
	dc.w	%1111111111111100
	dc.w	%1100000000001100
	dc.w	%1101111111111100
	dc.w	%1101111111111100
	dc.w	%1101111111011100
	dc.w	%1101110011011100
	dc.w	%1101110111011100
	dc.w	%1101111111011100
	dc.w	%1101111111011100
	dc.w	%1101100000011100
	dc.w	%1101111111111100
	dc.w	%1111111111111100
	dc.w	%1111111111111100
	dc.w	%0000000000000000

GfxData2:
	dc.w	%0000000000000010
	dc.w	%0111111111111110
	dc.w	%0111111111110110
	dc.w	%0111111111110110
	dc.w	%0111000000010110
	dc.w	%0111011111110110
	dc.w	%0111011101110110
	dc.w	%0111011101110110
	dc.w	%0111010001110110
	dc.w	%0111011111110110
	dc.w	%0111011111110110
	dc.w	%0111111111110110
	dc.w	%0100000000000110
	dc.w	%0111111111111110
	dc.w	%1111111111111110

;******************************************************************************

	SECTION	LEEREPLANE,BSS_C

Bitplane1:
		ds.b	40*256
Bitplane2:
		ds.b	40*256

	end

;******************************************************************************

Dieses Beispiel ist eine Variation des Beispiels Listing9c2.s. Diesmal haben
wir einen 2-Ebenen Bildschirm. Sogar unsere Kacheln bestehen aus 2 Ebenen. Die
Routine, die das "Tiling" des Bildschirms ausfhrt, hat die gleiche Struktur
wie die im Beispiel Listing9c2.s, nur dass 2 Kopien ausgefhrt werden:
Die erste Bitebene der Kachel auf der ersten Bitebene des Bildschirms und die
zweite Bitebene der Kachel auf der zweiten Bitebene des Bildschirms. Um es noch
interessanter zu machen, haben wir die Routine verlangsamt durch das Setzen
einer Warteschleife mittels des vertikalen Blanks.
Auf diese Weise werden die Kacheln in jeden vertikal Blank kopiert. Sie knnen 
die Reihenfolge, wie die Kacheln kopiert werden mit dem Auge beobachten.
