
; Listing9f1.s		Blitt, in dem wir ein Rechteck von einem Punkt zu einem 
; anderen Punkt des gleichen Bildschirms kopieren
; Linke Taste, um den Blitt auszufhren, rechts um zu beenden.

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"		; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"		; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	EQU	%1000001111000000	; Bitplane, Copper, Blitter DMA ; $83C0


Start:
	move.l	#Bitplane,d0		; Zeiger auf das Bild
	lea	Bplpointers,a1			; Bitplanepointer
	moveq	#3-1,d1				; Anzahl der Bitebenen (hier sind 3)
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*256,d0			; + Bitplane Lnge (hier 256 Zeilen hoch)
	addq.w	#8,a1
	dbra	d1,PointBp

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse1:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse1				; wenn nicht, nicht abbrechen

	bsr.s	Copy				; Kopierroutine ausfhren

Mouse2:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse2				; wenn nicht, gehe zurck zu Mouse2:

	rts

; ************************ KOPIER ROUTINE ****************************

; Ein Rechteck mit der Breite = 160 und der Hhe = 20 wird kopiert
; aus den Koordinaten X1 = 64, Y1 = 50 (Quelle)
; zu den Koordinaten X2 = 80, Y2 = 190 (Ziel)

;	   .  , _ .
;	   \_|/_/l
;	  //\/\\
;	 /_( (  )_\
;	l/_\_/\_/_\\
;	/ T (____) T \\
;	\/\___/\__/  //
;	(_/  __     T|
;	 l  (. )    |l\
;	  \      // /
;	   \______//
;	  __Tl___Tl xCz
;	 C____(____)

Copy:

; wir laden die Quell- und Zieladressen in 2 Register

	move.l	#Bitplane+((20*50)+64/16)*2,d0	; Adresse Quelle
	move.l	#Bitplane+((20*190)+80/16)*2,d2	; Adresse Ziel

								; Blitt-Schleife 
	moveq	#3-1,d1				; fr alle Bitplanes wiederholen 
CopyLoop:
	btst	#6,2(a5)			; warte auf das Ende des Blitters
WaitBlit:
	btst	#6,2(a5)
	bne.s	WaitBlit

	move.l	#$09f00000,$40(a5)	; BLTCON0 und BLTCON1 - Kopie A nach D
	move.l	#$ffffffff,$44(a5)	; BLTAFWM und BLTALWM wir werden es spter erklren

; Lade die Zeiger

	move.l	d0,$50(a5)			; BLTAPT
	move.l	d2,$54(a5)			; BLTDPT

; Diese 2 Anweisungen legen die Quell- und Zielmodulo fest
; Beachten Sie, dass Quelle und Ziel innerhalb des selben 
; Bildschirms liegen das Modulo ist das gleiche.
; das Modulo berechnet sich nach der Formel (H-L) * 2 (H ist die Breite der
; Bitebene in Worten und L ist die Breite des Bildes, immer in Worten)
; das haben wir in der Lektion gesehen, (20-160 / 16) * 2 = 20
; 20 words - (160 Pixel / 16 Pixel/Word) * 2 = 20 Bytes

	move.w	#(20-160/16)*2,$64(a5)	; BLTAMOD
	move.w	#(20-160/16)*2,$66(a5)	; BLTDMOD

; Beachten Sie auch, dass Sie, da die 2 Register aufeinanderfolgende 
; Adressen haben, knnen Sie eine einzige Anweisung anstelle von 2
; verwenden (denken Sie daran, dass 20 = $14) ist:
; move.l # $00140014,$64(a5)	; BLTAMOD und BLTDMOD

	move.w	#(20*64)+160/16,$58(a5)		; BLTSIZE						
								; Hhe 20 Zeilen
								; 160 Pixel breit (= 10 Wrter)
						
; Aktualisieren Sie die Variablen, die die Adressen enthalten, damit sie in 
; den folgenden Bitebenen darauf zeigen

	add.l	#40*256,d2			; Zieladresse nchste Ebene
	add.l	#40*256,d0			; Quelladresse nchste Ebene

	dbra	d1,CopyLoop

	btst	#6,$02(a5)			; warte auf das Ende des Blitters
WaitBlit2:
	btst	#6,$02(a5)
	bne.s	WaitBlit2
	rts

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

	dc.w	$100,$3200			; BPLCON0 - 1 Bitplane lowres

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane
	dc.w	$e4,$0000,$e6,$0000
	dc.w	$e8,$0000,$ea,$0000

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$475			; COLOR01
	dc.w	$0184,$fff			; COLOR02
	dc.w	$0186,$ccc			; COLOR03
	dc.w	$0188,$999			; COLOR04
	dc.w	$018a,$232			; COLOR05
	dc.w	$018c,$777			; COLOR06
	dc.w	$018e,$444			; COLOR07

	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

Bitplane:
	incbin	"/Sources/amiga.raw"	; Hier laden wir die Figur	
	
	end

;****************************************************************************

In diesem Beispiel kopieren wir mit dem Blitter ein Bild, das aus drei 
Bitebenen gebildet wird. Beachten Sie, dass die Schleife in der die Blitts
ausgefhrt werden strukturiert ist.
Die Quell- und Zieladressen werden in 2 Datenregister des Prozessors geladen,
die als Variablen verwendet werden. Bei jeder Wiederholung werden sie
modifiziert, um auf die nchste Bitebene zu zeigen. 
Dazu wird die Formel verwendet:

ADRESSE2 = ADRESSE1+2*H*V

Das hatten wir in der Lektion gesehen. In unserem Beispiel ist V = 256 (die
Anzahl der Zeilen) und H = 20 (die Breite des Bildschirms in Worten).

In diesem Beispiel sind Quelle und Ziel der Blitts auf dem gleichen Bildschirm
enthalten. Deshalb ist das Modulo fr beide gleich und wird nach der blichen
Formel berechnet.