
; Listing9e3.s		Komplette horizontale Verschiebung mit Shift + nderung des
; Ziels (um 2 Bytes = 16 Pixel)

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"		; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"		; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	EQU	%1000001111000000	; Bitplane, Copper, Blitter DMA ; $83C0


Start:
	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

	moveq	#0,d1				; Horizontale Koordinate startet mit 0
	move.w	#(320-32)-1,d7		; Es bewegt sich um 320 Pixel Minus die Breite
								; vom BOB, um sicherzustellen das 
								; sein erstes Pixel auf der linken Seite ist
								; Wir stoppen, wenn der BOB am Ende 
								; des Bildschirms rechts ankommt.
Loop:
	cmp.b	#$ff,$6(a5)			; VHPOSR - Warte auf Zeile $ff
	bne.s	loop
WarteY:
	cmp.b	#$ff,$6(a5)			; noch Zeile $ff?
	beq.s	WarteY

;	  \\ ,\\  /, ,,//
;	   \\\\\X///////
;	    \___  __/
;	   _;=(  )(_)
;	  (, _ T  \\
;	   T /\ '   ,)/
;	   |('/\_____/__
;	   l_         \
;	    _TT
;	 /l___\
;	/___,    ,___\
;	//  __T\\
;	(  \___/ '\ \ \
;	 \_________) \ \
;	    l_____ \  \ \
;	    / ___T   \ \
;	   / _/ \ l_    ) \
;	   \ \  \  \  ())))
;	  __\__\  \  )  
;	 (______)  \/\ xCz
;	           / /
;	          (_/

	lea	Bitplane,a0				; Ziel in a0
	move.w	d1,d0
	and.w	#$000f,d0			; wir whlen die ersten 4 Bits aus, weil sie 
								; in den Shifter von Kanal A eingefgt werden
	lsl.w	#8,d0				; die 4 Bits werden zum High-Nibble bewegt
	lsl.w	#4,d0				; des Wortes ... (8 + 4 = 12-Bit-Verschiebung)
	or.w	#$09f0,d0			; ... nur um in das BLTCON0-Register zu kommen				
								; Hier setzen wir $f0 in den Minterm fr die Kopie von
								; Quelle A nach Ziel D und aktivieren
								; natrlich die A + D Kanle mit $0900 (Bit 8
								; fr D und Bit 11 fr A). Das ist $09f0 + Verschiebung.
	move.w	d1,d2
	lsr.w	#3,d2				; (entspricht einer Division durch 8)
								; Runden auf ein Vielfaches von 8 fr den Zeiger
								; auf den Bildschirm, also auch auf ungerade Adressen
								; (also zu Bytes)
								; zB: eine 16 als Koordinate wird zu Byte 2
	and.w	#$fffe,d2			; Ich schliee Bit 0 aus
								; Ad: oder anders geschrieben:
	;lsr.w	#4,d2				; dividiert durch 16 (Word)
	;lsl.w	#1,d2				; und multipliziert * 2 (Byte)
	add.w	d2,a0				; addieren zur Adresse der Bitebene, 
								; um die richtige Zieladresse zu finden
	addq.w	#1,d1				; addiere 1 zur horizontalen Koordinate

	btst	#6,2(a5)			; DMACONR
WaitBlit1:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit1

; Jetzt, wie in der Theorie erklrt, nutzen wir die Gelegenheit, Werte 
; mit einem einzigen 'move.l' in zusammenhngende Register zu schreiben

	move.l	#$01000000,$40(a5)	; BLTCON0 + BLTCON1
	move.w	#$0000,$66(a5)		; BLTDMOD (=0)
	move.l	#Bitplane,$54(a5)	; BLTDPT
	move.w	#(64*6)+20,$58(a5)	; wenn sie diese Zeile entfernen wird
								; der Bildschirm nicht sauber sein,
								; damit der Fisch keine "Spur" zieht

	btst	#6,2(a5)			; DMACONR
WaitBlit2:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit2

	move.l	#$ffffffff,$44(a5)	; BLTAFWM und BLTALWM wir werden es spter erklren
	move.w	d0,$40(a5)			; BLTCON0 (A+D)
	move.w	#$0000,$42(a5)		; BLTCON1 (wir werden es spter erklren)
	move.l	#$00000024,$64(a5)	; BLTAMOD (=0) + BLTDMOD (=40-4=36=$24)
	move.l	#Figur,$50(a5)		; BLTAPT  (an der Quellfigur fixiert)
	move.l	a0,$54(a5)			; BLTDPT  (Bildschirm)
	move.w	#(64*6)+2,$58(a5)	; BLTSIZE (Bitter starten !)
								; wir blitten 2 Wrter, aber da das zweite
								; Word auf Null gesetzt ist, wird hier "nichts"
								; in die Bitplane geschrieben				

	btst	#6,$bfe001			; linke Maustaste gedrckt?
	beq.s	Exit

	dbra	d7,Loop

Exit:
	rts

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

	dc.w	$100,$1200			; BPLCON0 - 1 Bitplane LowRes

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$eee			; COLOR01
	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

; der kleine Fisch:

Figur:
	dc.w	%1000001111100000,0
	dc.w	%1100111111111000,0
	dc.w	%1111111111101100,0
	dc.w	%1111111111111110,0
	dc.w	%1100111111111000,0
	dc.w	%1000001111100000,0

;****************************************************************************

	SECTION	LEEREPLANE,BSS_C	

Bitplane:
	ds.b	40*256				; Bitplane lowres

	end

;****************************************************************************

In diesem Beispiel verschieben wir unsere Figur um eine beliebige Anzahl von
Pixeln. Die horizontale Koordinate der Figur ist in d1 gespeichert. Diese
Koordinate wird durch 8 geteilt, um die Speicheradresse des Wortes zu berechnen
zu dem es gehrt. Die 4 Bits der Koordinate, sie sind der Wert der
Verschiebung, wie in der Lektion erklrt.
