
; Listing9e2.s		SHIFTING mit 2-Word-breitem-Objekt (ein Null-Wort)

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"		; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"		; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	EQU	%1000001111000000	; Bitplane, Copper, Blitter DMA ; $83C0


Start:
	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

	moveq	#0,d4				; horizontale Koordinate startet mit 0
Loop:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$10800,d2			; Warte auf Zeile $108
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile $108
	bne.s	WarteY1
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile $108
	beq.s	WarteY2
;	            .
;	           ..:.::.:
;	          .;/'____  `;l
;	          ;/ /   \  __\
;	          / /     \/o\\
;	         /  \______/\__//
;	        / ____       \  \
;	        \ \   \    ,  )  \
;	        /\ \   \_________/
;	       /    \   l_l_|/ /
;	      /    \ \      / /
;	   __/    _/\ \/\__/ /
;	  / `----'\______/
;	 /  __      __ \
;	/   /        T  \

	move.w	d4,d5				; aktuelle horizontale Koordinate in d5

	and.w	#$000f,d5			; wir whlen die ersten 4 Bits aus, weil sie
								; in den Shifter von Kanal A eingefgt werden
	lsl.w	#8,d5				; die 4 Bits werden zum High-Nibble bewegt
	lsl.w	#4,d5				; des Wortes ... (8 + 4 = 12-Bit-Verschiebung!)
	or.w	#$09f0,d5			; ... nur um in das BLTCON0-Register zu kommen
								; Hier setzen wir $f0 in den Minterm fr die Kopie von
								; Quelle A nach Ziel D und aktivieren
								; natrlich die A + D Kanle mit $0900 (Bit 8
								; fr D und Bit 11 fr A). Das ist $09f0 + Verschiebung.

	addq.w	#1,d4				; Addiere 1 zur horizontalen Koordinate
								; gehe beim nchsten Mal 1 Pixel nach rechts

	move.w	#$ffff,$44(a5)		; BLTAFWM wir erklren es spter
	move.w	#$ffff,$46(a5)		; BLTALWM wir erklren es spter
	move.w	d5,$40(a5)			; BLTCON0 (A+D) - im Register
								; setzen wir die Shiftbits! (Bits 12,13
								; 14 und 15, d.h. High Nibble!)
	move.w	#$0000,$42(a5)		; BLTCON1 wir erklren es spter
	move.w	#0,$64(a5)			; BLTAMOD (=0)
	move.w	#36,$66(a5)			; BLTDMOD (40-4=36)
	move.l	#Figur,$50(a5)		; BLTAPT  (an der Quellfigur fixiert)
	move.l	#Bitplane,$54(a5)	; BLTDPT  (Bildschirm)
	move.w	#(64*6)+2,$58(a5)	; BLTSIZE (Blitter starten !)
								; wir blitten 2 Wrter, aber da das zweite
								; Word auf Null gesetzt ist, wird hier "nichts"
								; in die Bitplane geschrieben
											 
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	loop

	btst	#6,2(a5)			; DMACONR
WaitBlit2:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit2

	rts

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

	dc.w	$100,$1200

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$eee			; COLOR01

	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

; Hier ist der Fisch ... diesmal haben wir ein zweites Wort fr jede Zeile auf
; Null gesetzt
; Mae: 32 * 6

Figur:
	dc.w	%1000001111100000,%000000000000000
	dc.w	%1100111111111000,%000000000000000
	dc.w	%1111111111101100,%000000000000000
	dc.w	%1111111111111110,%000000000000000
	dc.w	%1100111111111000,%000000000000000
	dc.w	%1000001111100000,%000000000000000

;****************************************************************************

	SECTION	LEEREPLANE,BSS_C	

Bitplane:
	ds.b	40*256				; Bitplane lowres

	end

;****************************************************************************

In diesem Beispiel bewegen wir eine Figur jeweils um einen Pixel nach rechts
mit der Verschiebung, mit einem Nullwort rechts von jeder Zeile. Es verbessert
den Effekt im Vergleich zu Listing9e1.s.

Da wir die Zieladresse nicht erhhen, bewegt sich die Figur nur mit dem 
Blitter-Shifter. Auf diese Weise ist es mglich, bis zu 15 Pixel zu bewegen. 
Die 15 ist der maximal mgliche Verschiebungswert.
Nach Erreichen von 15 kehrt der Verschiebungswert zum Wert 0 zurck. (Wir
erhalten das, indem die 4 Bits als die Position der Figur genommen werden.)
Die Figur kehrt in die Ausgangsposition zurck, um sich wieder zu bewegen.
Um einen "richtigen" Bildlauf zu bekommen, werden alle 15 Scrollpixel genutzt
und anschlieend muss das Bild einen Shift von 16 Pixeln auslsen indem man
2 zum Ziel addiert und mit dem Shiften bei Null wieder beginnt.
Dies ist so hnlich wie wir es mit dem Scroll mit BPLCON1 ($dff102) und den
Bplpointers in der Copperliste gesehen haben.
