
; Listing9d2.s		Schleife mit einem Blitt von 6 Zeilen Hhe und Modulo 
; Wir setzen auch den gesamten Bildschirm jedes Mal neu, um zu vermeiden
; dass das "Zeichen" bleibt.

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"		; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"		; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	EQU	%1000001111000000	; Bitplane, Copper, Blitter DMA ; $83C0


Start:
	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter 
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

	lea	Bitplane,a0				; Adresse Bitplane Ziel
	move.w	#150-1,d7			; Anzahl der Blitts 150

BlitLoop:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$10800,d2			; Warte auf Zeile $108
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile $108
	bne.s	WarteY1
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile $108
	beq.s	WarteY2

	btst	#6,2(a5)			; DMACONR
WaitBlit:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit

;	Bildschirm lschen

	move.w	#$0100,$40(a5)		; BLTCON0 - nur Kanal D einschalten
								; dies verursacht die Lschung des
								; Ziels, da es keine Quelle gibt !!!					
	move.w	#$0000,$42(a5)		; BLTCON1 wir erklren es spter
	move.w	#$0000,$66(a5)		; BLTDMOD = 0, in der Tat die Zeilen der
								; Bitebene sind fortlaufend im Speicher angeordnet					
	move.l	#Bitplane,$54(a5)	; BLTDPT - Ziel (Bitplane)
	move.w	#(64*256)+20,$58(a5)	; BLTSIZE - Hhe 256 Zeilen, Breite 20 Wrter
								; lsche tatschlich den ganzen Bildschirm
								; die Zeilen sind 256, (64 * 256) und 
								; 40 Bytes pro Zeile sind 20 Wrter

	btst	#6,2(a5)			; DMACONR
WaitBlit2:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit2

;	Kopie der Figur

;	  ...........
;	. ...  ...  :
;	|.      .|
;	l_____  _____|
;	 | `',.`'  |
;	 | _________ |
;	 |    TlT  |
;	 l___ `---'__|xCz
;	    `------'

	move.w	#$ffff,$44(a5)		; BLTAFWM wir erklren es spter
	move.w	#$ffff,$46(a5)		; BLTALWM wir erklren es spter
	move.w	#$09f0,$40(a5)		; BLTCON0 (Kanal A und D einschalten)
	move.w	#$0000,$42(a5)		; BLTCON1 wir erklren es spter
	move.w	#0,$64(a5)			; BLTAMOD (=0)
	move.w	#36,$66(a5)			; BLTDMOD (40-4=36)
	move.l	#Figur,$50(a5)		; BLTAPT  (an der Quellfigur fixiert)
	move.l	a0,$54(a5)			; BLTDPT  (Ziel: Bildschirmzeilen)
	move.w	#(64*6)+2,$58(a5)	; BLTSIZE (Blitter starten !)					
								; Jetzt werden wir ein Bild von
								; 2 Wrtern x 6 Zeilen mit nur einem Blitt,
								; welches wir mit den Modulo entsprechend fr den 
								; Bildschirm richtig eingestellt haben, blitten.

	add.w	#40,a0				; Zeile in der nchsten Schleife.					
	dbra	d7,BlitLoop			; zum nchsten Blitt gehen

Mouse:

	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse

	btst	#6,2(a5)			; DMACONR
WaitBlit3:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit3

	rts

;****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

	dc.w	$100,$1200			; Bplcon0 - 1 Bitplane lowres

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$eee			; COLOR01
	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

; Wir definieren binr die Figur, die 16 Bits breit oder 2 Wrter und 
; 6 Zeilen hoch ist

Figur:
	dc.l	%00000000000000000000110001100000
	dc.l	%00000000000000000011000110000000
	dc.l	%00000000000000001100011000000000
	dc.l	%00000110000000110001100000000000
	dc.l	%00000001100011000110000000000000
	dc.l	%00000000011100011000000000000000

;****************************************************************************

	SECTION	LEEREPLANE,BSS_C	

Bitplane:
	ds.b	40*256				; Bitplane lowres

	end

;****************************************************************************

In diesem Beispiel verbessern wir das vorherige Listing9d1.s.
Die Figur zieht nun keine Spur mehr, weil wir jedes Mal den ganzen Bildschirm
lschen. Eigentlich ist es ein bisschen zu viel, den ganzen Bildschirm zu
lschen, es wre genug nur das gewnschte Rechteck zu lschen. Wie auch immer,
wir machen es!