
; Listing9c3.s		Blitt mit negativen Modulo
; Linke Taste, um den Blitt auszufhren, rechts um zu beenden.

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"		; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"		; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	EQU	%1000001111000000	; Bitplane, Copper, Blitter DMA ; $83C0


Start:
	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse

	btst	#6,2(a5)			; DMACONR
WaitBlit:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit
;	      __
;	     /\ \
;	    /  \ \
;	   / /\ \ \
;	  / / /\ \ \
;	 / / /__\_\ \
;	/ / /________\
;	\/___________/		

	move.w	#$ffff,$44(a5)		; BLTAFWM - wir erklren es spter
	move.w	#$ffff,$46(a5)		; BLTALWM - wir erklren es spter

	move.w	#$09f0,$40(a5)		; BLTCON0 - Kanal A und D einschalten, 
								; MINTERMS=$f0, das heit, Kopieren von A nach D

	move.w	#$0000,$42(a5)		; BLTCON1 - wir erklren es spter

	move.w	#2*(20-8),$66(a5)	; BLTDMOD - wie immer.

	move.w	#-16,$64(a5)		; BLTAMOD - das Bild ist 8 Wrter breit
								; (16 Bytes): um zum Anfang zurckzukehren
								; legen wir die negative Form an.

	move.l	#Figur,$50(a5)		; BLTAPT - Adresse Quellfigur 

; Die Zieladresse hngt von der gewnschten X- und Y-Position ab
; zeichne das erste Pixel der Figur. Die Regeln der Lektion gelten
; In diesem Fall X = 32 und Y = 4.

	move.l	#Bitplane+(4*20+32/16)*2,$54(a5)	; BLTDPT - Adresse Ziel
	move.w	#64*10+8,$58(a5)	; BLTSIZE - Hhe 10 Zeilen,
								; 8 Wrter Breite.

Mouse2:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse2

	btst	#6,2(a5)			; DMACONR
WaitBlit2:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit2

	rts


;*****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

	dc.w	$100,$1200			; BPLCON0 - 1 Bitplane lowres

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$eee			; COLOR01

	dc.w	$ffff,$fffe			; Ende Copperlist

;*****************************************************************************

; Dies ist die "Figur", die mit einem Blitt in die Bitplane kopiert wird

Figur:	
	dc.w	$1111,$1010,$2044,$235a
	dc.w	$18f0,$97ff,$ca54,$90a2

;*****************************************************************************

	SECTION	LEEREPLANE,BSS_C

Bitplane:
	ds.b	40*256		; Bitplane lowres

	end

;*****************************************************************************

In diesem Beispiel haben wir ein einzeiliges hohes Bild, das wir beginnend von
einer bestimmten Zeile des Bildschirms, 10 Mal kopieren. Jedes Mal gehen wir
eine Zeile tiefer. 
Natrlich knnten wir einfach eine Schleife von 10 Blitts machen, bei der wir
jedes Mal die Zieladresse ndern. Es ist jedoch mglich, es mit nur einem Blitt
zu erledigen, welches einen negativen Wert fr das Quellmodulo hat. Wie Sie
wissen, wird der Wert des Modulo dem Inhalt der Adresse im Zeigerregister jedes
Mal, wenn der Blitter eine Zeile beendet hinzugefgt.
Normalerweise setzt man im Modulo einen positiven Wert, der den Blitter erlaubt
die Wrter, die nicht zum Rechteck gehren, zu "berspringen" und zur nchsten
Zeile zu gehen. Wenn das Modulo jedoch einen negativen Wert hat, wird die
Adresse die im Zeigerregister enthalten ist "zurckgegangen".
Insbesondere wenn der Blitt L Wrter breit ist, und eine Zeile mit dem im
Zeiger enthaltenen Wert kopiert wird es um 2 * L erhht (weil der Zeiger Bytes
zhlt, und 1 Wort = 2 Bytes ist).
Wenn wir den Wert -2 * L in das Modulo schreiben, gehen wir mit dem Zeiger 
genau an den Anfang der Zeile zurck. In diesem Beispiel tun wir genau das
mit der Quelle. Wir lesen jedes Mal die gleiche Zeile neu. Fr das Ziel
verhalten wir uns stattdessen normal und dann werden die 10 Zeilen eine unter
der anderen geschrieben.
Wenn Sie sich erinnern, haben wir einen hnlichen Effekt mit den Bitplane-
Modulos gemacht. Wenn Sie sie auf -40 setzen, erhalten wir eine unendliche
"Verlngerung" der ersten Zeile, aber nur auf der Ansichtsebene. In diesem 
Fall schreiben wir stattdessen die selbe Zeile mehrmals mit dem Blitter in den
Speicher.  
