
; Listing9b2.s		 Schleife von Blitts

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"		; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"		; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	EQU	%1000001111000000	; Bitplane, Copper, Blitter DMA ; $83C0


Start:
	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

; In a0 wird die Adresse des Ziels gespeichert, die sich mit der Zeit ndert
; Die Anfangsadresse wird berechnet, um die Figur bei 
; Zeile Y = 3 beginnend mit dem Pixel mit X = 0 anzuzeigen

	lea	Bitplane+(3*20+0/16)*2,a0	; Zieladresse
	move.w	#200-1,d7			; Anzahl Schleifendurchlufe = 200

BlitLoop:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$10800,d2			; Warte auf Zeile $108
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile $108
	bne.s	WarteY1
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile $108
	beq.s	WarteY2

	btst.b	#6,2(a5)			; DMACONR
WaitBlit:
	btst.b	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit

;	          (####)
;	        (#######)
;	      (#########)
;	     (#########)
;	    (#########)
;	   (#########)
;	  (#########)
;	   (o)(o)(##)
;	 ,_c     (##)
;	/____,   (##)
;	  \     (#)
;	   |    |
;	   oooooo
;	  /      \

	move.w	#$ffff,$44(a5)		; BLTAFWM wir werden es spter erklren
	move.w	#$ffff,$46(a5)		; BLTALWM wir werden es spter erklren
	move.w	#$05cc,$40(a5)		; BLTCON0 (eine Kopie von B nach D erstellen)
	move.w	#$0000,$42(a5)		; BLTCON1 wir werden es spter erklren
	move.w	#$0000,$62(a5)		; BLTBMOD wir werden es spter erklren
	move.w	#$0000,$66(a5)		; BLTDMOD wir werden es spter erklren
	move.l	#Figur,$4c(a5)		; BLTBPT  (an der Quellfigur fixiert)
	move.l	a0,$54(a5)			; BLTDPT  (variables Ziel a0)
	move.w	#64*1+10,$58(a5)	; BLTSIZE (Blitter starten!)
								; jetzt statt 8 Wrter, wie im
								; vorherigen Beispiel, Block von 10 Wrtern

	add.w	#40,a0				; Lass uns zum nchsten Blitt gehen
								; Zeile in der nchsten Schleife.
	dbra	d7,BlitLoop

Mouse:
	btst	#6,$bfe001			; linke Mausetaste gedrckt?
	bne.s	Mouse

	btst.b	#6,2(a5)			; DMACONR
WaitBlit2:
	btst.b	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit2

	rts

;*****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

	dc.w	$100,$1200			; BPLCON0 - 1 Bitplane lowres

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$eee			; COLOR01

	dc.w	$ffff,$fffe			; Ende Copperlist

*****************************************************************************

	SECTION	GRAPHIC,DATA_C

Figur:
	dc.w	$8888,$aaaa,$cccc,$f0f0
	dc.w	$ffff,$6666,$eeee,$5555
	dc.w	$2222,$dddd

*****************************************************************************

	SECTION	LEEREPLANE,BSS_C	

Bitplane:
	ds.b	40*256				; Bitplane lowres

	end

*****************************************************************************

Dieses Beispiel ist eine Variation des Beispiels Listing9b1.s.
Beachten Sie, wie die Daten kopiert werden, indem wir die Zieladresse in die
verschiedenen Bereichen des Bildschirms ndern. Jeder Blitt wird eine Zeile
weiter gemacht (auf dem Bildschirm niedriger) als der vorherige. Dies wird
erreicht, indem die Zieladresse immer um 40 (= Anzahl Bytes fr jede Zeile)
erhht wird.

Beachten Sie eine sehr wichtige Sache: Immer, bevor ein Blitt gestartet wird,
das der vorherige Blitter-Block mit der WaitBlit-Schleife beendet ist.

In diesem Beispiel haben wir den Kanal B als Quellkanal verwendet.
Folglich verwenden wir die BLTBPT- und BLTBMOD-Register anstelle von BLTAPT 
und BLTAMOD. Auerdem ist der in BLTCON0 geschriebene Wert anders, weil wir 
den Kanal B anstelle von Kanal A aktivieren (daher Bit 11 ist 0 und Bit 10
ist 1) und das wir die MINTERMS auf den Wert $cc setzen mssen, der genau
eine Kopie von Kanal B zu Kanal D definiert.                     