
; Listing9b1.s		Blitt, in dem wir 8 Wrter in eine Null-Bit-Ebene kopieren.
; Linke Taste, um den Blitt auszufhren, rechts um zu beenden.

	SECTION	BLIT,CODE

;	include	"DaWorkBench.s"		; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/startup1.s"		; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	EQU	%1000001111000000	; Bitplane, Copper, Blitter DMA ; $83C0	


Start:
	move.l	#Bitplane,d0		; Zeiger auf die "leere" Bitplane
	lea	Bplpointers,a1			; Bitplanepointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	lea	$dff000,a5				; Custom Register Base in a5
	move.w	#DMASET,$96(a5)		; DMACON - einschalten Bitplane, Copper, Blitter
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	btst	#6,$bfe001			; Warten, bis die linke Maustaste gedrckt wird
	bne.s	Mouse

	btst.b	#6,2(a5)			; DMACONR
WaitBlit:
	btst.b	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit

;	 |\/\/\/|
;	 |      |
;	 |      |
;	 | (o)(o)
;	 c      _)
;	  | ,___|
;	  |   /
;	 /____\
;	/      \		

	move.w	#$ffff,$44(a5)		; BLTAFWM - wir werden es spter erklren
	move.w	#$ffff,$46(a5)		; BLTALWM - wir werden es spter erklren

	move.w	#$09f0,$40(a5)		; BLTCON0 - Kanal A und D ist aktiviert, 
								; MINTERMS=$f0, das Kopieren von A nach D ist definiert
	move.w	#$0000,$42(a5)		; BLTCON1 - wir werden es spter erklren
	move.l	#Figur,$50(a5)		; BLTAPT - Adresse Quelle

; Die Zieladresse hngt von der gewnschten X- und Y-Position ab
; zeichne das erste Pixel der Figur. Die Regeln der Lektion gelten
; In diesem Fall X = 32 und Y = 4.

	move.l	#Bitplane+(4*20+32/16)*2,$54(a5)	; BLTDPT - Adrese Ziel
	move.w	#64*1+8,$58(a5)		; BLTSIZE - Hhe 1 Zeile, Breite 8 Wrter

Mouse2:
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse2

	btst	#6,2(a5)			; DMACONR
WaitBlit2:
	btst	#6,2(a5)			; DMACONR - warte auf das Ende des Blitters
	bne.s	WaitBlit2

	rts

;******************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$38				; DDFSTRT
	dc.w	$94,$d0				; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

	dc.w	$100,$1200			; BPLCON0 - 1 Bitplane lowres

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane

	dc.w	$0180,$000			; COLOR00
	dc.w	$0182,$eee			; COLOR01

	dc.w	$ffff,$fffe			; Ende Copperlist

;*****************************************************************************

; Dies ist die "Figur", die mit einem Blitt in die Bitplane kopiert wird:

Figur:	
	dc.w	$1111,$1010,$2044,$235a
	dc.w	$18f0,$97ff,$ca54,$90a2

;******************************************************************************

	SECTION	LEEREPLANE,BSS_C

Bitplane:
	ds.b	40*256				; Bitplane zurcksetzen lowres

	end

;******************************************************************************

In diesem Beispiel kopieren wir einen Speicherbereich mit dem Blitter.
Genauer gesagt lesen wir 8 Wrter (betrachten sie es als ein 8 Wrter groes 
und nur eine Zeile hohes Rechteck) beginnend mit der identifizierten Adresse
vom Label "Figur:" und berschreiben sie beginnend mit der Adresse
identifiziert durch das Label "Bitplane:" Das Label Bitplane ist die Adresse 
einer Speicherzone, die eine Bitebene enthlt.
Eigentlich kopieren wir die Daten in die Bitplane + Offset, was von der
Anfangsecke versetzt ist. Daher werden die Daten, die wir kopieren, auf dem
Bildschirm angezeigt.
Um einen Kopiervorgang durchzufhren, mssen 2 DMA-Kanle verwendet werden,
eine zum Lesen und eine zum Schreiben. In diesem Fall benutzen wir den Kanal A
zum Lesen und Kanal D zum Schreiben. Daher werden nur diese 2 Kanle
aktiviert, indem die zugehrigen Bits im BLTCON0-Register auf 1 gesetzt werden.
Um dem Blitter mitzuteilen, dass er eine Kopie von Kanal A an den Kanal D
senden soll ist es notwendig, das Byte, das die MINTERMS enthlt, auf den Wert
$f0 zu setzen.
Versuchen Sie, die Position zu ndern, in der die Figur gezeichnet wird, indem 
sie die Zieladresse des Blitts variieren. Wenden Sie das in der Lektion
gelernte Wissen an.
