
; Listing8r.s		Prozessorerkennung und -routinen
; Chipsatz (aga oder normal).
; (Aber fr uns macht das die Sysinfo !!)

	SECTION	SYSINFO,CODE

*****************************************************************************
	include	"/Sources/Startup1.s"	; Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001110000000	; nur Copper und Bitplane DMA

Start:
;	Zeiger auf Bitplanes in Copperlist

	move.l	#Bitplane,d0		; in d0 setzen wir die Adresse der Bitplane
	lea	Bplpointers,a1			; Bitplanepointer in der Copperlist
	move.w	d0,6(a1)			; kopiere das LOW Wort der Bitplaneadresse
	swap	d0					; vertausche die 2 Wrter von d0 (zB: 1234> 3412)
	move.w	d0,2(a1)			; kopiere das HIGH Wort der Bitplaneadresse

; Beachten Sie die -80 !!!! (um den "Tiefen" - Effekt zu verursachen)

	move.l	#Bitplane-80,d0		; in d0 setzen wir die Adresse der Bitplane -80
								; das ist eine SUB-Zeile! *******
	lea	Bplpointers2,a1			; Bitplanepointer in der Copperlist
	move.w	d0,6(a1)			; Kopiere das LOW Wort der Bitplaneadresse
	swap	d0					; Vertausche die 2 Wrter von d0 (zB: 1234> 3412)
	move.w	d0,2(a1)			; Kopiere das HIGH Wort der Bitplaneadresse

	bsr.s	CpuDetect			; wir prfen, welche CPU vorhanden ist und wechseln
								; den Text richtig wenn es kein 68000 ist
								; grundlegend.
	bsr.w	FpuDetect			; berprfen, ob ein Coprozessor vorhanden ist
								; mathematische Gleitkommazahl (Floating Point Unit)

	bsr.w	AgaDetect			; berprfen, ob der AGA-Chipsatz vorhanden ist.

	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper
								; und sprites.

	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"


Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$10800,d2			; Warte auf Zeile = $108
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos. 
	cmp.l   d2,d0				; Warte auf Zeile = $108
	bne.s	WarteY1
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos. 
	cmp.l   d2,d0				; Warte auf Zeile = $108
	beq.s	WarteY2

	bsr.w	DruckeZeichen		; Drucke jeweils ein Zeichen

	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse

	rts

;*****************************************************************************
;			ROUTINE ZUM ERKENNEN DES PROZESSORS
;
; Sowohl diese Routine als auch die, die das Vorhandensein der FPU feststellt, 
; verwendet ein Spezialbyte des Betriebssystems, das sich $129 Bytes nach $4
; befindet, dh execBase + $129.
;
;	AttnFlags (dh Byte $129 (a6), in a6 ist die execBase)
;
;   Bit	CPU oder FPU
;
;	0	68010 (oder 68020/30/40)
;	1	68020 (oder 68030/40)
;	2	68030 (oder 68040)		[V37+]
;	3	68040 					[V37+]
;	4	68881 FPU fitted (oder 68882)
;	5	68882 FPU fitted		[V37+]
;	6	68040 FPU fitted		[V37+]
;
;*****************************************************************************

;	      /\                     ___.               /\
;	     /  \   ______  __      /   |_________     /  \NoS!
;	    /    \  \_    \/  \    /    |        /    /    \_ ___ _/\__
;	   //     \  /         \  /_____|   ____/___./     \ _ _ _  /
;	  //       \/    \  /   \/      |   \__     |       \\   /_)(_\
;	 /          \     \/     \      |     7     |         \    \/
;	/____________\____/_____/\______j___________j__________\

CpuDetect:
	lea	CpuType(pc),a1
	move.l	4.w,a6				; ExecBase in a6

; Hinweis: Der 68030/40 wird von KickStart 1.3 oder niedriger nicht erkannt,
; aber es wird davon ausgegangen, dass wer einen 68020+ hat, auch
; KickStart 2.0 oder hher hat!

	btst.b	#3,$129(a6)			; Attnflags - ein 68040?
	bne.s	M68040
	btst.b	#2,$129(a6)			; d0	; Attnflags - ein 68030?
	bne.s	M68030
	btst.b	#1,$129(a6)			; d0	; Attnflags - ein 68020?
	bne.s	M68020
	btst.b	#0,$129(a6)			; d0	; Attnflags - ein 68010?
	bne.s	M68010
M68000:
	bra.s	ProcDone			; ein 68000! lass den Text '68000'

M68010:
	move.w	#'10',(a1)			; ndert '68000' in '68010'
	bra.s	ProcDone

M68020:
	move.w	#'20',(a1)			; ndert '68000' in '68020'
	bra.s	ProcDone

M68030:
	move.w	#'30',(a1)			; ndert '68000' in '68030'
	bra.s	ProcDone

M68040:
	move.w	#'40',(a1)			; ndert '68000' in '68040'


ProcDone:
	rts

;*****************************************************************************
;			ROUTINE WELCHE DEN KOPROZESSOR ERKENNT
;*****************************************************************************

; wir berprfen nun, ob ein mathematischer Coprozessor (FPU) vorhanden ist.

FPUDetect:
	lea	FpuType(pc),a1			; Coprozessor-Textzeichenfolge (FPU)
	move.l	4.w,a6				; Execbase (Zugang zum byte AttnFlags)
	btst.b	#3,$129(a6)			; Wenn es sich um einen 68040 handelt, 
								; ist der Coprozessor im Lieferumfang enthalten!
	bne.s	FpuPresente
	btst.b	#4,$129(a6)			; d0	; 68881? -> FPU detected!
	bne.s	FpuPresente
	btst.b	#5,$129(a6)			; d0	; 68882? -> FPU detected!
	bne.s	FpuPresente
	bra.s	FpuNonPresente		; NO FPU! ....

FpuPresente:
	move.l	#'FOUN',(a1)+		; Wenn er vorhanden wurde, schreiben wir GEFUNDEN!
	move.b	#'D',(a1)+
FpuNonPresente:
	rts

;*****************************************************************************
;	      ROUTINE DIE DEN AGA CHIPSET ERKENNT (Mach NIEMALS einen Fehler!)
;*****************************************************************************

AgaDetect:
	lea	$dff000,a5
	move.w	$7c(a5),d0			; DeniseID (die LisaID AGA)
	moveq	#100,d7				; 100 mal kontrollieren (aus Sicherheitsgrnden)
								; dass die alte denise aus zuflligen werten)
DenLoop:
	move.w	$ff8,$dff180
	move.w	$7C(a5),d1			; Denise ID (die LisaID AGA)
	cmp.b	d0,d1				; gleicher Wert?
	bne.s	NotAga				; Nicht der gleiche Wert: Denise OCS!
	dbra	d7,DenLoop
	btst.l	#2,d0				; Bit 2 reset = AGA. Ist die Aga da?
	bne.s	NotAga				; nein?
	lea	Chipset(pc),a1			; ja!
	move.l	#'AGA ',(a1)+		; Setzen Sie AGA anstelle von NORMAL ein...
	move.w	#'  ',(a1)+
	lea	Message(pc),a1			; und gratuliere der AGA
	move.l	#'Grea',(a1)+
	move.l	#'te! ',(a1)+
	move.l	#'An A',(a1)+
	move.l	#'GA m',(a1)+
	move.l	#'achi',(a1)+
	move.l	#'ne !',(a1)+
	move.l	#'!!  ',(a1)+
	move.l	#'    ',(a1)+
	move.l	#'    ',(a1)+
	move.l	#'    ',(a1)
NotAga:							; nicht AGA... OCS/ECS... mah..
	rts							; Dann hinterlassen Sie die Nachricht, um es zu kaufen!

*****************************************************************************
;			Druckroutine
*****************************************************************************

DruckeZeichen:
	move.l	PointerText(pc),a0	; Adresse des zu druckenden Textes in a0
	moveq	#0,d2				; lsche d2
	move.b	(a0)+,d2			; Nchstes Zeichen in d2
	cmp.b	#$ff,d2				; Ende des Textsignals? ($ff)
	beq.s	EndText				; Wenn ja, beenden ohne zu drucken
	tst.b	d2					; Zeilenende-Signal? ($00)
	bne.s	NotEndLine			; Wenn nicht, nicht beenden

	add.l	#80*7,PointerBitplane	; Gehen wir zum Kopf
	addq.l	#1,PointerText		; erste Zeichenzeile nach
								; (berspringe die NULL)
	move.b	(a0)+,d2			; erstes Zeichen der Zeile nach
								; (berspringe die NULL)

NotEndLine:
	sub.b	#$20,d2				; ZHLE 32 VOM ASCII-WERT DES BUCHSTABEN WEG,
								; SOMIT VERWANDELN WIR Z.B. DAS LEERZEICHEN
								; (Das $20 entspricht), IN $00, DAS
								; AUSRUFUNGSZEICHEN ($21) IN $01....
	lsl.w	#3,d2				; MULTIPLIZIERE DIE ERHALTENE ZAHL MIT 8,
								; da die Charakter ja 8 Pixel hoch sind
	move.l	d2,a2
	add.l	#Font,a2			; FINDE DAS GEWNSCHTE ZEICHEN IM Font...

	move.l	PointerBitplane(pc),a3 ; Adresse der Zielbitebene in a3

								; WIR DRUCKEN DAS ZEILENZEICHEN ZEILENWEISE
	move.b	(a2)+,(a3)			; Drucke Zeile 1 des Zeichens
	move.b	(a2)+,80(a3)		; Drucke die Zeile 2  " "
	move.b	(a2)+,80*2(a3)		; Drucke die Zeile 3  " "
	move.b	(a2)+,80*3(a3)		; Drucke die Zeile 4  " "
	move.b	(a2)+,80*4(a3)		; Drucke die Zeile 5  " "
	move.b	(a2)+,80*5(a3)		; Drucke die Zeile 6  " "
	move.b	(a2)+,80*6(a3)		; Drucke die Zeile 7  " "
	move.b	(a2)+,80*7(a3)		; Drucke die Zeile 8  " "

	addq.l	#1,PointerBitplane	; wir bewegen uns 8 Bits vorwrts (NCHSTER ZEICHEN)
	addq.l	#1,PointerText		; nchstes zu druckendes Zeichen

EndText:
	rts


PointerText:
	dc.l	Text

PointerBitplane:
	dc.l	Bitplane

;	$00 fr "Zeilenende" - $ff fr "Textende"

			; Anzahl der Zeichen pro Zeile: 40
Text:	    ;		  1111111111222222222233333333334
            ;   1234567890123456789012345678901234567890
	dc.b	'    Loading Randy Operating System 1.02,'   ; 1
	dc.b	' please wait...                         ',0 ; 1b
;
	dc.b	'                                        '   ; 2
	dc.b	'                                        ',0 ; 2b
;
	dc.b	'    Testing HARDWARE...                 '   ; 3
	dc.b	'                                        ',0 ; 3b
;
	dc.b	'    Testing KickStart...                '   ; 4
	dc.b	'                                        ',0 ; 4b
;
	dc.b	'    Done.                               '   ; 5
	dc.b	'                                        ',0 ; 5b
;
	dc.b	'                                        '   ; 6
	dc.b	'                                        ',0 ; 6b
;
	dc.b	'    PROCESSOR (CPU):  680'
CpuType:
	dc.b	'00             '  ; 7
	dc.b	'                                        ',0 ; 7b
;
	dc.b	'    MATH COPROCESSOR: '
FpuType:
	dc.b	'NONE              '   ; 8
	dc.b	'                                        ',0 ; 8b
;
	dc.b	'    GRAPHIC CHIPSET:  '
Chipset:
	dc.b	'NORMAL           '   ; 9
	dc.b	'                                        ',0 ; 9b
;
	dc.b	'                                        '   ; 10
	dc.b	'                                        ',0 ; 10b
;
	dc.b	'     '
Message:
	dc.b	'Buy an AGA machine!                     '   ; 11
	dc.b	'                                        ',$ff ; 11b
;

	even


;	Die Font 8x8-Zeichen werden in CHIP von der CPU und nicht vom Blitter kopiert,
;	so kann es auch im Fast RAM sein. In der Tat wre es besser!

Font:
	incbin	"/Sources/nice.fnt"
******************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT	(Register mit normalen Werten)
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$003c			; DDFSTRT HIRES
	dc.w	$94,$00d4			; DDFSTOP HIRES
	dc.w	$102,0				; BPLCON1
	dc.w	$104,0				; BPLCON2
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD

			    ; 5432109876543210
	dc.w	$100,%1010001000000000	; bit 13 - 2 Bitplanes, 4 color HIRES

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane
Bplpointers2:
	dc.w	$e4,$0000,$e6,$0000	; zweite Bitplane

	dc.w	$180,$103			; COLOR00 - Hintergrund
	dc.w	$182,$fff			; COLOR01 - plane 1 normale Position, es ist
								; der Teil, der oben "hervorsteht".
	dc.w	$184,$345			; COLOR02 - plane 2 (Versatz unten)
	dc.w	$186,$abc			; COLOR03 - beide Ebenen - berlappen

	dc.w	$ffff,$fffe			; Ende Copperlist

******************************************************************************

	SECTION	MEINEPLANE,BSS_C		; ABSCHNITT BSS nur Nullen !!! 
			; Wir verwenden ds.b, um zu definieren
			; wie viele Nullen der Abschnitt enthlt.

; Deshalb brauchen wir die "ds.b 80":
; move.l #Bitplane-80,d0; in d0 setzen wir die Adresse der Bitplane -80
; das ist eine SUB-Zeile! *******

	ds.b	80					; die Zeile, die "berprfen"
Bitplane:
	ds.b	80*256				; eine Bitplane Hires 640x256

	end

Wenn Sie bemerken, ndern wir den Text, bevor er gedruckt wird, nichts Wunderbares.
Um herauszufinden, welcher Prozessor und welcher Chipsatz sich in Ihrem Computer 
befindet, wenden Sie sich einfach an die relativen Bits des Betriebssystems und 
des $dff07c. Es reicht jedoch aus eine Erkennung zu Beginn der Produktion 
anzuzeigen!!!