
; Listing8q.s  Verwendung von Bildern mit der Palette unten gespeichert (HINTER).
; Linke Taste zum "Frben", rechte zum Beenden.

	SECTION	Behind,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/Startup1.s"	; speichern Sie Copperlist Etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001110000000	; nur Copper und Bitplane DMA

Start:
	move.l	#Logo,d0			; Zeiger auf das Bild
	lea	Bplpointers,a1			; Bitplanepointer
	moveq	#4-1,d1				; Anzahl der Bitplanes (hier sind es 4)
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*84,d0			; + Lnge einer Bitplane (84 Zeilen hoch hier)
	addq.w	#8,a1
	dbra	d1,PointBp
	
	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper
								; und sprites.

	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse:
	btst.b	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse

;	          |||||
;	_____.oOo_/o_O\_oOo.____.

PointerColor:
	lea	Logo+(40*84*4),a0		; in a0 ist Adresse der Palette nach dem Bild,
								; man erhlt sie durch Addition der Lnge
								; der Bitebenen vom Anfang vom Bild
								; Die Farben bleiben!
	lea	CopColors+2,a1			; Adresse der Farbregister in der Coplist
	moveq	#16-1,d0			; Anzahl der Farben
PutLoop:
	move.w	(a0)+,(a1)			; Farben von der Palette in die Copperliste kopieren								
	addq.w	#4,a1				; zum nchsten Farbregister gehen
	dbra	d0,PutLoop			; mache alle Farben

Mouse2:
	btst.b	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse2

	rts

*****************************************************************************
;			Copperlist
*****************************************************************************
	
	SECTION	COPPER,DATA_C		; Chip data

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT - window start
	dc.w	$90,$2cc1			; DIWSTOP - window stop
	dc.w	$92,$38				; DDFSTRT - data fetch start
	dc.w	$94,$d0				; DDFSTOP - data fetch stop
	dc.w	$102,0				; BPLCON1 - scroll register
	dc.w	$104,0				; BPLCON2 - priority register
	dc.w	$108,0				; BPL1MOD - modulo pl. ungerade
	dc.w	$10a,0				; BPL2MOD - modulo pl. gerade

				; 5432109876543210
	dc.w	$100,%0100001000000000	; BPLCON0 - 4 planes lowres (16 color)

; Bitplane pointers

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste	 Bitplane
	dc.w	$e4,$0000,$e6,$0000	; zweite Bitplane
	dc.w	$e8,$0000,$ea,$0000	; dritte Bitplane
	dc.w	$ec,$0000,$ee,$0000	; vierte Bitplane

; Die ersten 16 Farben sind fr das LOGO

CopColors:
	dc.w	$180,0,$182,0,$184,0,$186,0	; Jetzt sind sie zurckgesetzt, wird
	dc.w	$188,0,$18a,0,$18c,0,$18e,0	; durch die Routine beim Kopieren von 
	dc.w	$190,0,$192,0,$194,0,$196,0	; Werten vom unteren Rand des Bildes
	dc.w	$198,0,$19a,0,$19c,0,$19e,0 ; gefllt.

;	Lassen Sie uns ein paar Nuancen fr die Szenografie setzen...

	dc.w	$8007,$fffe			; Wait - $2c+84=$80
	dc.w	$100,$200			; bplcon0 - no Bitplanes
	dc.w	$180,$003			; COLOR00
	dc.w	$8207,$fffe			; wait
	dc.w	$180,$005			; COLOR00
	dc.w	$8507,$fffe			; wait
	dc.w	$180,$007			; COLOR00
	dc.w	$8a07,$fffe			; wait
	dc.w	$180,$009			; COLOR00
	dc.w	$9207,$fffe			; wait
	dc.w	$180,$00b			; COLOR00
	dc.w	$9e07,$fffe			; wait
	dc.w	$180,$999			; COLOR00
	dc.w	$a007,$fffe			; wait
	dc.w	$180,$666			; COLOR00
	dc.w	$a207,$fffe			; wait
	dc.w	$180,$222			; COLOR00
	dc.w	$a407,$fffe			; wait
	dc.w	$180,$001			; COLOR00
	dc.l	$ffff,$fffe			; Ende Copperlist


*****************************************************************************
;				DESIGN
*****************************************************************************

	SECTION	GRAPHIC,DATA_C

; Design Gre 320 pixel, Hoch 84, 4 Bitplanes (16 Farben).

Logo:
	incbin	'/Sources/logo320x84x16c.raw'

	end

Wie ntzlich es ist, die Palette in der .raw Datei zu speichern, zeigt sich
beim Umgang mit vielen Bildern, zum Beispiel in Abenteuerspielen oder in
Diashows. In meiner "World of Manga" habe ich zum Beispiel dieses System
verwendet, mit den AGA Bildern, gespeichert durch den AGA iffconverter mit der
24-Bit-Palette am unteren Rand.
