
; Listing8p7.s	Verhalten der Condition Codes bei der Anweisung CMP

	SECTION	CONDCODES,CODE

Start:
	move.w	#$9000,d0
	move.w	#$6000,d1
	cmp.w	d0,d1	
	bgt.w	Skip
Stop:
	rts

Skip:
	nop		; Dieser Sprung wird gemacht, wenn das Ziel grer als die
			; Quelle ist
	rts

	end

Der CMP-Befehl ermglicht es uns, 2 Zahlen zu vergleichen und entsprechend die 
CCs einzustellen. Normalerweise folgt auf einen CMP ein Bcc-Befehl. 
Hier sind die 3 "Typen":

CMPA.x	<ea>,Ay		Quelle=All		Ziel=An (Hinweis: nur .W o .L).
-----------------------------------------------------------------------------
CMPI.x	#d,<ea>		Quelle=#d		Ziel=Daten, die gendert werden knnen
-----------------------------------------------------------------------------
CMPM.x	(Ax)+,(Ay)+	Quelle=(An)+	Ziel=(An)+
-----------------------------------------------------------------------------

Jede der 68000 Vergleichsanweisungen subtrahiert den Quelloperanden vom Ziel
und setzt die Bedingungsflags gem der folgenden Tabelle:

+----------------------+---+---+---+---+
|Zustand			   | N | Z | V | C |
+----------------------+---+---+---+---+
|Quelle<Ziel		   | 0 | 0 |0/1| 0 |
+----------------------+---+---+---+---+
|Quelle=Ziel		   | 0 | 1 | 0 | 0 |
+----------------------+---+---+---+---+
|Quelle>Ziel		   | 1 | 0 |0/1| 1 |
+----------------------+---+---+---+---+

Das V-Bit hat den Wert 1, wenn die Differenz zwischen Quelle und Ziel
ausserhalb des mglichen Ergebnisbereiches im Zweierkomplementfeld des
Operanden liegt.
(d.h. wenn es kleiner ist als das die kleinste darstellbare negative Zahl oder
grer ist als die grte darstellbare positive Zahl).
N und V sind nur beim Vergleich von 2er-Komplement-Operanden von Bedeutung.

HINWEIS: Anders als die Subtraktionsanweisungen speichern die
Vergleichsanweisungen nicht das Ergebnis der Subtraktion !!!!!!!!
(Es scheint mir klar zu sein!)
------------------------------------------------------------------------------

Bccs lesen den Status der CCs und wenn eine bestimmte Bedingung erfllt ist
(die zwischen den einzelnen Bccs variiert) wird ein Sprung ausgefhrt oder
nicht. Der CMP setzt die CC-Flags auf die gleiche Weise wie der SUB.

Sehen wir uns ein kurzes Beispiel an. Wir fhren einen Vergleich zwischen einer 
positiven und ein negativer Zahl durch. Wir sehen, dass das Ergebnis des
Vergleichs anders ausfllt, wenn wir die negative Zahl als positive betrachten.

Wir fhren das Programm bis zur BGT-Anweisung aus.

D0: 00009000 00006000 00000000 00000000 00000000 00000000 00000000 00000000 
A0: 00000000 00000000 00000000 00000000 00000000 00000000 00000000 07CA4F64 
SSP=07CA6097 USP=07CA4F64 SR=800B T1 -- PL=0 -N-VC PC=07CA7B52
PC=07CA7B52 6E000004		 BGT.W   $07CA7B58
>

Die bekannte BGT fhrt den Sprung aus, wenn der Zieloperand grer als der 
des Quelloperanden ist. Auerdem werden die Zahlen als Zweierkomplementwerte
betrachtet. In unserem Fall ist der Zieloperand grer als der Quelloperand,
da die erste Zahl positiv ist, whrend die zweite negativ ist.
Machen wir einen weiteren Schritt und berprfen es:

D0: 00009000 00006000 00000000 00000000 00000000 00000000 00000000 00000000 
A0: 00000000 00000000 00000000 00000000 00000000 00000000 00000000 07CA4F64 
SSP=07CA6097 USP=07CA4F64 SR=800B T1 -- PL=0 -N-VC PC=07CA7B58
PC=07CA7B58 4E71		 NOP
>

Wie Sie sehen, wurde der Sprung gemacht, in der Tat ist die nchste 
auszufhrene Anweisung das NOP.
Versuchen wir nun zu sehen, was passiert, wenn der BGT durch die BHI-Anweisung 
ersetzt wird. Dieser Befehl fhrt auch den Sprung aus, wenn der Zieloperand 
grer als der Quelloperand ist. Der Unterschied besteht darin, dass der BHI 
die Zahlen als positiv bercksichtigt.
Wir fhren das genderte Programm aus.

D0: 00009000 00006000 00000000 00000000 00000000 00000000 00000000 00000000
A0: 00000000 00000000 00000000 00000000 00000000 00000000 00000000 07CA4F64
SSP=07CA6097 USP=07CA4F64 SR=800B T1 -- PL=0 -N-VC PC=07CA7B52
PC=07CA7B52 62000004		 BHI.W   $07CA7B58
>

Diesmal werden $9000 als positive Zahl gewertet. Dann ist es ist grer
als $6000. Daher wird der Sprung nicht ausgefhrt:

D0: 00009000 00006000 00000000 00000000 00000000 00000000 00000000 00000000
A0: 00000000 00000000 00000000 00000000 00000000 00000000 00000000 07CA4F64
SSP=07CA6097 USP=07CA4F64 SR=800B T1 -- PL=0 -N-VC PC=07CA7B56
PC=07CA7B56 4E75		 RTS
>

Wenn Sie das CMP verwenden, mssen Sie also genau darauf achten, wie es ist.
Mchten Sie negative Zahlen interpretieren und verwenden daher das richtige
Bcc. 
