
; Listing8m.s - Routine zum Drucken eines Punktes, verwendet in einer Schleife
; um eine Linie zu machen

	SECTION	PUNKT,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/Startup1.s"	; damit mache ich Einsparungen und
									; schreib es nicht jedes mal neu!
*****************************************************************************


; Mit DMASET entscheiden wir, welche DMA-Kanle geffnet und welche
; geschlossen werden sollen

			;5432109876543210
DMASET	equ	%1000001110000000	; Copper und Bitplane DMA aktivieren
;			 -----a-bcdefghij

Koeff	equ	1					; Winkelkoeffizient, m

Start:
	move.l	#Bitplane,d0		; Adresse der Bitplane
	lea	Bplpointers,a1			; Bitplanepointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	move.w	#DMASET,$96(a5)		; DMACON - Copper und Bitplane DMA aktivieren

	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

	lea	Bitplane,a0				; Bitplane-Adresse, an der gedruckt werden soll

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$13000,d2			; Warte auf Zeile = $130 (304)
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile = $130 (304)
	bne.s	WarteY1

;	Y=m*x, oder am besten m*x=y, d.h. Koeff*d0=d1

	addq.w	#1,MeinX			; das X erhhen
	move.w	MeinX(pc),d1
	mulu.w	#Koeff,d1			; Y=m*x
	cmp.w	#255,d1				; sind wir am unteren Bildschirmrand?
	bhi.s	Ende
	move.w	MeinX(pc),d0		; X

	bsr.s	PlotPix				; den Punkt auf die Koordinate X=d0, Y=d1 drucken

	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$13000,d2			; Warte auf Zeile = $130 (304)
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; nur die Bits der vertikalen Pos. whlen
	cmp.l   d2,d0				; Warte auf Zeile = $130 (304)
	beq.s	WarteY2

	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Mouse
Ende:
	btst	#6,$bfe001			; Maus gedrckt?
	bne.s	Ende
	rts							; exit

MeinX:
	dc.w	0

*****************************************************************************
;			Routine zum Plotten eines Punktes
*****************************************************************************

;	Eingehende Parameter von PlotPix:
;
;	a0 = Ziel-Bitplane-Adresse
;	d0.w = Koordinate X (0-319)
;	d1.w = Koordinate Y (0-255)

BreiteBildschirm	equ	40				; Bildschirmbreite in Bytes.

;	     _____
;	    / ~\
;	  _/ \   / \_
;	 (/_(\ /)_\)
;	 / /   \ \
;	/  __(___)__  \
;	\ (l_T_|_T_|) /
;	 \ \_T_T_T_/ /
;	  \_    _/ xCz
;	   `-------'

PlotPix:
	move.w	d0,d2				; Koordinate X in d2 kopieren


; Wir finden den horizontalen Versatz, dh das X

	lsr.w	#3,d0				; den horizontalen Versatz finden wir indem wir
								; die X-Koordinate durch 8 dividieren, da der
								; Bildschirm aus Bits besteht, wir wissen das
								; die horizontale Zeile 320 Pixel breit ist
								; 320/8 = 40 Bytes. Mit der X-Koordinate welche
								; von 0 bis 320 geht, das heit Bits mssen wir
								; in Bytes umwandeln und durch 8 teilen.
								; Auf diese Weise haben wir das Byte, in dem
								; wir unser Bit setzen.

; Nun finden wir den vertikalen Versatz, das ist das Y:

	mulu.w	#BreiteBildschirm,d1		; die Breite einer Zeile mit der Anzahl der Zeilen
								; multiplizieren um den vertikalen Offset
								; vom Beginn des Bildschirms zu finden

; Schlielich finden wir den Versatz vom Anfang des Byte-Bildschirms, wo der
; Punkt (dh Bit), den wir mit der BSET-Anweisung setzen:

	add.w	d1,d0				; den vertikalen zum horizontalen Versatz hinzufgen

; Jetzt haben wir in d0 den Offset, in Bytes, vom Anfang des Bildschirms
; gefunden. Das Byte, in dem sich der einzustellende Punkt befindet. Wir mssen
; nun entscheiden, welches der 8 Bits des Bytes gesetzt sein muss.

; Jetzt finden wir heraus, welches Bit des Bytes wir setzen mssen:

	and.b	#%111,d2			; nur die ersten 3 Bits von X auswhlen, dh
								; der Offset (Versatz) im Byte,
								; Wir erhalten in d2 das zu setzende Bit
								; (In Wirklichkeit wre es der Rest der Division
								; durch 8, bset.b d2,memory)

	not.b	d2					; negieren

; Jetzt haben wir in d0 den Offset vom Anfang des Bildschirms, um das Byte zu
; finden und in d2 die Stelle des einzustellenden Bits innerhalb dieses Bytes 
; und in a0 die Bitplane-Adresse. Mit einer einzigen Anweisung knnen wir das
; Bit setzen:

	bset.b	d2,(a0,d0.w)		; Bit d2 des Bytes setzen, das d0 Bytes 
								; vom Anfang des Bildschirms entfernt ist
	rts							; Exit

*****************************************************************************

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT
	dc.w	$90,$2cc1			; DIWSTOP
	dc.w	$92,$0038			; DDFSTRT
	dc.w	$94,$00d0			; DDFSTOP
	dc.w	$102,0				; BPLCON1
	dc.w	$104,$24			; BPLCON2 - Alle Sprites ber der Bitplane
	dc.w	$108,0				; BPL1MOD
	dc.w	$10a,0				; BPL2MOD
			    ; 5432109876543210
	dc.w	$100,%0001001000000000	; 1 Bitplane LOWRES 320x256

Bplpointers:
	dc.w	$e0,0,$e2,0			; erste Bitplane

	dc.w	$0180,$000			; COLOR00 - Hintergrund
	dc.w	$0182,$1af			; COLOR01 - Schrift

	dc.w	$ffff,$fffe			; Ende Copperlist


*****************************************************************************

	SECTION	MEINEPLANE,BSS_C

Bitplane:
	ds.b	40*256				; eine Bitplane lowres 320x256

	end

Mit einer Schleife machen wir eine Linie. Wir wissen, dass die "Formel" einer
Linie y = m * x ist, wobei m eine Zahl ist, die als Winkelkoeffizient
bezeichnet wird und die Neigung der Geraden selbst bestimmt.
Fr diejenigen die mit Mathematik, hinterher sind, hier in Krze, was passiert:
Wir erhalten Y, wenn wir das X mit m multiplizieren, das hier am Anfang des
Listings mit einem equ definiert ist. Angenommen, Koeff ist = 1:
Wenn wir X=0  haben ist das Y = 0.

X = 0	-> Y=Koeff*X, d.h. 1*0, d.h. 0

deshalb, X=0 und Y=0

In der Schleife erhhen wir das X um 1. Dies passiert mit der nchsten Schleife:

X = 1	-> Y= 1*1, nmlich 1

dann...

X = 2	-> Y=2

Kurz gesagt, das Y ist immer gleich X, weil wir es mit Koeff = 1 multiplizieren.
Daraus ergibt sich folgende Zeile:

11
  22
    33
      44
		55
		  66
			77
			  88
				...

Ist es klar, wie es bei 45 Grad ist??? Versuchen Sie, den Koeffizienten durch
Setzen von m zu ndern. Beispiel 2. In diesem Fall passiert Folgendes:

X = 0	-> Y=Koeff*X, d.h. 2*0, d.h. 0
X = 1	-> Y= 2*1, d.h. 2
X = 2	-> Y= 2*2, d.h. 4
X = 3	-> Y= 2*3, d.h. 6
X = 4	-> Y= 2*4, d.h. 8
X = 5	-> Y= 2*5, d.h. 10

Die resultierende Zeile wird':

12

 24

  36

   48

    510


D.h. weiter nach links, und es geht nicht weiter. Zwischen einem Punkt und dem
nchsten befinden sich "Lcher", weil wir nur mit ganzen Zahlen und Werten
arbeiten. Zum Beispiel, zwischen 2 und 3 verlassen wir die "Leere". Wir werden
spter sehen, dass es viele Mglichkeiten gibt emulierte Gleitkommazahlen auch
ohne mathematische Coprozessoren zu verwenden, zum Beispiel, um 3D-Berechnungen
durchzufhren.
