
; Listing8h2.s		8 * 8-Scrolltext-Routine, die nur BPLCON1 zum 
; Scrollen verwendet. Original von Lorenzo Di Gaetano.

	SECTION	MAINPROGRAM,CODE

*****************************************************************************
	include	"/Sources/Startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001110000000	; nur Copper und Bitplane DMA
;			 -----a-bcdefghij
Start:
;	Zeiger auf Bitplanes in Copperlist

	move.l	#Bitplane,d0		; in d0 setzen wir die Adresse der Bitplane
	lea	Bplpointers,a1			; Zeiger in der Copperlist
	move.w	d0,6(a1)			; Kopiere das LOW-Wort der Bitplane-Adresse
	swap	d0					; Vertausche die 2 Wrter von d0 (zB: 1234> 3412)
	move.w	d0,2(a1)			; Kopiere das HIGH-Wort der Bitplane-Adresse

	move.w	#DMASET,$96(a5)		; DMACON - aktivieren Bitplane, Copper DMA

	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

	clr.w	CounterScroll		; den Scroll-Zhler zurcksetzen 
	bsr.w	Print				; Drucke das erste Mal

Mouse:
	move.l	#$1ff00,d1			; Bit zur Auswahl durch UND
	move.l	#$12c00,d2			; Warte auf Zeile = $12c
WarteY1:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile $12c
	bne.s	WarteY1
WarteY2:
	move.l	4(a5),d0			; VPOSR und VHPOSR - $dff004/$dff006
	and.l   d1,d0				; Whlen Sie nur die Bits der vertikalen Pos.
	cmp.l   d2,d0				; Warte auf Zeile $12c
	beq.s	WarteY2

	bsr.s	Scroll				; Routine ist der Text auf der linken Seite
								; mit BPLCON1 und alle 16 Pixel drucke es neu
								; 2 Zeichen (8 * 2 = 16 Pixel) voraus
								; BPLCON1 zurcksetzen -> SCROLLING !!!

	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse
	rts

*****************************************************************************
; Routine, die entscheidet, ob mit BPLCON1 gescrollt oder der gesamte Text 
; neu gedruckt werden soll
; 2 Zeichen (16 Pixel) weiter links (dies natrlich alle 16 Pixel)
*****************************************************************************

Scroll:
	tst.b	Scrolling			; Haben wir BPLCON1 optimal genutzt?
	bne.s	ThenSub				; Wenn noch nicht, wird die Subtraktion fortgesetzt

; Andernfalls Starten wir von $ff aus neu und drucken den Text 2 Zeichen weiter!

	addq.w	#2,CounterScroll	; 2 Zeichen voraus -> 16 Pixel voraus
	move.b	#$ff,Scrolling		; rcksetzen BPLCON1
	bsr.s	Print				; und drucken den ScrollText 2 weitere Zeichen
	rts							; vorwrts, dh 2 * 8 = 16 Pixel.

ThenSub:
	sub.b	#$11,Scrolling		; 1 Pixel nach links mit BPLCON1
	rts

*****************************************************************************
; Die Routine 8 * 8 wurde fr den Bildlauf gendert
*****************************************************************************

Print:
	lea	Bitplane+(42*192),a0	; Adresse, an der gedruckt werden soll
	lea	ScrollText(pc),a1		; Adresse Scrolltext (ascii)
	moveq	#42-1,d2			; Anzahl der zu druckenden Zeichen
	moveq	#0,d0
	move.w	CounterScroll(pc),d0	; Offset von Anfang an ScrollText
	add.l	d0,a1				; Finde den Charakter im Scrolltext
PrintLine:
	sub.l	a2,a2				; lsche a2
	moveq	#0,d1
	move.b	(a1)+,d1
	cmp.b	#$ff,d1				; Flag Ende ScrollText?
	bne.s	NotRepeat			; Wenn noch nicht, fahren Sie fort
	clr.w	CounterScroll		; Oder beginnen Sie erneut am Anfang des ScrollText
NotRepeat:
	sub.b	#$20,d1
	lsl.w	#3,d1				; multiplizieren mit 8
	move.l	d1,a2
	add.l	#Font,a2			; Finde das Charakter im Font
	move.b	(a2)+,(a0)
	move.b	(a2)+,42(a0)		; 42, um den ddfStart zu kompensieren und dann gehe
	move.b	(a2)+,42*2(a0)		; jenseits des Bildschirms
	move.b	(a2)+,42*3(a0)
	move.b	(a2)+,42*4(a0)
	move.b	(a2)+,42*5(a0)
	move.b	(a2)+,42*6(a0)
	move.b	(a2)+,42*7(a0)
	addq.w	#1,a0				; nchstes Zeichen
	dbra	d2,PrintLine
	rts

CounterScroll:
	dc.w	0
	
ScrollText:
	dc.b	"                                              "
	dc.b	"QUESTO Text VIENE SPOSTATO CON IL REGISTRO BPLCON1:"
	dc.b	" DOPO AVERLO SPOSTATO DI 16 PIXEL VIENE AZZERATO,"
	dc.b	" E INVECE DI PUNTARE ALLA PROSSIMA WORD DELL` IMMAGINE IL TE"
	dc.b	"STO VIENE RISTAMPATO SULLO SCHERMO 2 LETTERE DOPO."
	dc.b	"L'AUTORE, LORENZO DI GAETANO, (The Amiga Dj) HA FATTO QUESTA"
	dc.b	" ROUTINE CON LE SOLE CONOSCENZE DEL DISCO 1 DEL CORSO."
	dc.b	"... FORZA AMIGA!!!                    "
	dc.b	"                                       "
	dc.b	$ff					; Flag fr das Ende Scrolltext

	even

; Font 8x8

Font:
	incbin	"/Sources/nice.fnt"

;****************************************************************************

	SECTION	GRAPHIC,DATA_C


Copperlist:
	dc.w    $08e,$2c81			; Hier sind die Standardregister
	dc.w    $090,$2cc1
	dc.w    $092,$0038
	dc.w    $094,$00d0
	dc.w	$102,0
	dc.w    $104,0
	dc.w    $108,2				; 2, um die Leere des Bildes zu berspringen
	dc.w    $10a,2

Bplpointers:
	dc.w    $e0,$0000,$e2,$0000    ; Zeiger auf Bitplane

	dc.w    $100,%0001001000000000 ; Bplcon0 2 Farben

	dc.w	$180,$000
	dc.w	$182,$888

; Hier knnte ein beliebiges Bild stehen...

	dc.w	$eb07,$fffe			; Hier beginnt die Copperliste zum Scrollen.
	dc.w    $092,$0030			; So verbergen Sie den Bildlauffehler
	dc.w    $094,$00d0

	dc.w    $104,0
	dc.w    $108,0
	dc.w    $10a,0
	dc.w    $102				; BPLCON1
	dc.b	$00
Scrolling:
	dc.b	$ff
	dc.w	$182,$200
	dc.w	$ec07,$fffe
	dc.w	$182,$400
	dc.w	$ed07,$fffe
	dc.w	$182,$600
	dc.w	$ee07,$fffe
	dc.w	$182,$800
	dc.w	$ef07,$fffe
	dc.w	$182,$a00
	dc.w	$f007,$fffe
	dc.w	$182,$d00
	dc.w	$f107,$fffe
	dc.w	$182,$a00
	dc.w	$f207,$fffe
	dc.w	$182,$800
	dc.w	$f307,$fffe	
	
	dc.w	$182,$000			; Effekte Copper...
	dc.w	$180,$001
	dc.w	$108,-84
	dc.w	$10a,-84
	dc.w	$f4ff,$fffe
	dc.w	$180,$003
	dc.w	$f5ff,$fffe
	dc.w	$180,$005
	dc.w	$f6ff,$fffe
	dc.w	$180,$007
	dc.w	$f7ff,$fffe
	dc.w	$180,$009
	dc.w	$f8ff,$fffe
	dc.w	$180,$00b
	dc.w	$f8ff,$fffe
	dc.w	$180,$00c
	dc.w	$f9ff,$fffe
	dc.w	$180,$00f
	dc.w	$faff,$fffe
	dc.w	$180,$00f
	dc.w	$fbff,$fffe
	dc.w	$180,$000
	dc.w	$108,0
	dc.w	$10a,0
	dc.w	$ffff,$fffe			; Ende Copperlist

;****************************************************************************

	SECTION	LEEREPLANE,BSS_C

Bitplane:
	ds.b	42*256

	end
	                                                                                                                                                                                                                                                                                                                                                          ber hinaus ist die Ausfhrung schneller!
	