
; Listing8f.s	Eine Fade-Routine (dh Ein-und Ausblenden) von und nach jeder Farbe
; Drcken Sie abwechselnd die linke und rechte Taste, um die verschiedenen  
; bergnge anzuzeigen

	SECTION	FADE,CODE

;	include	"DaWorkBench.s"	; entferne das; vor dem Speichern mit "wo"

*****************************************************************************
	include	"/Sources/Startup1.s"	; speichern Copperlist etc.
*****************************************************************************

			;5432109876543210
DMASET	equ	%1000001110000000	; nur Copper und Bitplane DMA
;			 -----a-bcdefghij

;	a: Blitter Nasty
;	b: Bitplane DMA	   (Wenn es nicht gesetzt ist, verschwinden auch die Sprites)
;	c: Copper DMA
;	d: Blitter DMA
;	e: Sprite DMA
;	f: Disk DMA
;	g-j: Audio 3-0 DMA

Start:
	move.l	#Logo,d0			; Adresse der Bitplane
	lea	Bplpointers,a1			; Bitplanepointer in der Copperlist
	moveq	#4-1,d1				; Anzahl der Bitplanes (hier sind es 4)
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*84,d0			; + Lnge einer Bitplane (84 Zeilen hoch hier)
	addq.w	#8,a1
	dbra	d1,PointBp

	move.w	#DMASET,$96(a5)		; DMACON - Aktivieren Bitplane, Copper
	move.l	#Copperlist,$80(a5)	; Zeiger Copperlist
	move.w	d0,$88(a5)			; Start Copperlist
	move.w	#0,$1fc(a5)			; AGA "deaktivieren"
	move.w	#$c00,$106(a5)		; AGA "deaktivieren"
	move.w	#$11,$10c(a5)		; AGA "deaktivieren"

Mouse1:
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse1

;	********** erstes Fade (Einblenden): von SCHWARZ zu Farben *********

Mouse2:
	cmp.b	#$ff,$dff006		; Zeile 255
	bne.s	Mouse2
WarteY1:
	cmp.b	#$ff,$dff006		; Zeile 255
	beq.s	WarteY1

	lea	CStart1-2,a1			; Start Farbtabelle
	lea	Cend1-2,a2				; Ende Farbtabelle
	bsr.w	DoFade				; Fade!!!
	
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse2

	clr.w	PhaseOfFade			; die Bildnummer zurcksetzen

;	********** zweites Fade (Ausblenden): von Farben zu SCHWARZ *********

Mouse3:
	cmp.b	#$ff,$dff006		; Zeile 255
	bne.s	Mouse3
WarteY2:
	cmp.b	#$ff,$dff006		; Zeile 255
	beq.s	WarteY2

	lea	CStart2-2,a1			; Start Farbtabelle
	lea	Cend2-2,a2				; Ende Farbtabelle
	bsr.w	DoFade				; Fade!!!
	
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse3

	clr.w	PhaseOfFade			; die Bildnummer zurcksetzen
		
;	********** drittes Fade (Einblenden): von WEISS zu Farben *********

Mouse4:	
	cmp.b	#$ff,$dff006		; Zeile 255
	bne.s	Mouse4
WarteY3:
	cmp.b	#$ff,$dff006		; Zeile 255
	beq.s	WarteY3

	lea	CStart3-2,a1			; Start Farbtabelle
	lea	Cend3-2,a2				; Ende Farbtabelle
	bsr.w	DoFade				; Fade!!!
	
	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse4

	clr.w	PhaseOfFade			; die Bildnummer zurcksetzen

;	********** viertes Fade: von FARBEN zu anderen verschiedenen Farben! *

Mouse5:
	cmp.b	#$ff,$dff006		; Zeile 255
	bne.s	Mouse5
WarteY4:
	cmp.b	#$ff,$dff006		; Zeile 255
	beq.s	WarteY4

	lea	CStart4-2,a1			; Start Farbtabelle
	lea	Cend4-2,a2				; Ende Farbtabelle
	bsr.w	DoFade				; Fade!!!
	
	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	Mouse5

	clr.w	PhaseOfFade			; die Bildnummer zurcksetzen

;	********** fnftes Fade: von FARBEN zu anderen verschiedenen Farben! *

Mouse6:
	cmp.b	#$ff,$dff006		; Zeile 255
	bne.s	Mouse6
WarteY5:
	cmp.b	#$ff,$dff006		; Zeile 255
	beq.s	WarteY5

	lea	CStart5-2,a1			; Start Farbtabelle
	lea	Cend5-2,a2				; Ende Farbtabelle
	bsr.w	DoFade				; Fade!!!

	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	Mouse6

	rts


*****************************************************************************
*	Routine zum Ein- und Ausblenden in und aus einer beliebigen Farbe!		*
* Eingabe:																	*
*																			*
* d6 = Anzahl Farben-1														*
* a1 = Adresse Tabelle 1 mit den Farben des Bildes (Quelle)					*
* a2 = Adresse Tabelle 2 mit den Farben des Bildes (Ziel)					*
* a0 = Adresse der ersten Farbe in der Copperlist							*
* Label PhaseOfFade als d0 fr vorherige Routinen verwendet,				*
* = Moment der berblendung, Multiplikator, in diesem Fall ist es jedoch    *
* notwendig, ihn zurckzusetzen. Einfach, um eine neue berblendung		    *
* zu Starten																*
* Der Ablauf der Routine ist komplexer als die vorherigen und				*
* eigentlich wei ich gar nicht mehr, wie genau das funktioniert.			*
* Lesen Sie meine alten Kommentare, aber Hauptsache Sie wissen, wie man es  *
* benutzt																	*
*****************************************************************************

;	           .--._.--. 
;	          ( O     O ) 
;	          /   . .   \ 
;	         .`._______.'. 
;	        /(    \_/    )\ 
;	      _/  \  \   /  /  \_ 
;	   .~   `  \  \ /  /  '   ~. 
;	  {    -.   \  V  /   .-    } 
;	_ _`.    \  |  |  |  /    .'_ _ 
;	>_       _} |  |  | {_       _< 
;	 /. - ~ ,_-'  .^.  `-_, ~ - .\ 
;	         '-'|/   \|`-` 

DoFade:
	cmp.w	#17,PhaseOfFade		; Haben wir die letzte Phase erreicht? (16)?
	beq.s	EndFade
	lea	CopColors+2,a0			; Farben in der Copperlist
	move.w	#15-1,d6			; Anzahl Farben 
	bsr.w	Fade2				; Aufruf Fading!
EndFade:
	rts

; benutzt d0-d6/a0-a2

Fade2:
F2Main:
	addq.w	#4,a0				; gehe zum nchsten Farbregister in der Copperliste
	addq.w	#2,a1				; gehe zur nchsten Farbe der Quell-Farbtabelle
	addq.w	#2,a2				; das Gleiche gilt fr die Ziel-Farbtabelle
	move.w	(a0),d0				; Farbe von Copperlist in d0
	move.w	(a2),d1				; Farbe Zieltabelle in d1
	cmp.w	d0,d1				; sind sie die gleichen?
	beq.w	NextColor			; wenn ja, gehe zur nchsten Farbe
	move.w	PhaseOfFade(pc),d4	; Phase der berblendung in d4 (0-16)
	clr.w	ColorFinale			; die endgltige Farbe zurcksetzen

; blau

	move.w	(a1),d0				; aktuelle Farbe der Quell-Farbtabelle in d0
	move.w	(a2),d2				; Farbe der Ziel-Farbtabelle in d2
	and.l	#$00f,d0			; nur das blau von der Farbe der Quelltabelle auswhlen 
	and.l	#$00f,d2			; Farbe der Ziel-Farbtabelle
	cmp.w	d2,d0				; sind blau Quelle und Ziel gleich?
	bhi.b	SubD2Blue			; wenn d2>d0, FadCh1a
	beq.b	SubD2Blue			; wenn sie gleich sind, subtrahiere d2
	sub.w	d0,d2				; wenn d2<d0, sub d0 bis d2!
	bra.b	SubDoneBlue
SubD2Blue:
	sub.w	d2,d0				; sonst sub d2 von d0!
	bra.b	SubDoneBlue2

SubDoneBlue:
	move.w	d2,d0
SubDoneBlue2:
	moveq	#16,d1
	bsr.w	DoDivu
	and.w	#$00f,d1			; nur blau auswhlen
	move.w	(a1),d0				; aktuelle Farbe der Quell-Farbtabelle in d0
	move.w	(a2),d2				; Farbe der Ziel-Farbtabelle in d2
	and.w	#$00f,d0			; nur das blau von der Farbe der Quelltabelle auswhlen
	and.w	#$00f,d2			; Farbe der Ziel-Farbtabelle
	cmp.w	d0,d2				; sind blau Quelle und Ziel gleich?
	bhi.b	AddD1Blue			; wenn d0>d2, Summe d1 + d0
	beq.b	OkBlue				; wenn sie gleich sind, ok
	sub.w	d1,d0				; d0=d0-d1
	bra.b	OkBlue
AddD1Blue:
	add.w	d1,d0				; d0=d0+d1
OkBlue:
	move.w	d0,ColorFinale		; das endgltige blau speichern

; grn

	move.w	(a1),d0				; aktuelle Farbe der Quell-Farbtabelle in d0
	move.w	(a2),d2				; Farbe der Ziel-Farbtabelle in d2
	and.l	#$0f0,d0			; nur das grn von der Farbe der Quelltabelle auswhlen
	and.l	#$0f0,d2			; Farbe der Ziel-Farbtabelle
	cmp.w	d2,d0				; sind grn Quelle und Ziel gleich?
	bhi.b	SubD2Green			; wenn d2>d0, FadCh1a
	beq.b	SubD2Green			; wenn sie gleich sind, subtrahiere d2
	sub.w	d0,d2				; wenn d2<d0, subba d0 bis d2!
	bra.b	SubDoneGreen
SubD2Green:
	sub.w	d2,d0				; sonst sub d2 von d0!
	bra.b	SubDoneGreen2

SubDoneGreen:
	move.w	d2,d0
SubDoneGreen2:
	moveq	#16,d1
	bsr.w	DoDivu
	and.w	#$0f0,d1			; nur grn auswhlen
	move.w	(a1),d0				; aktuelle Farbe der Quell-Farbtabelle in d0
	move.w	(a2),d2				; Farbe der Ziel-Farbtabelle in d2
	and.w	#$0f0,d0			; nur das grn von der Farbe der Quelltabelle auswhlen
	and.w	#$0f0,d2			; Farbe der Ziel-Farbtabelle
	cmp.w	d0,d2				; sind grn Quelle und Ziel gleich?
	bhi.b	AddD1Green			; wenn d0>d2, Summe d1 + d0
	beq.b	OkGreen				; wenn sie gleich sind, ok
	sub.w	d1,d0				; d0=d0-d1
	bra.b	OkGreen
AddD1Green:
	add.w	d1,d0				; d0=d0+d1
OkGreen:
	or.w	d0,ColorFinale		; mit dem OR die grne Komponente verbinden

; rot

	move.w	(a1),d0				; aktuelle Farbe der Quell-Farbtabelle in d0
	move.w	(a2),d2				; Farbe der Ziel-Farbtabelle in d2
	and.l	#$f00,d0			; Whlen Sie nur das rot von der Farbe der Quelltabelle
	and.l	#$f00,d2			; Farbe der ZielFarbtabelle
	cmp.w	d2,d0				; sind rot Quelle und Ziel gleich?
	bhi.b	SubD2Red			; wenn d2>d0, FadCh1a
	beq.b	SubD2Red			; wenn sie gleich sind, subtrahiere d2
	sub.w	d0,d2				; wenn d2<d0, sub d0 bis d2!
	bra.b	SubDoneRed
SubD2Red:
	sub.w	d2,d0				; sonst sub d2 von d0!
	bra.b	SubDoneRed2

SubDoneRed:
	move.w	d2,d0
SubDoneRed2:
	moveq	#16,d1
	bsr.w	DoDivu
	and.w	#$f00,d1			; nur rot auswhlen
	move.w	(a1),d0				; aktuelle Farbe der Quell-Farbtabelle in d0
	move.w	(a2),d2				; Farbe der Ziel-Farbtabelle in d2
	and.w	#$f00,d0			; nur das rot von der Farbe der Quelltabelle auswhlen
	and.w	#$f00,d2			; Farbe der Ziel-Farbtabelle
	cmp.w	d0,d2				; sind rot Quelle und Ziel gleich?
	bhi.b	AddD1Red			; wenn d0>d2, Summe d1 + d0
	beq.b	OkRed				; wenn sie gleich sind, ok
	sub.w	d1,d0				; d0=d0-d1
	bra.b	OkRed
AddD1Red:
	add.w	d1,d0				; d0=d0+d1
OkRed:
	or.w	d0,ColorFinale		; mit dem OR die rote Komponente verbinden

; die Farbe in der Copperliste eingeben!

	move.w	ColorFinale(pc),(a0)	; und die endgltige Farbe in die Copperliste legen!

NextColor:
	dbra	d6,F2Main			; Wiederholen fr jede Farbe

	addq.w	#1,PhaseOfFade		; den nchsten Schritt vorbereiten
NoCrs:
	rts

***
* Eingang -> d0 = Anzahl
*			 d1 = Nenner	(16)
*			 d4 = * Multiplikationsfaktor
*
* Ausgang -> d1 = Ergebnis
***

DoDivu:
	divu.w	d1,d0				; Division durch 16, nicht optimierbar mit lsr
	move.l	d0,d1
	swap	d1
	move.l	#$31000,d2			; $10003 (65539) divu 16
	moveq	#0,d3
	move.w	d1,d3
	mulu.w	d3,d2
	move.w	d2,d1
	and.l	#$ffff,d1
	mulu.w	d4,d1				; multiplizieren mit der Fade-Phase
	swap	d1
	mulu.w	d4,d0				; multiplizieren mit der Fade-Phase
	add.w	d0,d1
	and.l	#$ffff,d1
	rts

PhaseOfFade:					; aktuelle Phase der berblendung (0-16)
	dc.w	0

;	Die endgltige Farbe wird jedes Mal in diesem Label gespeichert

ColorFinale:
	dc.w	0

; ---

CStart1:
	dcb.w	15,0									; Lass uns von Schwarz ausgehen
Cend1:
	dc.w $fff,$200,$310,$410,$620,$841,$a73			; und wir kommen zu den Farben
	dc.w $b95,$db6,$dc7,$111,$222,$334,$99b,$446
;=----------

CStart2:
	dc.w $fff,$200,$310,$410,$620,$841,$a73			; Beginnen wir mit Farben
	dc.w $b95,$db6,$dc7,$111,$222,$334,$99b,$446
Cend2:
	dcb.w	15,0									; und wir landen in schwarz
;=----------

CStart3:
	dcb.w	15,$FFF									; Fangen wir mit WEISS an
Cend3:
	dc.w $fff,$200,$310,$410,$620,$841,$a73			; und wir kommen zu den Farben
	dc.w $b95,$db6,$dc7,$111,$222,$334,$99b,$446
;=----------

CStart4:
	dc.w $fff,$200,$310,$410,$620,$841,$a73			; Beginnen wir mit Farben
	dc.w $b95,$db6,$dc7,$111,$222,$334,$99b,$446
Cend4:
	dc.w $fff,$020,$031,$041,$062,$184,$3a7			; und wir bekommen andere
	dc.w $5b9,$6db,$7dc,$111,$222,$433,$b99,$644	; Farben! (grner Ton)
;=----------

CStart5:
	dc.w $fff,$020,$031,$041,$062,$184,$3a7			; Beginnen wir mit anderen
	dc.w $5b9,$6db,$7dc,$111,$222,$433,$b99,$644	; Farben! (grner Ton)
Cend5:
	dc.w $fff,$002,$013,$014,$026,$148,$37a			; zu noch anderen Farben!
	dc.w $59b,$6bd,$7cd,$111,$222,$334,$99b,$446	; (blauer Ton)
;=----------


; die $180, COLOR00, sind $000, also nicht ndern! Die Tabelle beginnt mit COLOR01

TabColorPic:
	dc.w $fff,$200,$310,$410,$620,$841,$a73
	dc.w $b95,$db6,$dc7,$111,$222,$334,$99b,$446


*****************************************************************************
;			Copperlist
*****************************************************************************
	
	SECTION	COPPER,DATA_C		; Chip data

Copperlist:
	dc.w	$8e,$2c81			; DIWSTRT - window Start
	dc.w	$90,$2cc1			; DIWSTOP - window Stop
	dc.w	$92,$38				; DDFSTRT - data fetch Start
	dc.w	$94,$d0				; DDFSTOP - data fetch Stop
	dc.w	$102,0				; BPLCON1 - scroll register
	dc.w	$104,0				; BPLCON2 - priority register
	dc.w	$108,0				; BPL1MOD - modulo pl. ungerade
	dc.w	$10a,0				; BPL2MOD - modulo pl. gerade

			    ; 5432109876543210
	dc.w	$100,%0100001000000000	; BPLCON0 - 4 planes lowres (16 Farben)

; Bitplane pointers

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane
	dc.w	$e4,$0000,$e6,$0000	; zweite Bitplane
	dc.w	$e8,$0000,$ea,$0000	; dritte Bitplane
	dc.w	$ec,$0000,$ee,$0000	; vierte Bitplane

; Die ersten 16 Farben sind fr das LOGO

CopColors:
	dc.w	$180,0,$182,0,$184,0,$186,0
	dc.w	$188,0,$18a,0,$18c,0,$18e,0
	dc.w	$190,0,$192,0,$194,0,$196,0
	dc.w	$198,0,$19a,0,$19c,0,$19e,0

;	Lassen Sie uns ein paar Nuancen fr die Szenografie setzen...

	dc.w	$8007,$fffe			; Wait - $2c+84=$80
	dc.w	$100,$200			; bplcon0 - no Bitplanes
	dc.w	$180,$003			; COLOR00
	dc.w	$8207,$fffe			; wait
	dc.w	$180,$005			; COLOR00
	dc.w	$8507,$fffe			; wait
	dc.w	$180,$007			; COLOR00
	dc.w	$8a07,$fffe			; wait
	dc.w	$180,$009			; COLOR00
	dc.w	$9207,$fffe			; wait
	dc.w	$180,$00b			; COLOR00
	dc.w	$9e07,$fffe			; wait
	dc.w	$180,$999			; COLOR00
	dc.w	$a007,$fffe			; wait
	dc.w	$180,$666			; COLOR00
	dc.w	$a207,$fffe			; wait
	dc.w	$180,$222			; COLOR00
	dc.w	$a407,$fffe			; wait
	dc.w	$180,$001			; COLOR00
	dc.l	$ffff,$fffe			; Ende Copperlist


*****************************************************************************
;				DESIGN
*****************************************************************************

	SECTION	GRAPHIC,DATA_C

; Zeichnen von 320 Pixel breiten, 84 hohen 4-Bit-Ebenen (16 Farben).

Logo:
	incbin	"/Sources/logo320x84x16c.raw"
	
	end

Hier ist eine Routine, die Farben nach Belieben "transformiert". Das
Funktionsprinzip ist daher komplexer als bei einer normalen berblendung.
Verstehen Sie einfach, wie sie es benutzen knnen. Wenn Sie Ihr Gehirn braten
wollen, habe ich jedoch Kommentare abgegeben.