
; Listing7y5.s	- Landschaft aus 2 Sprites, die scrollt.

;	Dieses Beispiel ist das gleiche wie das Vorige, nur scrollen
;	wir es hier auch noch.

	SECTION CipundCop,CODE

Anfang:
	move.l	4.w,a6			; Execbase
	jsr	-$78(a6)			; Disable
	lea	GfxName(pc),a1		; Name lib
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop	; speichern die alte COP

;	Pointen auf das "leere" PIC

	move.l	#Bitplane,d0	; wohin pointen
	lea	Bplpointers,A1		; COP-Pointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

;	Wir pointen NICHT auf den Sprite !!!!!!!!!!!!!!!!!!!!

	move.l	#Copperlist,$dff080	; unsere COP
	move.w	d0,$dff088		; START COP
	move.w	#0,$dff1fc		; NO AGA!
	move.w	#$c00,$dff106	; NO AGA!

Mouse:
	cmpi.b	#$aa,$dff006	; Zeile $aa?
	bne.s	Mouse

	bsr.w	BewegeBerge		; Lt die Landschaft scrollen

Warte:
	cmpi.b	#$aa,$dff006	; Zeile $aa?
	beq.s	Warte

	btst	#6,$bfe001		; Mouse gedrckt?
	bne.s	Mouse
	
	move.l	OldCop(pc),$dff080	; Pointen auf die SystemCOP
	move.w	d0,$dff088		; starten die alte SystemCOP

	move.l	4.w,a6
	jsr	-$7e(a6)			; Enable
	move.l	gfxbase(pc),a1
	jsr	-$19e(a6)			; Closelibrary
	rts

;	Daten

GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0


; Diese Routine bringt die Daten der Sprites zum scrollen, die die Berge
; bilden.

BewegeBerge:
	moveq	#14-1,d0		; Anzahl der Zeilen
	lea	SpriteForm,a0		; Adresse ersten Daten des Sprite
LandLoop:

; Lt das Plane A der Sprites scrollen

	move.w	(a0),d1			; liest Wert von SPR6DATA
	swap	d1				; gibt ihn in das hochw. Word des Registers
	move.w	8(a0),d1		; liest Wert von SPR7DATA

	ror.l	#1,d1			; Lt die Bit der Form des Sprites scrollen
	move.w	d1,8(a0)		; schreibt Wert	SPR7DATA
	swap	d1				; vertauscht die Word des Registers
	move.w	d1,(a0)			; schreibt Wert	SPR6DATA

; Lt das Plane B der Sprites scrollen

	move.w	4(a0),d1		; liest Wert von SPR6DATB
	swap	d1				; gibt ihn in das hochw. Word des Registers
	move.w	12(a0),d1		; liest Wert von SPR7DATB

	ror.l	#1,d1			; Lt die Bit der Form des Sprites scrollen
	move.w	d1,12(a0)		; schreibt Wert	SPR7DATB
	swap	d1				; vertauscht die Word des Registers
	move.w	d1,4(a0)		; schreibt Wert	SPR6DATB

	add.w	#140,a0			; nchste Zeile der Landschaft
	dbra	d0,LandLoop

	rts



	SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; SPRITE
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

	dc.w	$8e,$2c81		; DiwStrt
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$38			; DdfStart
	dc.w	$94,$d0			; DdfStop
	dc.w	$102,0			; BplCon1
	dc.w	$104,0			; BplCon2
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod

				; 5432109876543210
	dc.w	$100,%0001001000000000	; Bit 12 an: 1 Bitplane Lowres

Bplpointers:
	dc.w	$e0,0,$e2,0		; erste Bitplane

	dc.w	$180,$000		; COLOR0	; schwarzer Hintergrund
	dc.w	$182,$123		; COLOR1	; COLOR1 des Bitplane, das
							; in diesem Fall leer ist, und
							; deswegen nicht erscheint.


	dc.w	$01ba,$0fff		; COLOR29
	dc.w	$01bc,$0aaa		; COLOR30
	dc.w	$01be,$0753		; COLOR31

; Aus Bequemlichkeit verwenden wir Symbole. Ich erinnere euch, da man ein
; Symbol (oder EQUATE) auf zwei Arten definieren kann: wie in diesem Fall,
; wo wir einfach ein = setzen, gefolgt vom Wert, den das Symbol haben soll,
; oder mit dem Schlsselword EQU anstelle des =.

SPR6POS		= $170
SPR6DATA	= $174
SPR6DATB	= $176
SPR7POS		= $178
SPR7DATA	= $17c
SPR7DATB	= $17e


; Zeile $50 - (Die Copperanweisungen fr eine Zeile sind 140 Byte lang)

	dc.w	$5025,$fffe		; Wait
	dc.w	SPR6DATA
SpriteForm:					; Ab dieser Label machen wir alle Offsets
	dc.w	$0				; um die anderen SPRxDATx zu erreichen
	dc.w	SPR6DATB
	dc.w	$0
	dc.w	SPR7DATA
	dc.w	$f000
	dc.w	SPR7DATB
	dc.w	$0
	dc.w	SPR6POS,$40,SPR7POS,$48,$504b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$505b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$506b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$507b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$508b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$509b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$50ab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$50bb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$50cb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$50db,$fffe

; Zeile $51
	dc.w	$5125,$fffe
	dc.w	SPR6DATA,$0001,SPR6DATB,$0000,SPR7DATA,$b800,SPR7DATB,$4000
	dc.w	SPR6POS,$40,SPR7POS,$48,$514b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$515b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$516b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$517b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$518b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$519b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$51ab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$51bb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$51cb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$51db,$fffe

; Zeile $52
	dc.w	$5225,$fffe
	dc.w	SPR6DATA,$0003,SPR6DATB,$0000,SPR7DATA,$bc00,SPR7DATB,$4000
	dc.w	SPR6POS,$40,SPR7POS,$48,$524b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$525b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$526b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$527b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$528b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$529b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$52ab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$52bb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$52cb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$52db,$fffe

; Zeile $53
	dc.w	$5325,$fffe
	dc.w	SPR6DATA,$0002,SPR6DATB,$0001,SPR7DATA,$ec00,SPR7DATB,$1200
	dc.w	SPR6POS,$40,SPR7POS,$48,$534b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$535b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$536b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$537b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$538b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$539b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$53ab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$53bb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$53cb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$53db,$fffe

; Zeile $54
	dc.w	$5425,$fffe
	dc.w	SPR6DATA,$0007,SPR6DATB,$0000,SPR7DATA,$2b00,SPR7DATB,$d400
	dc.w	SPR6POS,$40,SPR7POS,$48,$544b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$545b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$546b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$547b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$548b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$549b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$54ab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$54bb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$54cb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$54db,$fffe

; Zeile $55
	dc.w	$5525,$fffe
	dc.w	SPR6DATA,$001c,SPR6DATB,$0003,SPR7DATA,$e780,SPR7DATB,$1800
	dc.w	SPR6POS,$40,SPR7POS,$48,$554b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$555b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$556b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$557b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$558b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$559b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$55ab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$55bb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$55cb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$55db,$fffe

; Zeile $56
	dc.w	$5625,$fffe
	dc.w	SPR6DATA,$803e,SPR6DATB,$0001,SPR7DATA,$9ac1,SPR7DATB,$6500
	dc.w	SPR6POS,$40,SPR7POS,$48,$564b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$565b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$566b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$567b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$568b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$569b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$56ab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$56bb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$56cb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$56db,$fffe

; Zeile $57
	dc.w	$5725,$fffe
	dc.w	SPR6DATA,$c079,SPR6DATB,$0006,SPR7DATA,$b6e7,SPR7DATB,$4910
	dc.w	SPR6POS,$40,SPR7POS,$48,$574b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$575b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$576b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$577b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$578b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$579b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$57ab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$57bb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$57cb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$57db,$fffe

; Zeile $58
	dc.w	$5825,$fffe
	dc.w	SPR6DATA,$c07f,SPR6DATB,$0048,SPR7DATA,$fff6,SPR7DATB,$2009
	dc.w	SPR6POS,$40,SPR7POS,$48,$584b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$585b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$586b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$587b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$588b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$589b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$58ab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$58bb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$58cb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$58db,$fffe

; Zeile $59
	dc.w	$5925,$fffe
	dc.w	SPR6DATA,$e06f,SPR6DATB,$0096,SPR7DATA,$7eaf,SPR7DATB,$a150
	dc.w	SPR6POS,$40,SPR7POS,$48,$594b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$595b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$596b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$597b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$598b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$599b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$59ab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$59bb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$59cb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$59db,$fffe

; Zeile $5a
	dc.w	$5a25,$fffe
	dc.w	SPR6DATA,$61ed,SPR6DATB,$9013,SPR7DATA,$dfff,SPR7DATB,$6cab
	dc.w	SPR6POS,$40,SPR7POS,$48,$5a4b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$5a5b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$5a6b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$5a7b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$5a8b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$5a9b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$5aab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$5abb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$5acb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$5adb,$fffe

; Zeile $5b
	dc.w	$5b25,$fffe
	dc.w	SPR6DATA,$db9f,SPR6DATB,$72ed,SPR7DATA,$ffff,SPR7DATB,$dbee
	dc.w	SPR6POS,$40,SPR7POS,$48,$5b4b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$5b5b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$5b6b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$5b7b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$5b8b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$5b9b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$5bab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$5bbb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$5bcb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$5bdb,$fffe

; Zeile $5c
	dc.w	$5c25,$fffe
	dc.w	SPR6DATA,$ffff,SPR6DATB,$cfbf,SPR7DATA,$ffff,SPR7DATB,$ff3f
	dc.w	SPR6POS,$40,SPR7POS,$48,$5c4b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$5c5b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$5c6b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$5c7b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$5c8b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$5c9b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$5cab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$5cbb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$5ccb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$5cdb,$fffe

; Zeile $5d
	dc.w	$5d25,$fffe
	dc.w	SPR6DATA,$ffff,SPR6DATB,$ffff,SPR7DATA,$ffff,SPR7DATB,$feff
	dc.w	SPR6POS,$40,SPR7POS,$48,$5d4b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$5d5b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$5d6b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$5d7b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$5d8b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$5d9b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$5dab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$5dbb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$5dcb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$5ddb,$fffe

; Copperanweisung, um die Sprites zu deaktivieren

	dc.w	$5e07,$fffe		; Warte Anfang der Zeile ab
	dc.w	$172,0			; spr6ctl
	dc.w	$17a,0			; spr7ctl

	dc.w	$ffff,$fffe		; Ende der Copperlist

	SECTION LEERESPLANE,BSS_C	; Wir brauchen ein leeres Bitplane,
							; denn ohne Bitplanes knnen wir
							; keine Sprites anzeigen.

Bitplane:
	ds.b	40*256			; leere Bitplane Lowres

	end

In diesem Beispiel bringen wir die Landschaft aus  Sprites  zum  scrollen.
Dazu  ist  die  Verwendung des Registers BPLCON1 nicht mglich, das wir ja
verwendet hatten, um Bitplanes zu scollen, da dieses Register auf  Sprites
keinen  Effekt  hat.  Um  die  Berge zum Rollen zu bringen mssen wir alle
Pixel, aus denen sie bestehen, verstellen. Jetzt kommt es uns zurecht, da
die Berge alle gleich sind, da sie sich also in der horizontalen Richtung
wiederholen, und zwar alle 32 Pixel.
Das Panorama besteht nmlich aus zwei Sprites, jeder zu 16 Pixel, die sich
immerzu  wiederholen  und  fr  die  gesamte Zeile gleich sind. Um nun die
Landschaft zum Scrollen bringen brauchen wir nun nur die Pixel, aus  denen
die  zwei Sprites bestehen, verschieben. Aber diese Pixel werden bei jeder
Zeile neu in  die  Register  SPR6DATA,  SPR6DATB,  SPR7DATA  und  SPR7DATB
geschrieben.  Also mssen wir den Inhalt dieser Register in der Copperlist
verndern. An der Adresse SpriteForm in  der  Copperlist  finden  wir  den
Wert,  der in SPR6DATA fr die erste Zeile kommt. Jeweils 4,8 und 12 Bytes
spter die Werte der Register SPR6DATB, SPR7DATA und SPR7DATB,  immer  fr
die  erste  Zeile.  Wenn  wir  nun den Inhalt unserer Register in allen 14
Zeilen scrollen lassen, dann haben wir unser Ziel erreicht.

Sehen wir nun, wie wir einen Scroll, z.B. nach Rechts, erzielen.

Wir kennen schon die Anweisung, die es  uns  erlaubt,  die  Bit  in  einer
Speicherzelle  oder  einem Register zu verschieben. Es ist das LSR. Dieser
Befehl lt die Bit nach Rechts rutschen, und schiebt links  immer  Nullen
nach. Zum Beispiel:

	move.b	#%00100101,d0
	lsr.b	#3,d0

Nach dieser Anweisung wird in d0 der Wert %00000100 stehen. Das  geht  fr
uns  aber  nicht recht gut, denn die Nullen, die sich links einschmuggeln,
produzieren dann ein "Loch" im Sprite, das immer grer wird, bis sie dann
total verschwunden sind.

Was  wir  brauchen  ist  ein  Befehl,  der  zwar  die  Bit  nach  links
hinausschubst, aber sie rechts wieder reinlt. Der die  Bit  im  Register
also  rotieren  lt.  Diese  Anweisung  gibts,  sie  heit  ROR ("ROtate
Right"). Sehen wir gleich ein Beispiel:


  move.b  #%00100101,d0
  ror.b  #3,d0

Nach diesem Schritt wird in d0 der Wert %10100100 sein. Praktisch sind die
drei  Bits  ganz  rechts  verdrngt  worden  und  dann  von  links  wieder
hineingeschlpft. Es knnte etwa so aussehen:

Bit:     7 6 5 4 3 2 1 0
        -----------------
        | | | | | | | | |
        -----------------
       ->   -->   -->   -->
      |                     |   Laufrichtung
        <--   <--   <--   <-

Die Routine "BewegeBerge"  verwendet  eine  ROR-Anweisung,  um  die  Pixel
scrollen  zu lassen. Bemerkt, da die Inhalte von SPR6DATA und SPR7DATA in
das gleiche Register kommen und dann zusammen rotiert  werden,  soda  das
Bit, das SPR6DATA von links verlt, bei SPR7DATA rechts hineinkommen, und
die  Bits,  die  bei  SPR7DATA  links  rausfallen  bei  SPR6DATA  rechts
reinkommen.  Die  gleiche Operation wird auch fr die Inhalte der Register
SPR6DATB und SPR7DATB verrichtet, die stellen das zweite Plane des  Sprite
dar.

Um  euch  besser vor Augen zu halten, wie der Unterschied zwischen dem LSR
und ROR ist, versucht, das ROR mit dem LSR in  der  Routine  "BewegeBerge"
auszutauschen.  Ihr  werdet  sehen,  da  es  nicht genau das ist, was wir
wollten!

Natrlich gibt es zum ROR ein Gegenstck, das alles nach links rollen lt,
das  ROL  ("ROtate Left"). Es ist das gleiche wie das ROR, ihr knnt es in
der Routine austauschen  und  somit  die  Berge  in  die  andere  Richtung
schicken.

In  Theorie  knnte  man  mit  nur  zwei  Sprites  den gesamten Bildschirm
ausfllen, angefangen ganz oben, mit den Wolken, weiter herunten  mit  den
Bergen,  die  Prrie  und  die  Bume  im  Vordergrund.  Man  knnte  die
verscheidenen "Levels" auch mit verschiedenen  Geschwindigkeiten  scrollen
lassen, und so einen Parallax-Effekt erzeugen, also die Berge langsam, die
Prrie mittelschnell und die Bume schnell. Aber  das  wrde  eine  enorme
Copperlist  erfordern,  und die Scrollroutine wre recht langsam, deswegen
werden fr solche Operationen  die  Bitplanes  bevorzugt.  Sie  sind  auch
farbiger und eben schneller zu bewegen. Na ja, wenn sich nun jemand traut,
zu sagen, der Amiga hat nur 8 kleine Sprites, dann knntet ihr  ihm  einen
Bildschirm  zeigen,  der  nur aus 2 Sprites besteht, die sich in Parallaxe
bewegen, darbergeblendet ein Bild in 4096 Farben in HAM, dann wrden euch
noch  6  Sprites  brigbleiben,  um Sternchen und Raumschiffe zu zeichnen.
Wenn ihr dann dazwischen noch ein  paar  hundert  BOBs  mit  dem  Blitter
rumdsen  lt...vielleicht  wrde man nichts mehr verstehen, aber es wre
interessant!

