
; Listing7y4.s	- Landschaft, hergestellt mit nur 2 Sprites!

;	Dieses Beispiel zeigt, wie es mglich ist, eine ganze Landschaft
;	auf den Bildschirm zu malen, indem man nur zwei Sprites verwendet.
;	Wir pointen direkt auf die Spriteregister

	SECTION CipundCop,CODE

Anfang:
	move.l	4.w,a6			; Execbase
	jsr	-$78(a6)			; Disable
	lea	GfxName(pc),a1		; Name lib
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop	; speichern die alte COP

;	Pointen auf das "leere" PIC

	move.l	#Bitplane,d0	; wohin pointen
	lea	Bplpointers,A1		; COP-Pointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

;	Wir pointen NICHT auf den Sprite !!!!!!!!!!!!!!!!!!!!

	move.l	#Copperlist,$dff080	; unsere COP
	move.w	d0,$dff088		; START COP
	move.w	#0,$dff1fc		; NO AGA!
	move.w	#$c00,$dff106	; NO AGA!

Mouse:
	btst	#6,$bfe001		; linke Maustaste gedrckt?
	bne.s	Mouse

	move.l	OldCop(pc),$dff080	; Pointen auf die SystemCOP
	move.w	d0,$dff088		; starten die alte SystemCOP

	move.l	4.w,a6
	jsr	-$7e(a6)			; Enable
	move.l	gfxbase(pc),a1
	jsr	-$19e(a6)			; Closelibrary
	rts

;	Daten

GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0


	SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; SPRITE
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

	dc.w	$8e,$2c81		; DiwStrt
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$38			; DdfStart
	dc.w	$94,$d0			; DdfStop
	dc.w	$102,0			; BplCon1
	dc.w	$104,0			; BplCon2
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod

				; 5432109876543210
	dc.w	$100,%0001001000000000	; Bit 12 an: 1 Bitplane Lowres

Bplpointers:
	dc.w	$e0,0,$e2,0		; erste Bitplane

	dc.w	$180,$000		; COLOR0	; schwarzer Hintergrund
	dc.w	$182,$123		; COLOR1	; COLOR1 des Bitplane, das
							; in diesem Fall leer ist, und
							; deswegen nicht erscheint.
							
	dc.w	$01ba,$0fff		; COLOR29
	dc.w	$01bc,$0aaa		; COLOR30
	dc.w	$01be,$0753		; COLOR31

; Aus Bequemlichkeit verwenden wir Symbole. Ich erinnere euch, da man ein
; Symbol (oder EQUATE) auf zwei Arten definieren kann: wie in diesem Fall,
; wo wir einfach ein = setzen, gefolgt vom Wert, den das Symbol haben soll,
; oder mit dem Schlsselword EQU anstelle des =.

SPR6POS		= $170
SPR6DATA	= $174
SPR6DATB	= $176
SPR7POS		= $178
SPR7DATA	= $17c
SPR7DATB	= $17e

; Zeile $50
	dc.w	$5025,$fffe
	dc.w	SPR6DATA,$0,SPR6DATB,$0,SPR7DATA,$f000,SPR7DATB,$0
	dc.w	SPR6POS,$40,SPR7POS,$48,$504b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$505b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$506b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$507b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$508b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$509b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$50ab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$50bb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$50cb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$50db,$fffe

; Zeile $51
	dc.w	$5125,$fffe
	dc.w	SPR6DATA,$0001,SPR6DATB,$0000,SPR7DATA,$b800,SPR7DATB,$4000
	dc.w	SPR6POS,$40,SPR7POS,$48,$514b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$515b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$516b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$517b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$518b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$519b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$51ab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$51bb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$51cb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$51db,$fffe

; Zeile $52
	dc.w	$5225,$fffe
	dc.w	SPR6DATA,$0003,SPR6DATB,$0000,SPR7DATA,$bc00,SPR7DATB,$4000
	dc.w	SPR6POS,$40,SPR7POS,$48,$524b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$525b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$526b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$527b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$528b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$529b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$52ab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$52bb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$52cb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$52db,$fffe

; Zeile $53
	dc.w	$5325,$fffe
	dc.w	SPR6DATA,$0002,SPR6DATB,$0001,SPR7DATA,$ec00,SPR7DATB,$1200
	dc.w	SPR6POS,$40,SPR7POS,$48,$534b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$535b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$536b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$537b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$538b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$539b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$53ab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$53bb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$53cb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$53db,$fffe

; Zeile $54
	dc.w	$5425,$fffe
	dc.w	SPR6DATA,$0007,SPR6DATB,$0000,SPR7DATA,$2b00,SPR7DATB,$d400
	dc.w	SPR6POS,$40,SPR7POS,$48,$544b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$545b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$546b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$547b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$548b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$549b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$54ab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$54bb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$54cb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$54db,$fffe

; Zeile $55
	dc.w	$5525,$fffe
	dc.w	SPR6DATA,$001c,SPR6DATB,$0003,SPR7DATA,$e780,SPR7DATB,$1800
	dc.w	SPR6POS,$40,SPR7POS,$48,$554b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$555b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$556b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$557b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$558b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$559b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$55ab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$55bb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$55cb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$55db,$fffe

; Zeile $56
	dc.w	$5625,$fffe
	dc.w	SPR6DATA,$803e,SPR6DATB,$0001,SPR7DATA,$9ac1,SPR7DATB,$6500
	dc.w	SPR6POS,$40,SPR7POS,$48,$564b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$565b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$566b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$567b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$568b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$569b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$56ab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$56bb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$56cb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$56db,$fffe

; Zeile $57
	dc.w	$5725,$fffe
	dc.w	SPR6DATA,$c079,SPR6DATB,$0006,SPR7DATA,$b6e7,SPR7DATB,$4910
	dc.w	SPR6POS,$40,SPR7POS,$48,$574b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$575b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$576b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$577b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$578b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$579b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$57ab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$57bb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$57cb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$57db,$fffe

; Zeile $58
	dc.w	$5825,$fffe
	dc.w	SPR6DATA,$c07f,SPR6DATB,$0048,SPR7DATA,$fff6,SPR7DATB,$2009
	dc.w	SPR6POS,$40,SPR7POS,$48,$584b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$585b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$586b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$587b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$588b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$589b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$58ab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$58bb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$58cb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$58db,$fffe

; Zeile $59
	dc.w	$5925,$fffe
	dc.w	SPR6DATA,$e06f,SPR6DATB,$0096,SPR7DATA,$7eaf,SPR7DATB,$a150
	dc.w	SPR6POS,$40,SPR7POS,$48,$594b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$595b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$596b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$597b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$598b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$599b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$59ab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$59bb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$59cb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$59db,$fffe

; Zeile $5a
	dc.w	$5a25,$fffe
	dc.w	SPR6DATA,$61ed,SPR6DATB,$9013,SPR7DATA,$dfff,SPR7DATB,$6cab
	dc.w	SPR6POS,$40,SPR7POS,$48,$5a4b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$5a5b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$5a6b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$5a7b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$5a8b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$5a9b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$5aab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$5abb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$5acb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$5adb,$fffe

; Zeile $5b
	dc.w	$5b25,$fffe
	dc.w	SPR6DATA,$db9f,SPR6DATB,$72ed,SPR7DATA,$ffff,SPR7DATB,$dbee
	dc.w	SPR6POS,$40,SPR7POS,$48,$5b4b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$5b5b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$5b6b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$5b7b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$5b8b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$5b9b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$5bab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$5bbb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$5bcb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$5bdb,$fffe

; Zeile $5c
	dc.w	$5c25,$fffe
	dc.w	SPR6DATA,$ffff,SPR6DATB,$cfbf,SPR7DATA,$ffff,SPR7DATB,$ff3f
	dc.w	SPR6POS,$40,SPR7POS,$48,$5c4b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$5c5b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$5c6b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$5c7b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$5c8b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$5c9b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$5cab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$5cbb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$5ccb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$5cdb,$fffe

; Zeile $5d
	dc.w	$5d25,$fffe
	dc.w	SPR6DATA,$ffff,SPR6DATB,$ffff,SPR7DATA,$ffff,SPR7DATB,$feff
	dc.w	SPR6POS,$40,SPR7POS,$48,$5d4b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$5d5b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$5d6b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$5d7b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$5d8b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$5d9b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$5dab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$5dbb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$5dcb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$5ddb,$fffe

; Copperanweisungen zum deaktivieren der Sprite

	dc.w	$5107,$fffe		; Warte den Anfang der Zeile ab
	dc.w	$172,0			; spr6ctl
	dc.w	$17a,0			; spr7ctl

	dc.w	$ffff,$fffe		; Ende der Copperlist
	
 
	SECTION LEERESPLANE,BSS_C	; Wir brauchen ein leeres Bitplane,
							; denn ohne Bitplanes knnen wir
							; keine Sprites anzeigen.

Bitplane:
	ds.b	40*256			; leere Bitplane Lowres

	end

Wie  ihr  seht,  ist  es mglich, auch mehr als nur einmal pro Zeile einen
Sprite anzuzeigen, angenommen, man kann Assemblerprogrammieren.
In diesem Fall verwenden wir zwei Sprites (6+7) und zeigen  jeden  10  mal
an,  was  insgesamt  16*20=320  ergibt, genau die Breite des Bildschirmes.
Praktisch fllen wir den ganzen Bildschirm. Die Idee ist die  gleiche  wie
im  vorigen Beispiel, wir verndern die Werte der Register mit dem Copper.
Aber hier verndern wir nicht nur in jeder  Zeile  die  Position,  sondern
auch  noch  die  Form des Sprites, um eben die Landschaft zu erzeugen. Der
Einfachheit wegen ist unser Gebirge nur 14 Pixel  hoch,  aber  man  knnte
auch den ganzen Bildschirm ausfllen!
Jede Zeile in der Copperlist ist so aufgebaut:

; Zeile $50
	dc.w	$5025,$fffe
	dc.w	SPR6DATA,$0,SPR6DATB,$0,SPR7DATA,$f000,SPR7DATB,$0
	dc.w	SPR6POS,$40,SPR7POS,$48,$504b,$fffe
	dc.w	SPR6POS,$50,SPR7POS,$58,$505b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$506b,$fffe
	dc.w	SPR6POS,$70,SPR7POS,$78,$507b,$fffe
	dc.w	SPR6POS,$80,SPR7POS,$88,$508b,$fffe
	dc.w	SPR6POS,$90,SPR7POS,$98,$509b,$fffe
	dc.w	SPR6POS,$a0,SPR7POS,$a8,$50ab,$fffe
	dc.w	SPR6POS,$b0,SPR7POS,$b8,$50bb,$fffe
	dc.w	SPR6POS,$c0,SPR7POS,$c8,$50cb,$fffe
	dc.w	SPR6POS,$d0,SPR7POS,$d8,$50db,$fffe

Hier haben wir das Stck Copperlist fr Zeile  $50  herausgenommen.  Sehen
wir uns die Bedeutung aller Anweisungen an:

	dc.w	$5025,$fffe		; Wait

Die erste Anweisung dient dazu, abzuwarten, bis der  Elektronenstrahl  die
horizontale Position $25 in der aktuellen Zeile erreicht.

	dc.w	SPR6DATA,$0,SPR6DATB,$0,SPR7DATA,$f000,SPR7DATB,$0

Diese Befehle dienen zum setzen der  Werte  der  DATA-Register  fr  diese
Zeile, sie geben seine Form an, sein Aussehen.

	dc.w	SPR6POS,$40,SPR7POS,$48,$504b,$fffe

Damit wird die Position des Sprite festgelegt. Sie arbeiten wie im vorigen
Beispiel.  Zuerst  werden  die  Spritepositionen  erneuert,  und dann wird
abgewartet, bis die zwei Sprites angezeigt werden.  Nun  wiederholen  sich
zehn  Gruppen  von  solchen  Copper-Anweisungen,  die  wiederum  die
Spritepositionen verndern und  mit  einem  Wait  abwarten,  so,  da  die
Sprites  jeweils  16  Pixel  verschoben  sind,  um  sie  nebeneinander  zu
plazieren. Z.B.:

	dc.w	SPR6POS,$50,SPR7POS,$58,$505b,$fffe
	dc.w	SPR6POS,$60,SPR7POS,$68,$506b,$fffe

Zerteilen wir eine Zeile in die 3 Anweisungen, die sie enthlt:

	dc.w	SPR6POS,$50		; bestimmt die Position des Sprite6
	dc.w	SPR7POS,$58		; bestimmt die Position des Sprite7
	dc.w	$505b,$fffe		; WAIT - Wartet 16 Pixel ab, weiter rechts.

und so weiter.

Nach zehn solcher Gruppen haben  wir  eine  ganze  Zeile  gezeichnet.  Nun
bleibt  uns  nichts  anderes  brig,  als das, was wir fr Zeile $50 getan
haben, auch fr die anderen 13 Zeilen der Landschaft zu machen.  Natrlich
haben  wir  fr  jede Zeile andere Werte in den Registern SPRxDATx, um die
Berge zu gestalten.

Natrlich werden fr solche extrem  langen  Copperlisten  eigene  Routinen
geschrieben,  etwa "GeneriereCopperlist", die wegen ihrer Komplexitt aber
noch nicht im Kurs eingefhrt worden sind. Das wichtige ist im Moment,  zu
verstehen,  wie  die  Sache  mit der Wiederverwendung abluft, und wie man
direkt auf die Spriteregister mit der Copperlist zugreift.


