
; Listing7w1.s	KOLLISIONEN ZWISCHEN SPRITES

	SECTION CipundCop,CODE

Anfang:
	move.l	4.w,a6			; Execbase
	jsr	-$78(a6)			; Disable
	lea	GfxName(pc),a1		; Name lib
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop	; speichern die alte COP

;	Pointen wie immer auf unser PIC

	move.l	#PIC,d0
	lea	Bplpointers,A1
	moveq	#2-1,d1
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*256,d0
	addq.w	#8,a1
	dbra	d1,PointBp

;	Pointen auf den Sprite

	lea	SpritePointers,a1		; Pointer in der Copperlist
	move.l	#MeinSprite0,d0		; Adresse des Sprite in d0
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	add.l	#16,a1

	move.l	#MeinSprite2,d0		; Adresse des Sprite in d0
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	move.l	#Copperlist,$dff080	; unsere COP
	move.w	d0,$dff088			; START COP
	move.w	#0,$dff1fc			; NO AGA!
	move.w	#$c00,$dff106		; NO AGA!

Mouse:
	cmpi.b	#$ff,$dff006		; Zeile 255?
	bne.s	Mouse

	bsr.s	BewegeSprite0		; Bewege das Flugzeug
	bsr.s	BewegeSprite1		; Bewege die Rakete gegen das Flugzeug
	bsr.s	CheckColl			; Kontrolliere die Kollisionen und
								; greife eventuell ein

Warte:
	cmpi.b	#$ff,$dff006		; Zeile 255?
	beq.s	Warte

	btst	#6,$bfe001			; Mouse gedrckt?
	bne.s	Mouse

	move.l	OldCop(pc),$dff080	; Pointen auf die SystemCOP
	move.w	d0,$dff088			; starten die alte COP

	move.l	4.w,a6
	jsr	-$7e(a6)				; Enable
	move.l	gfxbase(pc),a1
	jsr	-$19e(a6)				; Closelibrary
	rts

;	Daten

GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0

; Diese Routine bewegt den Sprite, der das Flugzeug darstellt, gradlinig
; um jeweils 2 Pixel nach links. Sie greift auf das Byte Hstart zu

BewegeSprite0:
	subq.b	#1,Hstart0
	rts

;	-		-		-		-

; Dieses Routine bewegt die Rakete. Sie tut das nur, wenn das Flugzeug nah
; genug ist, um getroffen zu werden. Es ist soweit, wenn dessen Hstart $b0
; erreicht hat. Wenn ihr das Flugzeug retten wollt, versucht die Rakete bei
; $AA abzuschieen, also zu frh, oder bei Position $c1, wo es schon zu
; spt ist.

BewegeSprite1:
	cmp.b	#$b0,Hstart0			; Ist das Flugzeug in Schuweite?
	bhi.s	nicht_in_Schussweite	; noch nicht schieen, wenn es zu weit
									; weg ist
	subq.b	#1,Vstart2				; la die Rakete steigen, indem auf das Vstart
	subq.b	#1,Vstop2				; wie das Vstop eingewirkt wird
nicht_in_Schussweite:
	rts

;	-		-		-		-

; Diese Routine kontrolliert, ob es eine Kollision gab. Wenn ja, lscht
; sie die beiden Sprites, indem sie deren Pointer in der Copperlist auf


CheckColl:
	move.w	$dff00e,d0		; liest CLXDAT ($dff00e)
							; ein Lesevorgang dieses Register bewirkt
							; auch dessen komplette Lschung, es ist deshalb
							; ratsam, es sich in d0 zu kopieren, und dann
							; dort die Tests durchzufhren
	btst.l	#9,d0
	beq.s	NoColl			; wenn keine Kollision, berspringe

	moveq	#0,d0			 ; ansonsten lsche die Sprites
	lea	SpritePointers,a1	; Pointer Sprite 0
	move.w	d0,6(a1)		; Lsche Spritepointer 0 in der Copperlist
	move.w	d0,2(a1)
	add.w	#16,a1			; Pointer Sprite 2
	move.w	d0,6(a1)		; Lsche Pointer auf Sprite 2 in der Copperlist
	move.w	d0,2(a1)
NoColl:
	rts


	SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; SPRITE
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

	dc.w	$8e,$2c81		; DiwStrt
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$38			; DdfStart
	dc.w	$94,$d0			; DdfStop
	dc.w	$102,0			; BplCon1
	dc.w	$104,$0024		; BplCon2 - Sprites ber den Bitplanes
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod

				; 5432109876543210
	dc.w	$100,%0010001000000000	; Bit 13 an 2 Bitplane Lowres

Bplpointers:
	dc.w	$e0,0,$e2,0		; erste Bitplane
	dc.w	$e4,0,$e6,0		; zweite Bitplane

	dc.w	$180,$000		; COLOR0	; schwarzer Hintergrund
	dc.w	$182,$005		; COLOR1	; COLOR 1 des Bitplane
	dc.w	$184,$a40		; COLOR1	; COLOR 2 des Bitplane
	dc.w	$186,$f80		; COLOR1	; COLOR 3 des Bitplane

	dc.w	$1A2,$06f		; COLOR17, also COLOR1 des Sprite0
	dc.w	$1A4,$0c0		; COLOR18, also COLOR2 des Sprite0
	dc.w	$1A6,$0c0		; COLOR19, also COLOR3 des Sprite0

	dc.w	$1AA,$444		; COLOR21, also COLOR1 des Sprite2
	dc.w	$1AC,$888		; COLOR22, also COLOR2 des Sprite2
	dc.w	$1AE,$0c0		; COLOR23, also COLOR3 des Sprite2

	dc.w	$ffff,$fffe		; Ende der Copperlist


; *********** Hier ist der Sprite: Klarerweise ist er in CHIP RAM! ************

MeinSprite0:	; Lnge 6 Zeilen
Vstart0:
	dc.b 180	; Vertikale Anfangsposition (von $2c bis $f2)
Hstart0:
	dc.b $d8	; Horizontale Anfangsposition (von $40 bis $d8)
Vstop0:
	dc.b 186	; 180+6=186
VhBits:
	dc.b $00
	dc.w	$0008,$0000
	dc.w	$1818,$0000
	dc.w	$2C28,$1010
	dc.w	$7FF8,$0000
	dc.w	$3FC0,$0000
	dc.w	$01F0,$0000
	dc.w	$0000,$0000

MeinSprite2:	; Lnge 16 Zeilen
Vstart2:
	dc.b 224	; Vertikale Anfangsposition (von $2c bis $f2)
Hstart2:
	dc.b $86	; Horizontale Anfangsposition (von $40 bis $d8)
Vstop2:
	dc.b 240
	dc.b 0
	dc.w	$0200,$0000
	dc.w	$0200,$0000
	dc.w	$0200,$0000
	dc.w	$0000,$0200
	dc.w	$0000,$0700
	dc.w	$0000,$0700
	dc.w	$0500,$0200
	dc.w	$0200,$0500
	dc.w	$0500,$0200
	dc.w	$0200,$0500
	dc.w	$1540,$0200
	dc.w	$0200,$1DC0
	dc.w	$0000,$1FC0
	dc.w	$0000,$1740
	dc.w	$0500,$0200
	dc.w	$0000,$0000
	dc.w	$0000,$0000

;	Bild der Startrampe

PIC:
	incbin	"/Sources/paesaggio.raw"

	end

In  diesem Beispiel sehen wir, wie man die Kollision zwischen zwei Sprites
registrieren kann.
Wir haben zwei Objekte, die sich kreuzen. Achtet darauf, da wir  fr  die
zwei  Objekte  die  Sprites  0 und 2 gewhlt haben, also zwei Sprites, die
verschiedenen Paaren angehren. Das erlaubt uns zum Einen  die  Verwendung
von  zwei  verschiedenen Farbpaletten, ist aber andererseits notwendig, um
die Kollisionen berhaupt erkennen zu knnen. Denn  es  ist  nur  mglich,
Kollisionen  zwischen  Sprites  aus verschiedenen Gruppen zu erkennen, und
nicht zwischen Sprites aus ein und demselben Paar. Um  eine  Kollision  zu
erkennen  mu  nur ein Bit im Register CLXDAT kontrolliert werden, wie wir
schon in der Lektion gehrt haben.

Wenn dieses Bit auf  1  steht,  dann  hat  sich  effektiv  eine  Kollision
zugetragen.  In unserem Beispiel beschrnken wir uns lediglich darauf, die
beiden Sprites zu lschen, indem wir die Pointer auf 0 zeigen lassen.  Ihr
knnt  es  natrlich  verbessern,  indem  ihr  eine  schne  Explosion
dazu zeichnet. Es ist sehr einfach. Als erstes  zeichnet  ihr  euch  einen
Sprite,  der  eine  Explosion darstellt, und fgt ihn im Listing ein (Aber
bitte in die SECTION, die in  die  CHIP  kommt!!).  Dann  modifiziert  die
Routine  CheckColl:  wenn  eine  Kollision  auftritt,  dann  ersetzt  die
folgenden Zeilen


	moveq	#0,d0			; ansonsten lsche die Sprites
	lea	SpritePointers,a1	; Spritepointer 0
	move.w	d0,6(a1)		; lsche Spritepointer0 in der Copperlist
	move.w	d0,2(a1)

durch diese

	move.l	#EXPLOSIONS_SPRITE,d0	; Adresse des Explosionssprite
	lea	SpritePointers,a1			; Spritepointer 0
	move.w	d0,6(a1)		; verndert Spritepointer 0 in der Copperlist
	swap	d0
	move.w	d0,2(a1)

dadurch wird das Bild des Flugzeuges durch das der Explosion ersetzt.  Ihr
mt  dann  natrlich  noch  die  Byte,  die  die  Position des Flugzeuges
kontrollieren, in die Kontrollbytes der Explosion kopieren. Das knnt  ihr
nun  aber  schon alleine. Ihr mt nur bei Vstop etwas aufpassen: wenn die
Explosion eine andere Hhe hat als das Flugzeug, dann knnt ihr nicht  nur
das  alte  Vstop  einsetzen,  sondern  ihr  mt  es  anpassen.  Aber  nix
schwieriges.

In diesem Beispiel haben wir gezielt sehr einfache Bahnen gewhlt  (gerade
Linien),  um  den  Mechanismus  der  Kollision besser zu zeigen. Ihr knnt
statt dieser Routinen auch solche mit Tabellen einsetzen, wie wir  sie  in
einigen vorigen Beispielen verwendet haben.


