 
; Listing7v2.s  -  Sprite im Dual-Playfield-Mode
; In diesem Listing zeigen wir die verschiedenen Priorittslevel der
; Sprites gegenber den zwei Playfields. Die Sprites bewegen sich von oben nach
; unten. Jedesmal, wenn sie unten angekommen sind, beginnen sie wieder
; von oben, nur mit einer anderen Prioritt.
; Das Ende des Programmes mu abgewartet werden. (muss es nicht mehr...)

	SECTION CipundCop,CODE

Anfang:
	move.l	4.w,a6			; Execbase
	jsr	-$78(a6)			; Disable
	lea	GfxName(pc),a1		; Name lib
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop	; speichern die alte COP

;	Pointen auf die bliche Art unsere Pics an

	move.l	#Pic1,d0
	lea	Bplpointers1,A1
	moveq	#3-1,d1
PointBp:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*256,d0
	addq.w	#8,a1
	dbra	d1,PointBp

	move.l	#Pic2,d0
	lea	Bplpointers2,A1
	moveq	#3-1,d1
PointBp2:
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	swap	d0
	add.l	#40*256,d0
	addq.w	#8,a1
	dbra	d1,PointBp2

;	Pointen auf die Sprites

	move.l	#MeinSprite0,d0		; Adresse des Sprite in d0
	lea	SpritePointers,a1		; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite1,d0		; Adresse des Sprite in d0
	addq.w	#8,a1				; nchsten SpritePOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite2,d0		; Adresse des Sprite in d0
	addq.w	#8,a1				; nchsten SpritePOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite3,d0		; Adresse des Sprite in d0
	addq.w	#8,a1				; nchsten SpritePOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite4,d0		; Adresse des Sprite in d0
	addq.w	#8,a1				; nchsten SpritePOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite5,d0		; Adresse des Sprite in d0
	addq.w	#8,a1				; nchsten SpritePOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite6,d0		; Adresse des Sprite in d0
	addq.w	#8,a1				; nchsten SpritePOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite7,d0		; Adresse des Sprite in d0
	addq.w	#8,a1				; nchsten SpritePOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	move.l	#Copperlist,$dff080	; unsere COP
	move.w	d0,$dff088			; START COP
	move.w	#0,$dff1fc			; NO AGA!
	move.w	#$c00,$dff106		; NO AGA!

	lea	PriList(pc),a0			; a0 pointet auf die Liste mit Priorittsleveln
	
	move.w	#$0000,$dff104		; BPLCON2
								; mit diesem Wert sind alle Sprites unter
								; beiden Playfields

Warte1:
	cmpi.b	#$ff,$dff006		; Zeile 255?
	bne.s	Warte1

	bsr.s	BewegeSprites		; Bewegt die Sprites nach unten

	btst	#6,$bfe001			; linke Maustaste gedrckt?
	beq.s	Raus

Warte2:
	cmpi.b	#$ff,$dff006		; Zeile 255?
	beq.s	Warte2

	cmp.w	#250,Hoehe			; Haben die Sprites den unteren Rand erreicht?
	blo.s	Warte1				; nein, dann bewege sie weiter

	move.w	#$2c,Hoehe			; Ja. Setz sie wieder ganz nach oben
	cmp.l	#EndPriList,a0		; Haben wir die Prioritlevel alle durchgemacht?
	beq.s	Raus				; wenn ja, dann steig aus.
	move.w	(a0)+,$dff104		; Wenn nicht, gib den nchsten Wert in BPLCON2
	bra.s	Warte1

Raus:
	move.l	OldCop(pc),$dff080	; Pointen auf die SystemCOP
	move.w	d0,$dff088			; Starten die alte COP

	move.l	4.w,a6
	jsr	-$7e(a6)				; Enable
	move.l	gfxbase(pc),a1
	jsr	-$19e(a6)				; Closelibrary
	rts

;	Daten

GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0

; Diese Routine bewegt die 8 Sprites um einen Pixel pro Durchgang nach unten.
; Alle Sprites haben die selbe Hhe.


BewegeSprites:

; bewegt den Sprite 0

	addq.w	#1,Hoehe
	move.w	Hoehe(pc),d0

	clr.b	VHBITS0			; Lsche die Bits 8 der horizontalen Position
	move.b	d0,Vstart0		; Kopiere die Bit von 0 bis 7 in Vstart
	btst.l	#8,d0			; ist die Position grer als 255?
	beq.s	NOBIGVSTART		; wenn nicht, dann geh weitde, denn das Bit wurde
							; bereits mit clr.b VhBits gelscht

	bset.b	#2,VHBITS0		; ansonsten setze Bit 8 der vertikalen Startposition
							; auf 1
NOBIGVSTART:
	addq.w	#8,d0			; Zhle die Lnge des Sprite dazu, um die
							; Endposition zu ermitteln (Vstop)
	move.b	d0,Vstop0		; Gib die Bit von 0 bis 7 in Vstop
	btst.l	#8,d0			; ist die Position grer als 255 ?
	beq.s	NOBIGVSTOP		; wenn nicht, dann geh weiter, denn das Bit wurde
							; bereits mit clr.b VhBits gelscht

	bset.b	#1,VHBITS0		; ansonsten setze Bit 8 der vertikalen Startposition
							; auf 1
NOBIGVSTOP:

; kopiere die Hhe in die anderen Sprites

	move.b	vstart0,vstart1 ; kopiert Vstart
	move.w	vstop0,vstop1	; kopiert Vstop und VhBits

	move.b	vstart0,vstart2 ; kopiert Vstart
	move.w	vstop0,vstop2	; kopiert Vstop und VhBits

	move.b	vstart0,vstart3 ; kopiert Vstart
	move.w	vstop0,vstop3	; kopiert Vstop und VhBits

	move.b	vstart0,vstart4 ; kopiert Vstart
	move.w	vstop0,vstop4	; kopiert Vstop und VhBits

	move.b	vstart0,vstart5 ; kopiert Vstart
	move.w	vstop0,vstop5	; kopiert Vstop und VhBits

	move.b	vstart0,vstart6 ; kopiert Vstart
	move.w	vstop0,vstop6	; kopiert Vstop und VhBits

	move.b	vstart0,vstart7 ; kopiert Vstart
	move.w	vstop0,vstop7	; kopiert Vstop und VhBits

EndeBewegeSprites:
	rts

Hoehe:
	dc.w	$2c

; Das ist die Liste mit dne Priorittswerten. Ihr knnt sie variieren, wie
; ihr wollt. Nach dem letzten Wert mu aber das Label EndPriList stehen.
; Diese Werte werden in BPLCON2 geschrieben. Bemerkt den Unterschied zu
; Listing7v1.s, hier wird ein Screen im Dual-Playfield verwendet, somit knnen
; wir fr jedes Playfield eigene Priorittslevel vergeben.
; Ich erinnere euch daran, da zwischen den Sprites die Prioritten fix
; verteilt sind, und zwar so: der Sprite 0 hat die hchste Prioritt, der
; Sprite 7 die kleinste.

PriList:
	dc.w	$0008			; %001000 - mit disem Wert sind die Prioritten:
							; Playfield 1 (ber allem)
							; Sprite 0 und 1
							; Playfield 2
							; Sprite 2,3,4,5,6,7 (unter allem)

	dc.w	$0010			; %010000 - mit diesem Wert sind die Prioritten:
							; Playfield 1 (ber allem)
							; Sprite 0,1,2,3
							; Playfield 2
							; Sprite 4,5,6,7 (unter allem)

	dc.w	$0018			; %011000 - mit diesem Wert sind die Prioritten:
							; Playfield 1 (ber allem)
							; Sprite 0,1,2,3,4,5
							; Playfield 2
							; Sprite 6,7 (unter allem)
			
	dc.w	$0020			; %100000 - mit diesem Wert sind die Prioritten:
							; Playfield 1 (ber allem)
							; Sprite 0,1,2,3,4,5,6,7
							; Playfield 2
			
	dc.w	$0021			; %100001 - mit diesem Wert sind die Prioritten:
							; Sprite 0 und 1 (ber allem)
							; Playfield 1
							; Sprite 2,3,4,5,6,7
							; Playfield 2 (unter allem)
			
	dc.w	$0022			; %100010 - mit diesem Wert sind die Prioritten:
							; Sprite 0,1,2,3 (ber allem)
							; Playfield 1
							; Sprite 4,5,6,7
							; Playfield 2 (unter allem)
		
	dc.w	$0023			; %100011 - mit diesem Wert sind die Prioritten:
							; Sprite 0,1,2,3,4,5 (ber allem)
							; Playfield 1
							; Sprite 6,7
							; Playfield 2 (unter allem)

	dc.w	$0024			; %100100 - mit diesem Wert sind die Prioritten:
							; Sprite 0,1,2,3,4,5,6,7 (ber allem)
							; Playfield 1
							; Playfield 2 (unter allem)
EndPriList:


	SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; Sprite
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0


	dc.w	$8e,$2c81		; DiwStrt
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$38	 		; DdfStart
	dc.w	$94,$d0	 		; DdfStop

;	wir haben das BPLCON2 aus der Copperlist entfernt, da wie es
;	"manuell" mit dem Prozessor manipulieren.

	dc.w	$102,0			; BplCon1
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod

				; 5432109876543210
	dc.w	$100,%0110011000000000	; Bit 10 an = Dual Playfield
									; verwende 6 Planes = 8 Farben pro
									; Playfield
Bplpointers1:
	dc.w	$e0,0,$e2,0		; erste	Bitplane Playfield 1 (BPLPT1)
	dc.w	$e8,0,$ea,0		; zweite Bitplane Playfield 1 (BPLPT3)
	dc.w	$f0,0,$f2,0		; dritte Bitplane Playfield 1 (BPLPT5)


Bplpointers2:
	dc.w	$e4,0,$e6,0		; erste	Bitplane Playfield 2 (BPLPT2)
	dc.w	$ec,0,$ee,0		; zweite Bitplane Playfield 2 (BPLPT4)
	dc.w	$f4,0,$f6,0		; dritte Bitplane Playfield 2 (BPLPT6)

	dc.w	$180,$110		; Palette Playfield 1
	dc.w	$182,$005		; Farben von 0 bis 7
	dc.w	$184,$a40
	dc.w	$186,$f80 
	dc.w	$188,$f00 
	dc.w	$18a,$0f0 
	dc.w	$18c,$00f
	dc.w	$18e,$080

							; Palette Playfield 2
	dc.w	$192,$367		; Farben von 9 bis 15
	dc.w	$194,$0cc		; COLOR8 ist durchsichtig, er wird nicht gesetzt
	dc.w	$196,$a0a 
	dc.w	$198,$242 
	dc.w	$19a,$282 
	dc.w	$19c,$861
	dc.w	$19e,$ff0


	dc.w	$1a2,$f00		; Palette der Sprites
	dc.w	$1a4,$0f0
	dc.w	$1a6,$ff0

	dc.w	$1aa,$fff
	dc.w	$1ac,$0bd
	dc.w	$1ae,$d50

	dc.w	$1B2,$00F
	dc.w	$1B4,$F0F
	dc.w	$1B6,$BBB

	dc.w	$1BA,$8E0
	dc.w	$1BC,$a70
	dc.w	$1BE,$d00

	dc.w	$ffff,$fffe		; Ende der Copperlist


;	Die zwei Playfields

Pic1:	incbin	"/Sources/dual1.raw"
Pic2:	incbin	"/Sources/dual2.raw"

 ; ************ Hier die Sprite: KLARERWEISE in CHIP RAM! ************

 ; Referenztabelle zur Definition der Farben:


;  fr die Sprite 0 und 1
; BINR 00=COLOR 0 (TRANSPARENT)
; BINR 10=COLOR 1 (ROT)
; BINR 01=COLOR 2 (GRN)
; BINR 11=COLOR 3 (GELB)

MeinSprite0:	; Lnge: 8 Zeilen
Vstart0:
	dc.b $60	; Vertikale Pos. (von $2c bis $f2)
Hstart0:
	dc.b $60	; Horizontale Pos. (von $40 bis $d8)
Vstop0:
	dc.b $68	; $60+8=$68	; Ende Vertikal
VHBITS0:
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001110001111
 dc.w	%0011111111111100,%1100010001000011
 dc.w	%0111111111111110,%1000010001000001
 dc.w	%0111111111111110,%1000010001000001
 dc.w	%0011111111111100,%1100010001000011
 dc.w	%0000111111110000,%1111001110001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0		; Ende des Sprite


MeinSprite1:	; Lnge: 8 Zeilen
Vstart1:
	dc.b $60	; Vertikale Pos. (von $2c bis $f2)
Hstart1:
	dc.b $60+14	; Horizontale Pos. (von $40 bis $d8)
Vstop1:
	dc.b $68	; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111000010001111
 dc.w	%0011111111111100,%1100000110000011
 dc.w	%0111111111111110,%1000000010000001
 dc.w	%0111111111111110,%1000000010000001
 dc.w	%0011111111111100,%1100000010000011
 dc.w	%0000111111110000,%1111000111001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0		; Ende des Sprite

;  fr die Sprite 2 und 3
; BINR 00=COLOR 0 (TRANSPARENT)
; BINR 10=COLOR 1 (WEI)
; BINR 01=COLOR 2 (WASSER)
; BINR 11=COLOR 3 (ORANGE)

MeinSprite2:	; Lnge: 8 Zeilen
Vstart2:
	dc.b $60	; Vertikale Pos. (von $2c bis $f2)
Hstart2:
	dc.b $60+(14*2) ; Horizontale Pos. (von $40 bis $d8)
Vstop2:
	dc.b $68	; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111000111001111
 dc.w	%0011111111111100,%1100001000100011
 dc.w	%0111111111111110,%1000000000100001
 dc.w	%0111111111111110,%1000000111000001
 dc.w	%0011111111111100,%1100001000000011
 dc.w	%0000111111110000,%1111001111101111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0		; Ende des Sprite

MeinSprite3:	; Lnge: 8 Zeilen
Vstart3:
	dc.b $60	; Vertikale Pos. (von $2c bis $f2)
Hstart3:
	dc.b $60+(14*3) ; Horizontale Pos. (von $40 bis $d8)
Vstop3:
	dc.b $68	; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001111101111
 dc.w	%0011111111111100,%1100000000100011
 dc.w	%0111111111111110,%1000000111100001
 dc.w	%0111111111111110,%1000000000100001
 dc.w	%0011111111111100,%1100000000100011
 dc.w	%0000111111110000,%1111001111101111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0		; Ende des Sprite

;  fr die Sprite 4 und 5
; BINR 00=COLOR 0 (TRANSPARENT)
; BINR 10=COLOR 1 (BLAU)
; BINR 01=COLOR 2 (VIOLETT)
; BINR 11=COLOR 3 (GRAU)

MeinSprite4:	; Lnge: 8 Zeilen
Vstart4:
	dc.b $60	; Vertikale Pos. (von $2c bis $f2)
Hstart4:
	dc.b $60+(14*4) ; Horizontale Pos. (von $40 bis $d8)
Vstop4:
	dc.b $68	; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001001001111
 dc.w	%0011111111111100,%1100001001000011
 dc.w	%0111111111111110,%1000001111000001
 dc.w	%0111111111111110,%1000000001000001
 dc.w	%0011111111111100,%1100000001000011
 dc.w	%0000111111110000,%1111000001001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0		; Ende des Sprite

MeinSprite5:	; Lnge: 8 Zeilen
Vstart5:
	dc.b $60	; Vertikale Pos. (von $2c bis $f2)
Hstart5:
	dc.b $60+(14*5) ; Horizontale Pos. (von $40 bis $d8)
Vstop5:
	dc.b $68	; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0011111111111100,%1100001000000011
 dc.w	%0111111111111110,%1000001111000001
 dc.w	%0111111111111110,%1000000001000001
 dc.w	%0011111111111100,%1100000001000011
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0		; Ende des Sprite

;  fr die Sprite 6 und 7
; BINR 00=COLOR 0 (TRANSPARENT)
; BINR 10=COLOR 1 (HELLGRN)
; BINR 01=COLOR 2 (BRAUN)
; BINR 11=COLOR 3 (DUNKELROT)

MeinSprite6:	; Lnge: 8 Zeilen
Vstart6:
	dc.b $60	; Vertikale Pos. (von $2c bis $f2)
Hstart6:
	dc.b $60+(14*6) ; Horizontale Pos. (von $40 bis $d8)
Vstop6:
	dc.b $68	; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0011111111111100,%1100001000000011
 dc.w	%0111111111111110,%1000001111000001
 dc.w	%0111111111111110,%1000001001000001
 dc.w	%0011111111111100,%1100001001000011
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0		; Ende des Sprite

MeinSprite7:	; Lnge: 8 Zeilen
Vstart7:
	dc.b $60	; Vertikale Pos. (von $2c bis $f2)
Hstart7:
	dc.b $60+(14*7) ; Horizontale Pos. (von $40 bis $d8)
Vstop7:
	dc.b $68	; $60+8=$68	; Ende Vertikal
	dc.b $00
 dc.w	%0000001111000000,%0111110000111110
 dc.w	%0000111111110000,%1111001111001111
 dc.w	%0011111111111100,%1100000001000011
 dc.w	%0111111111111110,%1000000001000001
 dc.w	%0111111111111110,%1000000001000001
 dc.w	%0011111111111100,%1100000001000011
 dc.w	%0000111111110000,%1111000001001111
 dc.w	%0000001111000000,%0111110000111110
 dc.w	0,0		; Ende des Sprite

		end

Dieses Beispiel zeigt, wie die Prioritten  der  Sprites  gegenber  einem
Bildschirm  in  Dual-Playfield-Mode funktioniert. Fr jedes Playfield kann
ein anderer Priorittslevel gesetzt werden. Fr dieses Beispiel haben  wir
eine  Liste  mit Werten verwendet. Eine Liste ist praktisch eine Reihe von
Werten, wie eine TABELLE. Mit einem Adressregister  (in  diesem  Fall  a0)
pointen wir auf den ersten Wert, und zwar mit der Anweisung:


	lea PriList(pc),a0

Jedesmal  wenn  ein Wert gelesen wird, bewegen wir das Register a0 auf den
darauf folgenden Wert, mittels indirekter Adressierung mit Postinkrement:

	move.w	(a0)+,$dff104	; Geben den Wert in BPLCON2

Wenn wir den letzten Wert erreicht haben, wird a0  dazugebracht,  auf  die
Adresse  im  Speicher  zu pointen, die dem letzten Wert folgt. Das ist die
Adresse des Label EndPriList. Wenn a0 gleich EndPriList wird,  dann  haben
wir das Ende der Liste erreicht, und wir steigen vom Programm aus.

Ihr  knnt  die  Werte  in  der  Liste  austauschen,  und  so  ein bichen
herumexperimentieren. Versucht z.B. $0011, ihr werdet die Sprite 0  und  1
ber  allen  beiden Playfields sehen, die Sprites 2 und 3 ber Playfield 2
und unter dem ersten, whrend der Rest der Sprites unter beiden Playfields
sein wird.

BEMERKUNG:  In  diesem  Beispiel  verndern  wir  die Prioritt, indem wir
direkt ins Register $dff104 (BPLCON2) schreiben. Das ist mglich, weil wir
die  Zeile  fr  dessen Definition aus der Copperlist entfernt haben, also
die Zeile:


	dc.w	$104,0			; BPLCON2

Wenn ihr versucht, sie wieder einzufgen, dann werdet ihr sehen,  da  der
Effekt anulliert wird, da die Copperlist ja bei jedem Fotogramm ausgefhrt
wird, und damit  BPLCON2  gelscht  wird.  Es  ist  also  mglich,  einige
Register mit dem Copper zu verndern, und andere direkt mit dem Prozessor,
aber ich rate euch, wann immer es mglich ist, den Copper zu verwenden. Er
ist besser und leichter zu synchronisieren,die richtige Zeile auszuwhlen,
um auf ein Register zugreifen zu knnen.

Ad: "BUCO" bedeutet soviel wie "Loch"...  (Hatte  keine  Zeit,  das  Bild
neu zu zeichnen).

