
; Listing7p.s	EIN SPRITE WIRD MIT DEM JOYSTICK BEWEGT

		SECTION CipundCop,CODE

Anfang:
	move.l	4.w,a6			; Execbase
	jsr	-$78(a6)			; Disable
	lea	GfxName(pc),a1		; Libname
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop	; speichern die alte COP

;	Pointen auf das "leere" PIC

	move.l	#Bitplane,d0	; wohin pointen
	lea	Bplpointers,A1		; COP-Pointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

;	Pointen auf den Sprite

	move.l	#MeinSprite,d0	; Adresse des Sprite in d0
	lea	SpritePointers,a1	; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	move.l	#Copperlist,$dff080	; unsere COP
	move.w	d0,$dff088		; START COP
	move.w	#0,$dff1fc		; NO AGA!
	move.w	#$c00,$dff106

Mouse:
	cmpi.b	#$ff,$dff006	; Zeile $ff?
	bne.s	Mouse

	btst	#7,$bfe001		; FEUERKNOPF gedrckt?
	bne.s	NonFuoco		; Wenn nicht, berspringe die nchste Anweisung
	move.w	#$f00,$dff180	; Wenn ja, gib ein schnes ROT in COLOR0
NonFuoco:

	bsr.s	LiesJoy			; das liest den Joystick
	move.w	SpriteY(pc),d0  ; bereite die Parameter fr Universalroutine
	move.w	SpriteX(pc),d1  ; vor
	lea	MeinSprite,a1		; Spriteadresse
	moveq	#13,d2			; Hhe des Sprite
	bsr.w	UniMoveSprite	; Aufruf der UniversalRoutine

Warte:
	cmpi.b	#$aa,$dff006	; Zeile $aa?
	beq.s	Warte

	btst	#6,$bfe001		; linke Maustaste gedrckt?
	bne.s	Mouse
	
	move.l	OldCop(pc),$dff080	; Pointen auf die SystemCOP
	move.w	d0,$dff088		; Starten die alte SystemCOP

	move.l	4.w,a6
	jsr	-$7e(a6)			; Enable
	move.l	gfxbase(pc),a1
	jsr	-$19e(a6)			; Closelibrary
	rts

;	Daten

GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0

; Diese Routine liest den Joystick aus und updatet die Werte in
; den Variablen Sprite_x und Sprite_y

LiesJoy:
	move.w	$dff00c,d3		; JOY1DAT
	btst.l	#1,d3			; das Bit 1 sagt uns, ob wir nach rechts gehn
	beq.s	NichtRechts		; wenn es 0 ist, gehen wir nicht rechts
	addq.w	#1,SpriteX		; wenn es 1 ist, bewege den Sprite um 1 Pixel
							; nach rechts
	bra.s	CheckY			; gehzur Kontrolle fr Y

NichtRechts:
	btst.l	#9,d3			; Bit 9 sagt uns, ob wir nach links gehn.
	beq.s	CheckY			; wenn es 0 ist, gehen wir nicht nach links
	subq.w	#1,SpriteX		; wenn es 1 ist, bewege den Sprite um 1 Pixel
CheckY:
	move.w	d3,d2			; kopiere den Wert des Registers
	lsr.w	#1,d2			; lt die Bits um eins nach Rechts rutschen
	eor.w	d2,d3			; Exklusives OR. Nun knnen wir testen
	btst.l	#8,d3			; Testen, ob es nach oben geht
	beq.s	NichtRauf		; wenn nicht, kontrolliere ob nach unten
	subq.w	#1,SpriteY		; wenn ja, bewege den Sprite um 1 Pixel
	bra.s	EndJoyst

NichtRauf:
	btst.l	#0,d3			; testen, ob es nach unten geht
	beq.s	EndJoyst		; wenn nicht, ende
	addq.w	#1,SpriteY		; wenn ja, bewege den Sprite um 1 Pixel
EndJoyst:
	rts

SpriteY:	dc.w	0		; hier wird das Y des Sprite gespeichert
SpriteX:	dc.w	0		; hier wird das X des Sprite gespeichert

; Universelle Routine zum Positionieren der Sprites

;	Eingangsparameter von UniMoveSprite:
;
;	a1 = Adresse des Sprite
;	d0 = Vertikale Position des Sprite auf dem Screen (0-255)
;	d1 = Horizontale Position des Sprite auf dem Screen (0-320)
;	d2 = Hhe des Sprite
;
UniMoveSprite:
; Vertikale Positionierung

	add.w	#$2c,d0	 ; zhle den Offset vom Anfang des Screens dazu

; a1 enthlt die Adresse des Sprite

	move.b	d0,(a1)			; kopiert das Byte in Vstart
	btst.l	#8,d0
	beq.s	NichtVstartSet
	bset.b	#2,3(a1)		; Setzt das Bit 8 von Vstart (Zahl > $FF)
	bra.s	ToVstop
NichtVstartSet:
	bclr.b	#2,3(a1)		; Lscht das Bit 8 von Vstart (Zahl < $FF)
ToVstop:
	add.w	d2,d0			; Zhle die Hhe des Sprite dazu, um
							; die Endposition zu errechnen (Vstop)
	move.b	d0,2(a1)		; Setze den richtigen Wert in Vstop
	btst.l	#8,d0
	beq.s	NichtVstopSet
	bset.b	#1,3(a1)		; Setzt Bit 8 von Vstop (Zahl > $FF)
	bra.w	VstopEnde
NichtVstopSet:
	bclr.b	#1,3(a1)		; Lscht Bit 8 von Vstop (Zahl < $FF)
VstopEnde:

; horizontale Positionierung

	add.w	#128,d1			; 128 - um den Sprite zu zentrieren
	btst	#0,d1			; niederwert. Bit der X-Koordinate auf 0?
	beq.s	NiederBitNull
	bset	#0,3(a1)		; Setzen das niederw. Bit von Hstart
	bra.s	PlaceCoords

NiederBitNull:
	bclr	#0,3(a1)		; Lschen das niederw. Bit von Hstart
PlaceCoords:
	lsr.w	#1,d1			; SHIFTEN, wir verschieben den Wert von Hstart um
							; 1 Bit nach rechts, um es in den Wert zu
							; "verwandeln", der dann in Hstart kommt, also
							; ohne dem niederwertigen Bit.
	move.b	d1,1(a1)		; geben den Wert XX ins Byte Hstart
	rts


	SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; SPRITE
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

	dc.w	$8e,$2c81		; DiwStrt
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$38			; DdfStart
	dc.w	$94,$d0			; DdfStop
	dc.w	$102,0			; BplCon1
	dc.w	$104,0			; BplCon2
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod

				; 5432109876543210
	dc.w	$100,%0001001000000000	; Bit 12 an!! 1 Bitplane Lowres

Bplpointers:
	dc.w	$e0,0,$e2,0		; erste	Bitplane

	dc.w	$180,$000		; Color0	; Hintergrund Schwarz
	dc.w	$182,$123		; Color1	; Farbe 1 des Bitplane, die
							; in diesem Fall leer ist,
							; und deswegen nicht erscheint

	dc.w	$1a2,$f00		; Color17, oder COLOR1 des Sprite0 - ROT
	dc.w	$1a4,$0f0		; Color18, oder COLOR2 des Sprite0 - GRN
	dc.w	$1a6,$ff0		; Color19, oder COLOR3 des Sprite0 - GELB

	dc.w	$ffff,$fffe		; Ende der Copperlist


; ************ Hier ist der Sprite: NATRLICH mu er in CHIP RAM sein! ********

MeinSprite:		; Lnge 13 Zeilen
Vstart:
	dc.b $50	; Vertikale Anfangsposition des Sprite (von $2c bis $f2)
Hstart:
	dc.b $90	; Horizontale Anfangsposition des Sprite (von $40 bis $d8)
Vstop:
	dc.b $5d	; $50+13=$5d	; Vertikale Endposition des Sprite
VhBits:
	dc.b $00
 dc.w	%0000000000000000,%0000110000110000 ; Binres Format fr ev. nderungen
 dc.w	%0000000000000000,%0000011001100000
 dc.w	%0000000000000000,%0000001001000000
 dc.w	%0000000110000000,%0011000110001100 ; BINR 00=COLOR 0 (DURCHSICHTIG)
 dc.w	%0000011111100000,%0110011111100110 ; BINR 10=COLOR 1 (ROT)
 dc.w	%0000011111100000,%1100100110010011 ; BINR 01=COLOR 2 (GRN)
 dc.w	%0000110110110000,%1111100110011111 ; BINR 11=COLOR 3 (GELB)
 dc.w	%0000011111100000,%0000011111100000
 dc.w	%0000011111100000,%0001111001111000
 dc.w	%0000001111000000,%0011101111011100
 dc.w	%0000000110000000,%0011000110001100
 dc.w	%0000000000000000,%1111000000001111
 dc.w	%0000000000000000,%1111000000001111
 dc.w	0,0		; 2 word auf NULL definieren das Ende des Sprite.


	SECTION LEERESPLANE,BSS_C	; Ein auf 0 gesetztes Bitplane, wir
							; mssen es verwenden, denn ohne Bitplane
							; ist es nicht mglich, die Sprites
							; zu aktivieren
Bitplane:
	ds.b	40*256			; Bitplane auf 0 Lowres

	end

In  diesem  Beispiel   bewegen  wir  den  Sprite  mit  dem  Joystick.  Das
einfachste  ist zu kontrollieren, ob der Feuerknopf gedrckt ist,  einfach
ein  BTST  #7,$bfe001, genau das Gleiche wie bei der linken Maustaste, nur
ist es dort das Bit 6. Um den Sprite am Monitor zu bewegen  verwenden  wir
unsere  Universalroutine, die wir schon fix und fertig vorliegen haben und
ersparen uns so eine Menge Arbeit.
Die Routine LiesJoy  kmmert  sich  darum,  den  Joystick  auszulesen  und
infolgedessen  die Koordinaten des Sprites zu erneuern, sie upzudaten. Sie
sind in den zwei Speicherzellen Sprite_x und Sprite_y festgehalten. Um den
Joystick  lesen  zu  knnen brauchen wir das Exklusive OR, das, wie wir in
der Lektion gesehen haben, eine Ex-OR-Operation zwischen den Bits aus zwei
Registern  durchfhrt.  Das  Lesen des Joystick erfolgt durch das Register
JOY1DAT. Um zu wissen, ob der Hebel des Joystick nach  links  oder  rechts
gedrckt  ist,  reicht  es  den Status der Bits 1 und 9 zu kennen. Fr die
anderen Richtungen ist es etwas komplizierter. Denn um zu wissen,  ob  der
Hebel  nach  oben gedrckt ist, mu ein Ex-OR zwischen dem Bit 8 und 9 von
JOY1DAT gemacht werden. Da sich diese Bits aber beide im  selben  Register
befinden  kopieren wir dieses in zwei Datenregister des 68000, z.B. d2 und
d3. Dann SHIFTEN ("rutschen") wir eines der beiden Register um eine Stelle
nach  rechts.  Somit  wird  das  Bit  9  des  Registers auf die Position 8
verstellt. Da das Register,  das  wir  geshiftet  haben,  eine  Kopie  von
JOY1DAT  war,  wird nach dem SHIFT das Bit 8 des Datenregisters gleich dem
Bit 9 von JOY1DAT sein. Im noch nicht  geshiftetem  Register  wird  Bit  8
hingegen immer noch gleich dem Bit 8 von JOY1DAT sein.
Wenn wir nun ein EOR zwischen den beiden Registern machen wird in Position
8  das  EOR  zwischen  Bit  8 des Registers JOY1DAT und Bit 9 von Register
JOY1DAT sein. Genau das, was wir brauchen, um zu wissen,  ob  der  Sprite
nach oben geht. Um zu wissen, ob der Sprite nach unten geht mssen wir ein
EOR zwischen Bit 0 und 1 machen, genauso wie gerade beschrieben.

Ihr knnt versuchen, die Geschwindigkeit des Sprites  zu  verndern.  Wenn
die  Routine  LiesJoy  eine Bewegung des Hebels registriert, dann wird der
Sprite um 1 Pixel verstellt (mit ADDQ #1,xxx oder SUBQ #1,xxx).  Wenn  ihr
statt 1 grere Werte einsetzt, dann wird er sich schneller bewegen.

