
; Listing7n.s - Beispiel der Applikation der Universalroutine:
;				ein Sprite, der abprallt

	 SECTION CipundCop,CODE

Anfang:
	move.l	4.w,a6			; Execbase
	jsr	-$78(a6)			; Disable
	lea	GfxName(pc),a1		; Libname
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop	; speichern die alte COP

;	Pointen auf das "leere" PIC

	move.l	#Bitplane,d0	; wohin pointen
	lea	Bplpointers,A1		; COP-Pointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

;	Pointen auf den Sprite

	move.l	#MeinSprite,d0	; Adresse des Sprite in d0
	lea	SpritePointers,a1	; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	move.l	#Copperlist,$dff080	; unsere COP
	move.w	d0,$dff088		; START COP
	move.w	#0,$dff1fc		; NO AGA!
	move.w	#$c00,$dff106

Mouse:
	cmpi.b	#$aa,$dff006	; Zeile $aa?
	bne.s	Mouse
	
	btst	#2,$dff016
	beq.s	Warte

	bsr.w	BewegeSprite	; bewege Sprite

Warte:
	cmpi.b	#$aa,$dff006	; Zeile $aa?
	beq.s	Warte

	btst	#6,$bfe001		; linke Maustaste gedrckt?
	bne.s	Mouse


	move.l	OldCop(pc),$dff080	; Pointen auf die SystemCOP
	move.w	d0,$dff088		; Starten die alte SystemCOP

	move.l	4.w,a6
	jsr	-$7e(a6)			; Enable
	move.l	gfxbase(pc),a1
	jsr	-$19e(a6)			; Closelibrary
	rts

;	Daten

GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0

; Diese Routine ndert die Koordinaten des Sprite, indem sie eine kostante
; Geschwindigkeit sowohl vertikal als auch horizontal dazuzhlt. Weiters,
; wenn der Sprite einen Rand berhrt, wird die Richtung invertiert.
; Um diese Routine zu verstehen mu man die Anweisung "NEG" kennen:
; Sie verwandelt eine positive Zahl in eine negative und umgekehrt.

BewegeSprite:
	move.w	SpriteY(pc),d0		; lies die alte Position
	add.w	SpeedY(pc),d0		; zhle Geschwindigkeit dazu
	btst	#15,d0				; Wenn Bit 15 gesetzt ist, dann ist die
								; Zahl negativ. Ist sie das geworden?
	beq.s	NichtAngehenOben	; wenn >0, dann ist alles gut
	neg.w	SpeedY				; wenn <0, dann haben wir den oberen Rand
								; berhrt also invertiere die Richtung
	bra.s	BewegeSprite		; errechne die neue Position

NichtAngehenOben:
	cmp.w	#243,d0				; wenn die Position 256-13=243 ist, dann
								; berhrt der Sprite den unteren Rand
	blo.s	NichtAngehenUnten
	neg.w	SpeedY				; wenn der Sprite den unteren Rand berhrt,
								; invertiere die Geschwindigkeit
	bra.s	BewegeSprite		; errechne die neue Position

NichtAngehenUnten:
	move	d0,SpriteY			; erneuere die Position
PosX:
	move.w	SpriteX(pc),d1		; lies die alte Position
	add.w	SpeedX(pc),d1		; zhle Geschwindigkeit dazu
	btst	#15,d0				; Wenn das Bit 15 gesetzt ist, dann ist die
								; Zahl negativ. Ist sie das geworden?
	beq.s	NichtAngehenLinks
	neg.w	SpeedX				; wenn <0 dann berhrt er den linken Rand:
								; invertiere die Richtung
	bra.s	PosX				; errechne die neue hor. Position

NichtAngehenLinks:
	cmp.w	#304,d1				; wenn die Position 320-16=304 ist, dann
								; berhrt der Sprite den rechten Rand
	blo.s	NichtAngehenRechts
	neg.w	SpeedX				; wenn er rechts anstot, invertiere die Richtung
	bra.s	PosX				; errechne die neue hor. Position

NichtAngehenRechts:
	move.w	d1,SpriteX			; erneuere die Position

	lea	MeinSprite,a1			; Adresse Sprite
	moveq	#13,d2				; Hhe Sprite
	bsr.s	UniMoveSprite		; Fhrt die UniversalRoutine aus, die
								; den Sprite positioniert
	rts

SpriteY:
		dc.w	10				; Position Sprite
SpriteX:
		dc.w	0
SpeedY:
		dc.w	-4				; Geschwindigkeit Sprite
SpeedX:
		dc.w	3

; Universelle Routine zum Positionieren der Sprites

;	Eingangsparameter von UniMoveSprite:
;
;	a1 = Adresse des Sprite
;	d0 = Vertikale Position des Sprite auf dem Screen (0-255)
;	d1 = Horizontale Position des Sprite auf dem Screen (0-320)
;	d2 = Hhe des Sprite
;
UniMoveSprite:
; Vertikale Positionierung

	add.w	#$2c,d0	 ; zhle den Offset vom Anfang des Screens dazu

; a1 enthlt die Adresse des Sprite

	move.b	d0,(a1)			; kopiert das Byte in Vstart
	btst.l	#8,d0
	beq.s	NichtVstartSet
	bset.b	#2,3(a1)		; Setzt das Bit 8 von Vstart (Zahl > $FF)
	bra.s	ToVstop
NichtVstartSet:
	bclr.b	#2,3(a1)		; Lscht das Bit 8 von Vstart (Zahl < $FF)
ToVstop:
	add.w	d2,d0			; Zhle die Hhe des Sprite dazu, um
							; die Endposition zu errechnen (Vstop)
	move.b	d0,2(a1)		; Setze den richtigen Wert in Vstop
	btst.l	#8,d0
	beq.s	NichtVstopSet
	bset.b	#1,3(a1)		; Setzt Bit 8 von Vstop (Zahl > $FF)
	bra.w	VstopEnde
NichtVstopSet:
	bclr.b	#1,3(a1)		; Lscht Bit 8 von Vstop (Zahl < $FF)
VstopEnde:

; horizontale Positionierung

	add.w	#128,d1			; 128 - um den Sprite zu zentrieren
	btst	#0,d1			; niederwert. Bit der X-Koordinate auf 0?
	beq.s	NiederBitNull
	bset	#0,3(a1)		; Setzen das niederw. Bit von Hstart
	bra.s	PlaceCoords

NiederBitNull:
	bclr	#0,3(a1)		; Lschen das niederw. Bit von Hstart
PlaceCoords:
	lsr.w	#1,d1			; SHIFTEN, verschieben den Wert von Hstart um
							; 1 Bit nach Rechts, um es in den Wert zu
							; "verwandeln", der dann in Hstart kommt, also
							; ohne dem niederwertigen Bit.
	move.b	d1,1(a1)		; geben den Wert XX ins Byte Hstart
	rts



	SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; SPRITE
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

	dc.w	$8e,$2c81		; DiwStrt
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$38			; DdfStart
	dc.w	$94,$d0			; DdfStop
	dc.w	$102,0			; BplCon1
	dc.w	$104,0			; BplCon2
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod

				; 5432109876543210
	dc.w	$100,%0001001000000000	; Bit 12 an!! 1 Bitplane Lowres

Bplpointers:
	dc.w	$e0,0,$e2,0		; erste	Bitplane

	dc.w	$180,$000		; Color0	; Hintergrund Schwarz
	dc.w	$182,$123		; Color1	; Farbe 1 des Bitplane, die
							; in diesem Fall leer ist,
							; und deswegen nicht erscheint

	dc.w	$1a2,$f00		; Color17, oder COLOR1 des Sprite0 - ROT
	dc.w	$1a4,$0f0		; Color18, oder COLOR2 des Sprite0 - GRN
	dc.w	$1a6,$ff0		; Color19, oder COLOR3 des Sprite0 - GELB

	dc.w	$ffff,$fffe		; Ende der Copperlist


; ************ Hier ist der Sprite: NATRLICH mu er in CHIP RAM sein! ********

MeinSprite:		; Lnge 13 Zeilen
	dc.b $50	; Vertikale Anfangsposition des Sprite (von $2c bis $f2)
	dc.b $90	; Horizontale Anfangsposition des Sprite (von $40 bis $d8)
	dc.b $5d	; $50+13=$5d	; Vertikale Endposition des Sprite
	dc.b $00
 dc.w	%0000000000000000,%0000110000110000 ; Binres Format fr ev. nderungen
 dc.w	%0000000000000000,%0000011001100000
 dc.w	%0000000000000000,%0000001001000000
 dc.w	%0000000110000000,%0011000110001100 ; BINR 00=COLOR 0 (DURCHSICHTIG)
 dc.w	%0000011111100000,%0110011111100110 ; BINR 10=COLOR 1 (ROT)
 dc.w	%0000011111100000,%1100100110010011 ; BINR 01=COLOR 2 (GRN)
 dc.w	%0000110110110000,%1111100110011111 ; BINR 11=COLOR 3 (GELB)
 dc.w	%0000011111100000,%0000011111100000
 dc.w	%0000011111100000,%0001111001111000
 dc.w	%0000001111000000,%0011101111011100
 dc.w	%0000000110000000,%0011000110001100
 dc.w	%0000000000000000,%1111000000001111
 dc.w	%0000000000000000,%1111000000001111
 dc.w	0,0		; 2 word auf NULL definieren das Ende des Sprite.


	SECTION LEERESPLANE,BSS_C	; Ein auf 0 gesetztes Bitplane, wir
							; mssen es verwenden, denn ohne Bitplane
							; ist es nicht mglich, die Sprites
							; zu aktivieren
Bitplane:
	ds.b	40*256			; Bitplane auf 0 Lowres

	end

In diesem Beispiel zeigen wir eine  andere  Methode,  um  die  Sprites  zu
bewegen,  ohne  Tabellen.  In  diesem  Listing  bewegt  sich  ein  Sprite
geradlinig mit konstanter Geschwindigkeit, sowohl in vertikaler  als  auch
in  horizontaler Richtung. Die Geschwindigkeit ist nichts anderes als eine
Zahl, die sich in einer Speicherzelle befindet, die jedesmal zur  Position
dazugezhlt  wird,  die der Sprite vorher hatte, und errechnet so die neue
Position. Wenn die Geschwindigkeit eine positive Zahl war, dann  wird  die
Position  des  Sprites  jedesmal  erhht, und somit nach rechts verschoben
(oder nach Unten, im Falle der Y-Achse).
Wenn der Sprite einen Rand berhrt, ist es notwendig,  seine  Richtung  zu
ndern. Um das zu tun reicht es aus, das Vorzeichen der Geschwindigkeit zu
invertieren,  und  sie  so  von  Positiv  in  Negativ  umzuschalten  oder
umgekehrt.  Darum  kmmert  sich  der  Befehl "NEG", der genau das tut: er
ndert das Vorzeichen einer Zahl, die sich in einem  Register  oder  einer
Speicherzelle befindet.

