
; Listing7h.s	4 SPRITE ZU 16 FARBEN IM ATTACHED-MODE WERDEN AM BILDSCHIRM
;				MITTELS TABELLEN BEWEGT (vorausberechnete X- und Y-Koordinaten)
;
;	** BEMERKUNG** Um das Programm zu sehen und um auszusteigen:
;	LINKE TASTE RECHTE TASTE, LINKE TASTE, RECHTE TASTE

	SECTION CipundCop,CODE

Anfang:
	move.l	4.w,a6			; Execbase
	jsr	-$78(a6)			; Disable
	lea	GfxName(pc),a1		; Libname
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop	; speichern die alte COP

;	Pointen auf das "leere" PIC

	move.l	#Bitplane,d0	; wohin pointen
	lea	Bplpointers,A1		; COP-Pointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)


;	Pointen auf die 8 Sprite, die im Attaced-Modus 4 zu 16 Farben ergeben.
;	Die Sprite 1,3,5,7, die ungeraden, mssen das Bit 7 des zweiten Word
;	auf 1 haben.


	move.l	#MeinSprite0,d0 ; Adresse des Sprite in d0
	lea	SpritePointers,a1	; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite1,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite2,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite3,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite4,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite5,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite6,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)
	move.l	#MeinSprite7,d0	; Adresse des Sprite in d0
	addq.w	#8,a1			; nchsten SPRITEPOINTERS
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

; Setzen das Attached-Bit

	bset	#7,MeinSprite1+3	; Setzt das Bit fr Attached beim
								; Sprite. Wird es nicht gesetzt,
								; entstehen nur zwei Sprites mit
								; drei Farben, die sich berlappen
	
	bset	#7,MeinSprite3+3
	bset	#7,MeinSprite5+3
	bset	#7,MeinSprite7+3

	move.l	#Copperlist,$dff080	; unsere COP
	move.w	d0,$dff088			; START COP
	move.w	#0,$dff1fc			; NO AGA!
	move.w	#$c00,$dff106		; NO AGA!

;	Schaffen eine Positionsdifferenz in den Pointern der Tabelle zwischen
;	den 4 Sprites um sie in verschiedenen Richtungen zu bewegen.

	move.l	#TabX+55,TabXpoint0
	move.l	#TabX+86,TabXpoint1
	move.l	#TabX+130,TabXpoint2
	move.l	#TabX+170,TabXpoint3
	move.l	#TabY-1,TabYpoint0
	move.l	#TabY+45,TabYpoint1
	move.l	#TabY+90,TabYpoint2
	move.l	#TabY+140,TabYpoint3


Mouse1:
	bsr.w	BewegeSprite		; Wartet ein Fotogramm, bewegt die Sprites
								; und kommt zurck

	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	mouse1

	move.l	#TabX+170,TabXpoint0
	move.l	#TabX+130,TabXpoint1
	move.l	#TabX+86,TabXpoint2
	move.l	#TabX+55,TabXpoint3
	move.l	#TabY-1,TabYpoint0
	move.l	#TabY+45,TabYpoint1
	move.l	#TabY+90,TabYpoint2
	move.l	#TabY+140,TabYpoint3

Mouse2:
	bsr.w	BewegeSprite		; Wartet ein Fotogramm, bewegt die Sprites
								; und kommt zurck

	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	mouse2

; SPRITE IM GNSEMARSCH

	move.l	#TabX+30,TabXpoint0
	move.l	#TabX+20,TabXpoint1
	move.l	#TabX+10,TabXpoint2
	move.l	#TabX-1,TabXpoint3
	move.l	#TabY+30,TabYpoint0
	move.l	#TabY+20,TabYpoint1
	move.l	#TabY+10,TabYpoint2
	move.l	#TabY-1,TabYpoint3

Mouse3:
	bsr.w	BewegeSprite		; Wartet ein Fotogramm, bewegt die Sprites
								; und kommt zurck

	btst	#6,$bfe001			; linke Maustaste gedrckt?
	bne.s	mouse3

; BESOFFENE SPRITES AM BILDSCHIRM

	move.l	#TabX+220,TabXpoint0
	move.l	#TabX+30,TabXpoint1
	move.l	#TabX+102,TabXpoint2
	move.l	#TabX+5,TabXpoint3
	move.l	#TabY-1,TabYpoint0
	move.l	#TabY+180,TabYpoint1
	move.l	#TabY+20,TabYpoint2
	move.l	#TabY+100,TabYpoint3


Mouse4:
	bsr.w	BewegeSprite		; Wartet ein Fotogramm, bewegt die Sprites
								; und kommt zurck

	btst	#2,$dff016			; rechte Maustaste gedrckt?
	bne.s	mouse4

	move.l	OldCop(pc),$dff080	; Pointen auf die SystemCOP
	move.w	d0,$dff088			; Starten die alte COP


	move.l	4.w,a6
	jsr	-$7e(a6)				; Enable
	move.l	gfxbase(pc),a1
	jsr	-$19e(a6)				; Closelibrary
	rts

;	Daten

GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0


; Diese Routine startet die einzelnen Bewegungsroutinen der Sprites
; und beinhaltet auch den Warte-Loop des Fotogrammes fr das Timing.

BewegeSprite:
	cmpi.b	#$ff,$dff006		; Zeile 255?
	bne.s	BewegeSprite

	bsr.s	BewegeSprite0		; bewege den Sprite 0 horizontal
	bsr.w	BewegeSprite1		; bewege den Sprite 1 horizontal
	bsr.w	BewegeSprite2		; bewege den Sprite 2 horizontal
	bsr.w	BewegeSprite3		; bewege den Sprite 3 horizontal
	bsr.w	BewegeSpriteY0		; bewege den Sprite 0 vertikal
	bsr.w	BewegeSpriteY1		; bewege den Sprite 1 vertikal
	bsr.w	BewegeSpriteY2		; bewege den Sprite 2 vertikal
	bsr.w	BewegeSpriteY3		; bewege den Sprite 3 vertikal

Warte:
	cmpi.b	#$ff,$dff006		; Zeile 255?
	beq.s	Warte

	rts							; Zurck zum MOUSE - LOOP


; ********************* ROUTINEN ZUR HORIZONTALEN BEWEGUNG ******************

; Diese Routine bewegt den Sprite indem die auf das Byte Hstart, also dem
; Byte seiner X-Position, zugreift. Es werden die Werte einer vorausberechneten
; Tabelle (TabX) eingesetzt.

; Fr den Sprite0 ATTACCHED: (also Sprite0+Sprite1)

BewegeSprite0:
	addq.l	#1,TabXpoint0		; Pointe auf das nchste Byte
	move.l	TabXpoint0(pc),a0	; Adresse, die im Long TabXpoint enthalten
								; ist wird in a0 kopiert
	cmp.l	#EndeTabX-1,a0		; Sind wir beim letzten Long der TAB?
	bne.s	NobStartX0			; noch nicht? dann mach weiter
	move.l	#TabX-1,TabXpoint0	; Starte wieder beim ersten Long
NobStartX0:
	move.b	(a0),MeinSprite0+1 ; Kopie das Byte aus der Tabelle in Hstart0
	move.b	(a0),MeinSprite1+1 ; Kopie das Byte aus der Tabelle in Hstart1
	rts

TabXpoint0:
	dc.l	TabX+55				; ACHTUNG: Die Werte der Tabelle sind Bytes


; Fr den Sprite1 ATTACCHED: (also Sprite2+Sprite3)

BewegeSprite1:
	addq.l	#1,TabXpoint1		; Pointe auf das nchste Byte
	move.l	TabXpoint1(pc),a0	; Adresse, die im Long TabXpoint enthalten
								; ist wird in a0 kopiert
	cmp.l	#EndeTabX-1,a0		; Sind wir beim letzten Long der TAB?
	bne.s	NobStartX1			; noch nicht? dann mach weiter
	move.l	#TabX-1,TabXpoint1	; Starte wieder beim ersten Long
NobStartX1:
	move.b	(a0),MeinSprite2+1	; Kopie das Byte aus der Tabelle in Hstart0
	move.b	(a0),MeinSprite3+1	; Kopie das Byte aus der Tabelle in Hstart1
	rts

TabXpoint1:
	dc.l	TabX+86				; ACHTUNG: Die Werte der Tabelle sind Bytes
	

; Fr den Sprite2 ATTACCHED: (also Sprite4+Sprite5)

BewegeSprite2:
	addq.l	#1,TabXpoint2		; Pointe auf das nchste Byte
	move.l	TabXpoint2(pc),a0	; Adresse, die im Long TabXpoint enthalten
								; ist wird in a0 kopiert
	cmp.l	#EndeTabX-1,a0		; Sind wir beim letzten Long der TAB?
	bne.s	NobStartX2			; noch nicht? dann mach weiter
	move.l	#TabX-1,TabXpoint2  ; Starte wieder beim ersten Long
NobStartX2:
	move.b	(a0),MeinSprite4+1  ; Kopie das Byte aus der Tabelle in Hstart0
	move.b	(a0),MeinSprite5+1  ; Kopie das Byte aus der Tabelle in Hstart1
	rts

TabXpoint2:
	dc.l	TabX+130			; ACHTUNG: Die Werte der Tabelle sind Bytes


; Fr den Sprite3 ATTACCHED: (also Sprite6+Sprite7)

BewegeSprite3:
	addq.l	#1,TabXpoint3	    ; Pointe auf das nchste Byte
	move.l	TabXpoint3(pc),a0   ; Adresse, die im Long TabXpoint enthalten
							    ; ist wird in a0 kopiert
	cmp.l	#EndeTabX-1,a0	    ; Sind wir beim letzten Long der TAB?
	bne.s	NobStartX3		    ; noch nicht? dann mach weiter
	move.l	#TabX-1,TabXpoint3  ; Starte wieder beim ersten Long
NobStartX3:
	move.b	(a0),MeinSprite6+1  ; Kopie das Byte aus der Tabelle in Hstart0
	move.b	(a0),MeinSprite7+1  ; Kopie das Byte aus der Tabelle in Hstart1
	rts

TabXpoint3:
	dc.l	TabX+170			; ACHTUNG: Die Werte der Tabelle sind Bytes

; ********************* ROUTINES ZUR VERTIKALEN BEWEGUNG *******************

; Diese Routine bewegt den Sprite nach Oben und nach Unten, indem sie auf
; die Bytes Vstart und Vstop zugreift, also den Anfangs- und Endkoordinaten
; des Sprites. Es werden schon vordefinierte Koordinaten aus TabY eingesetzt.

BewegeSpriteY0:
	addq.l	#1,TabYpoint0		; Pointe auf das nchste Byte
	move.l	TabYpoint0(pc),a0	; Adresse, die im Long TabXpoint enthalten
								; ist wird in a0 kopiert
	cmp.l	#EndeTabY-1,a0		; Sind wir beim letzten Long der TAB?
	bne.s	NobStartY0			; noch nicht? dann mach weiter
	move.l	#TabY-1,TabYpoint0  ; Starte wieder beim ersten Long
NobStartY0:
	moveq	#0,d0				; Lsche d0
	move.b	(a0),d0				; kopiere das Byte aus der Tabelle in d0
	move.b	d0,MeinSprite0		; kopiere das Byte in Vstart0
	move.b	d0,MeinSprite1		; kopiere das Byte in Vstart1
	add.b	#15,d0				; Addiere die Lnge des Sprites
								; um die Endposition zu ermitteln (Vstop)
	move.b	d0,MeinSprite0+2	; setze den richtigen Wert in Vstop0
	move.b	d0,MeinSprite1+2	; setze den richtigen Wert in Vstop1
	rts

TabYpoint0:
	dc.l	TabY-1				; ACHTUNG: Die Werte der Tabelle sind Bytes

	
; Fr den Sprite1 ATTACCHED: (also Sprite2+Sprite3)

BewegeSpriteY1:
	addq.l	#1,TabYpoint1	    ; Pointe auf das nchste Byte
	move.l	TabYpoint1(pc),a0	; Adresse, die im Long TabXpoint enthalten
								; ist wird in a0 kopiert
	cmp.l	#EndeTabY-1,a0	    ; Sind wir beim letzten Long der TAB?
	bne.s	NobStartY1			; noch nicht? dann mach weiter
	move.l	#TabY-1,TabYpoint1  ; Starte wieder beim ersten Long
NobStartY1:
	moveq	#0,d0				; Lsche d0
	move.b	(a0),d0				; kopiere das Byte aus der Tabelle in d0
	move.b	d0,MeinSprite2		; kopiere das Byte in Vstart2
	move.b	d0,MeinSprite3		; kopiere das Byte in Vstart3
	add.b	#15,d0				; Addiere die Lnge des Sprites
								; um die Endposition zu ermitteln (Vstop)
	move.b	d0,MeinSprite2+2    ; setze den richtigen Wert in Vstop2
	move.b	d0,MeinSprite3+2    ; setze den richtigen Wert in Vstop3
	rts

TabYpoint1:
	dc.l	TabY+45				; ACHTUNG: Die Werte der Tabelle sind Bytes


; Fr den Sprite2 ATTACCHED: (also Sprite4+Sprite5)

BewegeSpriteY2:
	addq.l	#1,TabYpoint2	    ; Pointe auf das nchste Byte
	move.l	TabYpoint2(pc),a0   ; Adresse, die im Long TabXpoint enthalten
							    ; ist wird in a0 kopiert
	cmp.l	#EndeTabY-1,a0	    ; Sind wir beim letzten Long der TAB?
	bne.s	NobStartY2		    ; noch nicht? dann mach weiter
	move.l	#TabY-1,TabYpoint2  ; Starte wieder beim ersten Long
NobStartY2:
	moveq	#0,d0				; Lsche d0
	move.b	(a0),d0				; kopiere das Byte aus der Tabelle in d0
	move.b	d0,MeinSprite4		; kopiere das Byte in Vstart4
	move.b	d0,MeinSprite5		; kopiere das Byte in Vstart5
	add.b	#15,d0				; Addiere die Lnge des Sprites
								; um die Endposition zu ermitteln (Vstop)
	move.b	d0,MeinSprite4+2	; setze den richtigen Wert in Vstop4
	move.b	d0,MeinSprite5+2	; setze den richtigen Wert in Vstop5
	rts
	
TabYpoint2:
	dc.l	TabY+90				; ACHTUNG: Die Werte der Tabelle sind Bytes
	

; Fr den Sprite3 ATTACCHED: (also Sprite6+Sprite7)

BewegeSpriteY3:
	addq.l	#1,TabYpoint3		; Pointe auf das nchste Byte
	move.l	TabYpoint3(pc),a0	; Adresse, die im Long TabXpoint enthalten
								; ist wird in a0 kopiert
	cmp.l	#EndeTabY-1,a0	    ; Sind wir beim letzten Long der TAB?
	bne.s	NobStartY3			; noch nicht? dann mach weiter
	move.l	#TabY-1,TabYpoint3  ; Starte wieder beim ersten Long
NobStartY3:
	moveq	#0,d0				; Lsche d0
	move.b	(a0),d0				; kopiere das Byte aus der Tabelle in d0
	move.b	d0,MeinSprite6		; kopiere das Byte in Vstart6
	move.b	d0,MeinSprite7		; kopiere das Byte in Vstart1
	add.b	#15,d0				; Addiere die Lnge des Sprites
								; um die Endposition zu ermitteln (Vstop)
	move.b	d0,MeinSprite6+2	; setze den richtigen Wert in Vstop6
	move.b	d0,MeinSprite7+2	; setze den richtigen Wert in Vstop7
	rts

TabYpoint3:
	dc.l	TabY+140			; ACHTUNG: Die Werte der Tabelle sind Bytes



; Tabelle mit vorausberechneten X-Werten.

TabX:
	incbin	"/Sources/XCOORDINAT.TAB"	; 334 Werte
EndeTabX:

; Tabelle mit vorausberechneten Y-Werten.

TabY:
	incbin	"/Sources/YCOORDINAT.TAB"	; 200 Werte
EndeTabY:


	SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; SPRITE
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

	dc.w	$8e,$2c81		; DiwStrt
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$38			; DdfStart
	dc.w	$94,$d0			; DdfStop
	dc.w	$102,0			; BplCon1
	dc.w	$104,0			; BplCon2
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod

			    ; 5432109876543210
	dc.w	$100,%0001001000000000	; Bit 12 an, 1 Bitplane Lowres

Bplpointers:
	dc.w	$e0,0,$e2,0		; erste Bitplane

;	Palette der PIC

	dc.w	$180,$000		; color0	; schwarzer Hintergrund
	dc.w	$182,$123		; color1	; Color1 des Bitplane, das in
							; diesem Fall leer ist, und
							; deshalb nicht erscheint

;	Palette der Attached-SPRITES

	dc.w	$1a2,$ffc		; color17, Farbe 1 fr die Attached-Sprites
	dc.w	$1a4,$eeb		; color18, Farbe 2 fr die Attached-Sprites
	dc.w	$1a6,$cd9		; color19, Farbe 3 fr die Attached-Sprites
	dc.w	$1a8,$ac8		; color20, Farbe 4 fr die Attached-Sprites
	dc.w	$1aa,$8b6		; color21, Farbe 5 fr die Attached-Sprites
	dc.w	$1ac,$6a5		; color22, Farbe 6 fr die Attached-Sprites
	dc.w	$1ae,$494		; color23, Farbe 7 fr die Attached-Sprites
	dc.w	$1b0,$384		; color24, Farbe 7 fr die Attached-Sprites
	dc.w	$1b2,$274		; color25, Farbe 9 fr die Attached-Sprites
	dc.w	$1b4,$164		; color26, Farbe 10 fr die Attached-Sprites
	dc.w	$1b6,$154		; color27, Farbe 11 fr die Attached-Sprites
	dc.w	$1b8,$044		; color28, Farbe 12 fr die Attached-Sprites
	dc.w	$1ba,$033		; color29, Farbe 13 fr die Attached-Sprites
	dc.w	$1bc,$012		; color30, Farbe 14 fr die Attached-Sprites
	dc.w	$1be,$001		; color31, Farbe 15 fr die Attached-Sprites

	dc.w	$ffff,$fffe		; Ende der Copperlist

; ************ Hier die Sprites: KLARERWEISE in CHIP RAM! **********

MeinSprite0:				; Lnge 15 Zeilen
	incbin	"/Sources/Sprite16Col.PARI"

MeinSprite1:				; Lnge 15 Zeilen
	incbin	"/Sources/Sprite16Col.DISPARI"

MeinSprite2:				; Lnge 15 Zeilen
	incbin	"/Sources/Sprite16Col.PARI"

MeinSprite3:				; Lnge 15 Zeilen
	incbin	"/Sources/Sprite16Col.DISPARI"

MeinSprite4:				; Lnge 15 Zeilen
	incbin	"/Sources/Sprite16Col.PARI"

MeinSprite5:				; Lnge 15 Zeilen
	incbin	"/Sources/Sprite16Col.DISPARI"

MeinSprite6:				; Lnge 15 Zeilen
	incbin	"/Sources/Sprite16Col.PARI"

MeinSprite7:				; Lnge 15 Zeilen
	incbin	"/Sources/Sprite16Col.DISPARI"

		SECTION LEERESPLANE,BSS_C ; Ein auf 0 gesetztes Bitplane, wir
							; mssen es verwenden, denn ohne Bitplane
							; ist es nicht mglich, die Sprites
							; zu aktivieren
Bitplane:
	ds.b	40*256			; Bitplane auf 0 Lowres

	end

In diesem Listing werden alle 4 Attached-Sprites mit 16 Farben angezeigt.
Die Sprites wurden, einschlielich der Kontrollword, als File abgespeichert,
verwendet wurde dazu der Befehl "WB". Das um im Listing Platz zu sparen
und um die Sprites andere Male wiederverwenden zu knnen. Auch im Listing
selbst wurde der Sprite fters wiederverwendet,er ist in Sprite16Col.GERADE
und Sprite16Col.UNGERADE aufgeteilt. Alle vier Sprites wurden damit erzeugt.
Was die Bewegung der Sprites angeht, so hat ein jeder Sprite seine
eigene Routine mit eigenen Tabellenpointern auf X- und Y- Richtung.
Wenn man nun die Bewegungen "auer Fase", also in verschiedenen Punkten
der Tabelle, beginnen lt, entstehen scheinbar separate Bahnen. Die
Tabelle fr X- und Y- Richtung sind aber immer die gleichen fr alle
Routinen. Ein Sprite startet z.B. bei Position x,y, ein anderer bei Position
x+n,y+,, und plaziert ihn somit weiter vorne als den anderen. Das ist der
Fall beim "Gnsemarsch". Oder es entstehen scheinbar zufllige Bahnen.
Eine Besonderheit dieses Listings gebhrt aber noch etwas Aufmerksamkeit:
da fters auf den Druck des linken und des rechten Mausknopfes gewartet
werden mu, um die Bewegung der Sprites zu verndern, bevor man aussteigt,
wre es notwendig gewesen, jedesmal die zwei Loops, die die Zeile $FF
abwarten, neuzuschreiben. Auch alle 8 "BSR BEWEGESPRITE":

; Warte Zeile $FF
; bsr BEWEGESPRITE
; Warte auf linken Mausknopf

; ndere die Bahn des Sprite

; Warte Zeile $FF
; bsr BEWEGESPRITE
; Warte auf rechten Mausknopf

; ndere die Bahn des Sprite

; Warte Zeile $FF
; bsr BEWEGESPRITE
; Warte auf linken Mausknopf

; ndere die Bahn des Sprite

; Warte Zeile $FF
; bsr BEWEGESPRITE
; Warte auf rechten Mausknopf

Um Listingzeilen zu sparen ist eine Lsung die, die Warte-Schleife in die
Subroutine BSR BEWEGESPRITE einzubauen:

; Diese Routine startet die einzelnen Bewegungsroutinen der Sprites
; und beinhaltet auch den Warte-Loop des Fotogrammes fr das Timing.

BewegeSprite:
	cmpi.b	#$ff,$dff006	; Zeile 255?
	bne.s	BewegeSprite

	bsr.s	BewegeSprite0	; bewege den Sprite 0 horizontal
	bsr.w	BewegeSprite1	; bewege den Sprite 1 horizontal
	bsr.w	BewegeSprite2	; bewege den Sprite 2 horizontal
	bsr.w	BewegeSprite3	; bewege den Sprite 3 horizontal
	bsr.w	BewegeSpriteY0	; bewege den Sprite 0 vertikal
	bsr.w	BewegeSpriteY1	; bewege den Sprite 1 vertikal
	bsr.w	BewegeSpriteY2	; bewege den Sprite 2 vertikal
	bsr.w	BewegeSpriteY3	; bewege den Sprite 3 vertikal

Warte:
	cmpi.b	#$ff,$dff006	; Zeile 255?
	beq.s	Warte

	rts						; zurck zum MOUSE - Loop

Somit mu nur gewartet werden, bis die Maustaste gedrckt wird, ansonsten
wird die Routine BewegeSprite ausgefhrt:


Mouse1:
	bsr.w	BewegeSprite	; Wartet ein Fotogramm, bewegt die Sprite
							; und kommt zurck

	btst	#6,$bfe001		; linke Maustaste gedrckt?
	bne.s	mouse1

	move.l	#TabX+170,TabXpoint0	; ndere die Bahn des Sprite
	...

Mouse2:
	bsr.w	BewegeSprite	; Wartet ein Fotogramm, bewegt die Sprite
							; und kommt zurck

	btst	#2,$dff016		; rechte Maustaste gedrckt?
	bne.s	mouse2

