
; Listing7c.s	EIN SPRITE WIRD HORIZONTAL BEWEGT, INDEM AUF EINE TABELLE
;				MIT VORDEFINIERTEN WERTEN ZUGEGRIFFEN WIRD.

	SECTION CipundCop,CODE

Anfang:
	move.l	4.w,a6			; Execbase
	jsr	-$78(a6)			; Disable
	lea	GfxName(pc),a1		; Libname
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop	; speichern die alte COP

;	Pointen auf das "leere" PIC

	move.l	#Bitplane,d0	; wohin pointen
	lea	Bplpointers,A1		; COP-Pointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

;	Pointen auf den Sprite

	move.l	#MeinSprite,d0	; Adresse des Sprite in d0
	lea	SpritePointers,a1	; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	move.l	#Copperlist,$dff080	; unsere COP
	move.w	d0,$dff088		; START COP
	move.w	#0,$dff1fc		; NO AGA!
	move.w	#$c00,$dff106	; NO AGA!

Mouse:
	cmpi.b	#$ff,$dff006	; Zeile 255?
	bne.s	Mouse

	bsr.s	BewegeSprite	; Bewege Sprite 0 nach rechts

Warte:
	cmpi.b	#$ff,$dff006	; Zeile 255?
	beq.s	Warte

	btst	#6,$bfe001		; linke Maustaste gedrckt?
	bne.s	Mouse


	move.l	OldCop(pc),$dff080	; Pointen auf die alte SystemCOP
	move.w	d0,$dff088		; Starten die alte SystemCOP

	move.l	4.w,a6
	jsr	-$7e(a6)			; Enable
	move.l	gfxbase(pc),a1
	jsr	-$19e(a6)			; Closelibrary
	rts

;	Daten

GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0

; Diese Routine bewegt den Sprite indem die auf das Byte Hstart, also
; dem Byte seiner X-Position, zugreift. Es werden die Werte einer
; vorausberechneten Tabelle (TabX) eingesetzt.
; Wenn wir nur auf Hstart agieren, dann bewegen wir den Sprite um jeweils 2
; Pixel, und nicht nur einem, deswegen ist der Scroll etwas "ruckelig", vor
; allem wenn er langsamer wird. In den nchsten Listings werden wir dieses
; Manko beheben und mit einem Pixel scrollen.

BewegeSprite:
	addq.l	#1,TabXpoint	 ; Pointe auf das nchste Byte
	move.l	TabXpoint(pc),a0 ; Adresse, die im Long TabXpoint enthalten ist
							 ; wird in a0 kopiert
	cmp.l	#EndeTabX-1,a0	 ; Sind wir beim letzten Long der TAB?
	bne.s	NobStart		 ; noch nicht? dann mach weiter
	move.l	#TabX-1,TabXpoint ; Starte wieder beim ersten Long
NobStart:
	move.b	(a0),Hstart		; Kopiert das Byte aus der Tabelle nach Hstart
	rts

TabXpoint:
	dc.l	TabX-1			; BEMERKUNG: Die Werte in der Tabelle sind Bytes,
							; deswegen arbeiten wir mit einem addq.l #1,TabXpoint
							; und nicht mit #2 wie es bei Word der Fall wre oder
							; mit #4, Longword.

; Tabelle mit vordefinierten X-Koordinaten.
; Zu Bemerken, da die X-Werte innerhalb der Grenzen $40 und $d8 sein mssen,
; in der Tabelle kommen deswegen keine Werte vor, die kleiner als $40 oder
; grer als $d8 sind.


TabX:
	dc.b	$cf,$cd,$ca,$c8,$c6,$c4,$c1,$bf,$bd,$bb,$b8,$b6 ; 200 Werte
	dc.b	$b4,$b2,$af,$ad,$ab,$a9,$a7,$a5,$a2,$a0,$9e,$9c
	dc.b	$9a,$98,$96,$94,$92,$90,$8e,$8c,$8a,$88,$86,$84
	dc.b	$82,$80,$7e,$7c,$7a,$79,$77,$75,$73,$72,$70,$6e
	dc.b	$6d,$6b,$69,$68,$66,$65,$63,$62,$60,$5f,$5e,$5c
	dc.b	$5b,$5a,$58,$57,$56,$55,$53,$52,$51,$50,$4f,$4e
	dc.b	$4d,$4c,$4b,$4b,$4a,$49,$48,$47,$47,$46,$45,$45
	dc.b	$44,$44,$43,$43,$42,$42,$42,$41,$41,$41,$41,$40
	dc.b	$40,$40,$40,$40,$40,$40,$40,$40,$40,$41,$41,$41
	dc.b	$41,$42,$42,$42,$43,$43,$44,$44,$45,$45,$46,$47
	dc.b	$47,$48,$49,$4a,$4b,$4b,$4c,$4d,$4e,$4f,$50,$51
	dc.b	$52,$53,$55,$56,$57,$58,$5a,$5b,$5c,$5e,$5f,$60
	dc.b	$62,$63,$65,$66,$68,$69,$6b,$6d,$6e,$70,$72,$73
	dc.b	$75,$77,$79,$7a,$7c,$7e,$80,$82,$84,$86,$88,$8a
	dc.b	$8c,$8e,$90,$92,$94,$96,$98,$9a,$9c,$9e,$a0,$a2
	dc.b	$a5,$a7,$a9,$ab,$ad,$af,$b2,$b4,$b6,$b8,$bb,$bd
	dc.b	$bf,$c1,$c4,$c6,$c8,$ca,$cd,$cf
EndeTabX:


	SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; SPRITE
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

	dc.w	$8e,$2c81		; DiwStrt
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$38			; DdfStart
	dc.w	$94,$d0			; DdfStop
	dc.w	$102,0			; BplCon1
	dc.w	$104,0			; BplCon2
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod

				; 5432109876543210
	dc.w	$100,%0001001000000000  ; Bit 12 an!! 1 Bitplane Lowres

Bplpointers:
	dc.w	$e0,0,$e2,0		; erste Bitplane

	dc.w	$180,$000		; color0	; Hintergrund Schwarz
	dc.w	$182,$123		; color1	; Farbe 1 des Bitplane, die
							; in diesem Fall leer ist,
							; und deswegen nicht erscheint

	dc.w	$1a2,$f00		; Color17, oder COLOR1 des Sprite0 - ROT
	dc.w	$1a4,$0f0		; Color18, oder COLOR2 des Sprite0 - GRN
	dc.w	$1a6,$ff0		; Color19, oder COLOR3 des Sprite0 - GELB

	dc.w	$ffff,$fffe		; Ende der Copperlist


; ************ Hier ist der Sprite: NATRLICH mu er in CHIP RAM sein! *******

MeinSprite:		; Lnge 13 Zeilen
Vstart:
	dc.b $50	; Vertikale Anfangsposition des Sprite (von $2c bis $f2)
Hstart:
	dc.b $90	; Horizontale Anfangsposition des Sprite (von $40 bis $d8)
Vstop:
	dc.b $5d	; $50+13=$5d - Vertikale Endposition des Sprite
	dc.b $00
 dc.w	%0000000000000000,%0000110000110000 ; Binres Format fr ev. nderungen
 dc.w	%0000000000000000,%0000011001100000
 dc.w	%0000000000000000,%0000001001000000
 dc.w	%0000000110000000,%0011000110001100 ; BINR 00=COLOR 0 (DURCHSICHTIG)
 dc.w	%0000011111100000,%0110011111100110 ; BINR 10=COLOR 1 (ROT)
 dc.w	%0000011111100000,%1100100110010011 ; BINR 01=COLOR 2 (GRN)
 dc.w	%0000110110110000,%1111100110011111 ; BINR 11=COLOR 3 (GELB)
 dc.w	%0000011111100000,%0000011111100000
 dc.w	%0000011111100000,%0001111001111000
 dc.w	%0000001111000000,%0011101111011100
 dc.w	%0000000110000000,%0011000110001100
 dc.w	%0000000000000000,%1111000000001111
 dc.w	%0000000000000000,%1111000000001111
 dc.w	0,0		; 2 word auf NULL definieren das Ende des Sprite.


	SECTION LEERESPLANE,BSS_C ; Eine auf 0 gesetzte Bitplane, wir
							; mssen es verwenden, denn ohne Bitplane
							; ist es nicht mglich, die Sprites
							; zu aktivieren
Bitplane:
	ds.b	40*256			; Bitplane auf 0 Lowres

	end

Die komplexen und realistischen Bewegungen werden mit Tabellen gemacht!
Versucht die Tabelle mit der folgenden zu ersetzen, und ihr werdet den Abprall
des Sprite verndern(Amiga+b+c+i zum Kopieren),(Amiga+b+x um ein Stck zu
Lschen)

TabX:
	dc.b	$cf,$cd,$ca,$c8,$c6,$c4,$c1,$bf,$bd,$bb,$b8,$b6 ; 200 Werte
	dc.b	$b4,$b2,$af,$ad,$ab,$a9,$a7,$a5,$a2,$a0,$9e,$9c
	dc.b	$9a,$98,$96,$94,$92,$90,$8e,$8c,$8a,$88,$86,$84
	dc.b	$82,$80,$7e,$7c,$7a,$79,$77,$75,$73,$72,$70,$6e
	dc.b	$6d,$6b,$69,$68,$66,$65,$63,$62,$60,$5f,$5e,$5c
	dc.b	$5b,$5a,$58,$57,$56,$55,$53,$52,$51,$50,$4f,$4e
	dc.b	$4d,$4c,$4b,$4b,$4a,$49,$48,$47,$47,$46,$45,$45
	dc.b	$44,$44,$43,$43,$42,$42,$42,$41,$41,$41,$41,$40
	dc.b	$40,$40,$40,$40,$40,$40,$40,$40,$40,$41,$41,$41
	dc.b	$41,$42,$42,$42,$43,$43,$44,$44,$45,$45,$46,$47
	dc.b	$47,$48,$49,$4a,$4b,$4b,$4c,$4d,$4e,$4f,$50,$51
	dc.b	$52,$53,$55,$56,$57,$58,$5a,$5b,$5c,$5e,$5f,$60
	dc.b	$62,$63,$65,$66,$68,$69,$6b,$6d,$6e,$70,$72,$73
	dc.b	$75,$77,$79,$7a,$7c,$7e,$80,$82,$84,$86,$88,$8a
	dc.b	$8c,$8e,$90,$92,$94,$96,$98,$9a,$9c,$9e,$a0,$a2
	dc.b	$a5,$a7,$a9,$ab,$ad,$af,$b2,$b4,$b6,$b8,$bb,$bd
	dc.b	$bf,$c1,$c4,$c6,$c8,$ca,$cd,$cf
EndeTabX:


Nun ersetzt sie mit dieser, sie lt den Sprite in beide Richtungen schwingen.

TabX:
	dc.b	$91,$93,$96,$98,$9a,$9c,$9f,$a1,$a3,$a5,$a7,$a9 ; 200 Werte
	dc.b	$ac,$ae,$b0,$b2,$b4,$b6,$b8,$b9,$bb,$bd,$bf,$c0
	dc.b	$c2,$c4,$c5,$c7,$c8,$ca,$cb,$cc,$cd,$cf,$d0,$d1
	dc.b	$d2,$d3,$d3,$d4,$d5,$d5,$d6,$d7,$d7,$d7,$d8,$d8
	dc.b	$d8,$d8,$d8,$d8,$d8,$d8,$d7,$d7,$d7,$d6,$d5,$d5
	dc.b	$d4,$d3,$d3,$d2,$d1,$d0,$cf,$cd,$cc,$cb,$ca,$c8
	dc.b	$c7,$c5,$c4,$c2,$c0,$bf,$bd,$bb,$b9,$b8,$b6,$b4
	dc.b	$b2,$b0,$ae,$ac,$a9,$a7,$a5,$a3,$a1,$9f,$9c,$9a
	dc.b	$98,$96,$93,$91,$8f,$8d,$8a,$88,$86,$84,$81,$7f
	dc.b	$7d,$7b,$79,$77,$74,$72,$70,$6e,$6c,$6a,$68,$67
	dc.b	$65,$63,$61,$60,$5e,$5c,$5b,$59,$58,$56,$55,$54
	dc.b	$53,$51,$50,$4f,$4e,$4d,$4d,$4c,$4b,$4b,$4a,$49
	dc.b	$49,$49,$48,$48,$48,$48,$48,$48,$48,$48,$49,$49
	dc.b	$49,$4a,$4b,$4b,$4c,$4d,$4d,$4e,$4f,$50,$51,$53
	dc.b	$54,$55,$56,$58,$59,$5b,$5c,$5e,$60,$61,$63,$65
	dc.b	$67,$68,$6a,$6c,$6e,$70,$72,$74,$77,$79,$7b,$7d
	dc.b	$7f,$81,$84,$86,$88,$8a,$8d,$8f
EndeTabX:


TabX:
	dc.b	$41,$43,$46,$48,$4a,$4c,$4f,$51,$53,$55,$58,$5a ; 200 Werte
	dc.b	$5c,$5e,$61,$63,$65,$67,$69,$6b,$6e,$70,$72,$74
	dc.b	$76,$78,$7a,$7c,$7e,$80,$82,$84,$86,$88,$8a,$8c
	dc.b	$8e,$90,$92,$94,$96,$97,$99,$9b,$9d,$9e,$a0,$a2
	dc.b	$a3,$a5,$a7,$a8,$aa,$ab,$ad,$ae,$b0,$b1,$b2,$b4
	dc.b	$b5,$b6,$b8,$b9,$ba,$bb,$bd,$be,$bf,$c0,$c1,$c2
	dc.b	$c3,$c4,$c5,$c5,$c6,$c7,$c8,$c9,$c9,$ca,$cb,$cb
	dc.b	$cc,$cc,$cd,$cd,$ce,$ce,$ce,$cf,$cf,$cf,$cf,$d0
	dc.b	$d0,$d0,$d0,$d0,$d0,$d0,$d0,$d0,$d0,$cf,$cf,$cf
	dc.b	$cf,$ce,$ce,$ce,$cd,$cd,$cc,$cc,$cb,$cb,$ca,$c9
	dc.b	$c9,$c8,$c7,$c6,$c5,$c5,$c4,$c3,$c2,$c1,$c0,$bf
	dc.b	$be,$bd,$bb,$ba,$b9,$b8,$b6,$b5,$b4,$b2,$b1,$b0
	dc.b	$ae,$ad,$ab,$aa,$a8,$a7,$a5,$a3,$a2,$a0,$9e,$9d
	dc.b	$9b,$99,$97,$96,$94,$92,$90,$8e,$8c,$8a,$88,$86
	dc.b	$84,$82,$80,$7e,$7c,$7a,$78,$76,$74,$72,$70,$6e
	dc.b	$6b,$69,$67,$65,$63,$61,$5e,$5c,$5a,$58,$55,$53
	dc.b	$51,$4f,$4c,$4a,$48,$46,$43,$41
EndeTabX: