
; Listing7b.s	ANZEIGEN EINES SPRITES - RECHTE MAUSTASTE UM IHN ZU BEWEGEN

	SECTION CiriCop,CODE

Anfang:
	move.l	4.w,a6			; Execbase
	jsr	-$78(a6)			; Disable
	lea	GfxName(pc),a1		; Libname
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop	; speichern die alte COP

;	Pointen auf das "leere" PIC

	move.l	#Bitplane,d0	; wohin pointen
	lea	Bplpointers,A1		; COP-Pointer
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

;	Pointen auf den Sprite

	move.l	#MeinSprite,d0	; Adresse des Sprite in d0
	lea	SpritePointers,a1	; Pointer in der Copperlist
	move.w	d0,6(a1)
	swap	d0
	move.w	d0,2(a1)

	move.l	#Copperlist,$dff080	; unsere COP
	move.w	d0,$dff088		; START COP
	move.w	#0,$dff1fc		; NO AGA!
	move.w	#$c00,$dff106

Mouse:
	cmpi.b	#$ff,$dff006	; Zeile 255?
	bne.s	Mouse

	btst	#2,$dff016		; rechte Maustaste gedrckt?
	bne.s	Warte

	bsr.s	BewegeSprite	; Bewege Sprite 0 nach rechts

Warte:
	cmpi.b	#$ff,$dff006	; Zeile 255?
	beq.s	Warte

	btst	#6,$bfe001		; linke Maustaste gedrckt?
	bne.s	Mouse


	move.l	OldCop(pc),$dff080	; Pointen auf die SystemCOP
	move.w	d0,$dff088		; Starten die alte SystemCOP

	move.l	4.w,a6
	jsr	-$7e(a6)			; Enable
	move.l	gfxbase(pc),a1
	jsr	-$19e(a6)			; Closelibrary
	rts

;	Daten

GfxName:
	dc.b	"graphics.library",0,0

GfxBase:
	dc.l	0

OldCop:
	dc.l	0

; Diese Routine bewegt den Sprite nach rechts, indem es auf das Byte Hstart
; also seiner X-Position, zugreift. Zu Bemerken, da es jeweils um 2 Pixel
; bewegt wird.

BewegeSprite:
	addq.b	#1,Hstart		; (wie addq.b #1,MeinSprite+1)
	addq.b	#1,Vstart		; \ Bewegt den Sprite nach unten
	addq.b	#1,Vstop		; / (sowohl auf Vstart wie auch auf Vstop!)
	rts


	SECTION GRAPHIC,DATA_C

Copperlist:
SpritePointers:
	dc.w	$120,0,$122,0,$124,0,$126,0,$128,0 ; SPRITE
	dc.w	$12a,0,$12c,0,$12e,0,$130,0,$132,0
	dc.w	$134,0,$136,0,$138,0,$13a,0,$13c,0
	dc.w	$13e,0

	dc.w	$8e,$2c81		; DiwStrt
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$38			; DdfStart
	dc.w	$94,$d0			; DdfStop
	dc.w	$102,0			; BplCon1
	dc.w	$104,0			; BplCon2
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod

				; 5432109876543210
	dc.w	$100,%0001001000000000  ; Bit 12 an!! 1 Bitplane Lowres

Bplpointers:
	dc.w	$e0,0,$e2,0		; erstes  Bitplane

	dc.w	$180,$000		; color0	; Hintergrund Schwarz
	dc.w	$182,$123		; color1	; Farbe 1 des Bitplane, die
							; in diesem Fall leer ist,
							; und deswegen nicht erscheint

	dc.w	$1a2,$f00		; Color17, oder COLOR1 des Sprite0 - ROT
	dc.w	$1a4,$0f0		; Color18, oder COLOR2 des Sprite0 - GRN
	dc.w	$1a6,$ff0		; Color19, oder COLOR3 des Sprite0 - GELB

	dc.w	$ffff,$fffe		; Ende der Copperlist


; ************ Hier ist der Sprite: NATRLICH mu er in CHIP RAM sein! ************

MeinSprite:		; Lnge 13 Zeilen
Vstart:
	dc.b $30	; Vertikale Anfangsposition des Sprite (von $2c bis $f2)
Hstart:
	dc.b $90	; Horizontale Anfangsposition des Sprite (von $40 bis $d8)
Vstop:
	dc.b $3d	; $30+13=$3d	- Vertikale Endposition des Sprite
	dc.b $00
 dc.w	%0000000000000000,%0000110000110000 ; Binres Format fr ev. nderungen
 dc.w	%0000000000000000,%0000011001100000
 dc.w	%0000000000000000,%0000001001000000
 dc.w	%0000000110000000,%0011000110001100 ; BINR 00=COLOR 0 (DURCHSICHTIG)
 dc.w	%0000011111100000,%0110011111100110 ; BINR 10=COLOR 1 (ROT)
 dc.w	%0000011111100000,%1100100110010011 ; BINR 01=COLOR 2 (GRN)
 dc.w	%0000110110110000,%1111100110011111 ; BINR 11=COLOR 3 (GELB)
 dc.w	%0000011111100000,%0000011111100000
 dc.w	%0000011111100000,%0001111001111000
 dc.w	%0000001111000000,%0011101111011100
 dc.w	%0000000110000000,%0011000110001100
 dc.w	%0000000000000000,%1111000000001111
 dc.w	%0000000000000000,%1111000000001111
 dc.w	0,0		; 2 word auf NULL definieren das Ende des Sprite.


	SECTION LEERESPLANE,BSS_C	; Eine auf 0 gesetzte Bitplane, wir
							; mssen es verwenden, denn ohne Bitplane
							; ist es nicht mglich, die Sprites
							; zu aktivieren
Bitplane:
	ds.b	40*256			; Bitplane auf 0 Lowres

	end


Es ist einfach, den Sprite zu bewegen, versucht es mal mit dieser Modifizierung
der Routine BewegeSprite:


	subq.b	#1,Hstart		; Linksbewegung des Sprite

*

	addq.b	#1,Vstart		; \ bewegt den Sprite nach unten
	addq.b	#1,Vstop		; / (sowohl auf Vstart wie auch auf Vstop!)

*
	subq.b	#1,Vstart		; \ bewegt den Sprite nach oben
	subq.b	#1,Vstop		; / (sowohl auf Vstart wie auch auf Vstop!)
		
*

	addq.b	#1,Hstart		;\
	addq.b	#1,Vstart		; \ bewegt den Sprite diagonal nach unten-rechts
	addq.b	#1,Vstop		; /

*

	subq.b	#1,Hstart		;\
	addq.b	#1,Vstart		; \ bewegt den Sprite diagonal nach unten-links
	addq.b	#1,Vstop		; /

*

	addq.b	#1,Hstart		;\
	subq.b	#1,Vstart		; \ bewegt den Sprite diagonal nach oben-rechts
	subq.b	#1,Vstop		; /

*

	subq.b	#1,Hstart		;\
	subq.b	#1,Vstart		; \ bewegt den Sprite diagonal nach oben-links
	subq.b  #1,Vstop		; /

*

Probiert dann, den Wert, der dazu/weggezhlt wird, zu verndern, und schafft
neue, interessante "Schulinien":

	subq.b	#3,Hstart		;\
	subq.b	#1,Vstart		; \ bewegt den Sprite diagonal oben-seht links
	subq.b	#1,Vstop		; /

Und so weiter, und so weiter....
