
; Listing6l.s	BLINKENDE FARBEN, HERGESTELLT MIT EINER TABELLE
;				VERWENDET WIRD EINE ROUTINE, DIE AM ENDE RCKWRTS GEHT

	SECTION	CIPundCOP,CODE

Anfang:
	move.l	4.w,a6			; Execbase
	jsr	-$78(a6)			; Disable
	lea	GfxName(pc),a1		; Namen der Lib
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase		;
	move.l	d0,a6
	move.l	$26(a6),OldCop	; speichern die alte COP

	move.l	#Copperlist,$dff080	; COP1LC - unsere COP
	move.w	d0,$dff088		; COPJMP1 - Starten unsere COP
	move.w	#0,$dff1fc		; FMODE - Deaktiviert das AGA
	move.w	#$c00,$dff106	; BPLCON3 - Deaktiviert das AGA

Mouse:
	cmpi.b	#$ff,$dff006	; Sind wir auf Zeile 255?
	bne.s	Mouse			; Wenn nicht, geh nicht weiter

	btst	#2,$dff016		; wenn die rechte Maustaste gedrckt ist,
	beq.s	Warte			; gehe zu Warte
 
	bsr.w	Blinken			; ansonsten gehe zu Blinken

Warte:
	cmpi.b	#$ff,$dff006	; Sind wir auf Zeile 255?
	beq.s	Warte			; Wenn nicht, geh nicht weiter

	btst	#6,$bfe001		; linke Maustaste gedrckt?
	bne.s	Mouse			; wenn nicht, zurck zu Mouse:

	move.l	OldCop(pc),$dff080 ; COP1LC - "Zeiger" auf die Orginal-COP
	move.w	d0,$dff088	    ; COPJMP1 - und starten sie

	move.l	4.w,a6
	jsr	-$7e(a6)			; Enable - stellt Multitasking wieder her
	move.l	GfxBase(pc),a1	; Basis der Library, die es zu schlieen gilt
							; (Libraries werden geffnet UND geschlossen!)
	jsr	-$19e(a6)			; Closelibrary - schliet die Graphics lib
	rts


; DATEN

GfxName:
	dc.b	"graphics.library",0,0	

GfxBase:		; Hier hinein kommt die Basisadresse der graphics.lib,
	dc.l	0	; ab hier werden die Offsets gemacht

OldCop:			; Hier hinein kommt die Adresse der Orginal-Copperlist des
	dc.l	0	; Betriebssystemes

;	Blinkroutine, die eine vorgefertigte Farbverlauf-TABELLE verwendet.
;	Diese Tabelle ist nicht anderes als eine Reihe von Words mit den
;	verschiedenen RGB-Werten, die COLOR1 annehmen wird.
;	Diese Routine nimmt bei jedem Durchgang den nchsten Wert in der 
;	Tabelle, und wenn sie beim letzten Word der in ihr angekommen ist,
;	also beim Label EndeColorTab, dann wechselt sie die Richtung mit dem
;	BCHG.G  #1,DirFlag. Nun wird solange "rckwrts" gegangen, bis wir
;	beim ersten Word angekommen sind, dann wechseln wir erneut DirFlag
;	und wir fahren fort, indem wir wieder "vorwrts" lesen.
;	Bemerkung: Diese Routine ist dann ntzlich, wenn die Werte so gestaltet
;	sein sollen, da sie einen Maximalwert erreicht und dann wieder
;	abfallen. In diesem Fall htten wir so eine Tabelle schreiben mssen:
;
;	dc.w	0,1,2,3,4,5,6,7,8,9,10 ; rauf bis zum Maximum
;	dc.w	10,9,8,7,6,5,4,3,2,1,0 ; und dann wieder runter
;
;	Bei unserer Routine ist das aber nicht notwendig, es reicht die halbe
;	Tabelle, bis 10, dann ist die Routine selbst damit beschftigt, den
;	"Abstieg" zu machen. Wir sparen Platz und Zeit, wenn die Werte alle
;	"von Hand" eingegeben werden mssen.
;	Wenn die Tabelle aber nicht spiegelbildlich wre, etwa so:
;
;	dc.b	0,2,3,5,6,7,8,9,10
;	dc.b	9,8,7,6,4,3,2,1,0
;
;	dann htten wir eine Routine verwendet, die bis zum Ende liest und
;	dann von vorne beginnt.


Blinken:
	btst	#1,DirFlag		; mssen wir die Word in der Tabelle vorwrts
	beq.s	RunterT2		; oder rckwrts lesen?
RaufT2:
	subq.l	#2,ColTabPoint			; Pointe auf das vorherige Word
	move.l	ColTabPoint(pc),a0		; Adresse, die in ColTabPoint steht,
									; kommt in a0
	cmp.l	#ColorTab,a0	; Sind wir beim ersten Wert in der Tabelle 
							; angekommen?
	bne.s	NobStart2
	bchg.b	#1,DirFlag		; ndere Richtung, geh nach vorne!

NobStart2:
	move.w	(a0),Farbeo		; kopiere das Word der Tabelle in die COP
	move.w	(a0),Farbeu		; kopiere das Word der Tabelle in die COP
	rts

RunterT2:
	addq.l	#2,ColTabPoint			; Pointe auf das nchste Word
	move.l	ColTabPoint(pc),a0		; Adresse aus ColTabPoint kommt in a0
	cmp.l	#EndeColorTab-2,a0		; Sind wir beim letzten Word der TAB?
	bne.s	KeinRichtungsWechsel	; wenn nicht, ndere nix
	bchg.b	#1,DirFlag				; wechsle Richtung, geh rckwrts!
KeinRichtungsWechsel:
	move.w	(a0),Farbeo		; kopiere das Word aus der Tabelle in die
	move.w	(a0),Farbeu		; kopiere das Word aus der Tabelle in die
	rts						; Farbe0 in der COP

DirFlag:					; Label FLAG, wird verwendet, um die
	dc.w	0				; Leserichtung anzugeben.


ColTabPoint:				; Dieses Longword "POINTET" auf ColorTab, also
	dc.l	ColorTab-2		; enthlt es die Adresse von ColorTab. Es wird
						    ; die Adresse des zuletzt gelesenen Word innerhalb
						    ; der Tabelle beinhalten. (hier beginne es bei 
						    ; ColorTab-2, weil das Blinken ja mit addq.l #2,C...
						    ; beginnt. Es dient zum "ausgleich" dieser ersten
						    ; Anweisung.

;	Die Tabelle mit den vordefinierten Werten, die das Blinken ergeben:

ColorTab:
	dc.w	$000,$000,$001,$011,$011,$011,$012,$012 ; Beginn DUNKEL
	dc.w	$022,$022,$022,$023,$023
	dc.w	$033,$033,$034
	dc.w	$044,$044
	dc.w	$045,$055,$055
	dc.w	$056,$056,$066,$066,$066
	dc.w	$167,$167,$177,$177,$177,$177,$177
	dc.w	$278,$278,$278,$288,$288,$288,$288,$288
	dc.w	$389,$389,$399,$399,$399,$399
	dc.w	$39a,$39a,$3aa,$3aa,$3aa
	dc.w	$3ab,$3bb,$3bb,$3bb
	dc.w	$4bc,$4cc,$4cc,$4cc
	dc.w	$4cd,$4cd,$4dd,$4dd,$4dd
	dc.w	$5de,$5de,$5ee,$5ee,$5ee,$5ee
	dc.w	$6ef,$6ff,$6ff,$7ff,$7ff,$8ff,$8ff,$9ff ; Maximum HELL
EndeColorTab:



	SECTION GRAPHIC,DATA_C

Copperlist:
	dc.w	$120,$0000,$122,$0000,$124,$0000,$126,$0000,$128,$0000 ; SPRITE
	dc.w	$12a,$0000,$12c,$0000,$12e,$0000,$130,$0000,$132,$0000
	dc.w	$134,$0000,$136,$0000,$138,$0000,$13a,$0000,$13c,$0000
	dc.w	$13e,$0000

	dc.w	$8e,$2c81		; DiwStrt (Register mit Normalwerten)
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$0038		; DdfStart
	dc.w	$94,$00d0		; DdfStop
	dc.w	$102,0			; BplCon1
	dc.w	$104,0			; BplCon2
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod

				; 5432109876543210
	dc.w	$100,%0000001000000000  ; 0 BITPLANES LOWRES

	dc.w	$0180			; Color0 - HINTERGRUND
Farbeo:	
	dc.w	$000

	dc.w	$a027,$fffe		; Wait Zeile $a0
	dc.w	$180			; Color0
FARBE0:
	dc.w	$000

	dc.w	$c027,$fffe		; Wait Zeile $c0
	dc.w	$0180			; Color0
Farbeu:	
	dc.w	$000

	dc.w	$ffff,$fffe		; Ende der Copperlist

	end

Dies  ist  eine  der  vielen  Varienten der Routine, die aus einer Tabelle
Werte ausliest. Diese Routine kann nur bei  "spielgelbildlichen"  Tabellen
verwendet werden, also mit gleich ansteigenden Werten, die einen Hhepunkt
erreichen,  und  dann  symetrisch  abfallen  sollen.  Der  Effekt  ist
symetrischer als der in Listing6i.s prsentierte.

Versucht, die Tabelle mit dieser zu ersetzen: (Amiga+b+c+i)

ColorTab:
	dc.w $000,$100,$200,$300,$400,$500,$600,$700
	dc.w $800,$900,$a00,$b00,$c00,$d00,$e00
	dc.w $f00,$f10,$f20,$f30,$f40,$f50,$f60,$f70
	dc.w $f80,$f90,$fa0,$fb0,$fc0,$fd0,$fe0
	dc.w $ff0,$ef0,$df0,$cf0,$bf0,$af0,$9f0,$8f0
	dc.w $7f0,$6f0,$5f0,$4f0,$3f0,$2f0,$1f0
	dc.w $0f0,$0f1,$0f2,$0f3,$0f4,$0f5,$0f6,$0f7
	dc.w $0f8,$0f9,$0fa,$0fb,$0fc,$0fd,$0fe
	dc.w $0ff,$0ef,$0df,$0cf,$0bf,$0af,$09f,$08f
	dc.w $07f,$06f,$05f,$04f,$03f,$02f,$01f
	dc.w $00f,$10f,$20f,$30f,$40f,$50f,$60f,$70f
	dc.w $80f,$90f,$a0f,$b0f,$c0f,$d0f,$e0f
	dc.w $f0f,$e0e,$d0d,$c0c,$b0b,$a0a,$909,$808
	dc.w $707,$606,$505,$404,$303,$202,$101,$000
EndeColorTab:

Probiert auch diese:

ColorTab:
	dc.w 0,0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
	dc.w $10f,$20f,$30f,$40f,$50f,$60f,$70f,$80f
	dc.w $90f,$a0f,$b0f,$c0f,$d0f,$e0f,$f0f
	dc.w $f1e,$f2d,$f3c,$f4b,$f5a,$f69,$f78,$f87
	dc.w $f96,$fa5,$fb4,$fc3,$fd2,$fe1,$ff0
	dc.w $ff0,$ff0,$fe0,$fd0,$fc0,$fb0,$fa0,$f90
	dc.w $f80,$f70,$f60,$f50,$f40,$f30,$f20,$f10
	dc.w $f00,$f00,$e01,$d02,$c03,$b04,$a05,$906
	dc.w $807,$708,$609,$50a,$40b,$30c,$20d,$10e,15
	dc.w $0f,$1f,$2f,$3f,$4f,$5f,$6f,$7f,$8f,$9f,$af
	dc.w $bf,$cf,$df,$ef,$ff,$ff,$fe,$fd,$fc,$fb,$fa
	dc.w $f9,$f8,$f7,$f6,$f5,$f4,$f3,$f2,$f1,$f0
	dc.w $1f1,$2f2,$3f3,$4f4,$5f5,$6f6,$7f7,$8f8,$9f9
	dc.w $afa,$bfb,$cfc,$dfd,$efe,$fff,$ffe,$ffd,$ffc,$ffb
	dc.w $ffa,$ff9,$ff8,$ff7,$ff6,$ff5,$ff4,$ff3,$ff2,$ff1,$ff0
	dc.w $fe0,$fd0,$fc0,$fb0,$fa0,$f90,$f80,$f70,$f60,$f50,$f40
	dc.w $f30,$f20,$f10,$f00,$f00,$e00,$d00,$c00,$b00,$a00,$900
	dc.w $800,$700,$600,$500,$400,$300,$200,$100,$0,0
EndeColorTab:


