
; Listing6i.s		Text IN 3 FARBEN, BEI DEM EINE FARBE BLINKT
;					WIR VERWENDEN DAZU EINE VORDEFINIERTE TABELLE

	SECTION	CIPundCOP,CODE

Anfang:
	move.l	4.w,a6			; Execbase in a6
	jsr	-$78(a6)			; Disable - stoppt das Multitasking
	lea	GfxName(pc),a1		; Adresse des Namen der zu ffnenden Lib in a1
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase		; speichere diese Adresse in GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop	; hier speichern wir die Adresse der Copperlist
							; des Betriebssystemes

;	POINTEN AUF UNSERE BITPLANES

	move.l	#Bitplane,d0	; in d0 kommt die Adresse des Bildes
	lea	Bplpointers,a1		; Pointer in der Copperlist
	move.w	d0,6(a1)		; kopiert das niederw. Word der Planeadresse
	swap	d0				; vertauscht die 2 Word in d0 (1234 > 3412)
	move.w	d0,2(a1)		; kopiert das hochw. Word der Adresse des Plnae

;	POINTEN AUF UNSER BITPLANE

	move.l	#Bitplane2,d0	; in d0 kommt die Adresse des Bildes
	lea	Bplpointers2,a1		; Pointer in der Copperlist
	move.w	d0,6(a1)		; kopiert das niederw. Word der Planeadresse
	swap	d0				; vertauscht die 2 word in d0 (1234 > 3412)
	move.w	d0,2(a1)		; kopiert das hochw. Word der Planeadresse
	
	move.l	#Copperlist,$dff080	; COP1LC - "Zeiger" auf unsere COP
	move.w	d0,$dff088		; COPJMP1 - Starten unsere COP
	move.w	#0,$dff1fc		; FMODE - Deaktiviert das AGA
	move.w	#$c00,$dff106	; BPLCON3 - Deaktiviert das AGA

	lea	Text(pc),a0			; Adresse des zu schreibenden Textes in a0
	lea	Bitplane,a3			; Adresse des Ziel-Bitplanes in a3
	bsr.w	Print			; Bringt den Text auf den Bildschirm

	lea	Text2(pc),a0		; Adresse des zu schreibenden Textes in a0
	lea	Bitplane2,a3		; Adresse des Ziel-Bitplanes in a3
	bsr.w	Print			; Bringt den Text auf den Bildschirm
 
Mouse:
	cmpi.b	#$ff,$dff006	; Sind wir auf Zeile 255?
	bne.s	Mouse			; Wenn nicht, geh nicht weiter

	btst	#2,$dff016		; wenn die rechte Maustaste gedrckt ist,
	beq.s	Warte			; gehe zu Warte

	bsr.w	Blinken			; ansonsten gehe zu Blinken

Warte:
	cmpi.b	#$ff,$dff006	; Sind wir auf Zeile 255?
	beq.s	Warte			; Wenn nicht, geh nicht weiter

	btst	#6,$bfe001		; linke Maustaste gedrckt?
	bne.s	Mouse			; wenn nicht, zurck zu Mouse:

	move.l	OldCop(pc),$dff080	; COP1LC - "Zeiger" auf die Orginal-COP
	move.w	d0,$dff088		; COPJMP1 - und starten sie

	move.l	4.w,a6
	jsr	-$7e(a6)			; Enable - stellt Multitasking wieder her
	move.l	GfxBase(pc),a1	; Basis der Library, die es zu schlieen gilt
							; (Libraries werden geffnet UND geschlossen!)
	jsr	-$19e(a6)			; Closelibrary - schliet die Graphics lib
	rts

; DATEN

GfxName:
	dc.b	"graphics.library",0,0	

GfxBase:		; Hier hinein kommt die Basisadresse der graphics.lib,
	dc.l	0	; ab hier werden die Offsets gemacht

OldCop:			; Hier hinein kommt die Adresse der Orginal-Copperlist des
	dc.l	0	; Betriebssystemes


;	Blinkroutine, die eine vorgefertigte Farbverlauf-TABELLE verwendet.
;	Diese Tabelle ist nicht anderes als eine Reihe von Words mit den
;	verschiedenen RGB-Werten, die COLOR1 annehmen wird.
;	Diese Routine nimmt bei jedem Durchgang den nchsten Wert in der 
;	Tabelle, und wenn sie ein Word (2 Bytes) vor dem Label EndeColorTab
;	angekommen ist, beginnt der Lesevorgang wieder beim ersten Element:
;
;	dc.w	1,3,5,7,9,8,6,4,2,1	; unsere "Mini"-Tabelle
;
;	Whrend der nchsten Fotogramme wird die Reihenfolge der kopierten
;	word so aussehen, in einem unendlichen Loop:
;
;	1,3,5,7,9,8,6,4,2,1,1,3,5,7,9,8,6,4,2,1,1,3,5,7,9,8,6,4,2,1....
;
;	Die Adresse des letzten gelesenen Word wird im Longword ColTabPoint
;	gespeichert.

Blinken:
	addq.l	#2,ColTabPoint		; Pointet auf das nchste Word
	move.l	ColTabPoint(pc),a0  ; Adresse, die im Long ColTabPoint steht
								; wird in a0 kopiert
	cmp.l	#EndeColorTab-2,a0  ; Sind wir beim letzten Word in der TAB?
	bne.s	NobStart2			; noch nicht? dann geh weiter
	move.l	#ColorTab-2,ColTabPoint ; Starte wieder beim ersten Word
NobStart2:
	move.w	(a0),Farbe1			; kopiere das Word der Tabelle in die COP
	rts


ColTabPoint:				; Dieses Longword "POINTET" auf ColorTab, also
	dc.l	ColorTab-2		; enthlt es die Adresse von ColorTab. Es wird
						    ; die Adresse des zuletzt gelesenen Word innerhalb
						    ; der Tabelle beinhalten. (hier beginnt es bei 
						    ; ColorTab-2, weil das Blinken ja mit addq.l #2,C..
						    ; beginnt. Es dient zum "Ausgleich" dieser ersten
						    ; Anweisung.

;	Die Tabelle mit den vordefinierten Werten, die das Blinken ergeben:

ColorTab:
	dc.w	$26F,$27E,$28D,$29C,$2AB,$2BA,$2C9,$2D8,$2E7,$2F6
	dc.w	$4E7,$6D8,$8C9,$ABA,$CAA,$D9A,$E8A,$F7A,$F6B,$F5C
	dc.w	$D6D,$B6E,$96F,$76F,$56F,$36F
EndeColorTab:


;	Routine, die 8x8 Pixel groe Buchstaben druckt

Print:
	moveq	#27-1,d3		; ANZAHL DER ZEILEN, DIE ZU DRUCKEN SIND -> 26
PrintZeile:
	moveq	#40-1,d0		; ANZAHL DER SPALTEN EINER ZEILE: 40 (LOWRES!)

PrintChar2:
	moveq	#0,d2			; Lscht d2
	move.b	(a0)+,d2		; Nchster Charakter in d2
	sub.b	#$20,d2			; ZHLE 32 VOM ASCII-WERT DES BUCHSTABEN WEG,
							; SOMIT VERWANDELN WIR Z.B. DAS LEERZEICHEN
							; (Das $20 entspricht), IN $00, DAS
							; AUSRUFUNGSZEICHEN ($21) IN $01...
	mulu.w	#8,d2			; MULTIPLIZIERE DIE ERHALTENE ZAHL MIT 8,
							; da die Charakter ja 8 Pixel hoch sind
	move.l	d2,a2
	add.l	#Font,a2		; FINDE DEN GEWNSCHTEN BUCHSTEBEN IM FONT

							; DRUCKE DEN BUCHSTABEN ZEILE FR ZEILE
	move.b	(a2)+,(a3)		; Drucke Zeile 1 des Buchstaben
	move.b	(a2)+,40(a3)	; Drucke Zeile 2  "	"
	move.b	(a2)+,40*2(a3)	; Drucke Zeile 3  "	"
	move.b	(a2)+,40*3(a3)	; Drucke Zeile 4  "	"
	move.b	(a2)+,40*4(a3)	; Drucke Zeile 5  "	"
	move.b	(a2)+,40*5(a3)	; Drucke Zeile 6  "	"
	move.b	(a2)+,40*6(a3)	; Drucke Zeile 7  "	"
	move.b	(a2)+,40*7(a3)	; Drucke Zeile 8  "	"

	addq.w	#1,a3			; a3+1, wir gehen um 8 Bit weiter (zum
							; nchsten Buchstaben

	dbra	d0,PrintChar2	; DRUCKEN d0 (80) ZEICHEN PRO ZEILE

	add.w	#40*7,a3		; "Return", neue Zeile

	dbra	d3,PrintZeile	; Wir drucken d3 Zeilen
	rts

Text:
             ; Anzahl Charakter pro Zeile: 40
             ;            1111111111222222222233333333334
             ;   1234567890123456789012345678901234567890
	dc.b	'   ERSTE ZEILE (nur TEXT1)              ' ; 1
	dc.b	'                                        ' ; 2
	dc.b	'     /\  /                              ' ; 3
	dc.b	'    /  \/                               ' ; 4
	dc.b	'                                        ' ; 5
	dc.b	'        SECHSTE ZEILE (beide Bitplanes) ' ; 6
	dc.b	'                                        ' ; 7
	dc.b	'                                        ' ; 8
	dc.b	'FABIO CIUCCI               INTERNATIONAL' ; 9
	dc.b	'                                        ' ; 10
	dc.b	'   1  4 6 89  !@ $ ^& () +| =- ]{       ' ; 11
	dc.b	'                                        ' ; 12
	dc.b	'     I H D N E,  L O BIN I H            ' ; 13
	dc.b	'                                        ' ; 24
	dc.b	'                                        ' ; 15
	dc.b	'  Das Fraeulein stand am Meere,         ' ; 16
	dc.b	'                                        ' ; 17
	dc.b	'    Und seufzte lang und bang,          ' ; 18
	dc.b	'                                        ' ; 19
	dc.b	'    Es ruehrte sie so sehre,            ' ; 20
	dc.b	'                                        ' ; 21
	dc.b	'      Sonnenuntergang.                  ' ; 22
	dc.b	'                                        ' ; 23
	dc.b	'           ...                          ' ; 24
	dc.b	'                                        ' ; 25
	dc.b	'                                        ' ; 26
	dc.b	'                                        ' ; 27
	
    even

Text2:
             ; Anzahl Charakter pro Zeile: 40
             ;            1111111111222222222233333333334
             ;   1234567890123456789012345678901234567890
	dc.b	'                                        ' ; 1
	dc.b	'  ZWEITE ZEILE (nur TEXT2)              ' ; 2
	dc.b	'     /\  /                              ' ; 3
	dc.b	'    /  \/                               ' ; 4
	dc.b	'                                        ' ; 5
	dc.b	'        SECHSTE ZEILE (beide Bitplanes) ' ; 6
	dc.b	'                                        ' ; 7
	dc.b	'                                        ' ; 8
	dc.b	'FABIO        COMMUNICATION INTERNATIONAL' ; 9
	dc.b	'                                        ' ; 10
	dc.b	'   1234567 90  @#$%^&*( _+|\=-[]{}      ' ; 11
	dc.b	'                                        ' ; 12
	dc.b	'     ICH DENKE, ALSO     ICH            ' ; 13
	dc.b	'                                        ' ; 14
	dc.b	'                                        ' ; 15
	dc.b	'  Das           stand am                ' ; 16
	dc.b	'                                        ' ; 17
	dc.b	'    Und s u  te l n  und b  g,          ' ; 18
	dc.b	'                                        ' ; 19
	dc.b	'    Es ruehrte        sehre,            ' ; 20
	dc.b	'                                        ' ; 21
	dc.b	'  Der Sonnen     gang.                  ' ; 22
	dc.b	'                                        ' ; 23
	dc.b	'           ...                          ' ; 24
	dc.b	'                                        ' ; 25
	dc.b	'                                        ' ; 26
	dc.b	'                                        ' ; 27

	even


	SECTION GRAPHIC,DATA_C

Copperlist:
	dc.w	$120,$0000,$122,$0000,$124,$0000,$126,$0000,$128,$0000 ; SPRITE
	dc.w	$12a,$0000,$12c,$0000,$12e,$0000,$130,$0000,$132,$0000
	dc.w	$134,$0000,$136,$0000,$138,$0000,$13a,$0000,$13c,$0000
	dc.w	$13e,$0000

	dc.w	$8e,$2c81		; DiwStrt (Register mit Normalwerten)
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$0038		; DdfStart
	dc.w	$94,$00d0		; DdfStop
	dc.w	$102,0			; BplCon1
	dc.w	$104,0			; BplCon2
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod
	
				; 5432109876543210
	dc.w	$100,%0010001000000000  ; 2 BITPLANES LOWRES, 4 FARBEN

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane
Bplpointers2:
	dc.w	$e4,$0000,$e6,$0000	; zweite Bitplane

	dc.w	$0180,$000		; Color0 - HINTERGRUND
	dc.w	$0182

Farbe1:
	dc.w	$000
	dc.w	$0184,$f62		; Color2 - SCHRIFT zweites Bitplane (ORANGE)
	dc.w	$0186,$1e4		; Color3 - SCHRIFT erstes+zweites Bitplane (GRN)


	dc.w	$ffff,$fffe		; Ende der Copperlist

;	Der Font, Charakter 8x8

Font:
;	incbin	"/Sources/metal.fnt"	; Breiter Zeichensatz
;	incbin	"/Sources/normal.fnt"	; hnlich dem aus dem Kickstart 1.3
	incbin	"/Sources/nice.fnt"	; Schmaler Zeichensatz

	SECTION MEIPLANE,BSS_C	; Die SECTION BSS knnen nur aus NULLEN
							; bestehen!!! Man verwendet das DS.B um zu
							; definieren, wieviele Nullen die Section
							; enthalten soll

Bitplane:
	ds.b	40*256			; eine Bitplane LOWRES 320x256
Bitplane2:
	ds.b	40*256			; eine Bitplane LOWRES 320x256


	end


Unter Verwendung von vordefinierten oder "vorberechneten" Werten kann  man
viel  bessere  Bewegungen oder Farbverlufe herstellen, als mit bloen ADD
und SUB.
Die einzige "Neuigkeit" in diesem Listing besteht in der Auscodierung  der
Routine  "Blinken",  die  die  Werte  aus einer Tabelle liest, die dann in
"FARBE1" kommen. Dabei wird ein POINTER  auf  das  zuletzt  gelesene  Word
verwendet, also  ein LONGWORD, das die Adresse dieses Wordes innerhalb der
Tabelle speichert. Zu Bemerken ist, da ein:

ColTabPoint:
	dc.l	ColorTab

gleich einem

ColTabPoint:
	dc.l	0

ist, nachdem ein move.l #ColorTab,ColTabPoint ausgefhrt  wurde,  es  wird
also  ein  Longword  assembliert,  das  die Adresse eines bestimmten Label
enthlt. In dieser Routine ist ein

	dc.l	ColorTab-2

vorzufinden, es ist aber nur dazu da, um beim ersten Mal das erste Word zu
lesen, da die Routine ja mit

Blinken:
	addq.l	#2,ColTabPoint	; Pointet auf das nchste Word

beginnt.  ColTabPoint  mu  den  Anfang  des  ersten	Word-2	enthalten,
jedenfalls  nach  dem ersten addq.l #2 wird beim ersten jsr das erste Word
kopiert und nicht das zweite.
Danach wird das Longword ColTabPoint jedesmal um 2  erhht,  die  Adresse,
die  es enthlt, wird also jedesmal die nchste sein, bis nicht das letzte
Word erreicht wird, das zwei Bytes vor dem ENDE der Tabelle steht:

; wir sind auf dieser Adresse, wenn wir das letzte Word lesen...

	dc.w	$000			; wieder DUNKEL
EndeColorTab:

Hier wird dann mit einem

	move.l	#ColorTab-2,ColTabPoint ; Starte wieder beim ersten Word


das Label ColTabPoint wieder mit der Adresse des ersten Word geladen.

Ihr knnt diese Routine fr viele verschiedene Zwecke verwenden,  z.B.  um
Sprites zum springen oder wellen zu bringen. Einfach die Tabelle ersetzen.

Probiert, die Tabelle mit dieser zu ersetzen:

ColorTab:
	dc.w	$26F,$27E,$28D,$29C,$2AB,$2BA,$2C9,$2D8,$2E7,$2F6
	dc.w	$4E7,$6D8,$8C9,$ABA,$CAA,$D9A,$E8A,$F7A,$F6B,$F5C
	dc.w	$D6D,$B6E,$96F,$76F,$56F,$36F
EndeColorTab:

ColorTab:
	dc.w	$000,$000,$001,$011,$011,$011,$012,$012 ; Beginn DUNKEL
	dc.w	$022,$022,$022,$023,$023
	dc.w	$033,$033,$034
	dc.w	$044,$044
	dc.w	$045,$055,$055
	dc.w	$056,$056,$066,$066,$066
	dc.w	$167,$167,$177,$177,$177,$177,$177
	dc.w	$278,$278,$278,$288,$288,$288,$288,$288
	dc.w	$389,$389,$399,$399,$399,$399
	dc.w	$39a,$39a,$3aa,$3aa,$3aa
	dc.w	$3ab,$3bb,$3bb,$3bb
	dc.w	$4bc,$4cc,$4cc,$4cc
	dc.w	$4cd,$4cd,$4dd,$4dd,$4dd
	dc.w	$5de,$5de,$5ee,$5ee,$5ee,$5ee
	dc.w	$6ef,$6ff,$6ff,$7ff,$7ff,$8ff,$8ff,$9ff ; Maximum HELL
	dc.w	$5ee,$5ee,$5ee,$5de,$5de,$5de
	dc.w	$4dd,$4dd,$4dd,$4cd,$4cd
	dc.w	$4cc,$4cc,$4cc,$4bc
	dc.w	$3cb,$3bb,$3bb
	dc.w	$3ba,$3aa,$3aa
	dc.w	$3a9,$399,$399
	dc.w	$298,$288
	dc.w	$187,$177
	dc.w	$076,$066
	dc.w	$065,$055
	dc.w	$054,$044
	dc.w	$034
	dc.w	$022
	dc.w	$011
	dc.w	$000			; wieder DUNKEL
EndeColorTab: