
; Listing6f.s		SCHREIBEN "BER" EINEM BILD

	SECTION	CIPundCOP,CODE

Anfang:
	move.l	4.w,a6			; Execbase in a6
	jsr	-$78(a6)			; Disable - stoppt das Multitasking
	lea	GfxName(pc),a1		; Adresse des Namen der zu ffnenden Lib in a1
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase		; speichere diese Adresse in GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop	; hier speichern wir die Adresse der Copperlist
							; des Betriebssystemes

;	POINTEN AUF UNSERE BITPLANES

	move.l	#Pic,d0			; in d0 kommt die Adresse von unserem Bild
							; bzw. wo ihr erste Bitplane beginnt

	lea	Bplpointers,a1		; in a1 kommt die Adresse der Bitplane-
							; Pointer der Copperlist
	moveq	#2,d1			; Anzahl der Bitplanes -1 (hier sind es 3)
							; fr den dbra - Zyklus
PointBp:
	move.w	d0,6(a1)		; kopiert das niederw. Word der Planeadresse
	swap	d0				; vertauscht die 2 Word in d0 (1234 > 3412)
	move.w	d0,2(a1)		; kopiert das hochw. Word der Adresse des Plnae
	swap	d0				; vertauscht erneut die 2 Word von d0
	add.l	#40*256,d0		; + Lnge Bitplane -> nchstes Bitplane
	addq.w	#8,a1			; auf zum nchsten bplpointer in der COP
	dbra	d1,PointBp		; wiederhole d1 mal PointBp (d1=n. bitplanes)

;	POINTEN AUF UNSER BITPLANE

	move.l	#Bitplane,d0	; in d0 kommt die Adresse des Bildes
	lea	Bplpointers2,a1		; Pointer in der Copperlist
	move.w	d0,6(a1)		; kopiert das niederw. Word der Planeadresse
	swap	d0				; vertauscht die 2 word in d0 (1234 > 3412)
	move.w	d0,2(a1)		; kopiert das hochw. Word der Planeadresse

	move.l	#Copperlist,$dff080	; COP1LC - "Zeiger" auf unsere COP
	move.w	d0,$dff088		; COPJMP1 - Starten unsere COP
	move.w	#0,$dff1fc		; FMODE - Deaktiviert das AGA
	move.w	#$c00,$dff106	; BPLCON3 - Deaktiviert das AGA

	bsr.w	Print			; Bringt den Text auf den Bildschirm

Mouse:
	btst	#6,$bfe001		; linke Maustaste gedrckt?
	bne.s	Mouse			; wenn nicht, zurck zu Mouse:

	move.l	OldCop(pc),$dff080	; COP1LC - "Zeiger" auf die Orginal-COP
	move.w	d0,$dff088		; COPJMP1 - und starten sie

	move.l	4.w,a6
	jsr	-$7e(a6)			; Enable - stellt Multitasking wieder her
	move.l	GfxBase(pc),a1	; Basis der Library, die es zu schlieen gilt
							; (Libraries werden geffnet UND geschlossen!)
	jsr	-$19e(a6)			; Closelibrary - schliet die Graphics lib
	rts

; DATEN

GfxName:
	dc.b	"graphics.library",0,0	

GfxBase:		; Hier hinein kommt die Basisadresse der graphics.lib,
	dc.l	0	; ab hier werden die Offsets gemacht

OldCop:			; Hier hinein kommt die Adresse der Orginal-Copperlist des
	dc.l	0	; Betriebssystemes

;	Routine, die 8x8 Pixel groe Buchstaben druckt

Print:
	lea	Text(pc),a0			; Adresse des zu schreibenden Textes in a0
	lea	Bitplane,a3			; Adresse der Ziel-Bitplane in a3
	moveq	#26-1,d3		; ANZAHL DER ZEILEN, DIE ZU DRUCKEN SIND -> 25
PrintZeile:
	moveq	#40-1,d0		; ANZAHL DER SPALTEN EINER ZEILE: 40 (LOWRES!)

PrintChar2:			
	moveq	#0,d2			; Lscht d2
	move.b	(a0)+,d2		; Nchster Charakter in d2
	sub.b	#$20,d2			; ZHLE 32 VOM ASCII-WERT DES BUCHSTABEN WEG,
							; SOMIT VERWANDELN WIR Z.B. DAS LEERZEICHEN
							; (Das $20 entspricht), IN $00, DAS
							; AUSRUFUNGSZEICHEN ($21) IN $01...
	mulu.w	#8,d2			; MULTIPLIZIERE DIE ERHALTENE ZAHL MIT 8,
							; da die Charakter ja 8 Pixel hoch sind
	move.l	d2,a2
	add.l	#Font,a2		; FINDE DEN GEWNSCHTEN BUCHSTEBEN IM FONT

							; DRUCKE DEN BUCHSTABEN ZEILE FR ZEILE
	move.b	(a2)+,(a3)		; Drucke Zeile 1 des Buchstaben
	move.b	(a2)+,40(a3)	; Drucke Zeile 2  "	"
	move.b	(a2)+,40*2(a3)	; Drucke Zeile 3  "	"
	move.b	(a2)+,40*3(a3)	; Drucke Zeile 4  "	"
	move.b	(a2)+,40*4(a3)	; Drucke Zeile 5  "	"
	move.b	(a2)+,40*5(a3)	; Drucke Zeile 6  "	"
	move.b	(a2)+,40*6(a3)	; Drucke Zeile 7  "	"
	move.b	(a2)+,40*7(a3)	; Drucke Zeile 8  "	"

	addq.w	#1,a3			; a3+1, wir gehen um 8 Bit weiter (zum
							; nchsten Buchstaben

	dbra	d0,PrintChar2	; DRUCKEN d0 (80) ZEICHEN PRO ZEILE
 
	add.w	#40*7,a3		; "Return", neue Zeile

	dbra	d3,PrintZeile	; Wir drucken d3 Zeilen
	rts


Text:
                ; Anzahl Charakter pro Zeile: 80, also 2 von diesen zu 40!


             ;            1111111111222222222233333333334
             ;   1234567890123456789012345678901234567890

	dc.b	'                                        ' ; 1
	dc.b	'                ZWEITE ZEILE            ' ; 2
	dc.b	'     /\  /                              ' ; 3
	dc.b	'    /  \/                               ' ; 4
	dc.b	'                                        ' ; 5
	dc.b	'        SECHSTE ZEILE                   ' ; 6
	dc.b	'                                        ' ; 7
	dc.b	'                                        ' ; 8
	dc.b	'FABIO CIUCCI COMMUNICATION INTERNATIONAL' ; 9
	dc.b	'                                        ' ; 10
	dc.b	'   1234567890 !@#$%^&*()_+|\=-[]{}      ' ; 11
	dc.b	'                                        ' ; 12
	dc.b	' -=-    ICH DENKE, ALSO BIN ICH...  -=- ' ; 13
	dc.b	' ## sagte mal jemand, aber er gefiel ## ' ; 14
	dc.b	' ///dem Cartoonzeichner nicht und   \\\ ' ; 15
	dc.b	'       so wurde er ausradiert...        ' ; 16
	dc.b	'                                        ' ; 17
	dc.b	'  Das Fraeulein stand am Meere          ' ; 18
	dc.b	'                                        ' ; 19
	dc.b	'    und seufzte lang und bang,          ' ; 20
	dc.b	'                                        ' ; 21
	dc.b	'    ES RUEHRTE SIE SO SEHRE,            ' ; 22
	dc.b	'                                        ' ; 23
	dc.b	'  der Sonnenuntergang.                  ' ; 24
	dc.b	'                                        ' ; 25
	dc.b	'            ...                         ' ; 26


	even

	SECTION GRAPHIC,DATA_C

Copperlist:
	dc.w	$120,$0000,$122,$0000,$124,$0000,$126,$0000,$128,$0000 ; SPRITE
	dc.w	$12a,$0000,$12c,$0000,$12e,$0000,$130,$0000,$132,$0000
	dc.w	$134,$0000,$136,$0000,$138,$0000,$13a,$0000,$13c,$0000
	dc.w	$13e,$0000

	dc.w	$8e,$2c81		; DiwStrt (Register mit Normalwerten)
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$0038		; DdfStart
	dc.w	$94,$00d0		; DdfStop
	dc.w	$102,0			; BplCon1
	dc.w	$104,0			; BplCon2
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod
	
				; 5432109876543210
	dc.w	$100,%0100001000000000  ; Bit 14 - 4 Bitplanes, 16 Farben HIRES

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste  Bitplane
	dc.w	$e4,$0000,$e6,$0000	; zweite Bitplane
	dc.w	$e8,$0000,$ea,$0000	; dritte Bitplane
Bplpointers2: 
	dc.w	$ec,$0000,$ee,$0000	; vierte Bitplane
 
	dc.w	$180,$000		; Color0 ; Farben des Bildes, ein bichen
	dc.w	$182,$354		; Color1 ; gedmpft
	dc.w	$184,$678		; Color2
	dc.w	$186,$567		; Color3
	dc.w	$188,$455		; Color4
	dc.w	$18a,$121		; Color5
	dc.w	$18c,$455		; Color6
	dc.w	$18e,$233		; Color7

	dc.w	$190,$454		; color8  ; Die Farben der Schrift:
	dc.w	$192,$7a8		; color9  ; in diesem Fall erzeugen wir
	dc.w	$194,$eef		; color10 ; 8 verschieden Farben fr die
	dc.w	$196,$cde		; color11 ; 8 berlagerungsmglichkeiten, die
	dc.w	$198,$aab		; color12 ; sich ergeben knnen- bemerkt
	dc.w	$19a,$786		; color13 ; ihr, da sie hnlich zu den
	dc.w	$19c,$9aa		; color14 ; ersten 8 sind, nur leuchtender:
	dc.w	$19e,$789		; color15 ; es kommt der "TRASPARENZ"-Effekt
							; zustande

	dc.w	$ffff,$fffe		; Ende der Copperlist

;	Der Font, Charakter 8x8

Font:
;	incbin	"/Sources/metal.fnt"	; Breiter Zeichensatz
;	incbin	"/Sources/normal.fnt"	; hnlich dem aus dem Kickstart 1.3
	incbin	"/Sources/nice.fnt"		; Schmaler Zeichensatz

Pic:
	incbin	"/Sources/Amiga_320_256_3.raw"	; hier laden wir das Bild in RAW

	SECTION MEIPLANE,BSS_C	; Die SECTION BSS knnen nur aus NULLEN
							; bestehen!!! Man verwendet das DS.B um zu
							; definieren, wieviele Nullen die Section
							; enthalten soll

Bitplane:
	ds.b	40*256			; ein Bitplane LOWRES 320x256

	end

In diesem Beispiel haben wir das Bitplane 4 dazugenommen, auf ihm wird der
Text geschrieben. Mit dieser vierten Bitplane gehen wir von 8 zu 16 Farben
ber, um also die Schrift in jeder Position gleichfarbig zu behalten, men wir
alle 8 zustzlichen Farben, die sich ergeben knnen, gleich sezten.
Sie alle erhalten die "Textfarbe".
Wenn die "neuen" 8 Farben aber hnlich sind wie die ersten 8, nur heller,
dann kann man eine Art "Transparenz" erzeugen. Denn jedesmal wenn sich das
"Textplane" einem Pixel berlagert, wird eine Farbe aus dem "neuen"
Repertoir angezeigt, und wenn diese gleich mit der alten ist, nur etwas heller,
kommt es automatisch zu diesem Effekt.
Versucht mal, die Palette der letzten 8 Farben mit diesen zu ersetzen:

	dc.w	$190,$454		; color8  ; Die Farben der Schrift:
	dc.w	$192,$7a8		; color9  ; in diesem Fall erzeugen wir
	dc.w	$194,$eef		; color10 ; 8 verschieden Farben fr die
	dc.w	$196,$cde		; color11 ; 8 berlagerungsmglichkeiten, die
	dc.w	$198,$aab		; color12 ; sich ergeben knnen- bemerkt
	dc.w	$19a,$786		; color13 ; ihr, da sie hnlich zu den
	dc.w	$19c,$9aa		; color14 ; ersten 8 sind, nur leuchtender:
	dc.w	$19e,$789		; color15 ; es kommt der "TRASPARENZ"-Effekt
							; zustande


	dc.w	$190,$d6e		; Color8  ; Die Farben der Schrift:
	dc.w	$192,$d6e		; Color9  ; beim berlagern wrden sich
	dc.w	$194,$d6e		; Color10 ; immer andere Farben ergeben, aber
	dc.w	$196,$d6e		; Color11 ; wir geben ihnen allen den gleichen
	dc.w	$198,$d6e		; Color12 ; Wert, so ist es immer die gleiche
	dc.w	$19a,$d6e		; Color13 ; Farbe
	dc.w	$19c,$d6e		; Color14
	dc.w	$19e,$d6e		; Color15