
; Listing6e.s	BERLAGERUNG VON ZWEI BITPLANES MIT EINER KLEINEN
;				VERSCHIEBUNG NACH UNTEN, UM EINEN RELIEF-EFFEKT ZU ERZEUGEN
 
	SECTION	CIPundCOP,CODE

Anfang:
	move.l	4.w,a6			; Execbase in a6
	jsr	-$78(a6)			; Disable - stoppt das Multitasking
	lea	GfxName(pc),a1		; Adresse des Namen der zu ffnenden Lib in a1
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase		; speichere diese Adresse in GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop	; hier speichern wir die Adresse der Copperlist
							; des Betriebssystemes

;	POINTEN AUF UNSERE BITPLANES

	move.l	#Bitplane,d0	; in d0 kommt die Adresse des Bildes
	lea	Bplpointers,a1		; Pointer in der Copperlist
	move.w	d0,6(a1)		; kopiert das niederw. Word der Planeadresse
	swap	d0				; vertauscht die 2 word in d0 (1234 > 3412)
	move.w	d0,2(a1)		; kopiert das hochw. Word der Planeadresse
 
; BEACHTET DAS -80!!!!
 
	move.l	#Bitplane-80,d0 ; in d0 kommt die Adresse des Bitplane-80,
							; also eine Zeile nach UNTEN verschoben!! ****
	lea	Bplpointers2,a1		; Pointer in der Copperlist
	move.w	d0,6(a1)		; kopiert das niederw. Word der Planeadresse
	swap	d0				; vertauscht die 2 word in d0 (1234 > 3412)
	move.w	d0,2(a1)		; kopiert das hochw. Word der Planeadresse
	

	
	move.l	#Copperlist,$dff080	; COP1LC - "Zeiger" auf unsere COP
	move.w	d0,$dff088		; COPJMP1 - Starten unsere COP
	move.w	#0,$dff1fc		; FMODE - Deaktiviert das AGA
	move.w	#$c00,$dff106	; BPLCON3 - Deaktiviert das AGA

	bsr.w	Print			; Bringt den Text auf den Bildschirm

Mouse:
	
	btst	#6,$bfe001		; linke Maustaste gedrckt?
	bne.s	Mouse			; wenn nicht, zurck zu Mouse:

	move.l	OldCop(pc),$dff080	; COP1LC - "Zeiger" auf die Orginal-COP
	move.w	d0,$dff088		; COPJMP1 - und starten sie

	move.l	4.w,a6
	jsr	-$7e(a6)			; Enable - stellt Multitasking wieder her
	move.l	GfxBase(pc),a1	; Basis der Library, die es zu schlieen gilt
							; (Libraries werden geffnet UND geschlossen!)
	jsr	-$19e(a6)			; Closelibrary - schliet die Graphics lib
	rts

; DATEN

GfxName:
	dc.b	"graphics.library",0,0

GfxBase:		; Hier hinein kommt die Basisadresse der graphics.lib,
	dc.l	0	; ab hier werden die Offsets gemacht

OldCop:			; Hier hinein kommt die Adresse der Orginal-Copperlist des
	dc.l	0	; Betriebssystemes

;	Routine, die 8x8 Pixel groe Buchstaben druckt

Print:
	lea	Text(pc),a0			; Adresse des zu schreibenden Textes in a0
	lea	Bitplane,a3			; Adresse des Ziel-Bitplanes in a3
	moveq	#25-1,d3		; ANZAHL DER ZEILEN, DIE ZU DRUCKEN SIND -> 15
PrintZeile:
	moveq	#80-1,d0		; ANZAHL DER SPALTEN EINER ZEILE: 80 (HIRES!)

PrintChar2:
	moveq	#0,d2			; Lscht d2
	move.b	(a0)+,d2		; Nchster Charakter in d2
	sub.b	#$20,d2			; ZHLE 32 VOM ASCII-WERT DES BUCHSTABEN WEG,
							; SOMIT VERWANDELN WIR Z.B. DAS LEERZEICHEN
							; (Das $20 entspricht), IN $00, DAS
							; AUSRUFUNGSZEICHEN ($21) IN $01...
	mulu.w	#8,d2			; MULTIPLIZIERE DIE ERHALTENE ZAHL MIT 8,
							; da die Charakter ja 8 Pixel hoch sind
	move.l	d2,a2
	add.l	#Font,a2		; FINDE DEN GEWNSCHTEN BUCHSTEBEN IM FONT

							; DRUCKE DEN BUCHSTABEN ZEILE FR ZEILE
	move.b	(a2)+,(a3)		; Drucke Zeile 1 des Buchstaben
	move.b	(a2)+,80(a3)	; Drucke Zeile 2	"	"
	move.b	(a2)+,80*2(a3)	; Drucke Zeile 3  "	"
	move.b	(a2)+,80*3(a3)	; Drucke Zeile 4  "	"
	move.b	(a2)+,80*4(a3)	; Drucke Zeile 5  "	"
	move.b	(a2)+,80*5(a3)	; Drucke Zeile 6  "	"
	move.b	(a2)+,80*6(a3)	; Drucke Zeile 7  "	"
	move.b	(a2)+,80*7(a3)	; Drucke Zeile 8  "	"

	addq.w	#1,a3			; a3+1, wir gehen um 8 Bit weiter (zum
							; nchsten Buchstaben
	
	dbra	d0,PrintChar2	; DRUCKEN d0 (80) ZEICHEN PRO ZEILE
 
	add.w	#80*7,a3		; "Return", neue Zeile

	dbra	d3,PrintZeile	; Wir drucken d3 Zeilen
	
	rts
	

Text:
		; Anzahl Charakter pro Zeile: 80, also 2 von diesen zu 40!

             ;            1111111111222222222233333333334
             ;   1234567890123456789012345678901234567890
	dc.b	'   ERSTE ZEILE IN  HIRES 640  PIXEL  BRE' ; 1a \ ERSTE ZEILE
	dc.b	'ITE!  -- -- -- --  IMMER DIE ERSTE ZEILE' ; 1b /
	dc.b	'                ZWEITE ZEILE            ' ; 2  \ ZWEITE ZEILE
	dc.b	'AUCH NOCH ZWEITE ZEILE                  ' ;    /
	dc.b	'     /\  /                              ' ; 3
	dc.b	'                                        ' ;
	dc.b	'    /  \/                               ' ; 4
	dc.b	'                                        ' ;
	dc.b	'                                        ' ; 5
	dc.b	'                                        ' ;
	dc.b	'        SECHSTE ZEILE                   ' ; 6
	dc.b	'                      ENDE SECHSTE ZEILE' ;
	dc.b	'                                        ' ; 7
	dc.b	'                                        ' ;
	dc.b	'                                        ' ; 8
	dc.b	'                                        ' ;
	dc.b	'FABIO CIUCCI COMMUNICATION INTERNATIONAL' ; 9
	dc.b	' MARKETING TRUST TRADEMARK COPYRIGHTED  ' ;
	dc.b	'                                        ' ; 10
	dc.b	'                                        ' ;
	dc.b	'   1234567890 !@#$%^&*()_+|\=-[]{}      ' ; 11
	dc.b	'       TECHNISCHER SENDETEST            ' ;
	dc.b	'                                        ' ; 12
	dc.b	'                                        ' ;
	dc.b	'     SEIN ODER NICHT SEIN, DAS IST HIER ' ; 13
	dc.b	' DIE FRAGE...                           ' ;
	dc.b	'                                        ' ; 14
	dc.b	'                                        ' ;
	dc.b	'                                        ' ; 15
	dc.b	'                                        ' ;
	dc.b	'  Das Fraeulein stand am Meere          ' ; 16
	dc.b	'                                        ' ;
	dc.b	'                                        ' ; 17
	dc.b	'                                        ' ;
	dc.b	'    UnD seufzte LanG uNd Bang,          ' ; 18
	dc.b	'                                        ' ;
	dc.b	'                                        ' ; 19
	dc.b	'                                        ' ;
	dc.b	'    Es ruehrte sie so sehre,            ' ; 20
	dc.b	'                                        ' ;
	dc.b	'                                        ' ; 21
	dc.b	'                                        ' ;
	dc.b	'  der Sonnenuntergang...                ' ; 22
	dc.b	'                                        ' ;
	dc.b	'                                        ' ; 23
	dc.b	'                                        ' ;
	dc.b	'                                        ' ; 24
	dc.b	'                                        ' ;
	dc.b	'                                        ' ; 25
	dc.b	'                                        ' ;
	dc.b	'                                        ' ; 26
	dc.b	'                                        ' ;


	even
	
	SECTION GRAPHIC,DATA_C

Copperlist:
	dc.w	$120,$0000,$122,$0000,$124,$0000,$126,$0000,$128,$0000 ; SPRITE
	dc.w	$12a,$0000,$12c,$0000,$12e,$0000,$130,$0000,$132,$0000
	dc.w	$134,$0000,$136,$0000,$138,$0000,$13a,$0000,$13c,$0000
	dc.w	$13e,$0000

	dc.w	$8e,$2c81		; DiwStrt (Register mit Normalwerten)
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$003c		; DdfStart \ HIRES...
	dc.w	$94,$00d4		; DdfStop  /
	dc.w	$102,0			; BplCon1
	dc.w	$104,0			; BplCon2
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod

				; 5432109876543210
	dc.w	$100,%1010001000000000  ; Bit 13 - 2 Bitplanes, 4 Farben HIRES

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane
Bplpointers2:
	dc.w	$e4,$0000,$e6,$0000	; zweite Bitplane

	dc.w	$180,$103		; Color0 - HINTERGRUND
	dc.w	$182,$fff		; Color1 - Plane 1 Normalposition, es ist das
							; Stck, das oben "bersteht"
	dc.w	$184,$745		; Color2 - Plane 2 (nach unten verschoben)
	dc.w	$186,$abc		; Color3 - beide Plane - berlagerung

	dc.w	$ffff,$fffe		; Ende der Copperlist
 
;	Der Font, Charakter 8x8

Font:
;	incbin	"/Sources/metal.fnt"	; Breiter Zeichensatz
;	incbin	"/Sources/normal.fnt"	; hnlich dem aus dem Kickstart 1.3
	incbin	"/Sources/nice.fnt"	; Schmaler Zeichensatz


	SECTION MEIPLANE,BSS_C	; Die SECTION BSS knnen nur aus NULLEN
							; bestehen!!! Man verwendet das DS.B um zu
							; definieren, wieviele Nullen die Section
							; enthalten soll
	
	ds.b	80				; Die Zeile, die "bersteht"
Bitplane:
	ds.b	80*256			; ein Bitplane HIRES 640x256

	end
 
Hier ein kleiner "Trick", um unsere Schrift  etwas  netter  zu  gestalten:
einfach  das  zweite Bitplane aktivieren und dem ersten berlagern, jedoch
um eine Zeile nach unten verschoben, um folgende Situation hervorzurufen:


	...###..				...111..	; 1 = Color1 (Hell)
	..#...#.	...###..	..12221.	; 2 = Color2 (Dunkel)
	..#...#.	..#...#.	..3...3.	; 3 = Color3 (Mittel)
	..#####.+	..#...#.=	..31113.
	..#...#.	..#####.	..32223.
	..#...#.	..#...#.	..3...3.
	..#...#.	..#...#.	..3...3.
	........	..#...#.	..2...2.
			........
				
	dc.w	$180,$103		; Color0 - HINTERGRUND
	dc.w	$182,$fff		; Color1 - Plane 1 Normalposition, es ist das
							; Stck, das oben "bersteht"
	dc.w	$184,$345		; Color2 - Plane 2 (nach unten verschoben)
	dc.w	$186,$abc		; Color3 - beide Plane - berlagerung
 

Dieser berlagerungseffekt von gleichen Bitplanes wird oft  verwendet,  um
Reliefs und Schattierungen vorzutuschen.

Um  diesen Aspekt noch weiters hervorzuheben, wird oft auch noch zur Seite
verschoben, probiert das:

	dc.w	$102,$10		; BplCon1 - Plane 2 um ein Pixel nach rechts

(Diese Zeile kommt in der Copperlist zwischen die beiden BPLPOINTER!)

Bei kleinen Fonts verschlechtert das zwar oft die Leserbarkeit,  aber  bei
groen Flchen kann es manchmal toll aussehen:

	......
	.:::::#
	.:::::#
	.:::::#
	 ######

