
; Listing6c.s	GEBEN MEHRERE ZEILEN AM BILDSCHIRM AUS!!!

	SECTION	CIPundCOP,CODE

Anfang:
	move.l	4.w,a6			; Execbase in a6
	jsr	-$78(a6)			; Disable - stoppt das Multitasking
	lea	GfxName(pc),a1		; Adresse des Namen der zu ffnenden Lib in a1
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase		; speichere diese Adresse in GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop	; hier speichern wir die Adresse der Copperlist
							; des Betriebssystemes

;	POINTEN AUF UNSERE BITPLANES

	move.l	#Bitplane,d0	; in d0 kommt die Adresse unseres Bitplane
	lea	Bplpointers,a1		; in a1 kommt die Adresse der Bitplane-
							; Pointer der Copperlist
	move.w	d0,6(a1)		; kopiert das niederwertige Word der Plane-
							; Adresse ins richtige Word der Copperlist
	swap	d0				; vertauscht die 2 Word in d0 (1234 > 3412)

	move.w	d0,2(a1)		; kopiert das hochwertige Word der Adresse des 
							; Plane in das richtige Word in der Copperlist

	move.l	#Copperlist,$dff080	; COP1LC - "Zeiger" auf unsere COP
	move.w	d0,$dff088		; COPJMP1 - Starten unsere COP
	move.w	#0,$dff1fc		; FMODE - Deaktiviert das AGA
	move.w	#$c00,$dff106	; BPLCON3 - Deaktiviert das AGA

	bsr.w	Print			; Bringt die Zeile auf den Bildschirm

Mouse:
	btst	#6,$bfe001		; linke Maustaste gedrckt?
	bne.s	Mouse			; wenn nicht, zurck zu Mouse:

	move.l	OldCop(pc),$dff080	; COP1LC - "Zeiger" auf die Orginal-COP
	move.w	d0,$dff088		; COPJMP1 - und starten sie

	move.l	4.w,a6
	jsr	-$7e(a6)			; Enable - stellt Multitasking wieder her
	move.l	GfxBase(pc),a1	; Basis der Library, die es zu schlieen gilt
							; (Libraries werden geffnet UND geschlossen!)
	jsr	-$19e(a6)			; Closelibrary - schliet die Graphics lib
	rts

; DATEN

GfxName:
	dc.b	"graphics.library",0,0

GfxBase:		; Hier hinein kommt die Basisadresse der graphics.lib,
	dc.l	0	; ab hier werden die Offsets gemacht

OldCop:			; Hier hinein kommt die Adresse der Orginal-Copperlist des
	dc.l	0	; Betriebssystemes

;	Routine, die 8x8 Pixel groe Buchstaben druckt


Print:
	lea	Text(pc),a0			; Adresse des zu schreibenden Textes in a0
	lea	Bitplane,a3			; Adresse des Ziel-Bitplanes in a3
	moveq	#23-1,d3		; ANZAHL DER ZEILEN, DIE ZU DRUCKEN SIND -> 23
PrintZeile:
	moveq	#40-1,d0		; ANZAHL DER SPALTEN EINER ZEILE: 40 (also die
							; Anzahl der Buchstaben, die in einer Zeile
							; Platz haben).
PrintChar2:
	moveq	#0,d2			; Lscht d2
	move.b	(a0)+,d2		; Nchster Charakter in d2
	sub.b	#$20,d2			; ZHLE 32 VOM ASCII-WERT DES BUCHSTABEN WEG,
							; SOMIT VERWANDELN WIR Z.B. DAS LEERZEICHEN
							; (Das $20 entspricht), IN $00, DAS
							; AUSRUFUNGSZEICHEN ($21) IN $01...
	mulu.w	#8,d2			; MULTIPLIZIERE DIE ERHALTENE ZAHL MIT 8,
							; da die Charakter ja 8 Pixel hoch sind
	move.l	d2,a2
	add.l	#Font,a2		; FINDE DEN GEWNSCHTEN BUCHSTEBEN IM FONT

							; DRUCKE DEN BUCHSTABEN ZEILE FR ZEILE
	move.b	(a2)+,(a3)		; Drucke Zeile 1 des Buchstaben
	move.b	(a2)+,40(a3)	; Drucke Zeile 2  "	"
	move.b	(a2)+,40*2(a3)	; Drucke Zeile 3  "	"
	move.b	(a2)+,40*3(a3)	; Drucke Zeile 4  "	"
	move.b	(a2)+,40*4(a3)	; Drucke Zeile 5  "	"
	move.b	(a2)+,40*5(a3)	; Drucke Zeile 6  "	"
	move.b	(a2)+,40*6(a3)	; Drucke Zeile 7  "	"
	move.b	(a2)+,40*7(a3)	; Drucke Zeile 8  "	"

	addq.w	#1,a3			; a3+1, wir gehen um 8 Bit weiter (zum
							; nchsten Buchstaben

	dbra	d0,PrintChar2	; DRUCKEN d0 (40) ZEICHEN PRO ZEILE
 
	add.w	#40*7,a3		; "Return", neue Zeile

	dbra	d3,PrintZeile	; Wir drucken d3 Zeilen
	rts


Text:
             ;            1111111111222222222233333333334
             ;   1234567890123456789012345678901234567890
	dc.b	'   ERSTE ZEILE                          ' ; 1
	dc.b	'                ZWEITE ZEILE            ' ; 2
	dc.b	'     /\  /                              ' ; 3
	dc.b	'    /  \/                               ' ; 4
	dc.b	'                                        ' ; 5
	dc.b	'        SECHSTE ZEILE                   ' ; 6
	dc.b	'                                        ' ; 7
	dc.b	'                                        ' ; 8
	dc.b	'FABIO CIUCCI COMMUNICATION INTERNATIONAL' ; 9
	dc.b	'                                        ' ; 10
	dc.b	'   1234567890 !@#$%^&*()_+|\=-[]{}      ' ; 11
	dc.b	'                                        ' ; 12
	dc.b	'   PREISFRAGE: WER KENNT DEN AUTOR?     ' ; 15
	dc.b	'                                        ' ; 25
	dc.b	'                                        ' ; 16
	dc.b	'  Das Fraeulein stand am Meere          ' ; 17
	dc.b	'                                        ' ; 18
	dc.b	'  Und seufzte lang und bang.            ' ; 19
	dc.b	'                                        ' ; 20
	dc.b	'  Es RueHrtE sIe sO sEhRe               ' ; 21
	dc.b	'                                        ' ; 22
	dc.b	'  der Sonnenuntergang.                  ' ; 23
	dc.b	'                                        ' ; 24
	dc.b	'        ...                             ' ; 25
	dc.b	'                                        ' ; 26
	dc.b	'                                        ' ; 27

	even



	SECTION GRAPHIC,DATA_C

Copperlist:
	dc.w	$120,$0000,$122,$0000,$124,$0000,$126,$0000,$128,$0000 ; SPRITE
	dc.w	$12a,$0000,$12c,$0000,$12e,$0000,$130,$0000,$132,$0000
	dc.w	$134,$0000,$136,$0000,$138,$0000,$13a,$0000,$13c,$0000
	dc.w	$13e,$0000

	dc.w	$8e,$2c81		; DiwStrt
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$0038		; DdfStart
	dc.w	$94,$00d0		; DdfStop
	dc.w	$102,0			; BplCon1
	dc.w	$104,0			; BplCon2
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod
				; 5432109876543210
	dc.w	$100,%0001001000000000  ; 1 Bitplane LOWRES 320x256

Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste Bitplane

	dc.w	$0180,$000		; color0 - HINTERGRUND
	dc.w	$0182,$19a		; color1 - SCHRIFTEN

	dc.w	$6c07,$fffe		; Farbverlauf auf Textzeile 9
	dc.w	$182,$451		; Zeile1 des Charakters
	dc.w	$6d07,$fffe
	dc.w	$182,$671		; Zeile 2
	dc.w	$6e07,$fffe
	dc.w	$182,$891		; Zeile 3
	dc.w	$6f07,$fffe
	dc.w	$182,$ab1		; Zeile 4
	dc.w	$7007,$fffe
	dc.w	$182,$781		; Zeile 5
	dc.w	$7107,$fffe
	dc.w	$182,$561		; Zeile 6
	dc.w	$7207,$fffe
	dc.w	$182,$451		; Zeile 7  die letzte, weil die achte auf
							;  NULL steht, um einen Abstand zwischen
							;  den Buchstaben zu lassen

	dc.w	$7307,$fffe
	dc.w	$182,$19a		; Normale Farbe

	dc.w	$8c07,$fffe		; Farbverlauf auf Textzeile 11
	dc.w	$182,$516		; Zeile1 des Buchstaben
	dc.w	$8d07,$fffe
	dc.w	$182,$739		; Zeile 2
	dc.w	$8e07,$fffe
	dc.w	$182,$95b		; Zeile 3
	dc.w	$8f07,$fffe
	dc.w	$182,$c6f		; Zeile 4
	dc.w	$9007,$fffe
	dc.w	$182,$84a		; Zeile 5
	dc.w	$9107,$fffe
	dc.w	$182,$739		; Zeile 6
	dc.w	$9207,$fffe
	dc.w	$182,$517		; Zeile 7  die letzte, weil die achte auf NULL

	dc.w	$9307,$fffe
	dc.w	$182,$19a		; Normale Farbe

	dc.w	$ffff,$fffe		; Ende der Copperlist

;	Der Font, Charakter 8x8

Font:
;	incbin	"/Sources/metal.fnt"	; breite Charakter
;	incbin	"/Sources/normal.fnt"	; hnlich den Kickstart 1.3 Fonts
	incbin	"/Sources/nice.fnt"	; schmale Charakter

	SECTION MEIPLANE,BSS_C	; Die SECTION BSS knnen nur aus NULLEN
							; bestehen!!! Man verwendet das DS.B um zu
							; definieren, wieviele Nullen die Section
							; enthalten soll

Bitplane:
	ds.b	40*256			; ein Bitplane LowRes 320x256

	end

Wie ihr gesehen habt,ist der Umstand, da der Font nur in einer Farbe ist, noch
lange kein Grund, um nicht mit dem Copper etwas Farbe ins Spiel zu bringen!

Um mehrere Zeilen  zu  schreiben,  mu  man  nur "Zeile-wechseln" und dann die
nchste auf den Schirm pulvern! Das wiederholt sich d3 Mal.

	add.w	#40*7,a3		; "RETURN"
	dbra	d3,PrintZeile	; MACHEN d3 ZEILEN

Bemerkung: Um eine neue Zeile zu nehmen, also "RETURN", mu man 7 Zeilen  nach
unten  gehen. Mit neuer  Zeile  meinte ich TEXTZEILE, 8 Pixel hoch, die andere
Zeile war die effektive VideoZeile.

Darum braucht es ein "add.w #40*7,a3" fr ein RETURN:

Das Probelm besteht darin, da man den Eindruck haben knnte, man befinde sich
mit a3 schon auf der untersten V-Zeile des zuletzt gedruckten Buchstaben,und es
reiche, eine einzige nach unten zu gehen, um sich in die nchsten  Textzeile zu
begeben. Aber in a3 ist und bleibt immer nur die Adresse der ersten V-Zeile des
Charakters, denn die weiteren 7 werden ja mittels OFFSET erzeugt:

	move.b	(a2)+,(a3)		; Drucke Zeile 1 des Buchstaben
	move.b	(a2)+,40(a3)	; Drucke Zeile 2  "	"
	move.b	(a2)+,40*2(a3)	; Drucke Zeile 3  "	"
	move.b	(a2)+,40*3(a3)	; Drucke Zeile 4  "	"
	move.b	(a2)+,40*4(a3)	; Drucke Zeile 5  "	"
	move.b	(a2)+,40*5(a3)	; Drucke Zeile 6  "	"
	move.b	(a2)+,40*6(a3)	; Drucke Zeile 7  "	"
	move.b	(a2)+,40*7(a3)	; Drucke Zeile 8  "	"

Aber in Register  a3  steht immer die Adresse der ersten Zeile. Denn jedesmal,
wenn ein Buchstabe gedruckt wird, dann begeben wir uns zum nchsten  Charakter,
indem wir 8  Bit, also ein Byte, zur Adresse in a3 dazuzhlen. Diese wird dann
auf die erste (Video)Zeile dieses Buchstaben pointen.

	addq.w	#1,a3			; a3+1, wir gehen um 8 Bit weiter (zum
							; nchsten Buchstaben

An diesem Punkt, um den "nchsten Charakter" zu drucken, braucht  man  nur  die
Routine mit  den  Offsets zu wiederholen. Schauen wir die Situation genauer an,
wenn wir den Buchstaben ganz rechts  gedruckt  haben,  also den  letzten  einer
T-Zeile: in a3 haben wir die Adresse des letzten Buchstaben,und nach den ganzen
Offsets kommt die Anweisung zum  Zuge,  die  a3  um  8  Bit weitersetzt.  Damit
befinden wir uns aber schon in der nchsten V-Zeile, aber ganz links,weil es ja
"zu weit" gerutscht ist! Deswegen brauchen wir nur 7 -und nicht 8- dazuzhlen,
weil  wir uns ja schon auf der "zweiten" VideoZeile nach der gerade gedruckten
Textzeile befinden.

