
; Listing5m2.s	"SCHLIESSEN"  DES VIDEOFENSTERS MIT DEN DIWSTART/STOP ($8e/$90)

	SECTION  CIPundCOP,CODE

Anfang:
	move.l	4.w,a6			; Execbase in a6
	jsr	-$78(a6)			; Disable - stoppt das Multitasking
	lea	GfxName(PC),a1		; Adresse des Namen der zu ffnenden Library
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase		; speichere diese Adresse in GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop	; hier speichern wir die Adresse der Copperlist
							; des Betriebssystemes (immer auf $26 nach GfxBase)

;	POINTEN AUF UNSERE BITPLANES

	move.l	#Pic,d0			; in d0 kommt die Adresse von unserem Bild
	lea Bplpointers,a1		; in a1 kommt die Adresse der Bitplane-
							; Pointer der Copperlist
	moveq	#2,d1			; Anzahl der Bitplanes -1 (hier sind es 3)
							; fr den dbra - Zyklus

PointBp:
	move.w	d0,6(a1)		; kopiert das niederwertige Word der Plane-
							; Adresse ins richtige Word der Copperlist
	swap	d0				; vertauscht die 2 Word in d0 (1234 > 3412)

	move.w	d0,2(a1)		; kopiert das hochwertige Word der Adresse des 
							; Plane in das richtige Word in der Copperlist
	swap	d0				; vertauscht erneut die 2 Word von d0
	add.l	#40*256,d0		; Zhlen 10240 zu d0 dazu, -> nchstes Plane

	addq.w	#8,a1			; zu den nchsten Bplpointers in der Cop
	dbra	d1,PointBp		; Wiederhole d1 mal PointBp (d1=n. bitplanes)

	move.l	#Copperlist,$dff080	; COP1LC - "Zeiger" auf unsere COP
	move.w	d0,$dff088		; COPJMP1 - Starten unsere COP
	move.w	#0,$dff1fc		; FMODE - Deaktiviert das AGA
	move.w	#$c00,$dff106	; BPLCON3 - Deaktiviert das AGA

Mouse:
	cmpi.b	#$ff,$dff006	; Sind wir auf Zeile 255?
	bne.s	Mouse			; Wenn nicht, geh noch nicht weiter

	btst	#2,$dff016		; wenn die rechte Maustaste gerdckt ist, dann
	beq.s	Warte			; berspringe die Scrollroutine (blockiert)

	bsr.w	DiwHorizontal	; Zeigt die Funktion des DIWSTART und DIWSTOP
	bsr.w	DiwVertikal		; 

Warte:
	cmpi.b	#$ff,$dff006	; Sind wir auf Zeile 255?
	beq.s	Warte			; Wenn ja, geh nicht weiter, warte!

	btst	#6,$bfe001		; linke Maustaste gedrckt?
	bne.s	Mouse			; wenn nicht, zurck zu Mouse:

	move.l	OldCop(PC),$dff080	; Pointen auf die SystemCOP
	move.w	d0,$dff088		; starten die alte COP


	move.l	4.w,a6
	jsr	-$7e(a6)			; Enable - stellt Multitasking wieder her
	move.l	GfxBase(PC),a1	; Basis der Library, die es zu schlieen gilt
							; (Libraries werden geffnet UND geschlossen!)
	jsr	-$19e(a6)			; Closelibrary - schliet die Graphics lib
	rts
 
; DATEN


GfxName:
	dc.b	"graphics.library",0,0

GfxBase:		; Hier hinein kommt die Basisadresse der graphics.lib,
	dc.l	0	; ab hier werden die Offsets gemacht

OldCop:			; Hier hinein kommt die Adresse der Orginal-Copperlist
	dc.l	0	; des Betriebssystemes



DiwHorizontal:
	cmpi.b	#$ff,DiwXStart	; Sind wir bei maximal DIWSTART angekommen?
	beq.s	Ende			; wenn ja, dann knnen wir nicht weiter
	addq.b	#2,DiwXStart	; wenn nicht, dann zhl 1 dazu
Ende:
	tst.b	DiwXStop		; Sind wir beim Minimum von DIWSTOP? ($00)?
	beq.s	Ende2			; wenn ja knnen wir nicht noch mehr abziehen
	subq.b	#2,DiwXStop		; wenn nicht, 1 wegzhlen
Ende2:
	rts						; Ende der Routine, Ausstieg


DiwVertikal:
	cmpi.b	#$95,DiwYStop	; Sind wir beim richtigen DIWSTOP angekommen?
	beq.s	Ende3			; wenn ja, brauchen wir nicht weitergehen
	addq.b	#1,DiwYStart	; zhlen 1 zum Start dazu
	subq.b	#1,DiwYStop		; ziehen 1 vom Stop ab
Ende3:
	rts						; Raus aus der Routine

	SECTION	GRAPHIC,DATA_C

Copperlist:
	dc.w	$120,$0000,$122,$0000,$124,$0000,$126,$0000,$128,$0000 ; SPRITE
	dc.w	$12a,$0000,$12c,$0000,$12e,$0000,$130,$0000,$132,$0000
	dc.w	$134,$0000,$136,$0000,$138,$0000,$13a,$0000,$13c,$0000
	dc.w	$13e,$0000

	dc.w	$8E				; DIWSTART - Anfang Videofenster
DiwYStart:
	dc.b	$2c				; DIWSTRT $YY
DiwXStart:
	dc.b	$81				; DIWSTRT $XX (erhhen es bis $ff)

	dc.w	$90				; DIWSTOP - Ende des Videofensters
DiwYStop:
	dc.b	$fe				; DiwStop YY
DiwXStop:
	dc.b	$c1				; DiwStop XX (verringern es bis $00)
	dc.w	$92,$0038		; DdfStart
	dc.w	$94,$00d0		; DdfStop
	dc.w	$102,0			; BplCon1
	dc.w	$104,0			; BplCon2
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod

				; 5432109876543210
	dc.w	$100,%0011001000000000	; Bits 13 und 12 an!! (3 = %011)
									; 3 Bitplanes Lowres, nicht Lace
Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste	 Bitplane
	dc.w	$e4,$0000,$e6,$0000	; zweite Bitplane
	dc.w	$e8,$0000,$ea,$0000	; dritte Bitplane

	dc.w	$0180,$000		; color0
	dc.w	$0182,$475		; color1
	dc.w	$0184,$fff		; color2
	dc.w	$0186,$ccc		; color3
	dc.w	$0188,$999		; color4
	dc.w	$018a,$232		; color5
	dc.w	$018c,$777		; color6
	dc.w	$018e,$444		; color7

	dc.w	$ca07,$fffe
	dc.w	$180,$456		; Bemerke: Die Hintergrundfarbe wird vom
							; Diwstart-Diwstop nicht beeinflut

	dc.w	$ffff,$fffe		; Ende der Copperlist

;	Bild

Pic:
	incbin	"/Sources/Amiga_320_256_3.raw"
							; hier laden wir das Bild im RAW-Format
							; das wir zuvor mit dem
							; Kefcon konvertiert haben

	end

In diesem Listing wurden sowohl die XX als auch die YY der DIWSTART und
DIWSTOP verndert, um das Bild zu erwrgen.

