
; Listing5h.s	HORIZONTALE WELLENBEWEGUNG EINES BILDES MIT DEM $dff102

	SECTION	CIPundCOP,CODE

Anfang:
	move.l	4.w,a6			; Execbase in a6
	jsr	-$78(a6)			; Disable - stoppt das Multitasking
	lea	GfxName(PC),a1		; Adresse des Namen der zu ffnenden Lib in a1
	jsr	-$198(a6)			; OpenLibrary
	move.l	d0,GfxBase		; speichere diese Adresse in GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop	; hier speichern wir die Adresse der Copperlist
							; des Betriebssystemes

;	POINTEN AUF UNSERE BITPLANES

	move.l	#Pic,d0			; in d0 kommt die Adresse von unserem Bild
	lea Bplpointers,a1		; in a1 kommt die Adresse der Bitplane-
							; Pointer der Copperlist
	moveq	#2,d1			; Anzahl der Bitplanes -1 (hier sind es 3)
							; fr den dbra - Zyklus
PointBp:
	move.w	d0,6(a1)		; kopiert das niederwertige Word der Plane-
							; Adresse ins richtige Word der Copperlist
	swap	d0				; vertauscht die 2 Word in d0 (1234 > 3412)

	move.w	d0,2(a1)		; kopiert das hochwertige Word der Adresse des 
							; Plane in das richtige Word in der Copperlist
	swap	d0				; vertauscht erneut die 2 Word von d0
	add.l	#40*256,d0		; Zhlen 10240 zu d0 dazu, -> nchstes Plane

	addq.w	#8,a1			; zu den nchsten Bplpointers in der Cop
	dbra	d1,PointBp		; Wiederhole d1 mal PointBp (d1=n. bitplanes)

	move.l	#Copperlist,$dff080	; COP1LC - "Zeiger" auf unsere COP
	move.w	d0,$dff088		; COPJMP1 - Starten unsere COP
	move.w	#0,$dff1fc		; FMODE - Deaktiviert das AGA
	move.w	#$c00,$dff106	; BPLCON3 - Deaktiviert das AGA

Mouse:
	cmpi.b	#$ff,$dff006	; Sind wir auf Zeile 255?
	bne.s	Mouse			; Wenn nicht, geh nicht weiter

	btst	#2,$dff016		; wenn die rechte Maustaste gedrckt ist,
	beq.s	Warte			; berspringe die Routine

	bsr.s	Wellen			; Bringt das Bild in Wellenbewegung

Warte:
	cmpi.b	#$ff,$dff006	; Sind wir auf Zeile 255?
	beq.s	Warte			; Wenn nicht, geh nicht weiter

	btst	#6,$bfe001		; linke Maustaste gedrckt?
	bne.s	Mouse			; wenn nicht, zurck zu Mouse:

	move.l	OldCop(PC),$dff080	; COP1LC - "Zeiger" auf die Orginal-COP
	move.w	d0,$dff088		; COPJMP1 - und starten sie

	move.l	4.w,a6
	jsr	-$7e(a6)			; Enable - stellt Multitasking wieder her
	move.l	GfxBase(PC),a1	; Basis der Library, die es zu schlieen gilt
							; (Libraries werden geffnet UND geschlossen!)
	jsr	-$19e(a6)			; Closelibrary - schliet die Graphics lib
	rts

; DATEN


GfxName:
	dc.b	"graphics.library",0,0	

GfxBase:		; Hier hinein kommt die Basisadresse der graphics.lib,
	dc.l	0	; ab hier werden die Offsets gemacht

OldCop:			; Hier hinein kommt die Adresse der Orginal-Copperlist des
	dc.l	0	; Betriebssystemes


; Diese Routine ist hnlich mit der in Listing3e.s, die Werte werden wie in
; einer Kette vertauscht. Ich erinnere euch das System:
;
;	move.w	col2,col1		; col2 kommt in col1
;	move.w	col3,col2		; col3 kommt in col2
;	move.w	col4,col3		; col4 kommt in col3
;	move.w	col5,col4		; col5 kommt in col4
;
; In dieser Routine werden aber anstatt der Farben die Werte des $dff102
; kopiert, aber die grundstzliche funktionsweise der Routine ist die gleiche.
; Um LABEL und Zeit zu sparen wurde diese Routine mit einem dbra-Zyklus
; ausgestattet, der die Rotation sovieler Word vornimmt, wie wir wollen: da
; die zu ndernden Word alle 8 Byte entfernt sind, brauchen wir nur eines
; in a0 zu geben, das andere in a1 und dann mit einem move.w (a0),(a1) zu
; kopieren. Dann schreiten wir zum nchsten Paar ber, indem wir zu a0 und a1
; 8 dazuzhlen, sie werden dann auf die nchsten Word pointen.
; Achtung: um einen unendlichen Zyklus zu machen, mu der letzte Wert immer
; in den errsten geschrieben werden:
;
;	>>>>>>>>>>>>>>>>>>>>>
;	^		    v
; In diesem Fall wir am Ende des Zyklus immer der erste Wert in den letzten
; geschrieben, der Zuflu ist also konstant. Die alte Routine endete so:
;	move.w	col1,col14		; col1 kommt in col14

Wellen:
	lea	Con1Effekt+8,a0		; Adresse Quellword in a0
	lea	Con1Effekt,a1		; Adresse Zielword in a1
	moveq	#44,d2			; 45 BPLCON1 sind in COPLIST zu ndern
Vertausche:
	move.w	(a0),(a1)		; kopiert zwei Word - scroll!
	addq.w	#8,a0			; nchstes Word-Paar
	addq.w	#8,a1			; nchstes Word-Paar
	dbra	d2,Vertausche	; wiederhole "Vertausche" die richtige
							; Anzahl mal
	move.w	Con1Effekt,LetzterWert	; um den Zyklus unendlich fortlaufen zu
	rts						; lassen kopieren wir den ersten Wert
							; jedesmal in den Letzten.


	SECTION GRAPHIC,DATA_C


Copperlist:
	dc.w	$120,$0000,$122,$0000,$124,$0000,$126,$0000,$128,$0000 ; SPRITE
	dc.w	$12a,$0000,$12c,$0000,$12e,$0000,$130,$0000,$132,$0000
	dc.w	$134,$0000,$136,$0000,$138,$0000,$13a,$0000,$13c,$0000
	dc.w	$13e,$0000

	dc.w	$8e,$2c81		; DiwStrt	(Register mit Standartwerten)
	dc.w	$90,$2cc1		; DiwStop
	dc.w	$92,$0038		; DdfStart
	dc.w	$94,$00d0		; DdfStop
	
	dc.w	$102			; BplCon1 - DAS REGISTER
	dc.b	$00				; BplCon1 - DAS NICHT VERWENDETE BYTE!!!
MeinCon1:
	dc.b	$00				; BplCon1 - DAS VERWENDETE BYTE!!!

	dc.w	$104,0			; BplCon2
	dc.w	$108,0			; Bpl1Mod
	dc.w	$10a,0			; Bpl2Mod

				; 5432109876543210  ; BPLCON0:
	dc.w	$100,%0011001000000000  ; Bits 13 und 12 an!! (3 = %011)
									; 3 Bitplanes Lowres, nicht Lace
Bplpointers:
	dc.w	$e0,$0000,$e2,$0000	; erste  Bitplane - BPL0PT
	dc.w	$e4,$0000,$e6,$0000	; zweite Bitplane - BPL1PT
	dc.w	$e8,$0000,$ea,$0000	; dritte Bitplane - BPL2PT

	dc.w	$0180,$000		; Color0
	dc.w	$0182,$475		; Color1
	dc.w	$0184,$fff		; Color2
	dc.w	$0186,$ccc		; Color3
	dc.w	$0188,$999		; Color4
	dc.w	$018a,$232		; Color5
	dc.w	$018c,$777		; Color6
	dc.w	$018e,$444		; Color7

; Der Effekt in der Copperlist: er besteht aus einem Wait und einem
; BPLCON1, die Wait stehen alle 4 Zeilen: $34, $38, $3c...
; In den $dff102 sind schon die "Wellenwerte" enthalten: 1,2,3,4,...3,2,1.

	dc.w	$3007,$fffe,$102
Con1Effekt:
	dc.w	$00
	dc.w	$3407,$fffe,$102,$00
	dc.w	$3807,$fffe,$102,$00
	dc.w	$3c07,$fffe,$102,$11
	dc.w	$4007,$fffe,$102,$11
	dc.w	$4407,$fffe,$102,$11
	dc.w	$4807,$fffe,$102,$11
	dc.w	$4c07,$fffe,$102,$22
	dc.w	$5007,$fffe,$102,$22
	dc.w	$5407,$fffe,$102,$22
	dc.w	$5807,$fffe,$102,$33
	dc.w	$5c07,$fffe,$102,$33
	dc.w	$6007,$fffe,$102,$44
	dc.w	$6407,$fffe,$102,$44
	dc.w	$6807,$fffe,$102,$55
	dc.w	$6c07,$fffe,$102,$66
	dc.w	$7007,$fffe,$102,$77
	dc.w	$7407,$fffe,$102,$88
	dc.w	$7807,$fffe,$102,$88
	dc.w	$7c07,$fffe,$102,$99
	dc.w	$8007,$fffe,$102,$99
	dc.w	$8407,$fffe,$102,$aa
	dc.w	$8807,$fffe,$102,$aa
	dc.w	$8c07,$fffe,$102,$aa
	dc.w	$9007,$fffe,$102,$99
	dc.w	$9407,$fffe,$102,$99
	dc.w	$9807,$fffe,$102,$88
	dc.w	$9c07,$fffe,$102,$88
	dc.w	$a007,$fffe,$102,$77
	dc.w	$a407,$fffe,$102,$66
	dc.w	$a807,$fffe,$102,$55
	dc.w	$ac07,$fffe,$102,$44
	dc.w	$b007,$fffe,$102,$44
	dc.w	$b407,$fffe,$102,$33
	dc.w	$b807,$fffe,$102,$33
	dc.w	$bc07,$fffe,$102,$22
	dc.w	$c007,$fffe,$102,$22
	dc.w	$c407,$fffe,$102,$22
	dc.w	$c807,$fffe,$102,$11
	dc.w	$cc07,$fffe,$102,$11
	dc.w	$d007,$fffe,$102,$11
	dc.w	$d407,$fffe,$102,$11
	dc.w	$d807,$fffe,$102,$00
	dc.w	$dc07,$fffe,$102,$00
	dc.w	$e007,$fffe,$102,$00
	dc.w	$e407,$fffe,$102

LetzterWert:
	dc.w	$00

	dc.w	$ffff,$fffe		; Ende der Copperlist

;	BILD


Pic:
	incbin	"/Sources/Amiga_320_256_3.raw"
							; hier laden wir das Bild im RAW-Format

	end

Dieser  Welleneffekt  ist  ein Klassiker der Amiga. Um zu Sparen wird hier
nicht bei jeder Zeile eine Welle erzeugt, sondern nur alle 4 Zeilen,  aber
mindestens  ist  die  Routine  schnell,  die die $dff102 in der Copperlist
durchluft.

Die Routine in diesem Listing kann berall dort verwendet werden  wo  Word
"rotiert"  werden  men,  also  knnte  sie  euch  bei  Farbeffekten  und
hnlichem dienen.

