
; Listing3d.s	; BALKEN, DER RAUF-UND RUNTERGEHT, ERSTELLT MIT MOVE & WAIT
				; DES COPPERS

;	In diesem Listing wird ein Label als FLAG verwendet, also als
;	Signal, ob unser Balken steigen oder sinken mu. Analysiert
;	dieses Programm sehr genau, es ist das erste im Kurs, das
;	Probleme im Bereich der bedingten Sprnge/Schleifen bereiten
;	kann.

	SECTION CIPundCOP,CODE	; auch Fast ist	OK

Anfang:
	move.l	4.w,a6			; Execbase in a6
	jsr	-$78(a6)			; Disable - stoppt das Multitasking
	lea	GfxName,a1			; Adresse des Namen der zu ffnenden Library in a1
	jsr	-$198(a6)			; OpenLibrary, Routine der EXEC, die Libraris
							; ffnet, und als Resultat in d0 die Basisadresse
							; derselben Bibliothek liefert, ab welcher
							; die Offsets (Distanzen) zu machen sind
	move.l	d0,GfxBase		; speichere diese Adresse in GfxBase
	move.l	d0,a6
	move.l	$26(a6),OldCop	; hier speichern wir die Adresse der Copperlist
							; des Betriebssystemes
	move.l	#Copperlist,$dff080  ; COP1LC - "Zeiger" auf unsere COP
							; (deren Adresse)
	move.w	d0,$dff088	    ; COPJMP1 - Starten unsere COP
Mouse:	
	cmpi.b	#$ff,$dff006	; VHPOSR - sind wir bei Zeile 255 angekommen?
	bne.s	Mouse			; Wenn nicht, geh nicht weiter

	bsr.s	BewegeCopper	; Diese Subroutine lt das WAIT sinken!
							; Sie wird einmal pro Frame ausgefhrt.
							
Warte:
	cmpi.b	#$ff,$dff006	; VHPOSR:
							; Sind wir noch auf $ff? Wenn ja, warte auf die
	beq.s	Warte			; nchste Zeile (00). Ansonsten wird BewegeCopper


	btst	#6,$bfe001		; linke Maustaste gedrckt?
	bne.s	Mouse			; wenn nicht, zurck zu mouse:

	move.l	OldCop(PC),$dff080	; COP1LC - "Zeiger" auf die Orginal-COP
	move.w	d0,$dff088		; COPJMP1 - und starten sie

	move.l	4.w,a6
	jsr	-$7e(a6)			; Enable - stellt Multitasking wieder her
	move.l	GfxBase(PC),a1	; Basis der Library, die es zu schlieen gilt
							; (Libraries werden geffnet UND geschlossen!!)
	jsr	-$19e(a6)			; Closelibrary - schliet die Graphics lib
	rts


BewegeCopper:
	lea	Balken,a0			; in a0 kommt die Adresse von Balken
	txt.b	RaufRunter		; men wir steigen oder sinken? Wenn RaufRunter
							; auf 0 steht (wenn TST also BEQ liefert), dann
						    ; springen wir auf GehRunter, wenn es hingegen
						    ; auf $ff ist (TST also nicht eintrifft), fahren
	beq.w	GehRunter		; wir fort und fhren somit den "steigenden" Teil
							; aus
	
	cmpi.b	#$82,8*9(a0)	; sind wir bei Zeile $82 angekommen?
	beq.s	SetzRunter		; wenn ja, sind wir oben angekommen und
	subq.b	#1,(a0)			; men runter
	subq.b	#1,8(a0)		;
	subq.b	#1,8*2(a0)		; nun ndern wir die anderen Wait: der
	subq.b	#1,8*3(a0)		; Abstand zwischen einem und dem anderen betrgt
	subq.b	#1,8*4(a0)		; 8 Byte
	subq.b	#1,8*5(a0)
	subq.b	#1,8*6(a0)
	subq.b	#1,8*7(a0)		; hier men wir alle 9 Wait des roten Balken
	subq.b	#1,8*8(a0)		; ndern, wenn wir ihn steigen und sinken lassen
	subq.b	#1,8*9(a0)		; wollen.
	rts


SetzRunter:
	clr.b	RaufRunter		; Setzt RaufRunter auf 0, beim TST.B RaufRunter
	rts						; wird das BEQ zu Routine GehRunter verzweigen,
							; und der Balken wird sinken


GehRunter:
	cmpi.b	#$fc,8*9(a0)	; sind wir bei Zeile $fc angekommen?
	beq.s	SetzRauf		; wenn ja, sind wir unten und men wieder
	addq.b	#1,(a0)			; steigen
	addq.b	#1,8(a0)
	addq.b	#1,8*2(a0)		; nun ndern wir die anderen Wait: der
	addq.b	#1,8*3(a0)		; Abstand zwischen einem und dem anderen betrgt
	addq.b	#1,8*4(a0)		; 8 Byte
	addq.b	#1,8*5(a0)
	addq.b	#1,8*6(a0)
	addq.b	#1,8*7(a0)		; hier men wir alle 9 Wait des roten Balken
	addq.b	#1,8*8(a0)		; ndern, wenn wir ihn steigen und sinken lassen
	addq.b	#1,8*9(a0)		; wollen.
	rts

SetzRauf:
	move.b	#$ff,RaufRunter ; Wenn das Label nicht auf NULL ist,
	rts						; bedeutet es, da wir steigen men


; Dieses Byte, das von dem Label RaufRunter markiert ist, ist ein FLAG,
; also eine "Fahne" (man kann es sich so vorstellen), einmal ist sie
; auf $ff, ein anderes Mal auf $00, je nachdem ob wir steigen oder sinken
; men! Es ist wie eine Flagge, denn wenn sie unten ist ($00) bedeutet
; es, da wir runter men, wenn sie gehit ist ($ff), dann men wir
; rauf. Es wird eine Kontrolle gemacht, auf welcher Zeile wir uns
; befinden, und verglichen, ob wir oben oder unter angelangt sind. Ist
; das der Fall, dann sagt uns das Flag, welche Richtung wir danach
; einschlagen men, und dann ndern wir ihren Zustand mit clr.b RaufRunter
; oder move.b #$ff,RaufRunter.

;	DATEN...

RaufRunter:
	dc.b	0,0

GfxName:
	dc.b	"graphics.library",0,0	; Bemerkung: um Charakter in den
							; Speicher zu geben, verwenden wir
							; immer das dc.b und setzen sie
							; unter "" oder , Abschlu mit ,0


GfxBase:	    ; Hier hinein kommt die Basisadresse der graphics.library,
	dc.l	0   ; ab hier werden die Offsets gemacht



OldCop:		    ; Hier hinein kommt die Adresse der Orginal-Copperlist des
	dc.l	0   ; Betriebssystemes


	SECTION GRAPHIC,DATA_C	; Dieser Befehl veranlat das Betriebssystem,
							; das folgende Datensegment in die CHIP-RAM
							; zu laden, obligatorisch.
							; Die Copperlist MSSEN in die CHIP RAM!
Copperlist:
	dc.w	$100,$200		; BPLCON0
	dc.w	$180,$000		; COLOR0 - Beginne die COP mit SCHWARZ
	dc.w	$4907,$fffe		; WAIT - Warte auf Zeile $49 (73)
	dc.w	$180,$001		; COLOR0 - sehr dunkles Blau
	dc.w	$4a07,$fffe		; WAIT - Zeile 74 ($4a)
	dc.w	$180,$002		; ein bichen helleres Blau
	dc.w	$4b07,$fffe		; Zeile 75 ($4b)
	dc.w	$180,$003		; helleres  Blau
	dc.w	$4c07,$fffe		; nchste Zeile
	dc.w	$180,$004		; helleres  Blau
	dc.w	$4d07,$fffe		; nchste Zeile
	dc.w	$180,$005		; helleres  Blau
	dc.w	$4e07,$fffe		; nchste Zeile
	dc.w	$180,$006		; Blau auf 6
	dc.w	$5007,$fffe		; berspringe 2 Zeilen:
							; von $4e bis $50, also von 78 bis 80
	dc.w	$180,$007		; Blau auf 7
	dc.w	$5207,$fffe		; berspringe 2 Zeilen
	dc.w	$180,$008		; Blau auf 8
	dc.w	$5507,$fffe		; berspringe 3 Zeilen
	dc.w	$180,$009		; Blau auf 9
	dc.w	$5807,$fffe		; berspringe 3 Zeilen
	dc.w	$180,$00a		; Blau auf 10
	dc.w	$5b07,$fffe		; berspringe 3 Zeilen
	dc.w	$180,$00b		; Blau auf 11
	dc.w	$5e07,$fffe		; berspringe 3 Zeilen
	dc.w	$180,$00c		; Blau auf 12
	dc.w	$6207,$fffe		; berspringe 4 Zeilen
	dc.w	$180,$00d		; Blau auf 13
	dc.w	$6707,$fffe		; berspringe 5 Zeilen
	dc.w	$180,$00e		; Blau auf 14
	dc.w	$6d07,$fffe		; berspringe 6 Zeilen
	dc.w	$180,$00f		; Blau auf 15
	dc.w	$780f,$fffe		; Zeile $78
	dc.w	$180,$000		; Farbe SCHWARZ

Balken:
	dc.w	$7907,$fffe		; Warte auf Zeile $79
	dc.w	$180,$300		; Beginne den roten Balken: Rot auf3
	dc.w	$7a07,$fffe		; nchste Zeile
	dc.w	$180,$600		; Rot auf 6
	dc.w	$7b07,$fffe
	dc.w	$180,$900		; Rot auf 9
	dc.w	$7c07,$fffe
	dc.w	$180,$c00		; Rot auf 12
	dc.w	$7d07,$fffe
	dc.w	$180,$f00		; Rot auf 15 (Maximum)
	dc.w	$7e07,$fffe
	dc.w	$180,$c00		; Rot auf 12
	dc.w	$7f07,$fffe
	dc.w	$180,$900		; Rot auf 9
	dc.w	$8007,$fffe
	dc.w	$180,$600		; Rot auf 6
	dc.w	$8107,$fffe
	dc.w	$180,$300		; Rot auf 3
	dc.w	$8207,$fffe
	dc.w	$180,$000		; Farbe SCHWARZ

	dc.w	$fd07,$fffe		; Warte auf Zeile $fd
	dc.w	$180,$00a		; Blau Intensitt 10
	dc.w	$fe07,$fffe		; nchste Zeile
	dc.w	$180,$00f		; Blau maximale Helligkeit (15)
	dc.w	$ffff,$fffe		; Ende der Copperlist


	end

Jetzt geht der Balken rauf und runter. Geholfen hat uns dabei  ein  Label,
das  uns mitteilt, welche Richtung wir einschlagen muten: wenn RaufRunter
NULL ist, dann werden die Befehle ausgefhrt, die den  Balken  zum  sinken
bringen,  umgekehrt,  wenn  es  auf  $FF  stand,  dann wurde die Serie von
Anweisungen ausgefhrt, die den Balken zum steigen stimulieren. Am  Anfang
ist das Label auf 0, also werden die ADDQ durchgefhrt, die den Balken zum
sinken bringen, bis, einmal unten angekommen, das Label umgeschrieben wird
(es kommt ein $FF rein), und deswegen beim TST.B RaufRunter jetzt die SUBQ
angesprungen  werden,  die  ihn  zum  steigen  bringen.  Am  oberen   Ende
angekommen  kommt  wieder 0 ins FLAG RaufRunter, und das Spielchen beginnt
von vorne. Mit dieser Routine knnen auf einfache Weise  die  Effekte  der
nderungen  getestet  werden: Probiert einen ; vor den Befehlen zu setzen,
die die Zeile $FF mittels $dff006 abwarten:

mouse:	
	cmpi.b	#$ff,$dff006	; VHPOSR - sind wir bei Zeile 255 angekommen?
;	bne.s	mouse			; Wenn nicht, geh nicht weiter
	...

	bsr.s	BewegeCopper	; Diese Subroutine lt das WAIT sinken!
							; Sie wird einmal pro Frame ausgefhrt.
Warte:
	cmpi.b	#$ff,$dff006	; VHPOSR
;	beq.s	Warte

Jetzt verlieren wir das Timing mit dem Bildschirm, und der  Balken  spielt
verrckt,  versucht  es mal so auszufhren! Habt ihrs gesehen, ihr hattet
nicht mal die Zeit, die Bewegung zu sehen! Vor allem, wenn ihr einen A1200
oder  einen  anderen  schnellen  Computer  habt. Nun lassen wir den Balken
langsamer  laufen,  und  zwar  dadurch,  da  wir  die  Routine,  die  ihn
steigen/sinken  lt,  nur einmal alle 2 Frames ausfhren lassen statt
bei jedem: (entfernt auch den "Warte"-Zyklus)

mouse:
	cmpi.b	#$ff,$dff006	; Sind wir auf Zeile 255?
;	bne.s	mouse			; Wenn nicht, geh nicht weiter

frame:
	cmpi.b	#$fe,$dff006	; Sind wir auf Zeile 254? (mu die Runde nochmal
	bne.s	frame			; drehen!) Wenn nicht, geh nicht weiter

	bsr.s	BewegeCopper

Warte:						; weggelassen, kein Risiko mehr...
;	cmpi.b	#$ff,$dff006	; VHPOSR
;	beq.s	Warte
	
In diesem Fall geht die Zeit von zwei Fotogrammen verloren, denn wenn  der
Beam  bei Zeile $FF ankommt, also 255, dann wird der erste Loop (Schleife)
verlassen und man steig in den zweiten ein, dem  frame-Loop:  dieser  aber
wartet  auf  Zeile  254!!! Um dahinzukommen mu der Beam aber zum Ende des
Bildschirms gelangen, und von vorne  starten,  deshalb  ergibt  sich  eine
Gesamtwartezeit  von  2 Fotogrammem (Frames). Ihr werdet bemerken, da mit
dieser nderung der Balken nur  mehr  den  halben  Zahn  drauf  hat.  Noch
langsamer wollt ihr es? Na gut, verlieren wir 3 Frames:

mouse:
	cmpi.b	#$ff,$dff006	; Sind wir auf Zeile 255?
;	bne.s	mouse			; Wenn nicht, geh nicht weiter

frame:
	cmpi.b	#$fe,$dff006	; Sind wir auf Zeile 254? (mu die Runde nochmal
	bne.s	frame			; drehen!) Wenn nicht, geh nicht weiter
	

frame2:
	cmpi.b	#$fd,$dff006	; Sind wir auf Zeile 253? (mu die Runde nochmal
	bne.s	frame			; drehen!) Wenn nicht, geh nicht weiter

	bsr.s	BewegeCopper
	...

Auf die gleiche Weise haben wir hier beim Ausgang aus dem  2.  Loop  einen
dritten angehngt, und somit wieder ein Frame "verloren".

Um  zu  berprfen, zu welcher Zeile ihr gekommen seid, steigt durch einen
Mausklick aus und probiert ein "M BALKEN", und ihr werdet den letzten Wert
erhalten, den das WAIT hatte.


