
; Listing2l.s

Anfang:
	lea	$dff000,a0			; gib $dff000 in a0
Waitmouse:
	move.w	#$20,$1dc(a0)	; BEAMCON0 (ECS+) Auflsung Video PAL
	bsr.s	Blinken			; Bringt den Bildschirm dazu zu blinken
	bsr.s	ZeigerFarbe		; Bringt den Mauspointer zum blinken
	btst	#2,$16(a0)		; POTINP - Rechte Maustaste gedrckt?
							; (bit 2 im $dff016)
	bne.s	NichtGedrueckt	; Wenn nicht, springe zu VollesChaos
	bsr.s	VollesChaos		;
NichtGedrueckt:
	btst	#6,$bfe001		; Linke Maustaste gedrckt?
	bne.s	Waitmouse		; wenn nicht, zurck zu Waitmouse
	rts						; Ende


ZeigerFarbe:
	moveq	#-1,d1			; Also moveq #$ffffffff,d1
	moveq	#20-1,d0		; Anzahl der ZeigerFarbe-Zyklen
Flash:
	subq.w	#8,d1			; ndere die Farbe, die in $dff1a4 kommt
	move.w	d1,$1a4(a0)		; COLOR18 - gib den Wert von d1 in $dff1a4
							; (Die Farbe des Mauspointers!)
	dbra	d0,Flash
	rts

Blinken:
	move.w	6(a0),$180(a0)	; Gib den .w-Wert von $dff006 in COLOR0
	move.b	6(a0),$182(a0)	; Gib den .b-Wert von $dff006 in COLOR1
	rts

VollesChaos:
	move.w	#0,$1dc(a0)		; BEAMCON0 (ECS+) Auflsung video NTSC
	rts

	end

Dieses Programm ist nur seiner Struktur wegen interessant, denn es hat ein
Hauptprogramm, das von Anfang: bis zum RTS, das SubRoutinen aufruft  (also
Unterprogramme,  die nichts anderes sind als Teile des Programmes, die mit
einem Label versehen wurden und einem RTS enden). Mit  dem  Debugger  (AD)
knnt  ihr  versuchen,  den  Ablauf  des  Programmes zu verfolgen: um alle
SubRoutinen durchzugehen,  drckt  die  Pfeil-nach-Rechts-Taste,  und  ihr
werdet  in  der  Routine  Zeigerfarbe  sehen,  wie  d1  in Einserschritten
heruntergezhlt wird.

Das fundamentale Problem der BSR/BEQ/BNE/RTS - Strukturen liegt darin, da
alles  durch Sprnge geregelt ist, bei denen man nach Abarbeitung entweder
mit einem RTS zur Zeile unter  dem  BSR  zurckkehrt,  oder  einen  Sprung
macht,  der  einer  Weiche  hnelt, bei der man entweder links oder rechts
geht, an deren Ende man aber nicht zurck kann.

Ast 1
					_______ _ _ etc etc _ _ _  RTS, Ausstieg von diesem Weg
   Weiche beq/bne /
   ______________/
		 \ Ast 2
		  \______ _ _ etc etc _ _ _ _ RTS, Ausstieg von diesem Weg

Ein BEQ/BNE-Sprung ist wie die Entscheidung,  ob  man  nach  Mnchen  oder
Hamburg  fahren  soll, man wird andere Straen befolgen und einmal am Ziel
angekommen, wird man dort die Nacht verbringen, wenn man das RTS  erreicht
hat. Es wurden aber andere Wege genommen.

Wenn wir aber ein BSR.w Mnchen antreffen, dann springen wir nach Mnchen,
fhren die Befehle aus, die wir dort antreffen, und  wenn  wir  einem  RTS
begegnen,  dann  "beamen"  wir uns auf magische Art und Weise zur Kreuzung
zurck, an der wir nach Mnchen abgebogen sind. Es ist, als wrden wir ein
Zauberbuch  lesen, bei der auf jeder Seite eine Landschaft abgebildet ist,
und wenn wir ein AbraCadaBSR aussprechen, werden wir  in  diese  Zeichnung
katapultiert, wir verbringen dort eine Zeit lang, dann treffen wir auf ein
SimsalaRTS  und  wir  sitzen  vor  dem  Buch,  bereit   auf   Seite   zwei
einzusteigen, mit einem erneutem AbraCadaBSR.

Bemerkung1:   Durch  Drcken  der  rechten  Maustaste  wird  eine  Routine
ausgefhrt, die sonst bersprungen wird:

	btst	#2,$16(a0)		; POTINP - Rechte Maustaste gedrckt?
							; (bit 2 im $dff016
	bne.s	NichtGedrueckt  ; Wenn nicht, springe zu VollesChaos
	bsr.s	VollesChaos		;
NichtGedrueckt: 

Erinnert euch gut an diese Art, um eine Routine nur auszufhren, wenn eine
bestimmte  Kondition  gegeben  ist,  in  diesem  Beispiel  ob  die  rechte
Maustaste gedrckt ist. Beim Programmieren treten solche  Dinge  oft  auf.
Das  Register, das dazu verwendet wird, "VollesChaos" zu bereiten, ist das
$dff1dc, in dem Bit 5 dazu dient, zwischen der  europischen  PAL  und der
amerikanischen NTSC -Videonorm umzuschalten. Dieses Register existiert nur
in Computern, die nach 1989 gebaut wurden, bei jemanden, der  einen  recht
alten  Computer  hat,  knnte  es  nicht  funktionieren. Wenn es euch aber
funktioniert, dann werdet  ihr  bemerken,  da  bei  Tastendruck  (rechter
Mausknopf)  der  Bildschirm  quasi  zu  "explodieren"  scheint, da er sehr
schnell zwischen  den  Videonormen  PAL/NTSC  umschaltet.  Wenn  ihr  zwei
Programme  schreiben  mchtet, die zwischen PAL/NTSC umschalten, dann mt
ihr nur folgendes tun:

	move.w	#0,$dff1dc		; BEAMCON0
	rts

Assembliert es mit a, und speichert ab mit WO  (also  als  File,  den  ihr
ausfhren  knnt),  gebt ihm ev. den Namen NTSC. Dann assembliert folgende
zwei Zeilen:

	move.w	#$20,$dff1dc	; BEAMCON0
	rts

Speichert es als PAL ab. Von der Shell aus knnt ihr so zwischen  PAL  und
NTSC umschalten, indem ihr einfach eines der zwei Programme startet.

Wenn ihr bei diesem Programm schon Orientierungsschwierigkeiten habt, dann
bedenkt,  da  ECHTE  Programme  tausend  mal  komplizierter   sind,   mit
verschiedensten BSR, also versucht, dieses zu 100% zu verstehen, bevor ihr
zu LEKTION3.TXT bergeht, die auch den Untertitel trgt "WIR KNNTEN  EUCH
MIT  SPEZIALEFFEKTEN VERWUNDERN, SCHAFFEN ES ABER NOCH NICHT". (A.d..: In
Orginalton klingt dieser Spruch sehr viel witziger..!)
