
ASSEMBLERKURS - LEKTION 13:  OPTIMIERUNG DES ASSEMBLER CODES

Author: Fabio Ciucci, Ugo Erra

Danksagung: Michael Glew, 2-Cool/LSD, Subhuman/Epsilon


Das Schreiben von Assembler-Routinen bedeutet nicht unbedingt, dass ihr eigener
Code mit voller Geschwindigkeit ausgefhrt wird. In der Tat nicht immer kann
der Assemblercode als der beste in Bezug auf die erreichbare Geschwindigkeit
eingestuft werden. Betrachten wir die zahlreichen sich im Umlauf befindenden
Demos und genau diejenigen, die sich in den meisten Fllen mit 3D-Grafiken
beschftigen. In den meisten Fllen (fast immer) sind die Routinen fr Effekte
wie Rotationen, Zoom, Welterkundung usw. gleich, aber ihre Implementierung in
Assembler-Code ist anders, da jeder Programmierer versucht sie bestmglich zu
implementieren, so dass sie mit maximaler Geschwindigkeit ausgefhrt werden.
Dies wird durch Optimierungstechniken erreicht, die jeder gute Assemblercoder
kennen muss. Die Techniken sind zahlreich und sicherlich wird es einige Zeit
dauern, bis sie sie auf ganz natrliche Weise anwenden. Es gibt verschiedene
Arten der Optimierung und viele dieser Techniken, die ich erklren werde,
gelten fr den 68000, aber die gleichen sind auch fr Mikroprozessoren wie den
68040 oder 68060.
Das erste, was Sie zur Verfgung haben mssen, ist eine Tabelle mit den 
Prozessorzyklen jeder einzelnen 68000-Anweisung, die Sie in dieser Lektion
zusammengefasst finden.
Wenn Sie einen kurzen Blick auf diese Tabelle werfen, werden Sie vielleicht
erstaunt sein, wieviel "Zeit" fr die Ausfhrung jedes Befehls bentigt wird,
und mglicherweise haben Sie bis zu diesem Punkt geglaubt, dass jede Anweisung
in der gleichen Zeit ausgefhrt wird. Nun, sie haben sich geirrt!!!
Beachten Sie zunchst die Zeit, die eine Multiplikations-Anweisung (MULU) im
Vergleich zu einer Addition (ADD) bentigt und Sie werden sofort verstehen,
warum Optimierung wichtig ist:

	ADD				; Ausfhrungszeit: 6 bis 12+ Taktzyklen

	MULS			; Ausfhrungszeit: 70+ Taktzyklen

Daher ist es leicht zu verstehen, wie diese Anweisung optimiert werden kann:

langsam:		MULU.W	#2,D0		; 70+ Zyklen

optimiert:		ADD.W	d0,d0		; 6+ Zyklen

Ich gehe davon aus, dass Multiplikationen und Divisionen die beiden langsamsten
Anweisungen sind. Sehen wir uns eine ungefhre Liste der Befehle an, sortiert
vom schnellsten bis zum langsamsten: (Zyklen sind bestenfalls!)

EXT, SWAP, NOP, MOVEQ				; 4 Zyklen -> die schnellsten!

TST, BTST, ADDQ, SUBQ, AND, OR, EOR	; 4 + Adressierung, Geschwindigkeit...

MOVE, ADD, SUB, CMP, LEA			; 4+ Adressierung, aber oft sind die
									; Adressierungen "schwer" auszufhren

Dann haben wir BCLR/BCHG/BSET mit 8+, LSR/LSL/ASR/ASL/ROR/ROL mit 6 +2n, wobei
n die Anzahl der durchzufhrenden Verschiebungen ist und schliesslich haben
wir:

	MULS/MULU		; 70+ !
	DIVU			; 140+ !!
	DIVS			; 158+ !!!

Es sollte auch daran erinnert werden:

	BEQ,BNE,BRA...	; 10
	DBRA			; 10
	BSR				; 18
	JMP				; 12
	RTS				; 16
	JSR				; 16/20

Achten Sie also darauf, nicht zu viele Unterprogrammaufrufe zu ttigen, da alle
BSR + RTS fr die Rckkehr mindestens 18 + 16 = 34 Zyklen verbrauchen!
Wennn Sie immer kurze Unterprogramme in die Hauptschleife setzen, ist es eine
Verschwendung. Sie verlieren 34 Zyklen fr BSR + RTS, um eine Handvoll
Anweisungen auszufhren!

EXAMPLE:
	BSR.S	ROUT1	; 18
	BSR.S	ROUT2	; 18
	BSR.S	ROUT3	; 18
	RTS

ROUT1:
	MOVE.W	d0,d1
	RTS				; 16
ROUT2:
	MOVEQ	#0,d2
	MOVEQ	#0,d3
	RTS				; 16
ROUT3:
	LEA	label1(PC),A0
	RTS				; 16

Diese Version spart 34 * 3 = 96 Zyklen:

EXAMPLEFIX:
	MOVE.W	d0,d1
	MOVEQ	#0,d2
	MOVEQ	#0,d3
	LEA	label1(PC),A0
	RTS

Neben dem Befehl selbst zhlt auch die verwendete Adressierungsart.
Beispielsweise:

	MOVE.L	(a0),d0					; 12

ist schneller als:

	MOVE.L	$12(a0,d1.w),LABEL1		; 34

Dennoch handelt es sich um MOVE-Anweisungen. Es mag Ihnen jedoch logisch
erscheinen, warum die zweite Anweisung langsamer ist als die erste:
Der Prozessor muss den Offset berechnen, indem er den Wert von d1 plus $12
zu a0 addiert. Dazu macht er eine Kopie, und wo? Im Speicher mit einem Label,
anstatt in einem Register, das viel schneller ist, da die Register INNERHALB
des Prozessors sind, whrend der Speicher auerhalb liegt und um ihn zu
erreichen mssen die Daten durch die Leitungen der Hauptplatine laufen!!!!!

*****************************************************************************
* OPTIMIERUNGEN DER ERSTEN EBENE: "AUSTAUSCH" UND "AUSWAHL" DER ANWEISUNGEN *
*****************************************************************************

Hier sind die Adressierungsmodi vom schnellsten zum langsamsten sortiert:
Hinweis: die Zahlen nach dem "," sind die Taktzyklen, die zu der von der
Anweisung verwendeten Zeit hinzuzurechnen sind, bei Byte-Word/Longword die
Zeit, die der Befehl bentigt


Datenregister direkt									 Dn/An	    ; 0

Adressregister indirekt (oder mit Postinkrement) 		 (An)/(An)+ ; 4/8
unmittelbar												 #x			; 4/8

Adressregister indirekt mit Predekrement				-(An)	    ; 6/10

Adressregister  indirekt mit Offset (max 32767)			 w(An)	    ; 8/12
Absolut kurz											 w			; 8/12
Program Counter mit Offset (berechnet vom asmone)		 w(PC)	    ; 8/12

Program Counter mit Offset und Index					b(PC,Rx)    ; 10/14
Adressregister indirekt mit Offset und Index			b(An,Rx)    ; 10/14

Absolut lang											l			; 12/16


Wie Sie sehen, bentigt die Adressierung von "MOVE.L LABEL1,LABEL2" 16+16=32
Zyklen, ein "MOVE.L #1234,d0" beansprucht nur 8+0=8 Zyklen.
Es ist offensichtlich, dass .W-Anweisungen schneller sind als .L-Anweisungen,
zum Beispiel Adressierung (An), .W bentigt 4 Zyklen und .L 8 Zyklen!

Diese Beispiele sind jedoch SEHR indikativ, denn auch mit den Tabellen in der
Hand ist es schwierig, die wirkliche Ausfhrungszeit der Routine zu berechnen.
Wir sind aber immer sicher, dass ein BSR schneller als ein JSR ist, das ADDQ 
schneller als ADD ist und vor allem wenn es uns gelingt ein MULU/DIVU/MULS/DIVS
durch etwas anderes zu ersetzen, haben wir mit Sicherheit alles beschleunigt!

Wir sprechen hier von "Befehlsnderungen", d.h. kleinen nderungen durch
Ersetzen langsamer Anweisungen durch schnellere. Aber die Kunst der
Optimierungen, die wahre Knigin der Demo-Szene, beinhaltet auch die Verwendung
von "vorberechneten" Tabellen, anstatt eine Mega-Funktion zu implementieren,
die die gleichen Ergebnisse liefert und unzhlige andere Dinge.

Aber es gibt auch den Nachteil: Mega-optimierter Code mit Tabellen und anderen 
Tricks sind oft weniger lesbar und verstndlich und weniger "editierbar". Also,
vermeiden Sie den Fehler, in den viele von uns verfallen sind, zuerst die
Routine optimieren zu wollen, bevor sie sie Schritt fr Schritt fertig erstellt
haben. Dies verlangsamt nur die Entwicklung der fraglichen Routine, besonders
wenn man Anfnger ist, denn was ntzt eine mega-optimierte Routine, die die
Perspektive berechnet, wenn wir nicht mehr "drum herum" die Routine zum
Zeichnen und Drehen des Krpers schreiben knnen? Oder wir verstehen gar nicht
mehr warum sie funktioniert? 

---->>>>> NIEMALS MIT DER OPTIMIERUNG EINER ROUTINE BEGINNEN, WENN SIE NOCH
NICHT VOLLSTNDIG BEENDET IST UND FUNKTIONIERT.

Denken Sie bei der Optimierung daran, Kopien der verschiedenen Listings
aufzubewahren um Schritte der Optimierung "zurckzugehen"!!!
DANN WERDEN WIR DIE GENDERTE VERSION ERNEUT OPTIMIEREN!

Diese Warnung wird Ihnen seltsam vorkommen, aber ein Listung, das einmal
optimiert wurde, ist selbst fr den Autor oft unverstndlich. Nun, wenn es SEHR
optimiert ist, kann das passieren! 

Denken Sie jedoch daran, dass Optimierungen in Teilen des Listings durchgefhrt
werden mssen, deren Durchfhrung tatschlich lange dauert: Zum Beispiel macht
es keinen Sinn, eine Routine zu optimieren, die nur einmal beim Start oder
einmal pro Frame ausgefhrt wird. Die ersten Routinen, die optimiert werden
mssen, sind diejenigen, die viele Male pro Frame ausgefhrt werden, dh die in
den dbra-Schleifen oder auf jeden Fall in verschiedenen Schleifen.
Zum Beispiel wie in diesem Listing:

Bau:
	cmp.w	#$ff,$dff006	; warten auf Wblank
	bne.s	Bau
	bsr.s	routine1
	bsr.s	routine2
	btst	#6,$bfe001		; warten auf die Maus
	bne.s	Bau
	rts

Routine1:
	move.w	#label2,d6
	move.w	d0,d1
	move.w	d2,d3
	and.w	d4,d5
	rts

Routine2:
	move.w	#200,d7
	lea	label2(PC),a0
	lea	label3(PC),a1
loop1:
	move.w	(a0)+,d0
	move.w	(a0)+,d1
	add.w	d0,d5
	add.w	d0,d6
	move.w	d5,(a1)+
	move.w	d5,(a2)+
	dbra	d7,loop1
	rts

In diesem Fall ist es offensichtlich, dass 99% der Zeit durch das 200-Mal
durchlaufen der Routine2 verloren geht. Folglich, wenn wir diese Schleife
optimiert haben, sodass sie doppelt so schnell luft, wrde das gesamte
Programm doppelt so schnell laufen, whrend, wenn die Geschwindigkeit der
Routine1 dreifach oder vierfach so schnell wre, wrden Sie den Unterschied
vielleicht nicht einmal bemerken!!!!!

Um zu sehen, wie viele "Rasterzeilen" eine Routine bentigt, verwenden Sie
einfach den coppermonitor, die alte Methode der nderung der Farbe am Anfang
und am Ende der Routine. Auf diese Weise zeigt der "Streifen" die Zeit in
"Videozeilen" an, die fr die Ausfhrung verwendet wurde:

Bau:
	cmp.w	#$90,$dff006	; warten auf Wblank
	bne.s	Bau
	bsr.s	routine1
	move.w	#$F00,$dff180	; Color0: rot
	bsr.s	routine2
	move.w	#$000,$dff180	; Color0: schwarz
	btst	#6,$bfe001		; warten auf die Maus
	bne.s	Bau
	rts

In diesem Fall warten wir auf die Zeile $90 in der Mitte des Bildschirms. Dann
fhren wir Routine 1 aus, unwichtig, und dann ndern wir die Farbe (rot). Dann
fhren wir die Routine2 aus und ndern die Farbe in (schwarz) zurck. Auf dem
Bildschirm erscheint ein roter Streifen ... das ist die "Zeit", in der die
Routine2 ausgefhrt wird. Um zu sehen, ob sich die Geschwindigkeit verbessert
oder verschlechtert, gengt es zu sehen, ob der Streifen lnger oder krzer
wird.
Einige Verrckte (wie mein Freund, hedgehog) kleben ein Stck Klebeband auf den
Monitor in Hhe der letzten farbigen Zeile um bei jeder nderung eine leichte
Verbesserung oder Verschlechterung festzustellen. Ich persnlich lege einen
Finger darauf oder schau mit dem Auge. Wir haben dieses System jedoch bereits
in der Blitter-Lektion und in Listing11n1.s und den Folgenden, um die Wartezeit
der CIAA / CIAB-Chip zu "visualisieren" gesehen. brigens knnen Sie auch die
Timer verwenden, um die Zeiten "numerisch" zu berechnen, aber das
Farbwechselsystem ist unkomplizierter.

Beginnen wir aber zunchst mit den elementaren Optimierungen, die Sie "beim
Schreiben" kennen sollten. Am einfachsten ist es zu wissen, welche Anweisung
unter den mglichen zu whlen ist, wenn man eine bestimmte Aufgabe erledigen
mchte. Tatschlich kann ein und dieselbe Operation auf verschiedene Arten
ausgefhrt werden!
Sehen wir uns zum Beispiel dieses Listing an:

	lea	LABEL1,a0
	move.l	0(a0),d0
	move.l	2(a0),d1
	ADD.W	#5,d0
	SUB.W	#5,d1
	MULU.W	#2,d0
	MOVE.L	#30,d2
	RTS

Dasselbe knnen Sie erreichen, indem Sie diese Anweisungen auswhlen:

	lea	LABEL1(PC),a0	; schnellere (PC) Adressierung
	move.l	(a0),d0		; kein Offset 0 erforderlich !!
	move.l	2(a0),d1	; das bleibt so
	ADDQ.W	#5,d0		; Nummer kleiner als 8, Sie knnen ADDQ verwenden!
	SUBQ.W	#5,d1		; das Gleiche gilt fr SUBQ!
	ADD.W	d0,d0		; spart 60 Zyklen!! D0*2 ist das gleiche wie D0+D0!!!
	MOVEQ	#30,d2		; Zahl kleiner als 127, ich kann MOVEQ verwenden!
	RTS

Die Routine ist viel schneller und immer noch gut lesbar. Also, als erstes gilt
es darauf zu achten, die entsprechenden Quick-Anweisungen zu verwenden, wie
z.B. ADDQ /SUBQ / MOVEQ, wenn die Zahl klein genug ist, Multiplikationen und
Divisionen zu entfernen wann immer es mglich ist, Adressierungen relativ zum
(PC) oder zu Registern + Offset zu verwenden anstelle der reinen LABEL, etc.
Mit ein wenig Erfahrung wird es fr Sie selbstverstndlich sein, die
schnelleren Anweisungen zu whlen, und Sie werden gleich beim ersten Mal wie
das zweite aufgefhrte Listing schreiben, anstatt wie das erste aufgefhrte
Listing, das Sie hoffentlich schon jetzt nicht mehr schreiben!!!!

Hier ist ein weiteres Beispiel fr die Optimierung von "Swap" -Anweisungen:

	Move.l	#3,d0		; 12 Zyklen
	Clr.l	d0			; 6 Zyklen
	Add.l	#3,a0		; 16 Zyklen
;
	Move.l	#5,Label	; 28 Zyklen

Optimierte "Austausch"-Version:

	Moveq	#3,d0		; 4 Zyklen
	Moveq	#0,d0		; 4 Zyklen
	Addq.w	#3,a0		; 4 Zyklen
;
	Moveq	#5,d0		; 4 Zyklen
	Move.l	d0,Label	; 20 Zyklen, gesamt 24 Zyklen

Ich knnte mit solchen Beispielen noch lange weitermachen, aber Sie mssen
natrlich nicht alle mglichen Flle auswendig kennen! Vielmehr ist es
notwendig, "die Methode", die Philosophie der optimierten Codierung, zu
verstehen. Es gibt zum Beispiel Techniken, um das Laden von 32 Bit-Werten
in Register zu beschleunigen:

	move.l	#$100000,d0	; 12 Zyklen

optimierte Version:

	moveq	#10,d0		; 4 Zyklen
	Swap	d0			; 4 Zyklen, insgesamt 8 Zyklen

Ein anderer SEHR WICHTIGER Punkt ist, dass der Zugriff auf den Speicher (dh auf
die Label) viel LANGSAMER ist als der Zugriff auf Daten- und Adressregister.
Daher ist es eine gute Angewohnheit, alle Register zu verwenden und Label so
wenig wie mglich zu berhren. Zum Beispiel dieses Listing:

	MOVE.L	#200,LABEL1
	MOVE.L	#10,LABEL2
	ADD.L	LABEL1,LABEL2

Sie knnen VIEL optimieren, indem Sie schreiben :

	move.l	#200,d0
	moveq	#10,d1
	add.l	d0,d1

Achten Sie nicht auf die Dummheit des Beispiels, sondern auf die Tatsache, dass 
whrend wir im ersten Beispiel 4 Zugriffe auf den sehr langsamen RAM gemacht
haben, indem wir die Daten ber die wirren Drhte der Hauptplatine geleitet
haben, wurde im zweiten Fall alles in der CPU erledigt, was das ganze
beschleunigt. Wenn Ihnen die Datenregister ausgehen, verwenden Sie auch die
Adressregister, um Daten zu speichern, anstatt auf Label zuzugreifen! Verwenden
Sie nach Mglichkeit auch .w anstelle von .l-Anweisungen, z.B. das Listing oben
knnte neu optimiert werden:

	move.w	#200,d1
	moveq	#10,d0
	add.w	d0,d1

In diesem Fall belegen die Anweisungen 8 statt 12 Zyklen ... und das ist nicht
wenig! Aber achten Sie darauf, dass das hohe Wort zurckgesetzt wird und / oder
nie gebraucht wird!!

Die profitabelsten "Austausch"-Optimierungen sind jedoch diejenigen, die die
Multiplikations- (70 Zyklen) und Divisionsanweisungen (158 Zyklen) eliminieren
und man kann sagen, dass in dieser Hinsicht eine Wissenschaft darber
entstanden ist.
Der einfachste Fall ist, wenn wir Zahlen mit Potenzen von 2 dividieren oder
multiplizieren mssen, weil wir dann Shiftanweisungen verwenden knnen die,
genau so viele Zyklen bentigen, wie unten angegeben:

	lsl.w	6+2n		; n = Anzahl der Verschiebungen
	asr.w	6+2n
	lsr.l	8+2n
	asr.l	8+2n

Hier gibt n die Anzahl der Bits an und die Anzahl der Zyklen bezieht sich
darauf, wenn die Register verwendet werden.
Die zu befolgende Regel ist im Allgemeinen die folgende: (fr MULS oder MULU)

Hinweis: Manchmal wird ein EXT.L D0 vor den ASLs, die die MULS ersetzen,
verwendet, whrend vor den ASLs, die die MULUs ersetzen, eine Reinigung des 
hohen Wortes mit "swap d0, clr.w d0, swap d0" erforderlich sein kann.

MULS.w	#2,d0		| ADD.L d0,d0 ; das scheint mir klar zu sein!

MULS.w	#4,d0		| ADD.L d0,d0 ; das auch!
					| ADD.L d0,d0

MULS.w	#8,d0		| ASL.l #3,d0 ; von 8 bis 256 ist ASL praktisch
MULS.w	#16,d0		| ASL.l #4,d0
MULS.w	#32,d0		| ASL.l #5,d0
MULS.w	#64,d0		| ASL.l #6,d0
MULS.w	#128,d0		| ASL.l #7,d0
MULS.w	#256,d0		| ASL.l #8,d0

Wenn es Probleme mit den MULUs gibt, kann das hohe Wort bereinigt werden:

mulu.w #n,dx ->	swap dx				; n ist 2^m, 2..2^8
				clr.w dx			; (2,4,8,16,32,64,128,256)
				swap dx
				asl.l #m,dx

Bei den MULS kann es gengen, ein "ext.l" vor das asl zu setzen.

muls #n,dx ->	ext.l dx			; n ist 2^m, 2..2^8
				asl.l #m,dx

Whrend fr die DIVISIONEN:

DIVS.w	#2,d0		| ASR.L #1,d0	; Achtung: Ignorieren Sie den Rest!!
DIVS.w	#4,d0		| ASR.L #2,d0
DIVS.w	#8,d0		| ASR.L #3,d0
DIVS.w	#16,d0		| ASR.L #4,d0
DIVS.w	#32,d0		| ASR.L #5,d0
DIVS.w	#64,d0		| ASR.L #6,d0
DIVS.w	#128,d0		| ASR.L #7,d0
DIVS.w	#256,d0		| ASR.L #8,d0

DIVU.w	#2,d0		| LSR.L #1,d0	; Achtung: Ignorieren Sie den Rest!!
DIVU.w	#4,d0		| LSR.L #2,d0
DIVU.w	#8,d0		| LSR.L #3,d0
DIVU.w	#16,d0		| LSR.L #4,d0
DIVU.w	#32,d0		| LSR.L #5,d0
DIVU.w	#64,d0		| LSR.L #6,d0
DIVU.w	#128,d0		| LSR.L #7,d0
DIVU.w	#256,d0		| LSR.L #8,d0

Wie Sie wissen, bleibt nach einer Division das Ergebnis im niedrigen Wort und
der Rest im hohen Wort. Wenn Sie stattdessen die DIVS / DIVU durch eine
Verschiebung ersetzen, steht das Ergebnis im niedrigen Wort und das hohe Wort
wird auf Null zurckgesetzt... es ist also NICHT DAS GLEICHE, seien Sie
vorsichtig!
Im ungnstigsten Fall, wenn n=8 ist, erhalten Sie genau eine Anzahl von
6+2*8=22 Zyklen fr Wrter und 8+2*8=24 Zyklen fr Langwrter, so dass die
Einsparungen garantiert sind. Sie sollten auch wissen, dass bei einem 68020 die
Anzahl der Zyklen fr die Shift-Anweisungen unabhngig von der Anzahl der
Verschiebungen gleich ist.
Denken Sie auch daran, das die Durchfhrung der Swap-Anweisung 4 Zyklen dauert,
was in vielen Situationen, in denen die Anzahl der zu verschiebenden Bits gro
ist ntzlich sein kann. Lassen Sie uns in diesem Zusammenhang einige Beispiele
ansehen:

; 9 Bit Links-Verschiebung

	Lsl.l	#8,d0
	Add.l	d0,d0

; 16 Bit Links-Verschiebung

	Swap	d0
	Clr.w	d0

; 24 Bit Links-Verschiebung

	Swap	d0
	Clr.w	d0
	Lsl.l	#8,d0

; 16 Bit Rechts-Verschiebung

	Clr.w	d0
	Swap	d0

; 24 Bit Rechts-Verschiebung

	Clr.w	d0
	Swap	d0
	Lsr.l	#8,d0

Wie Sie sehen, fehlt es nicht an Techniken fr die Verschiebung und sie knnen
eine Menge davon bekommen. Wie immer liegt es an Ihnen, in die richtige
Perspektive einzunehmen und zu versuchen, die gewnschte Optimierung
vorzunehmen. Also fr Potenzen von 2 haben sie kein groes Problem in einer
angemessenen Zeit zu multiplizieren und zu dividieren.
Probleme knnten entstehen, wenn die Zahl keine Zweierpotenz ist, das ist zwar
richtig, aber fr viele Werte knnen wir immer noch um das Problem umgehen.
Betrachten wir den Fall, in dem wir den in einem Register enthaltenen Wert mit
3 multiplizieren. Denken sie daran, dass Sie einen Ausdruck wie 3*x, auch als
2*x+x schreiben knnen. An diesem Punkt haben Sie Ihr Problem gelst, weil:

Ihr Code lautet wird:

	Move.l	d0,d1
	Add.l	d0,d0 ; d0=d0*2
	Add.l	d1,d0 ; d0=(d0*2)+d0

Betrachten wir einen anderen Fall zum Beispiel fr n=5, dann haben wir 5*x,
also 4*x+x: Als Code erhalten wir das:

	Move.l	d0,d1
	Asl.l	#2,d0 ; d0=d0*4
	Add.l	d1,d0 ; d0=(d0*4)+d0

Betrachten Sie schlielich einen anderen Fall, in dem n=20 ist, dann haben
wir 20*x, aber 20*x=4*(5*x)=4*(4*x+x)

	Move.l	d0,d1
	Asl.l	#2,d0 ; d0=d0*4
	Add.l	d1,d0 ; d0=(d0*4)+d0
	Asl.l	#2,d0 ; d0=4*((d0*4)+d0)

Kurz gesagt, knnen wir versuchen, die Zahl in Primfaktoren aufzulsen und
feststellen wie viele 2en es gibt, aber immer auch eine kleine Notiz ber
die Anzahl der Zyklen notieren, um zu sehen, ob es zu uns passt oder nicht.
Viele von Ihnen sind vielleicht berrascht, dass die Optimierung eines
einfachen MULU oder DIVU hier behandelt wird, aber denken Sie an die Flle, in
denen diese in Schleifen stehen, in diesem Fall sind diese Techniken wirklich
sehr ntzlich, aber selbst wenn die MULU nicht nicht in einer Schleife steht,
was kostet es Sie, sie durch etwas Besseres zu ersetzen?
Da wir gerade beim Thema sind, lassen Sie uns kurz ber die Implementierung 
von Ausdrcken in Assember sprechen. Was ich Ihnen sagen werde, ist nichts
Besonderes, aber oft wird einer trivialen Tatsache keine Beachtung geschenkt.
Wenn wir eine Funktion implementieren mssen, tun wir dies normalerweise
in dem wir die Werte in die Register laden und alle Operationen ausfhren.
Um Prozessorzeit bei der Berechnung der Funktionen zu sparen, ist es besser,
mathematische Terme zusammenzufassen, so wie sie es in der Schule gelernt
haben.

In der Tat betrachten wir einen trivialen Ausdruck:

a*d0+b*d1+a*d3+b*d5 kann geschrieben werden als:

a*(d0+d3)+b*(d1+d5)

Auf diese Weise sparen wir zwei Multiplikationen.

Um die richtige Anweisung zu whlen, muss man nur wissen, welche von zwei
gleichwertigen Anweisungen die schnellste ist. Ich prsentiere eine hnliche
Tabelle wie die am Ende von 68000-2.txt, mit "langsamen" Befehlen und
"schnellen" quivalenten, die zu verwenden sind:

 ANWEISUNG Beispiel		| QUIVALENT, ABER SCHNELLER
------------------------|-----------------------------------------------
add.X #6,XXX			| addq.X #6,XXX		(maximal 8)
sub.X #7,XXX			| subq.X #7,XXX		(maximal 8)
MOVE.X LABEL,XX			| MOVE.X LABEL(PC),XX	(wenn in der gleichen SECTION)
LEA LABEL,AX			| LEA LABEL(PC),AX	(wenn in der gleichen SECTION)
MOVE.L #30,d1			| moveq #30,d1		(min #-128, max #+127)
CLR.L d4				| MOVEQ #0,d4		(nur fr Datenregister)
ADD.X/SUB.X #12000,a3	| LEA (+/-)12000(a3),A3	(min -32768, max 32767)
MOVE.X #0,XXX			| CLR.X XXX			; #0 zu bewegen ist dumm!
CMP.X  #0,XXX			| TST.X XXX			; das TST, wo Sie es verlassen?
Reg. Ax	zurcksetzen	| SUB.L A0,A0		; besser als "LEA 0,a0"		
JMP/JSR	XXX				| BRA/BSR XXX		(wenn XXX in der Nhe ist)
MOVE.X #label,AX		| LEA label,AX		(nur Adressregister!)
MOVE.L 0(a0),d0			| MOVE.L (a0),d0	(Offset entfernen, wenn es 0 ist!!!)
LEA	(A0),A0				| HAHAHAHA!         ; es hat keine Wirkung!!
LEA	4(A0),A0			| ADDQ.W #4,A0		; bis zu 8
addq.l #3,a0			| addq.w #3,a0		; nur Adressregister , max 8
Bcc.W label				| Bcc.S label       ; Beq,Bne,Bsr... dist. <128

Fr Multiplikationen und Divisionen mit Vielfachen von 2, umgerechnet in
ASL / ASR, siehe die Tabelle oben.

Hier sind einige Sonderflle, um MULS / MULU in etwas anderes zu ndern:

Hinweis: Wenn es sich um ein "MULS" handelt, ist es of notwendig, "ext.l dx"
als erste Anweisung hinzuzufgen, um das Vorzeichen auf Langwort zu erweitern.

mul*.w #3,dx -> move.l dx,ds
				add.l dx,dx
				add.l ds,dx
------------------------------------
mul*.w #5,dx -> move.l dx,ds
				asl.l #2,dx
				add.l ds,dx
------------------------------------
mul*.w #6,dx -> add.l dx,dx
				move.l dx,ds
				add.l dx,dx
				add.l ds,dx
------------------------------------
mul*.w #7,dx -> move.l dx,ds
				asl.l #3,dx
				sub.l ds,dx
------------------------------------
mul*.w #9,dx -> move.l dx,ds
				asl.l #3,dx
				add.l ds,dx
------------------------------------
mul*.w #10,dx -> add.l dx,dx
				move.l dx,ds
				asl.l #2,dx
				add.l ds,dx
------------------------------------
mul*.w #12,dx -> asl.l #2,dx
				move.l dx,ds
				add.l dx,dx
				add.l ds,dx
------------------------------------
mulu.w #12,dx -> swap dx	; HEI! oft ist es notwendig, das hohe Wort fr 
				clr.w dx	; MULUs zurckzusetzen ... beachten Sie dies auch... 
				swap dx		; fr mulu #3, #5, #6 ....

				asl.l #2,dx		; normale mulu #12
				move.l dx,ds
				add.l dx,dx
				add.l ds,dx
------------------------------------

Wenn Sie das hohe Wort der Register mehrmals zurcksetzen mssen, knnen Sie
auch Folgendes verwenden:

	move.l	#$0000FFFF,ds	; 1 Register wird bentigt, um $FFFF zu halten

	and.l	ds,dx			; das ist schneller als tauschen, aber
			; erfordert ein Register, das $0000FFFF enthlt,
			; andernfalls ist "AND.L #$FFFF,dx" nicht schneller ...

Zusammenfassend kann man sagen, dass es im Fall von MULS, da es 
vorzeichenbehafted ist, notwendig sein kann, das sie am Anfang ein "EXT.L"
machen mssen. 
Andererseits kann es im Falle von MULUs hingegen erforderlich sein, das das
hohe Wort des Registers zurckzusetzen.

zusammengefasst:

asl.x #2,dy -> 	add.x dy,dy
				add.x dy,dy
------------------------------------
asl.l #16,dx -> swap dx
				clr.w dx
------------------------------------
asl.w #2,dy -> 	add.w dy,dy
				add.w dy,dy
------------------------------------
asl.x #1,dy -> 	add.x dy,dy
------------------------------------
asr.l #16,dx -> swap dx
				ext.l dx
------------------------------------
bsr label -> 	bra label
				rts
------------------------------------
clr.x n(ax,rx) -> move.x ds,n(ax,rx)	; ds muss natrlich 0 sein!
------------------------------------
lsl.l #16,dx -> swap dx
				clr.w dx
------------------------------------
move.b #-1,(ax) -> st (ax)
------------------------------------
move.b #-1,dest -> st dest
------------------------------------
move.b #x,mn ->	move.w #xy,mn
				move.b #y,mn+1
------------------------------------
move.x ax,ay -> lea n(ax),ay			; -32767 <= n <= 32767
				add.x #n,ay
------------------------------------
move.x ax,az -> lea n(ax,ay),az			;  az=n+ax+ay, n<=32767
				add.x #n,az
				add.x ay,az
------------------------------------
sub.x #n,ax -> 	lea -n(ax),ax			; -32767 <= n <= -9, 9 <= n <= 32767
------------------------------------

An dieser Stelle sehen Sie die Ausfhrungszeit der verschiedenen Anweisungen.
Zur Ausfhrungszeit des Befehls muss die fr die verschiedenen Adressierungen
aufgewendete Zeit addiert werden, deren Ausfhrungszeit wir bereits gesehen
haben. Beachten Sie, dass dies die normalen 68000 Ausfhrungszeiten sind!
Zum Beispiel werden im 68040 die MULS/MULUs ber Hardware implementiert und
bentigen daher weniger Zyklen!

>>>				MOVE.B und MOVE.W				   <<<

+-------------+---------------------------------------------------------------+
|             |                           ZIEL		                          |
+   QUELLE    +---------------------------------------------------------------+
|             | Dn | An |(An)|(An)+|-(An)|(d16,An)|(d8,An,Xn)*|(xxx.W)|(xxx).L|
+-------------+----+----+----+-----+-----+--------+-----------+-------+-------+
| Dn / An     | 4  | 4  | 8  |  8  |  8  |   12   |    14     |  12   |  16   |
| (An)        | 8  | 8  | 12 | 12  | 12  |   16   |    18     |  16   |  20   |
+-------------+----+----+----+-----+-----+--------+-----------+-------+-------+
| (An)+       | 8  | 8  | 12 | 12  | 12  |   16   |    18     |  16   |  20   |
| -(An)       | 10 | 10 | 14 | 14  | 14  |   18   |    20     |  18   |  22   |
| (d16,An)    | 12 | 12 | 16 | 16  | 16  |   20   |    22     |  20   |  24   |
+-------------+----+----+----+-----+-----+--------+-----------+-------+-------+
| (d8,An,Xn)* | 14 | 14 | 18 | 18  | 18  |   22   |    24     |  22   |  26   |
| (xxx).W     | 12 | 12 | 16 | 16  | 16  |   20   |    22     |  20   |  24   |
| (xxx).L     | 16 | 16 | 20 | 20  | 20  |   24   |    26     |  24   |  28   |
+-------------+----+----+----+-----+-----+--------+-----------+-------+-------+
| (d16,PC)    | 12 | 12 | 16 | 16  | 16  |   20   |    22     |  20   |  24   |
| (d8,PC,Xn)* | 14 | 14 | 18 | 18  | 18  |   22   |    24     |  22   |  26   |
| #(data)     | 8  | 8  | 12 | 12  | 12  |   16   |    18     |  16   |  20   |
+-------------+----+----+----+-----+-----+--------+-----------+-------+-------+
* Die Gre des Indexregisters (Xn) (.w oder .l) ndert nichts an der
 Geschwindigkeit.

>>>				    MOVE.L			   <<<

+-------------+---------------------------------------------------------------+
|             |                           ZIEL		                          |
+   QUELLE    +---------------------------------------------------------------+
|             | Dn | An |(An)|(An)+|-(An)|(d16,An)|(d8,An,Xn)*|(xxx.W)|(xxx).L|
+-------------+----+----+----+-----+-----+--------+-----------+-------+-------+
| Dn o  An    | 4  | 4  | 12 | 12  | 12  |   16   |    18     |  16   |  20   |
| (An)        | 12 | 12 | 20 | 20  | 20  |   24   |    26     |  24   |  28   |
+-------------+----+----+----+-----+-----+--------+-----------+-------+-------+
| (An)+       | 12 | 12 | 20 | 20  | 20  |   24   |    26     |  24   |  28   |
| -(An)       | 14 | 14 | 22 | 22  | 22  |   26   |    28     |  26   |  30   |
| (d16,An)    | 16 | 16 | 24 | 24  | 24  |   28   |    30     |  28   |  32   |
+-------------+----+----+----+-----+-----+--------+-----------+-------+-------+
| (d8,An,Xn)* | 18 | 18 | 26 | 26  | 26  |   30   |    32     |  30   |  34   |
| (xxx).W     | 16 | 16 | 24 | 24  | 24  |   28   |    30     |  28   |  32   |
| (xxx).L     | 20 | 20 | 28 | 28  | 28  |   22   |    34     |  32   |  36   |
+-------------+----+----+----+-----+-----+--------+-----------+-------+-------+
| (d,PC)      | 16 | 16 | 24 | 24  | 24  |   28   |    30     |  28   |  32   |
| (d,PC,Xn)*  | 18 | 18 | 26 | 26  | 26  |   30   |    32     |  30   |  34   |
| #(data)     | 12 | 12 | 20 | 20  | 20  |   24   |    26     |  24   |  28   |
+-------------+----+----+----+-----+-----+--------+-----------+-------+-------+
* Die Gre des Indexregisters (Xn) (.w oder .l)ndert nichts an der
 Geschwindigkeit.

Und jetzt die anderen Anweisungen.
Anmerkung:

#  - Operand unmittelbar
An - Adressregister
Dn - Datenregister
ea - ein Operand, der durch eine tatschliche Adresse angegeben wird
M  - effektive Adresse
+  - Addition der Zeit fr die Berechnung der Adresse (Adressierung)

+-------------+-----------+------------+-----------+-----------+
| Instruct.	  |   Size    | op<ea>,An | op<ea>,Dn | op Dn,<M> |
+-------------+-----------+------------+-----------+-----------+
|             | Byte,Word |     8+     |     4+    |     8+    |
|  ADD/ADDA   +-----------+------------+-----------+-----------+
|             |   Long    |     6+     |     6+    |    12+    |
+-------------+-----------+------------+-----------+-----------+
|             | Byte,Word |     -      |     4+    |     8+    |
|  AND        +-----------+------------+-----------+-----------+
|             |   Long    |     -      |     6+    |    12+    |
+-------------+-----------+------------+-----------+-----------+
|             | Byte,Word |     6+     |     4+    |     -     |
|  CMP/CMPA   +-----------+------------+-----------+-----------+
|             |   Long    |     6+     |     6+    |     -     |
+-------------+-----------+------------+-----------+-----------+
|  DIVS       |     -     |     -      |   158+    |     -     |
+-------------+-----------+------------+-----------+-----------+
|  DIVU       |     -     |     -      |   140+    |     -     |
+-------------+-----------+------------+-----------+-----------+
|             | Byte,Word |     -      |     4     |     8+    |
|  EOR        +-----------+------------+-----------+-----------+
|             |   Long    |     -      |     8     |    12+    |
+-------------+-----------+------------+-----------+-----------+
|  MULS/MULU  |     -     |     -      |    70+    |     -     |
+-------------+-----------+------------+-----------+-----------+
|             | Byte,Word |     -      |     4+    |     8+    |
|  OR         +-----------+------------+-----------+-----------+
|             |   Long    |     -      |     6+    |    12+    |
+-------------+-----------+------------+-----------+-----------+
|             | Byte,Word |     8+     |     4+    |     8+    |
|  SUB        +-----------+------------+-----------+-----------+
|             |   Long    |     6+     |     6+    |    12+    |
+-------------+-----------+------------+-----------+-----------+

+-------------+-----------+---------+---------+--------+
| Instruct.   |   Size    | op #,Dn | op #,An | op #,M |
+-------------+-----------+---------+---------+--------+
|             | Byte,Word |    8    |    -    |   12+  |
|  ADDI       +-----------+---------+---------+--------+
|             |   Long    |    16   |    -    |   20+  |
+-------------+-----------+---------+---------+--------+
|             | Byte,Word |    4    |    4    |    8+  |
|  ADDQ       +-----------+---------+---------+--------+
|             |   Long    |    8    |    8    |   12+  |
+-------------+-----------+---------+---------+--------+
|             | Byte,Word |    8    |    -    |   12+  |
|  ANDI       +-----------+---------+---------+--------+
|             |   Long    |   14    |    -    |   20+  |
+-------------+-----------+---------+---------+--------+
|             | Byte,Word |    8    |    -    |    8+  |
|  CMPI       +-----------+---------+---------+--------+
|             |   Long    |   14    |    -    |   12+  |
+-------------+-----------+---------+---------+--------+
|             | Byte,Word |    8    |    -    |   12+  |
|  EORI/SUBI  +-----------+---------+---------+--------+
|             |   Long    |   16    |    -    |   20+  |
+-------------+-----------+---------+---------+--------+
|  MOVEQ      |   Long    |    4    |    -    |   -    |
+-------------+-----------+---------+---------+--------+
|             | Byte,Word |    8    |    -    |   12+  |
|  ORI        +-----------+---------+---------+--------+
|             |   Long    |   16    |    -    |   20+  |
+-------------+-----------+---------+---------+--------+
|             | Byte,Word |    4    |    8    |    8+  |
|  SUBQ       +-----------+---------+---------+--------+
|             |   Long    |    8    |    8    |   12+  |
+-------------+-----------+---------+---------+--------+

+-------------+-----------+----------+--------+
| Instruct.   |   Size    | Register | Memory |
+-------------+-----------+----------+--------+
|  NBCD       |   Byte    |    6     |    8+  |
+-------------+-----------+----------+--------+
|             | Byte,Word |    4     |    8+  |
|  CLR/NEG    +-----------+----------+--------+
|  NEGX/NOT   |   Long    |    6     |   12+  |
+-------------+-----------+----------+--------+
|             | Byte,False|    4     |    8+  |
|  Scc        +-----------+----------+--------+
|             | Byte,True |    6     |    8+  |
+-------------+-----------+----------+--------+
|  TAS        |   Byte    |    4     |   14+  |
+-------------+-----------+----------+--------+
|  TST   | Byte,Word,Long |    4     |    4+  |
+-------------+-----------+----------+--------+
|  LSR/LSL    | Byte,Word |  6 + 2n  |   8+   |
|  ASR/ASL    +-----------+----------+--------+
|  ROR/ROL    |   Long    |  8 + 2n  |   -    |
|  ROXR/ROXL  |           |          |        |
+-------------+-----------+----------+--------+
Hinweis: n ist die Anzahl der Shifts!

Bit Manipulation Anweisung Ausfhrungszeit
+-------------+-----------+-------------------+-------------------+
|             |           |       Dynamic     |       Static      |
| Instruct.   |   Size    +----------+--------+----------+--------+
|             |           | Register | Memory | Register | Memory |
+-------------+-----------+----------+--------+----------+--------+
|             |   Byte    |    -     |   8+   |    -     |  12+   |
|  BCHG/BSET  +-----------+----------+--------+----------+--------+
|             |   Long    |    8     |   -    |    12    |   -    |
+-------------+-----------+----------+--------+----------+--------+
|             |   Byte    |    -     |   8+   |    -     |  12+   |
|  BCLR       +-----------+----------+--------+----------+--------+
|             |   Long    |   10     |   -    |    14    |   -    |
+-------------+-----------+----------+--------+----------+--------+
|             |   Byte    |    -     |   4+   |    -     |   8+   |
|  BTST       +-----------+----------+--------+----------+--------+
|             |   Long    |    6     |   -    |    10    |   -    |
+-------------+-----------+----------+--------+----------+--------+

+-------------+-------------------+--------+-----------+
|             |                   | Branch |  Branch   |
| Instruct.   |   Displacement    | Taken  | Not Taken |
+-------------+-------------------+--------+-----------+
|             |       Byte        |   10   |     8     |
|  Bcc        +-------------------+--------+-----------+
|             |       Word        |   10   |    12     |
+-------------+-------------------+--------+-----------+
|             |       Byte        |   10   |     -     |
|  BRA        +-------------------+--------+-----------+
|             |       Word        |   10   |     -     |
+-------------+-------------------+--------+-----------+
|  BSR        |     Byte,word     |   18   |     -     |
+-------------+-------------------+--------+-----------+
|             |      cc true      |   -    |    12     |
|             +-------------------+--------+-----------+
|             |  cc false, Count  |        |     _     |
|  DBcc       |    Not Expired    |   10   |           |
|             +-------------------+--------+-----------+
|             | cc false, Counter |   _    |           |
|             |      Expired      |        |    14     |
+-------------+-------------------+--------+-----------+

+----+----+---+-----+-----+--------+-----------+------+-------+-------+-------+
|Ins.|Sz|(An)|(An)+|-(An)|(d16,An)|(d8,An,Xn)+|(x).W|(x).L|(d16,PC)|(d8,PC,Xn)*
+----+---+----+-----+-----+-------+-----------+-----+-----+--------+----------+
| JMP| -  | 8  |  -  | -  |  10   |   14      | 10  | 12  |  10    |    14    |
+----+----+----+-----+----+-------+-----------+-----+-----+--------+----------+
| JSR| -  | 16 |  -  | -  |  18   |   22      | 18  | 20  |  18    |    22    |
+----+----+----+-----+----+-------+-----------+-----+-----+--------+----------+
| LEA| -  | 4  |  -  | -  |  8    |   12      |  8  | 12  |  8     |    12    |
+----+----+-----+-----+----+------+-----------+-----+-----+--------+----------+
| PEA| -  | 12  |  -  | -  |  16  |   20      | 16  | 20  |  16    |    20    |
+-----+----+-----+-----+----+-----+-----------+-----+-----+--------+----------+
|     |Word|12+4n|12+4n| _  |16+4n|  18+4n    |16+4n|20+4n| 16+4n  |  18+4n   |
|     |    |     |     |    |     |           |     |     |        |          |
|MOVEM+----+-----+-----+----+-----+-----------+-----+-----+--------+----------+
|M->R |Long|12+8n|12+8n| _  |16+8n|  18+8n    |16+8n|20+8n| 16+8n  |  18+8n   |
|     |    |     |     |    |     |           |     |     |        |          |
+-----+----+-----+-----+----+-----+-----------+-----+-----+--------+----------+
|     |Word| 8+4n|  _  |8+4n|12+4n|  14+4n    |12+4n|16+4n|   _    |    _     |
|     |    |     |     |    |     |           |     |     |        |          |
|MOVEM+----+-----+-----+----+-----+-----------+-----+-----+--------+----------+
|R->M |Long| 8+8n|  _  |8+8n|12+8n|  14+8n    |12+8n|16+8n|   _    |    _     |
|     |    |     |     |    |     |           |     |     |        |          |
+-----+----+-----+-----+----+-----+-----------+-----+-----+--------+----------+
Hinweis: n ist die Anzahl der zu verschiebenden Register.


EXT/SWAP/NOP	4
EXG				6
UNLK			12
LINK/RTS		16
RTE				20

Bedenken Sie schlielich, dass Ausnahmen 44 Zyklen dauern, wenn es sich um 
einen Interrupt handelt, 34 wenn es sich um einen TRAP handelt. Plus 20 fr die
RTE !!! Ich empfehle, eine Optimierung IMMER zu kommentieren, zum Beispiel wenn
Sie diese Routine optimieren wollen:

	movem.l	label1(PC),d1-d4
	mulu.w	#16,d1
	mulu.w	#3,d2
	muls.w	#5,d3
	divu.w	#8,d4
	rts

Durch die Optimierung wre das Ergebnis:

	movem.l	label1(PC),d1-d4
	asl.l	#4,d1		; mulu.w #16,d1
	move.l	d2,d5		; \
	add.l	d2,d2		;  > mulu.w #3,d2
	add.l	d5,d2		; /
	move.l	d3,d5		; \
	asl.l	#2,d3		;  > muls.w #5,d3
	add.l	d5,d3		; /
	asr.l	#3,d4		; divu.w #8,d4
	rts

Zustzlich zur Verwendung des d5-Registers haben wir das Lesen des Listings 
erschwert. Wre es auf den ersten Blick verstndlich was mit den Registern
d1, d2, d3 und d4 passiert, wenn wir die Kommentare nicht hingeschrieben
htten? Und stellen Sie sich vor, wir mssten auch das hohe Wort vor den MULUs
bereinigen und es vor den MULS verlngern:

	movem.l	label1(PC),d1-d4
	swap	d1
	clr.w	d1
	swap	d1
	asl.l	#4,d1
	swap	d2
	clr.w	d2
	swap	d2
	move.l	d2,d5
	add.l	d2,d2
	add.l	d5,d2
	ext.l	d3
	move.l	d3,d5
	asl.l	#2,d3
	add.l	d5,d3
	asr.l	#3,d4
	rts

Oder Sie knnen das hohe Wort auf die schnellste Weise zurcksetzen:

	move.l	#$FFFF,d6
	...
	movem.l	label1(PC),d1-d4
	and.l	d6,d1
	asl.l	#4,d1
	and.l	d6,d2
	move.l	d2,d5
	add.l	d2,d2
	add.l	d5,d2
	ext.l	d3
	move.l	d3,d5
	asl.l	#2,d3
	add.l	d5,d3
	asr.l	#3,d4
	rts

Wenn Sie nach einem Monat des Schreibens zu Ihrem Listing zurckkehren, wrden
sie erkennen, das all diese unverstndlichen Anweisungen nichts anderes machen
als 3 Multiplikationen und eine Division? SIE WRDEN VIEL ZEIT BRAUCHEN, oder
vielleicht sogar das Listing lschen und im Falle einer nderung von vorne
beginnen. Ich habe die Kommentare nicht zu dieser neuesten Version hinzugefgt,
um verstndlich zu machen wie GRUNDLEGEND es ist, Kommentare fr Optimierungen
abzugeben, wie im vorherigen Listing. Deshalb: 
KOMMENTIEREN SIE IMMER DIE OPTIMIERUNGEN!!!!!!!!!!!!

Ein weiteres Beispiel: siehe diese 3 Anweisungen:

	move.l	a1,a0
	add.w	#80,a0
	add.l	d0,a0

Das gleiche kann so gemacht werden:

	lea	80(a1,d0.l),a0	; oder d0.w wenn das niedrige Wort von d0 ausreicht.

*****************************************************************************
* OPTIMIERUNGEN AUF ZWEITER EBENE: DIE "TABELLEN -> VORBERECHNUNG!			*
*****************************************************************************

Lassen Sie uns nun ber Tabellen sprechen, eines der wichtigsten Themen fr
Optimierung, das mit dem Grobuchstaben O, mit dem Sie schneller arbeiten
knnen, als jeder C-Compiler, BASIC usw.
Die Tabellen fr die Optimierung sind "hnlich" zu denen, die in wir in
frheren Lektionen gesehen haben z.B. die die Bewegungs-Koordinaten der Sprites
enthalten oder andere.
In diesem Fall knnen wir sagen, dass wir die verschiedenen Positionen, die 
die Objekte eingenommen haben "vorberechnet" haben, aber hier geht es um eine
Tabelle die verwendet wird, um die Ergebnisse einer gegebenen Multiplikation,
Division oder ganze mathematische Funktionen "vorberechnet" werden, also ist
der Fall ein bisschen anders. Nehmen wir ein konkretes Beispiel.

Angenommen, wir haben eine Routine, die eine Reihe von Werten von 0 bis 100
verarbeitet und irgendwann mssen wir eine Multiplikation mit einer
Konstanten c durchfhren. Wenn diese Routine viele Male ausgefhrt werden
muss, dann wird diese Multiplikation viel Zeit verschwenden.
Wie kann man das Problem umgehen? Wir erstellen eine Tabelle mit allen Werten
von unserem "Bereich" von 0..100 mit bereits multiplizierten c. 
Das ist solche Sache:

Table:
	dc.w	0*c
	dc.w	1*c
	dc.w	2*c
	dc.w	3*c
	.
	dc.w	n*c
	.
	dc.w	100*c

Zu diesem Zeitpunkt ist es einfach, auf die Tabelle zuzugreifen, da der 
mit c multiplizierte Wert fr d0 angegeben ist, haben wir das:

	Lea	Table,a0		; Adresse der Tabelle
	Add.w	d0,d0		; d0 * 2, um den Offset der Tabelle zu finden,
						; da jeder Wert ein Wort lang ist
	Move.w	(a0,d0.w),d0; Kopieren des richtigen Werts aus der Tabelle nach d0

Einfach, oder? Der einzige Nachteil ist, dass wir ein 100 Wrter langes Listing
haben, um die Tabelle zu erhalten. Wenn diese Tabelle nicht grer als
256 Bytes wre, knnten wir schreiben:

	Add.w	d0,d0				; d0*2, jeder Wert 1 Wort, d.h. 2 Bytes
	Move.w	Table(pc,d0.w),d0	; kopiere den richtigen Wert aus der Tabelle

Wre das Listing fr 68020+ , wrde eine einzige Anweisung ausreichen:

	Move.w	Table(pc,d0.w*2),d0	; Anweisung fr 68020 oder hher

Letzteres ist jedoch eine Vorwegnahme, denn die spezifischen Optimierungen fr 
68020 werden wir spter behandeln.
Die gebruchlichste Lsung fr "kurze" Tabellen besteht jedoch darin, sie in
einem BSS-Abschnitt durch eine Routine zu erstellen. Auf diese Weise wird die
ausfhrbare Datei nicht lnger, sondern nimmt nur wenig Speicher in Anspruch 
(es sei denn, Sie machen eine Tabelle die 500KB lang ist, in diesem Fall nimmt
es VIEL mehr Speicher in Anspruch, heheheeh!)

Wenn Sie aufmerksam waren, wir haben in den vorherigen Lektionen bereits einige
"tabellarische" Listings aufgefhrt, eine zum Entfernen eines "MULU.W #40", die
sehr hufig vorkommt, da 40 die Lnge einer Lowres-Bildschirmzeile ist.
Sehen Sie sich das Beispiel sorgfltig an, es ist Listing8n2.s in dem beide
Versionen im Vergleich optimiert und normal vorhanden sind. Schauen Sie sich
auch die vorherigen Listings an, um die normalen und optimierten Routinen
einzeln zu sehen. Das Problem war:

	mulu.w	#largschermo,d1		; d.h. mulu.w #40,d1

Hier ist der Trick, um das Problem zu beheben:

; LASSEN SIE UNS EINE TABELLE MIT DEN VIELFACHEN VON 40 VORBERECHNEN,
; dh mit der Breite des Bildschirms, um eine Multiplikation fr jeden
; Plot zu vermeiden.

-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-

	lea	MulTab,a0			; Adressraum mit 256 Wrtern zum Schreiben
							; der Vielfachen von 40 ...
	moveq	#0,d0			; wir beginnen mit 0 ...
	move.w	#256-1,d7		; Anzahl der bentigten Vielfachen von 40
PreCalcLoop
	move.w	d0,(a0)+		; wir speichern das aktuelle Vielfache
	add.w	#LargSchermo,d0	; Bildbreite hinzufgen, nchstes Vielfaches
	dbra	d7,PreCalcLoop	; Wir erstellen die gesamte MulTab
	....

	SECTION	Precalc,bss

MulTab:
	ds.w	256	; Beachten Sie, dass der aus Nullen bestehende Abschnitt
; bss nicht die tatschliche Lnge der ausfhrbaren Datei verlngert.

-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-

Dies dient der Berechnung der Tabelle. Dann anstelle der Mulu:

-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-

	lea	MulTab,a1			; Adresse der Tabelle mit Vielfachen von
							; der Breite des Bildschirms in a1 vorberechnet
	add.w	d1,d1			; d1*2, um den Versatz in der Tabelle zu finden
	add.w	(a1,d1.w),d0	; Kopiere das richtige Vielfache
							; von der Tabelle nach d0
-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-

Kurz gesagt, dies ist die Methode der Tabellierung einer Multiplikation.
Natrlich wussten wir hier, dass d1 nur von 0 bis 255 gehen kann, folglich
haben wir nur 256 Vielfache vorberechnet. Wenn d1 stattdessen einen Bereich
von 0 bis 65000 gehabt htte, htten wir eine 128Kb lange Tabelle erstellen
mssen und das wre vielleicht nicht einmal praktisch!

Wenn das maximale Ergebnis in der Tabelle $FFFF (65535) nicht berschreitet,
reicht das Erstellen einer Tabelle mit .Word-Werten aus. Wenn andererseits die
hchsten Werte diesen Wert berschreiten, muss die Tabelle aus einem Langwort
bestehen. In diesem Fall mssen wir den Weg ndern, um den Offset zu finden:
nicht mehr * 2, sondern * 4!

	lea	MulTab,a1			; Adresse der Tabelle mit Vielfachen von
							; der Breite des Bildschirms in a1 vorberechnet
	add.w	d1,d1			; d1*4, um den Versatz in der Tabelle zu finden
	add.w	d1,d1			;
	move.l	(a1,d1.w),d0	; Kopieren Sie das richtige Vielfache
							; von der Tabelle nach d0

Was die Tabelle der Divisionen betrifft, so ist die Sache analog, man macht
einfach eine Routine mit einer Schleife, die in jeder Schleife eine steigende
Zahl dividiert und speichert die Ergebnisse in der Tabelle. In diesem Fall
knnen Sie whlen, ob Sie nur das niedrige Wort mit dem Ergebnis oder auch das 
hohe mit dem Rest speichern mchten, wenn es unserem Zweck dient.
	
Eine grundlegende Sache ist, die Tabelle "vor Ort" zu erstellen, NIEMALS
EINE TABELLE EINFGEN, VOR ALLEM, WENN VIELE KB AN VORBERECHNETEN LANGWRTERN
VORHANDEN SIND.

Wenn wir beispielsweise eine Multab von 20 KB vorberechnet haben, stellen Sie
sich den Unterschied vor zwischen einer ausfhrbaren Datei, die sie beim Start
berechnet, und einer, die eine bereits vorberechnete durch incbin einschliet
vor. Beispiel:

	file1	->	Lnge = 40K	; Berechnen der Tabelle beim Starten
	file1	->	Lnge = 60K	; Tabelle mit incbin einbinden

In Bezug auf den Speicherverbrauch sind sie gleichwertig, aber wenn Sie ein
40K- oder 64K-Intro machen wrden, knnte man sich die immense Platzersparnis
vorstellen, auf Kosten von 1 oder 2 Sekunden der Vorberechnung am Anfang. 
Aber selbst wenn Sie ein Spiel oder ein Programm erstellen wrden, wrde die
Tatsache, dass es mehr als 20k (oder mehr) kostet, es Ihnen ermglichen, mehr
Material auf die Diskette zu legen und eine grere Verbreitung in den BBSen
finden, da sie kleiner ist.
Dann gibt es noch einen weiteren Anreiz, die Tabellen an Ort und Stelle
vorzuberechnen: Die Tatsache, dass man das Listing leicht ndern kann, z.B.
wenn man mit 80 statt 40 multiplizieren mchte. Der Dumme, der mit dem INCBIN
eine Tabelle mit den Vielfachen von 40 mit eingefgt hat, msste die
Multiplikationsroutine mit 80 umschreiben, sie ausfhren und die Binrdatei
speichern, whrend der SCHLAUE der die Routine im Listing hat, einfach 40 in 80
ndern muss und alles weitere macht es von selbst.
Schlielich ist die Bedienung, insbesondere bei Vorberechnungen komplexer
Routinen VIEL klarer, wenn man die ursprngliche Routine, die die Tabelle
erstellt, im Blick hat. 
Daher sollten Sie TABELLEN "vor Ort" In LEEREN SPEICHERBEREICHEN VORBERECHNEN, 
INSBESONDERE IN BSS-ABSCHNITTEN, WENN ES GROSSE TABELLEN SIND.

Der Rat, den ich Ihnen geben kann, ist, immer zu versuchen, ALLES zu
tabellieren.

Wenn Sie sehr gut aufgepasst haben, sollten Sie sich auch daran erinnern, dass
in Lektion11 ein Listing einer Tabellenoptimierung unterzogen wurde, die
weitaus riskanter ist, als die jetzt zu sehen ist. 
Tatschlich wird eine ganze Routine anstelle von nur einer Multiplikation 
aufgezeichnet. Es ist kein Zufall, dass ich es in Lektion 11 und nicht in 8
eingefgt habe! Das "normale" Listing ist Listing11l5.s, das "tabellarische"
Listing ist Listing11l5b.s.
berprfen Sie, wie die starke Optimierung stattgefunden hat, die ich erneut
vorschlage.

Dies ist die "normale" Routine:

-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-

Animloop:
	moveq	#0,d0
	move.b	(A0)+,d0	; Nchstes byte in d0
	MOVEQ	#8-1,D1		; 8 Bits zum berprfen und Erweitern.
BYTELOOP:
	BTST.l	D1,d0		; Test des aktuellen Schleifenbits
	BEQ.S	bitclear	; zurckgesetzt?
	ST.B	(A1)+		; wenn nicht, setze byte (=$FF)
	BRA.S	bitset
bitclear:
	clr.B	(A1)+		; Wenn es gelscht ist, wird das Byte gelscht
bitset:
	DBRA	D1,BYTELOOP	; berprfen und erweitern Sie alle Bits des Bytes
	DBRA	D7,Animloop	; Konvertieren Sie den gesamten Frame

-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-

Wir haben nichts getan, als alle Mglichkeiten vorab zu berechnen:

-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-

****************************************************************************
; Routine, die alle mglichen 8 Bytes in Kombination mit den mglichen 8 Bit
; vorberechnet. Mit allem meinen wir $FF, das sind 255.
****************************************************************************

PrecalcoTabba:
	lea	Precalctabba,a1	; Ziel
	moveq	#0,d0		; von Null anfangen
FaiTabba:
	MOVEQ	#8-1,D1		; 8 Bits zum berprfen und Erweitern.
BYTELOOP:
	BTST.l	D1,d0		; Test des aktuellen Schleifenbits
	BEQ.S	bitclear	; zurckgesetzt?
	ST.B	(A1)+		; wenn nicht, setze byte (=$FF)
	BRA.S	bitset
bitclear:
	clr.B	(A1)+		; Wenn es gelscht ist, wird das Byte gelscht
bitset:
	DBRA	D1,BYTELOOP	; berprfen und erweitern Sie alle Bits des Bytes:
						; D1, das jedes Mal fllt, macht den btst von
						; alle Bits.
	ADDQ.W	#1,D0		; Nchster Wert
	CMP.W	#256,d0		; Haben wir alle gemacht? (max $FF)
	bne.s	FaiTabba
	rts

-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-

Und ndern Sie die "Executive" -Routine:

-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-

Animloop:
	moveq	#0,d0
	move.b	(A0)+,d0	; Nchstes Byte in d0
	lsl.w	#3,d0		; d0 * 8, um den Wert in der Tabelle zu finden
						; (d.h. der Versatz von seinem Anfang)
	lea	Precalctabba,a2
	lea	0(a2,d0.w),a2	; In a2 die Adresse in der 8-Byte-Tabelle
						; genau richtig fr die "Erweiterung" der 8 Bits.
	move.l	(a2)+,(a1)+	; 4 bytes erweitern
	move.l	(a2),(a1)+	; 4 bytes erweitern (gesamt 8 bytes!!)

	DBRA	D7,Animloop	; Konvertieren Sie den gesamten Frame

-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-	-.-

Wie Sie sehen, handelt es sich hier um eine Art der Optimierung, die eine
gewisse Erfahrung und eine gewisse Intuition erfordert.
Mechanisch gesehen ist einfach zu sagen: "Ich versuche, alle Multiplikationen
und Divisionen zu tabellieren und alle mglichen addqs und moveqs zu setzen".
Aber auch wenn ich davon wei, wenn sie "seltsame" Routinen wie die bereits
gesehene finden, welche durch btst aus einem ganzen Byte es auf 8 Bytes
erweitert, ist es notwendig das Auge eines Luchses zu haben, um zu verstehen,
wie man es optimiert. Es ist dieses Luchsauge, das den Unterschied zwischen
einer 3D-Routine ausmacht, die ruckelt, wenn sie sich 10 Punkte dreht, und
einer, die in einer Fnfzigstelsekunde geht, whrend sie sich 8192 mal dreht.
Und natrlich kann man nicht eine Liste mit allen mglichen Routinen mit allen
mglichen Optimierungen auflisten.
Es ist notwendig, das Auge eines Luchses zu bekommen, indem man die wenigen
vorgestellten Beispiele sieht.

******************************************************************************
*		VERSCHIEDENE OPTIMIERUNGEN - GEMISCHTE GRUPPE					     *
******************************************************************************

Betrachten wir den Fall, in dem wir fr jeden Wert in d0 eine bestimmte Routine
ausfhren mssen und nehmen wir auerdem an, dass diese mglichen Werte 
zwischen 0 und 10 sind. Nun, wir knnten versucht sein, so etwas zu tun:

	Cmp.b	#1,d0
	Beq.s	Rout1
	Cmpi.b	#2,d0
	Beq.s	Rout2
	...
	Cmp.b	#10,d0
	Beq.s	Rout10

Es ist eine sehr schlechte Idee, zumindest htten wir das tun knnen:

	Subq.b	#1,d0	; wir entfernen 1. Wenn d0 = 0 ist, wird das Z-Flag gesetzt
	Beq.s	Rout1	; Folglich war d0 1 und wir springen zu Rout1
	Subq.b	#1,d0	; etc.
	Beq.s	Rout2
	...
	Subq.b	#1,d0
	Beq.s	Rout10

Tatschlich ist das schon besser, aber wir sind Perfektionisten und mit Hilfe
einer Tabelle machen wir das:

	Add.w	d0,d0		  ;\ d0*4, um den Versatz in der Tabelle zu finden,
	Add.w	d0,d0		  ;/       bestehend aus Langwrtern (4 bytes!)
	Move.l	Table(pc,d0.w),a0 ; in a0 die Adresse der richtigen Routine
	Jmp	(a0)

Table:
	dc.l	Rout1	; 0 (Wert in d0, um die Routine aufzurufen)
	dc.l	Rout2	; 1
	dc.l	Rout3	; 2
	dc.l	Rout4	; 3
	dc.l	Rout5	; 4
	dc.l	Rout6	; 5
	dc.l	Rout7	; 6
	dc.l	Rout8	; 7
	dc.l	Rout9	; 8
	dc.l	Rout10	; 9

Auf diese Weise vergleichen wir nicht und es ist offensichtlich, dass dies eine
sehr gute Technik ist, wenn wir die zu vergleichenden Werte kennen und sie
aufeinanderfolgend sind.
Ich mchte auch darauf hinweisen, dass wir bei intensiv Nutzung der Tabellen,
sogar mit Zweierpotenzen arbeiten knnen was uns selbst diese beiden Add.w
erspart. Wenn Sie also Routine 1 wollen, brauchen Sie d0=0, wenn Sie Rout2
mchten d0=4, wenn Sie Rout3 mchten d0=8 und so weiter.

Es gibt zum Beispiel auch Variationen dieses Systems:

	move.b	Table(pc,d0.w),d0	; den richtigen Versatz aus der Tabelle holen
	jmp	Table(pc,d0)			; zu Table hinzufgen und springen!

Table:	
	dc.b	Rout1-Table	; 0
	dc.b	Rout2-Table	; 1
	dc.b	Rout3-Table	; 2
	...
	even

Bei diesem System brauchen wir d0 nicht multiplizieren, da wir eine
Offsettabelle der Routinen von der Tabelle selbst gemacht haben. Hier sind es
.byte-Offsets, weil die Routinen als klein angenommen werden und Nachbarn sind.
Ansonsten knnen die Offsets .words sein:

	add.w	d0,d0				; d0*2
	move.w	Table(pc,d0.w),d0	; den richtigen Versatz von der Tabelle holen
	jmp	Table(pc,d0)			; fge es der Tabelle hinzu und springe!

Table:	
	dc.w	Rout1-Table	; 0
	dc.w	Rout2-Table	; 1
	dc.w	Rout3-Table	; 2
	...

Der Vorteil dieses Systems besteht darin, dass das Register d0 nicht mit 4,
sondern nur mit 2 multipliziert werden muss. 
Wenn Sie die Tabelle nicht nahe genug herankriegen, knnen Sie dies tun:

	add.w	d0,d0				; d0*2
	lea	Table(pc),a0
	move.w	(a0,d0.w),d0
	jmp	(a0,d0.w)

Table:	
	dc.w	Rout1-Table	; 0
	dc.w	Rout2-Table	; 1
	dc.w	Rout3-Table	; 2
	...

Wir haben den Sprung zu Routinen bereits mit subq.b #1,d0 implementiert gefolgt
von den BEQs, ohne CMP oder TST. Wir wollen uns mit deren Verwendung verbunden
mit den Condition Codes befassen. (berprfen Sie es gut in 68000-2.txt)
Wir Assemblerprogrammierer knnen uns den Luxus erlauben, drei Bedingungen auf
einmal zu testen. In der Tat betrachten wir das Beispiel:

	Add.w	#x,d0		; die CCs sind in irgendeiner Weise eingestellt
	Beq.s	Zero		; das Ergebnis ist Null
	Blt.s	Negativo	; das Ergebnis ist kleiner als Null
	...					; ansonsten ist das Ergebnis positiv...

Wenn Sie also ein Ergebnis testen mssen, versuchen Sie immer, dies nach der
letzten mathematischen Operation zu tun, und nicht am Ende, wenn der cc etwas 
anderes anzeigt. Es wre gut, wenn Sie wissen, welche CC's die verschiedenen 
Anweisungen beeinflussen.

Ich rate Ihnen auch, die Bccs entsprechend ihrer Wahrscheinlichkeit der
Ausfhrung zuerst zu platzieren, das sind praktisch diejenigen, die mit
grerer Wahrscheinlichkeit die Kontrolle bertragen. Ein weiterer
interessanter Fall ist zum Beispiel dieser: Wir haben eine Reihe von Werten,
wir wissen nicht wie viele, aber wir wissen, dass sie mit einer Null enden ... 
Angenommen, wir mssen sie von einem Speicherbereich in einen anderen kopieren.
Wir knnten so etwas tun:

	Lea	Source,a0
	Lea	Dest,a1
CpLoop:
	Move.b	(a0)+,d0	; Quelle -> d0
	Move.b	d0,(a1)+	; d0 -> Ziel
	Tst.b	d0			; d0=0?
	Bne.s	CpLoop		; Wenn noch nicht, weiter

Aber wir knnen es auf folgende Weise besser machen:

	Lea	Source,a0
	Lea	Dest,a1
CpLoop:
	Move.b	(a0)+,(a1)+	; Quelle -> Ziel
	Bne.s	CpLoop		; flag 0 gesetzt? Wenn noch nicht, weiter!

Wie Sie sehen knnen, erledigt der 68000 in diesem Fall alles von selbst.

Sprechen wir jetzt ber die Aufrufe der Subroutinen und damit ber das Movem.
Die Verwendung von Subroutinen ist natrlich sehr ntzlich bei der Erstellung
von Programmen, aber bei der Optimierung Ihres Codes sollten Sie beachten, dass
Sie anstelle des Befehlspaars BSR Label / RTS auch das BRA Label gefolgt von
einem weiteren BRA am Ende des Unterprogramms verwenden knnen, das Sie zu der
Anweisung zurckbringt, das unmittelbar auf das BRA Label folgt, aber diese
Optimierung liegt in Ihrem Ermessen.
Verwenden Sie jedoch, immer BSR anstelle von JSR, wenn Sie knnen, und ebenso
BRA anstelle von JMP, wenn mglich. Um jedoch auf die Verwendung von Routinen
zurckzukommen, so kommt es hufig vor, dass wir den Inhalt der Register
lschen mssen, bevor wir mit ihnen arbeiten, aber wir knnen uns jedes Mal
eine Menge "Moveq #0,Dx" und "Sub.l Ax,Ax" sparen. Tatschlich machen wir das
zu Beginn des Hauptprogramms und sehen was passiert, wenn wir unsere
Subroutinen aufrufen. Beispiel:

	Moveq	#0,d0	;
	Moveq	#0,d1
	...
	Moveq	#0,d7
	Move.l	d0,a0
		..
   	Move.l	d0,a6
Main:
	Bsr.s	Pippo
	Bsr.s	Pluto
	Bsr.s	Paperino
	...
	Bra.s	Main

Nun, wenn wir den Inhalt der verwendeten Register bei jedem Aufruf speichern,
werden wir jedes Mal, wenn eine Routine endet und zur nchsten geht "saubere"
Register haben. Es ist offensichtlich, dass dies fr unseren Code gut ist.
Ansonsten knnten Sie mit einer Anweisung alle Register reinigen, und zwar:

	movem.l	TantiZeri(PC),d0-d7/a0-a6

TantiZeri:
	dcb.b	15,0

Wir kommen nun zur Movem-Anweisung und untersuchen ihre Strken und Schwchen.

Schauen wir uns zunchst die Anzahl der Prozessorzyklen des Movem, insbesondere
bei Langworttransfers an: Die bertragung von Registern in den Speicher
verwendet 8 + 8n, wobei n die Anzahl der Register angibt, beobachten wir auch
die Anzahl der Zyklen, die stattdessen ein einfaches Move.l Dx (Ax) verwendet:
12 Zyklen. Der gewhnliche Ingenieur knnte sich nun folgende Frage stellen:
Wenn ich mehrere lange Wrter in verschiedenene Register bertragen muss,
inwieweit sollte ich den klassischen Move.l Dx (Ax) verwenden? Nun, auch
diesmal hat der Ingenieur eine korrekte Beobachtung gemacht, und zwar 
betrachten wir einen Extremfall, in dem wir den Inhalt der Register D0..D7 und
A0..A6 bertragen mssen: wir bruchten genau 8 + 7 = 15 Move.l fr insgesamt
15 * 12 = 180 Zyklen. Wenn wir stattdessen das Movem verwenden, htten wir 
8 + 8 * 15 = 128 Zyklen, das ist eine Einsparung von 52 Zyklen!
An dieser Stelle wird deutlich, dass natrlich das Mammut Movem verwendet
werden muss, wenn groe Datenmengen bertragen werden mssen. Wenn nur zwei
Register verwendet werden, sollte das normale Move.l verwendet werden. An
dieser Stelle sehen wir eine Reihe praktischer Anwendungen, die mit einem nicht
optimierten Code beginnen bis zu einem optimierten.
Angenommen, wir mssen 1200 Bytes vom Speicherort Table zurcksetzen.
Anfnger wrden es so machen:

	Lea	Table,a0		; 12 Zyklen
	Move.w	#1200-1,d7	; 8 Zyklen
CleaLoop:
	Clr.b	(a0)+		; 12 Zyklen 
	Dbne	d7,CleaLoop ; 10 Zyklen / (1*14 Zyklen)

Diese Art von Code ist schrecklich!! Mal sehen, wie lange es dauert ... die
ersten zwei Anweisungen dauern 20 Zyklen, dann muss das clr.b 1200 mal
ausgefhrt werden d.h. 1200 * 12 = 14400 Zyklen, auerdem muss das Dbne
hinzugefgt werden was  1199 * 10 = 11990 Zyklen durchgefhrt werden muss
plus 14 am Ende.
Zusammenfassung 20 + 14400 + 11990 + 14 = 26424!!! Nun, das alles ist keinen
Kommentar wert. Wir htten zumindest so etwas tun knnen:

	Lea	Table,a0
	Move.w	#(1200/4)-1,d7	; Anzahl der Bytes geteilt durch 4, fr das clr.l !
Clr:
	Clr.l	(a0)+		; Wir setzen jeweils 4 Bytes zurck ...
	Dbra	d7,Clr		; und wir machen 1/4 der Schleifen.

Tatschlich lschen wir mit einem Clr.l mindestens 4 Bytes auf einmal und da
wir 1200 zu lschen haben, wrden wir 1200/4 = 300 Zyklen machen und viel
weniger im Vergleich zu frher bentigen (rechnen Sie aus Mitleid selbst nach).
Um noch mehr zu optimieren, knnen wir dies tun:

	Lea	Table,a0
	Move.w	#(1200/16)-1,d7	; Anzahl der Bytes geteilt durch 16 fr das clr.l !
Clr:
	Clr.l	(a0)+		; zurcksetzen 4 bytes
	Clr.l	(a0)+		; zurcksetzen 4 bytes
	Clr.l	(a0)+		; zurcksetzen 4 bytes
	Clr.l	(a0)+		; zurcksetzen 4 bytes
	Dbra	d7,Clr		; und wir machen 1/16 der Schleifen.

Allerdings kann auch diese Art von Code als schlecht eingestuft werden. Lassen 
Sie uns versuchen, es mithilfe eines Datenregisters weiter zu optimieren:

	Lea	Table,a0
	moveq	#0,d0		; "move.l d0" schneller als ein "CLR"!
	Move.w	#(1200/32)-1,d7	; Anzahl der Bytes geteilt durch 32
Clr:
	move.l	d0,(a0)+	; zurcksetzen 4 bytes
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	Dbra	d7,Clr		; und wir machen 1/32 der Schleifen.

Mit dieser Version haben wir die Optimierung aufgrund der Verringerung der
auszufhrenden dbra erhht, und wir haben die Tatsache ausgenutzt, dass die
Verwendung von Registern mega-schnell ist, sogar schneller als "CLR".

Wir kommen jetzt dazu, das Movem zu benutzen und sehen, was passiert:

	movem.l	TantiZeri(PC),d0-d6/a0-a6	; alle Register lschen
						; auer d7 und a7, natrlich,
						; welcher der stack ist. Sie knnen
						; so oder mit vielen moveq #0,Dx zurcksetzen...
					
; Jetzt haben wir 7 + 7 = 14 Register gelscht, insgesamt 14*4=56 byte.
; Wir mssen 1200 Byte/56 Byte = 21 bertragen, aber 21*56=1176 Byte, und
; weitere 1200-1176 = 24 Byte mssen noch erledigt werden, was wir separat
; tun werden.

	Move.l	a7,SalvaStack	; wir speichern den Stack in einem Label
	Lea	Table+1200,a7	; in A7 einfgen (oder SP, es ist das gleiche Register)
						; die Adresse des Endes des zu reinigenden Bereichs.
	Moveq	#21-1,d7	; Anzahl der auszufhrenden movem (2100/56=21)
CleaLoop:
	Movem.l	d0-d6/a0-a6,-(a7)	; Wir setzen "rckwrts" zurck 56 bytes.
								; Wenn Sie sich erinnern, das movem arbeitet
								; schreibend "rckwrts" fr den Stack.
	Dbra	d7,CleaLoop
	Movem.l	d0-d5,(a7)+	  		; die hohen 24 bytes zurcksetzen
	Move.l	SalvaStack(PC),a7 	; den Stack wieder in SP setzen
	rts

SalvaStack:
	dc.l	0

Rechnen wir mal nach: Das interne MOVEM bentigt genau 8+8*14=120 Zyklen, es
muss 21 Mal ausgefhrt werden, also 21*120=2520 Zyklen, zu denen mssen wir
die gesamte Initialisierungs- und Schliephase hinzurechnen, aber keine Sorge,
die oben genannten Flle werden nicht berschritten. Wir knnen noch mehr
Perfektionist sein, indem wir den Code erweitern, d h. die Schleifen
eliminieren und so viele MOVEMs wie ntig einfgen; keine Angst, die Code-
Erweiterung ist eine weit verbreitete Technik, besonders wenn man nicht mehr
wei, was man optimieren soll. Wir werden sim Folgenden eine Reihe von
Beispielen sehen. Im ersten Fall wrde jedoch folgendes passieren:

	Move.l	a7,SalvaStack	; wir speichern den Stack in einem Label
	Lea	Table+1200,a7	; in A7 einfgen (oder SP, es ist das gleiche Register)
				; die Adresse des Endes des zu reinigenden Bereichs.
CleaLoop:

	rept	20				  ; wiederholen 20 movem...
	Movem.l	d0-d7/a0-a6,-(a7) ; Wir setzen "rckwrts" zurck 60 bytes.
	endr

	Move.l	SalvaStack(PC),a7 ; den Stack wieder in SP setzen
	rts

Beachten Sie, dass wir nachdem wir das dbra eliminiert haben, auch das Register
d7 verwenden knnen, wodurch wir mit jedem Movem 4 Bytes mehr zurcksetzen
knnen. Auf diese Weise ist 1200/60 genau 20. Demos verwenden normalerweise
dieses System, das schnellste!

Schauen wir uns die Code-Erweiterungstechnik genauer an. Beachten Sie diese
Routine:

ROUTINE2:
	MOVEQ	#64-1,D0	; 64 Zyklen
SLOWLOOP2:
	MOVE.W	(a2),(a1)
	ADDQ.w	#4,a1
	ADDQ.w	#8,a2
	DBRA	D0,SLOWLOOP2

Und hier ist die sehr beschleunigte Routine:

ROUTINE2:
	MOVE.W	(a2),(a1)
	MOVE.W	8(a2),4(a1)
	MOVE.W	8*2(a2),4*2(a1)
	MOVE.W	8*3(a2),4*3(a1)
	MOVE.W	8*4(a2),4*4(a1)
	MOVE.W	8*5(a2),4*5(a1)
	MOVE.W	8*6(a2),4*6(a1)
	MOVE.W	8*7(a2),4*7(a1)
	.....
	MOVE.W	8*63(a2),4*63(a1)

Wir haben die Zeit fr das DBRA und die 2 Addqs entfernt! Es muss jedoch gesagt
werden, dass 68020 und hhere Prozessoren Befehls-Cache haben, die Schleifen mit
einer Lnge von weniger als 256 Bytes beschleunigen. Es kann also vorkommen,
dass es fr 68000 optimiert und langsamer, als auf 68020 ausgefhrt wird.
Folglich wre es gut, eine Vermittlung wie diese durchzufhren:

ROUTINE2:
	MOVEQ	#4-1,D0				; nur 4 Zyklen (64/16)
FASTLOOP2:
	MOVE.W	(a2),(a1)			; 1
	MOVE.W	8(a2),4(a1)			; 2
	MOVE.W	8*2(a2),4*2(a1)		; 3
	MOVE.W	8*3(a2),4*3(a1)		; 4
	MOVE.W	8*4(a2),4*4(a1)		; 5
	MOVE.W	8*5(a2),4*5(a1)		; ...
	MOVE.W	8*6(a2),4*6(a1)
	MOVE.W	8*7(a2),4*7(a1)
	MOVE.W	8*8(a2),4*8(a1)
	MOVE.W	9*9(a2),4*9(a1)
	MOVE.W	8*10(a2),4*10(a1)
	MOVE.W	8*11(a2),4*11(a1)
	MOVE.W	8*12(a2),4*12(a1)
	MOVE.W	8*13(a2),4*13(a1)
	MOVE.W	8*14(a2),4*14(a1)
	MOVE.W	8*15(a2),4*15(a1)	; 16
	ADD.w	#4*16,a1
	ADD.w	#8*16,a2
	DBRA	D0,FASTLOOP2

Dies gilt auch fr das Lschen mit dem Movem und die anderen Routinen, bei
denen wir einen Teppich wiederholen.

Lassen Sie uns nun einige ntzliche Beobachtungen machen:
Die selbstinkrementierende indirekte Adressierungsmethode ist etwas, das man
immer im Hinterkopf behalten sollte. In der Tat bentigt die indirekte
Adressierung, sowohl ohne als auch mit Inkrement die gleiche Anzahl von Zyklen.
Ein sehr guter Fall ist die Verwendung des Blitters, und wir werden spter ein
Beispiel dieser Art sehen.
Die zweite Methode, mit der wir zum Kopieren der 1200 Bytes verwendet haben,
ist jedoch nicht komplett zu verwerfen: Wenn wir eine Kopie machen mssten,
knnten wir es viel besser machen, aber denken Sie an den Fall, indem wir 1200
Bytes maskieren mussten: Wir sind zwangslufig gezwungen, eine Dbcc-Schleife zu
verwenden. Versuchen Sie in diesen Fllen, die Vorteile der Dbcc-Anweisung zu
nutzen und denken Sie daran, dass auf einem 680xx mit Cache diese Arten von
Schleifen mit TURBO-Geschwindigkeit ausgefhrt werden.
Darber hinaus eignen sich die DBcc-Anweisungen auch hervorragend fr
Vergleiche. Hier ein Beispiel:

	Move.w	Len(PC),d0		; Max Lnge zu suchen <> 0
	Move.l	String(PC),a0	
	Moveq	#Char,d1		; Character zu suchen
FdLoop:
	Cmp.b	(a0)+,d1
	Dbne.s	d0,FdLoop

Der folgende Schleife berprft zwei Dinge gleichzeitig, und zwar wird der cc
EQ gesetzt, wenn wir alle Len (Anzahl der Zeichen) untersucht haben, oder wenn
das Zeichen gefunden wurde, knnten wir in diesem Fall auch sagen an welcher
Position es sich befindet.
An dieser Stelle mchte ich die letzten Beispiele zum Movem und machen, und
zwar speziell zum Kopieren von Speicherzonen: Im Gegensatz zum Nullsetzen 
mssen wir hier Daten abrufen und dann kopieren, aber sehen wir uns sofort ein
Beispiel an:

	Lea	Start,a0
	Lea	Dest,a1
FASTCOPY:								; Ich benutze 13 Register
	Movem.l	(a0)+,d0-d7/a2-a6
	Movem.l	d0-d7/a2-a6,(a1)
	Movem.l	(a0)+,d0-d7/a2-a6
	Movem.l	d0-d7/a2-a6,$34(a1)			; $34
	Movem.l	(a0)+,d0-d7/a2-a6
	Movem.l	d0-d7/a2-a6,$34*2(a1)		; $34*2
	Movem.l	(a0)+,d0-d7/a2-a6
	Movem.l	d0-d7/a2-a6,$34*3(a1)
	Movem.l	(a0)+,d0-d7/a2-a6
	Movem.l	d0-d7/a2-a6,$34*4(a1)
	Movem.l	(a0)+,d0-d7/a2-a6
	Movem.l	d0-d7/a2-a6,$34*5(a1)
	Movem.l	(a0)+,d0-d7/a2-a6
	Movem.l	d0-d7/a2-a6,$34*6(a1)
	Movem.l	(a0)+,d0-d7/a2-a6

Zunchst einmal haben wir hier die Technik der Code-Erweiterung bernommen
(wenn man sie so nennen kann). Sie mag bertrieben sein, aber sie ist sehr
effizient. Nun, was haben wir getan? Wir nehmen 13*4 Bytes vom Speicherort, auf
den a0 zeigt und kopieren sie an den Speicherort auf den a1 zeigt, wobei wir
darauf achten, den Offset zu a1 nach jedem kopieren zu erhhen. Falls Sie den
Code erweitern mchten, strt es wenn Sie alle diese Anweisungen sehen. Sie
knnen die Rept-Direktive verwenden:

	REPT		100
	And.l		(a0)+,(a1)+
	ENDR

Der Assembler generiert sie dann fr Sie. Zum Schluss sehen wir uns ein
Beispiel zu den Farbregistern an:

	Lea	$dff180,a6
	Movem.l	Colours(pc),d0-a5	; wir laden 14 Langwrter oder 28 Wrter
	Movem.l	d0-a5,(a6)			; setzt 28 Farben auf einmal!!
	
Colours:	dc.w	...


Oder wenn Sie zu Beginn einer Routine viele Register laden mssen:


	MOVE.L	#$4232,D0
	MOVE.W	#$F20,D1
	MOVE.W	#$7FFF,D2
	MOVEQ	#0,D3
	MOVE.L	#123456,D4
	LEA	$DFF000,A0
	LEA	$BFE001,A1
	LEA	$BFD100,A2
	LEA	Schermo,A3
	LEA	BUFFER,A4
	...

All dies kann mit nur 1 Routine zusammengefasst werden:


	MOVEM.L	VariaRoba(PC),D0-D4/A0-A4
	...

VariaRoba:
	dc.l	$4243		; d0
	dc.l	$f20		; d1
	dc.l	$7fff		; d2
	dc.l	0			; d3
	dc.l	$123456		; d4
	dc.l	$dff000		; a0
	dc.l	$bfe001		; a1
	dc.l	$bfd100		; a2
	dc.l	Schermo		; a3
	dc.l	Buffer		; a4

Zum Movem-Befehl knnten wir noch viele andere Beispiele auffhren, aber ich
denke, Sie haben seine Ntzlichkeit in bestimmten Fllen verstanden.

Aufrufe, die sich auf den Programmcounter (PC) beziehen, sind schneller als
Aufrufe zu normalen Labeln, weil sie "kleiner" sind. In der Tat mssen die
normalen Aufrufe die 32bit lange Adresse der Label enthalten, whrend die (PC)
Aufrufe nur den 16-Bit-Offset des PC-Registers enthalten, wodurch 2 Bytes und
Zeit gespart werden. Leider ist es genau die Tatsache, dass der Offset 16Bit
betrgt, was es uns nicht erlaubt, relativ zum PC weiter als 32k vorwrts oder
rckwrts zu gehen. Wir kommen nun zu einem Trick, um das gesamte Programm
relativ zum (PC) zu machen, was die Ausfhrung beschleunigt. Wie Sie wissen,
ist es mglich, dies zu tun:

	move.l	label1(PC),d0

Aber es ist jedoch unmglich, diese Anweisung relativ zum PC zu machen:

	move.l	d0,label1

Wie macht man das? Dies ist kein groes Problem, aber nehmen wir an, wir haben
diese Anweisung viele Male in einer Schleife ausgefhrt. Wenn wir das Label
nicht relativ zum PC machen knnen, knnen wir es relativ zu einem gemeinsamen
Adressregister machen! Die naheliegendste Methode ist diese:

	move.x	XXXX,label	->	lea	label(PC),a0
							move.x  XXXX,(a0)

	tst.x	label		->	lea	label(PC),a0
							tst.x	label

Beachten Sie, dass es auch Zeit spart, die #immediate Werte durch Werte aus 
Datenregistern zu ersetzen, solange die Werte zwischen -80 und + 7f liegen, um 
um die Verwendung von "MOVEQ" zu ermglichen:

	move.l	#xx,dest	->	moveq	#xx,d0
							move.l	d0,dest


	ori.l	#xx,dest	->	moveq	#xx,d0
							or.l	d0,dest


	addi.l	#xx,dest	->	moveq	#xx,d0
							add.l	d0,dest

Insbesondere wenn es mglich ist, alle Register vor einer Schleife zu laden um
dann Zeit beim Laden zu sparen, knnen Sie auch "MOVE.L #xx,Dx" ausfhren, die
Schleife ohne #immediate wird sich auszahlen!

Beispiel:

RoutineSchifosa:
	move.w	#1024-1,d7		; Anzahl der Schleifen
LoopSquallido:
	add.l	#$567,label2
	sub.l	#$23,label3
	move.l	label2(PC),(a0)+
	move.l	label3(PC),(a0)+
	add.l	#30,(a0)+
	sub.l	#20,(a0)+
	dbra	d7,LoopSquallido
	rts

Dies kann so optimiert werden':

RoutineDecente:
	moveq	#30,d0			; wir laden die notwendigen Register...
	moveq	#20,d1
	move.l	#$567,d2
	moveq	#$23,d3
	lea	label2(PC),a1
	lea	label3(PC),a2
	move.w	#1024-1,d7		; Anzahl der Schleifen
LoopNormale:
	add.l	d2,(a1)
	sub.l	d3,(a2)
	move.l	(a1),(a0)+
	move.l	(a2),(a0)+
	add.l	d0,(a0)+
	sub.l	d1,(a0)+
	dbra	d7,LoopNormale
	rts

Um es zu bertreiben, knnen wir endlich die Anzahl der 
auszufhrenden Dbra sparen:

RoutineOK:
	moveq	#30,d0
	moveq	#20,d1
	move.l	#$567,d2
	moveq	#$23,d3
	lea	label2(PC),a1
	lea	label3(PC),a2
	move.w	#(1024/8)-1,d7	; Anzahl der Schleifen = 128
LoopOK:

	rept	8				; Ich wiederhole 8 mal das Stck...

	add.l	d2,(a1)
	sub.l	d3,(a2)
	move.l	(a1),(a0)+
	move.l	(a2),(a0)+
	add.l	d0,(a0)+
	sub.l	d1,(a0)+

	endr

	dbra	d7,LoopNormale
	rts

Um jedoch alles, was mit dem PC zu tun hat, schnell zu machen, gibt es ein
System. Wenn wir in einem festgelegten Adressregister, zum Beispiel a5, die
Adresse des Programmanfangs, oder auf jeden Fall eine in unserem Programm
bekannte Adresse haben, reicht es aus, unser Label als a5 + Offset anzugeben,
um das betreffende Label zu finden. Aber sollten wir dies "VON HAND" tun????
Nein, nein! Hier ist ein sehr schneller Weg, dies zu tun:

S:								; Label der Referenz
MYPROGGY:
	LEA	$dff002,A6				; in a6 haben wir das custom Register
	LEA	S(PC),A5				; in a5 das Register fr den Labelversatz

	MOVE.L	#$123,LABEL2-S(A5)	; label2-s = offset! Beispiel: "$364(a5)"

	MOVE.L	LABEL2(PC),d0		; hier handeln wir normal

	MOVE.L	d0,LABEL3-S(A5)		; gleiche Rede.

	move.l	#$400,$96-2(a6)		; Dmacon (in a6 ist $dff002!!!)

	...

; Nehmen wir an, Sie haben das A5-Register "verschmutzt" ... 
; laden Sie es einfach neu!

	LEA	S(PC),A5
	move.l	$64(a1),OLDINT1-S(A5)
	CLR.L	LABEL1-S(A5)

Es scheint klar zu sein, oder? Sie htten das Label BAU: anstelle von S:
nennen knnen, aber ich denke, dass es ntzlich ist, es S:, E:, I: zu nennen,
was krzer zu schreiben ist. Die einzige Einschrnkung besteht darin, dass,
wenn das Label mehr als 32 KB vom Referenzlabel entfernt ist, berschreiten
wir die Adressierungsgrenzen. Das ist kein unberwindbares Problem, denn es
reicht aus, alle 30K ein Referenzlabel zu setzen und auf das nchstgelegene
zu verweisen, zum Beispiel:

B:
	...
	LEA	B(PC),A5
	MOVE.L	D0,LABEL1-B(A5)
	...

; 30K Pass

C:

	LEA	C(PC),A5
	MOVE.L	(a0),LABEL40-C(A5)
	...

Dieses System macht es auch schwierig, Ihren Code zu disassemblieren fr den
Fall, dass jemand Ihre Routinen mit einem Disassembler "stehlen" mchte.

Eine weitere Sache, die fr Sie ntzlich sein kann, ist die Verwendung von Bits
als Flags. Beispielsweise, wenn wir in unserem Programm Variablen haben, die
TRUE oder FALSE sein mssen, dh ON oder OFF, dann ist es sinnlos, fr jedes ein
Byte zu verschwenden. Ein Bit reicht aus, und wir sparen Platz. Zum Beispiel:

Opzione1	=	0
VaiDestra	=	1		; gehe nach rechts oder links?
Avvicinamento	=	2	; Annherung oder Rckzug?
Music		=	3		; Musik ein oder aus?
Candele		=	4		; Kerzen anznden oder nicht anznden?
FirePremuto	=	5		; jemand drckte Feuer?
Acqua		=	6		; im Teich unten?
Cavallette	=	7		; gibt es Heuschrecken?

Controllo:
	move.w	MieiFlags(PC),d0
	btst.l	#Opzione1,d0
	...


CambiaFlags:
	lea	MieiFlags(PC),a0
	bclr.b	#Opzione1,(a0)
	...

MieiFlags:
	dc.b	0
	even

Wenn Sie jedoch btst und bclr/bset/bchg nicht mgen, knnen Sie dies tun:

	bset.l	#Opzione1,d0	->	or.b	#1<<Opzione1,d0

	bclr.l	#Opzione1,d0	->	and.b	#~(1<<Opzione1),d0

	bchg.l	#Opzione1,d0	->	eor.b	#1<<Opzione1,d0

Beachten Sie die Ntzlichkeit der asmone Verschiebefunktionen ">>" und "<<"
sowie das eor "~".

Um den Abschnitt ber CPU-Optimierungen zu beenden, stelle ich einige Tricks
vor, die nur auf 68020 und hher beschleunigen, aber da sie nichts kosten, kann
es ntzlich sein, um unsere Routinen auf schnelleren Computern spritziger zu
sehen.
Zunchst einmal gibt es die Caches, die es erlauben, Schleifen die bis zu 256 
Bytes lang sind, so dass sie ab der zweiten Schleifen aus dem internen Speicher
zur CPU!!!!!!!!!!!!!! und nicht aus dem langsamen Speicher (insbesondere wenn
Chip-Ram!) lesen. Folglich ist es gut, die Operationen so zu wiederholen, wie
wir es gesehen haben, in den verschiedenen Schleifen zu wiederholen, so dass
sie etwa 100-150 Bytes gro sind. Auf diese Weise laufen sie auf 68020+ viel
schneller als Routinen, in denen stattdessen so viele Anweisungen
aneinandergereiht werden, wie Schleifen zu erledigen sind. Um das
klarzustellen, wenn wir haben:

Routine1:
	move.w	#2048-1,d7
loop1:
	< Block mit Anweisungen >
	dbra	d7,loop1

Wir knnen es optimieren in:

Routine1:
	rept	2048
	< Block mit Anweisungen >
	endr	

Auf einem Basis 68000er ist es viel schneller, aber auf einem 68020 ist es
langsamer! Optimierung, die in allen Fllen so schnell wie mglich ist:

Routine1:
	move.w	#(2048/16)-1,d7
loop1:
	rept	16
	< Block mit Anweisungen >
	endr

	dbra	d7,loop1

Angenommen, der Befehlsblock ist 12 Bytes lang, dann sind 12*16=192, die sich
im Cache befinden und es geht sehr schnell auf 68020, whrend auf 68000 der
Unterschied zur der Version mit 2048 rept unmerklich ist und Sie sparen auch in
der Lnge der ausfhrbaren Datei. Achten Sie nicht nur darauf, die Schleifen
nur 250 oder 256 Bytes lang zu machen, da der Cache nur nach bestimmten
"blocking" und "alignment" Bedingungen gefllt werden kann. Bleiben Sie also
immer unter 180-200 Bytes, nur um sicher zu gehen.

Ein weiterer Punkt, den Sie beachten sollten, ist, dass Sie, wenn es mglich
ist einen aufeinanderfolgenden Zugriff auf den Speicher zu vermeiden. Beispiel:

	move.l	d0,(a0)
	move.l	d1,(a1)
	move.l	d2,(a2)
	sub.l	d2,d0
	eor.l	d0,d1
	add.l	d1,d2

Es sollte "umformuliert" werden in:

	move.l	d0,(a0)
	sub.l	d2,d0
	move.l	d1,(a1)
	eor.l	d0,d1
	move.l	d2,(a2)
	add.l	d1,d2

Wenn auf den Speicher zugegriffen wird (insbesondere wenn Chip-RAM), gibt es
die sogenannten WAIT STATE, dh Wartezeiten, bevor wieder geschrieben werden
kann. In dem ersten Beispiel gibt es zwischen einem Schreibvorgang und dem
anderen eine Totzeit, in der der Prozessor darauf wartet, dass die Daten in
den Speicher zurckgeschrieben werden.
Im zweiten Fall hingegen, wird nach dem Schreiben in den RAM eine Operation
zwischen Registern innerhalb der CPU ausgefhrt, nach der Ablauf erneut auf den
Chip-RAM zugegriffen wird, sobald die Zugriffszeit abgelaufen ist. Beim Zugriff
auf 32-Bit-FAST-RAM, ist das Problem weit weniger schwerwiegend, aber es
besteht.

Schlielich mag der 68020+ wirklich Routinen und Label, die an Adressen mit
Vielfachen von 32 ausgerichtet sind, d.h. Langwort ausgerichtet.
Um auf 32-Bit auszurichten, gengt ein:

	CNOP	0,4

Vor der Routine oder dem Label. Auf 68000 gibt es keine Verbesserungen, aber
auf 68020+ gibt es sie, insbesondere wenn der ausgerichtete Code in Fast RAM
oder in Cache geht. Hier ist ein Beispiel:

Routine1:
	bsr.s	rotazione
	bsr.s	proiezione
	bsr.s	disegno
	rts

	cnop	0,4
rotazione:
	...
	rts

	cnop	0,4
proiezione:
	...
	rts

	cnop	0,4
disegno:
	...
	rts

Stellen Sie bei Labeln sicher, dass Sie nicht auf ungerade Adressen zugreifen,
wodurch es sich verlangsamt. Richten Sie diese stattdessen auch auf long aus:

Originalfassung:

Label1:
	dc.b	0
Label2:
	dc.b	0	; Adresse seltsam! "move.b xx, label1" wird langsam sein!
Label3:
	dc.w	0
Label4:
	dc.w	0
Label5:
	dc.l	0
Label6:
	dc.l	0
Label7:
	dc.l	0

ausgerichtete Version:

	cnop	0,4
Label1:
	dc.b	0
	cnop	0,4
Label2:
	dc.b	0
	cnop	0,4
Label3:
	dc.w	0
	cnop	0,4
Label4:
	dc.w	0
	cnop	0,4
Label5:
	dc.l	0
Label6:
	dc.l	0 ; diese 2 sind definitiv ausgerichtet, 
Label7:		  ;	es besteht keine Notwendigkeit fr cnop
	dc.l	0

Um zu berprfen, ob ein Label auf 32-Bit ausgerichtet ist, assemblieren Sie
es und prfen Sie dann, an welcher Adresse dieses Label sich befindet mit dem
Befehl "M", dann dividieren Sie die Adresse durch 4 und multiplizieren das
Ergebnis erneut mit 4. Wenn die ursprngliche Adresse zurckgegeben wird,
bedeutet dies, dass es ein Vielfaches von 4 ist und alles ist OK, wenn es
anders ist, bedeutet dies, dass es einen Rest gibt und es kein Vielfaches von
4 ist. Setzen Sie dann "dc.w 0" ber die Adresse und versuchen Sie, es "von
Hand" auszurichten und schicke den Assembler ins Land, das ein wenig gespielt
wird. Wenn Ihre Routine jedoch bereits bis zur fnfzigsten ruckelfrei auf A500
luft, ersparen Sie sich all diese "cnop 0,4" in ihrem Listing. "Cnop" nur in
den Listings mit sehr schweren Routinen auffhren, die nicht innerhalb eines
frames funktionieren, wie z.B. fraktale Routinen oder "bertriebene" 
3D-Routinen usw.

******************************************************************************
*			OPTIMIERUNGEN VON BLITTER										 *
******************************************************************************

Am Ende werden wir ein weiteres Beispiel zum Blitter auffhren.
Die Art von Optimierungen, die wir bisher behandelt haben, beziehen sich nur 
auf den 68000er und sind daher unabhngig von der Maschine, auf die wir Bezug
genommen haben. Wir werden nun hardwarebezogene Optimierungen vom Amiga
diskutieren, genau genomen zum Blitter.
Wie Sie wissen, ist der Blitter ein leistungsstarker Coprozessor zum Bewegen
von Daten viel schneller als der Basis 68000er (beachten Sie jedoch, dass er
langsamer ist als ein 68020+!). Es ist gut, das Meiste mit dem Blitter zu
machen. Eine allgemein akzeptierte Philosophie fr Blitts ist, das ich nach dem
Start der Datenbertragung frher fertig bin. Sie mssen sich jedoch immer gut
an das Bit namens "blitter-nasty" halten, das dem Blitter in Bezug auf die CPU
eine hhere Prioritt einrumt. In der Praxis wird der Bus fr die bertragung
von Daten die meiste Zeit dem Blitter gehren, sehen wir uns ein Beispiel an:

a6=$dff000
			; angenommen, wir haben alle Register initialisiert
	
	Move.w	d0,$58(a6)		; BLTSIZE - der Blitter beginnt
Wblit:
	Move.w	#$8400,$96(a6)	; einschalten blit nasty
Wblit1:
	Btst	#6,2(a6)		; warten, bis der Blitter fertig ist
	Bne.s	Wblit1
	Move.w	#$400,$96(a6)	; ausschalten blit nasty
	....

Dies ist ein trivialer Fall, denn whrend der Blitter arbeitet, knnte die CPU
etwas anderes tun, so dass die Warteschleife nicht unproduktiv ist. In der Tat
blockiert diese Funktion auf Computern mit nur CHIP-RAM vollstndig den
Prozessor und sollte vielleicht nie verwendet werden.
Aber der Fall, in dem wir das blitter nasty aktivieren knnen und sollten, ist
in Fllen in denen wir auf dem Bildschirm eine Bitplane Bob pro Bitplane
kopieren mssen, denn da normalerweise die CPU zwischen den Blitts warten muss,
knnen wir das nasty blit aktivieren. Sehen wir uns ein Beispiel an:

BLITZ:						; die Register wurden bereits aktiviert
	Move.w	#$8400,$96(a6)	; einschalten blit nasty
	Move.l	Plane0,$50(a6)	; Zeiger Kanal A
	Move.l	a1,$54(a6)		; Zeiger Kanal D
	Move.w	d0,$58(a6)		; Start Blitter!!!
WBL1:
	Btst	#6,2(a6)		; hier muss die CPU auf das Ende warten...
	Bne.s	WBL1			; also muss der Blitter maximal gehen!
	Move.l	Plane1,$50(a6)	; Zeiger Kanal A
	Move.l	a2,$54(a6)		; Zeiger Kanal D
	Move.w	d0,$58(a6)		; Start Blitter!!!
WBL2:
	Btst	#6,2(a6)		; wie oben
	Bne.s	WBL2
	Move.l	Plane2,$50(a6)	; ebenso
	Move.l	a3,$54(a6)
	Move.w	d0,$58(a6)
WBL3:
	Btst	#6,2(a6)
	Bne.s	WBL3
	Move.w	#$400,$96(a6)	; an dieser Stelle kann auch das Bit blit nasty
	Rts						; deaktiviert werden.


Dieses Beispiel gibt mir die Gelegenheit, Sie auf eine Eigenschaft des Blitters
hinzuweisen, nmlich wenn einige Werte seiner Register nicht verndert werden,
zum Beispiel in den Moduloregistern (BltAMod, BltBMod usw.). Wir werden am Ende
des Blitts die gleichen Werte vorfinden, so dass keine Notwendigkeit besteht
sie erneut zu initialisieren, wenn das Modulo fr den nchsten Blit gleich ist.
Gleiches gilt fr Register wie BltCon0, BltCon1, BltFWM, BltLWM, aber es gilt
nicht fr Zeigerregister, wenn sie mit einer inkrementellen Adressierung
arbeiten. Dies legt Folgendes nahe: Angenommen, wir haben einen 5-Bitplane-Bob
eine nach der anderen in einer "Video"-Bitplane zu platzieren, dann laden wir
jedes Mal den Zeiger auf die "Video"-Bitplane in Register D und den Zeiger auf
den Bob in A: Nach dem ersten Blit wird das Register D geladen mit dem gleichen
Wert plus einem bestimmten Betrag, um auf die nchste Bitebene zu zeigen, aber
es wre nutzlos es fr Kanal A so zu tun, da unser Bob mit aufeinanderfolgende
Bitebenen im Speicher gespeichert wurde. Nach dem ersten Blit zeigt Kanal A
automatisch auf die zweite Bitebene des Bobs.
Wir knnen auch gute Ergebnisse erzielen, wenn wir Folgendes tun. Wir
reservieren einen Speicherbereich mit allen Werten, die an die Register des
Blitters bergeben werden sollen (in unserem Fall beginnt der Bereich mit
DataBlit). In einigen Adressregistern laden wir also die Registeradressen des
Blitters, damit wir schneller darauf zugreifen knnen, und wir kopieren die
vorgefertigten Daten zum Starten des Blitters durch direkten Zugriff auf die
CPU-Register. Sehen wir uns ein Beispiel an:

	Lea	$dff002,a6			; a6 = DMAConR
	Move.l	DataBlit(pc),a5	; dann zeigt a5 auf eine Wertetabelle
							; vorberechnet

; Laden wir nun die Adressregister

	Lea	$40-2(a6),a0		; a0 = BltCon0
	Lea	$62-2(a6),a1		; a1 = BltBMod
	Lea	$50-2(a6),a2		; a2 = BltApt
	Lea	$54-2(a6),a3		; a3 = BltDpt
	Lea	$58-2(a6),a4		; a4 = BltSize
	Moveq	#6,d0			; d0 Konstante zur berprfung des Zustands
							; des Blitters.
	Move.w	(a5)+,D7		; Anzahl der Blittings
	Move.w	#$8400,$96-2(a6) ; nasty enable
BLITLOOP:
	Btst	d0,(a6)			; Wie immer warten wir auf das Ende einiger
	Bne.s	BLITLOOP		; Operationen.
; Bevor wir nach unten schauen, machen wir eine
; Beobachtung, wenn ich in a0 den Wert $40000 habe
; fhre ich die Anweisung in drei verschiedenen Fllen aus
							; a)Move.b #"1",(a0)
							; b)Move.w #"12",(a0)
							; c)Move.l #"1234",(a0)
							; Ich werde die folgende Sache bekommen:
							;           (a)	(b)	(c)
							; $40000	"1"	"1"	"1"
							; $40001	"0"	"2"	"2"
							; $40002	"0"	"0"	"3"
							; $40003	"0"	"0"	"4"
							; Wir werden jetzt so etwas tun...
	Move.l	(a5)+,(a0)		; $dff040-42 das ist Bltcon0-Bltcon1
	Move.l	(a5)+,(a1)		; $dff062-64 das ist BltBMod-BltAMod
	Move.l	(a5)+,(a2)		; $dff050 - Kanal A
	Move.l	(a5)+,(a3)		; $dff054 - Kanal D
	Move.l	(a5)+,(a4)		; $dff058 - BLTSIZE... START!!
	Dbra	d7,BLITLOOP		; Dies fr d7 mal.


In diesem Beispiel haben wir verschiedene Optimierungstechniken verwendet, die
wir bereits besprochen haben, auf jeden Fall wollen wir einige davon sehen.
Zuallererst, wenn wir eine Schleife mehrmals ausfhren mssen und sich im
Inneren eine Operation befindet, die eine Konstante (d.h. ein unmittelbares
Datum) beinhaltet ist es besser, diesen Wert in ein Register zu schreiben, das
nicht in der Schleife verwendet wird. Dann Fhren Sie die Operation mit diesem
Wert direkt mit dem Register in der Schleife aus, das es enthlt, um den
Zugriff auf den Speicher zu vermeiden.
In unserem Fall haben wir diese Strategie verwendet, indem wir den Bit-Wert
zum Testen in das Register d0 geladen haben, um zu berprfen, ob der Blitter
seine Aufgabe beendet hat.
In der Praxis haben wir eine der ersten Regeln bernommen, die ich eingangs
erwhnt habe, und zwar immer zu versuchen, die Werte in den Registern zu
halten. Auerdem haben wir $dff002 als Basis verwendet und nicht $dff000. Das
wurde gemacht, um die Zeit zu eliminieren, die im Waitblit zur Berechnung des
Offsets verwendet wird:

	Btst	#6,2(a6)		; a6 = $dff000

Es ist langsamer als:

	btst	d0,(a6)			; a6 = $dff002, d0 = 6

Denken Sie daran, vor (a6) eine -2 zu setzen, um den richtigen Versatz zu
erhalten:

	$54-2(a6)				; BltDpt
	$58-2(a6)				; BltSize
	$96-2(a6)				; DmaCon
	...

Es ist wichtig, dass der Waitblit schnell ist, denn je frher er "merkt", dass 
der Blitt vorbei ist, desto eher beginnt der nchste!
Vermeiden Sie aus diesem Grund, den Waitblit mit einem BSR aufzurufen und
setzen Sie ihn immer vor Ort ein, und wiederhole ihn sogar jedes Mal, wenn Sie 
ihn brauchen.
Den gleichen Diskurs, den wir jetzt gemacht haben, haben wir auch auf die 
Register des Blitters angewendet, indem wir sie in die CPU-Register geladen
haben, um den Zugriff auf den Speicher zu vermeiden (in der Praxis greifen wir
ohnehin auf den Speicher zu, um den Blitter zu initialisieren, aber wir
vermeiden es, jedes Mal die Adresse aus dem Speicher zu holen).
Wir haben auch einen Trick verwendet, den jeder verwendet, der Spiele oder
Demos programmiert. Das heit, anstatt die Abmessungen des Bobs im Speicher zu
halten und dann den bltsize-Wert zu berechnen, behalten wir den bltsize-Wert
direkt bei. Wir haben es ber die DataBlit-Tabelle gemacht. Aber wie ich oben
erwhnt habe, kann der 68000 jedoch etwas anderes tun, whrend der Blitter
arbeitet, zum Beispiel, wenn der Blitter einen Speicherbereich lscht, kann der
68000 als guter Christ, ihm zum Beispiel helfen:


	btst	#6,2(a6)
WaitBlit:
	btst	#6,2(a6)
	bne.s	WaitBlit
	Moveq	#-1,d0
	Move.l	d0,$44(a6)			; -1 = $ffffffff
	Move.l	#$9f00000,$40(a6)
	Moveq	#0,d1
	Move.l	d1,$64(a6)
	Move.l	a0,$50(a6)
	Move.l	a1,$54(a6)
	Move.w	#$4414,$58(a6)		; Der Blitter beginnt zu reinigen...
	Move.l	a7,OldSp
	Movem.l	CLREG(pc),d0-d7/a0-a6	; Register reinigen
	Move.l	Screen(pc),a7		; Adresse der zu lschenden Zone
	Add.w	#$a8c0,a7			; zum Ende gehen (+$a8c0)

	Rept		1024			; der 68000 beginnt mit der Reinigung
	Movem.l	d0-d7/a0-a6,-(a7)	; 60 Bytes reinigen 1024 Mal
	EndR

	Lea	$dff000,a6
	Movea.l	OLDSP(pc),a7
	Rts

CLREG:
	ds.l	15


Wie Sie sehen knnen, reinigen hier der Blitter und die CPU zur Hlfte
den Bildschirm "gleichzeitig". Natrlich darf in diesem Fall das blitter
nasty nicht gesetzt sein, sonst kann die CPU nicht in Ruhe reinigen.

Der beste Weg, die Leistung Ihres Programms zu steigern, ist jedoch sehr
oft, die eigenen Algorithmen zu verbessern. Denken sie zum Beispiel nicht,
dass die Implementierung eines schlechten Sortieralgorithmus in Assembler wie
Bubble Sort schneller ist als der beste Sortieralgorithmus wie z.B. Quick
Sort, der in C implementiert ist.
Wenn Ihr Algorithmus auch nach Anwendung der besten Optimierungstechniken
einfach nicht schneller laufen will, dann lschen Sie ihn und schreiben Sie
ihn komplett neu mit einem besseren Algorithmus von Anfang an.
Und selbst wenn Sie den besten Algorithmus haben, versuchen Sie ihn immer zu
optimieren, sodass es auf Computern ausgefhrt werden kann, die auch nicht
schnell sind. Nicht wie in der Welt der PCs, wo ein 486-Programmierer
zufrieden ist, wenn der Code nur auf seiner eigenen Konfiguration schnell
ausgefhrt wird.

Was braucht es, um schnelle Routinen zu machen, wenn dann auf der Verpackung
des Spiels oder des Programms zu lesen ist: 
MINDESTKONFIGURATION: PENTIUM 60MHz mit 8MB RAM.

