;======================================================================================================================
; Random Number
; D0 - Byte containing Random Number
; https://eab.abime.net/showthread.php?t=53462
;======================================================================================================================

RndB:
		move.b	$dff007,d0		; Hpos
		move.b	$bfd800,d1		; Event counter - http://amiga-dev.wikidot.com/information:hardware#toc3
		eor.b	d1,d0
		rts

;======================================================================================================================
; Random Number Generator
; Written some 30 years ago by myself
; I have notes about it but don't ask me how it works right now
; It is following some University accademic thing that I used to understand back then :)
; D0 = Random Number between 0 and 255
;======================================================================================================================

RndA:
		clr.l	d0					;behaves as y-register
		clr.l	d1					;behaves as a-register
		clr.l	d2					;behaves as x-register
		clr.l	d3

		lea		rseed(pc),a0
		lea		const(pc),a1
	.rndst:
		moveq	#$08,d0
	.rndl1:
		and.b	#$fe,ccr			; ccr = Conditional Code Status Register
		move.w	$6(a0),d1
		bpl.s	.rndzb
		moveq	#$06,d2
	.rndl2:
		move.w	$0(a0,d2),d1
		move.w	$0(a1,d2),d3
		eor.w	d3,d1
		move.w	d1,$0(a0,d2)
		sub.b	#$02,d2
		bpl.s	.rndl2
		and.b	#$ff,ccr
	.rndzb:
		rol.w	$0(a0)
		rol.w	$2(a0)
		rol.w	$4(a0)
		rol.w	$6(a0)
		sub.b	#$01,d0
		bne.s	.rndl1
		move.b	$6(a0),d0
		rts

;Constants used by the RND routine
const:
		dc.w	$0053
		dc.w	$00b5
		dc.w	$0076

; Seeds Used by the RND routine
rseed:
		dc.w	$0001
		dc.w	$0002
		dc.w	$0003
		dc.w	$0004