;======================================================================================================================
; Prints a Character to the screen
;======================================================================================================================

PrintInfo:
	MOVE.L	TextPtr(PC),A0			; Text Address in a0
	MOVEQ	#0,D2					; Clear d2
	MOVE.B	(A0)+,D2				; Next Char d2
	CMP.B	#$ff,d2					; End of text? ($FF)
	beq.s	Text_Exit				; Yes - Exit
	TST.B	d2						; End of Line? ($00)
	bne.s	NotEOL					; No Not End Of Line

	ADD.L	#40*7,BitplanePtr		; Screen is 40 byte wide and the font is 8 bytes high
	ADDQ.L	#1,TextPtr				; Hold the column on the on the screen or where we are on the current line
									; hence reset it to 1 since we are starting a new line
	move.b	(a0)+,d2				; First character on the line skipping 0

NotEOL:
	SUB.B	#$20,D2					; Subtract 32 from the char ASCII value 
									; so that we can transform for example
									; if it was a space which is $20 to a $00
									; the asterics $21 to $01 etc etc
	LSL.W	#3,D2					; Multiply the same number by 8,
									; since the font is 8 pixels high
	MOVE.L	D2,A2					; move the multiplication result to A2
	ADD.L	#FONT,A2				; Add the value in A2 to the font Base address

	; Display char on bitplanes
	MOVE.L	BitplanePtr(PC),A3		; Bitplane Address in a3
	MOVE.B	(A2)+,40*0(A3)			; Print Line 1 of char
	MOVE.B	(A2)+,40*1(A3)			; Print Line 2 of char
	MOVE.B	(A2)+,40*2(A3)			; Print Line 3 of char
	MOVE.B	(A2)+,40*3(A3)			; Print Line 4 of char
	MOVE.B	(A2)+,40*4(A3)			; Print Line 5 of char
	MOVE.B	(A2)+,40*5(A3)			; Print Line 6 of char
	MOVE.B	(A2)+,40*6(A3)			; Print Line 7 of char
	MOVE.B	(A2)+,40*7(A3)			; Print Line 8 of char

	ADDQ.L	#1,BitplanePtr	 		; We need to move 8 bits or 1 byte for next character
	ADDQ.L	#1,TextPtr				; Next character to print

Text_Exit:
	RTS

TextPtr:
	dc.l	TextMsg

BitplanePtr:
	dc.l	GameScreenBitplanes

Font:
	incbin	"gfx/nice.fnt"

TextMsg:
    dc.b    "Phaze101 Rules"
    dc.b    $ff
    even