#include <proto/intuition.h>
#include <proto/graphics.h>
#include <proto/dos.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct Screen *pubscreen;
struct Screen *myscreen;

void cleanexit(char *s)
{
    UnlockPubScreen(NULL, pubscreen);
    CloseScreen(myscreen);

    if (s)
    {
	puts(s);
	exit(EXIT_FAILURE);
    }
    exit(EXIT_SUCCESS);
}

int main(void)
{
    int i, y;
    struct Screen *pubscreen = LockPubScreen(NULL);
    if ( ! pubscreen)
	cleanexit("LockPubScreen failed");

    int width = pubscreen->Width;
    int height = pubscreen->Height;
    int depth = GetBitMapAttr(pubscreen->RastPort.BitMap, BMA_DEPTH);
    myscreen = OpenScreenTags(NULL,
	    SA_Width, width,
	    SA_Height, height,
	    SA_Depth, depth,
	    TAG_END);

    if ( ! myscreen)
	cleanexit("OpenScreenTags failed");

    SetRGB32(&myscreen->ViewPort, 0, 0, 0 , 0); // black
    SetRGB32(&myscreen->ViewPort, 1, 0xFFFFFFFF, 0 , 0);  // red
    
    struct RastPort *rp = &myscreen->RastPort;
    BltBitMapRastPort(pubscreen->RastPort.BitMap, 0, 0, rp, 0, 0, width, height, 0xC0);
    
    Delay(50);

    // wiggle
    for (i=0; i<10 ; i++)
    {
	ScrollRaster(rp, 0, -5, 0, 0, width, height);
	Delay(3);
	ScrollRaster(rp, 0, 5, 0, 0, width, height);
	Delay(3);
    }
    
    // Guru
    BltBitMapRastPort(pubscreen->RastPort.BitMap, 0, 0, rp, 0, 120, width, height - 120, 0xC0);
    SetAPen(rp, 0);
    RectFill(rp, 0, 0, width-1, 120);
    SetAPen(rp, 1);
    char *text = "Software Failure. Press left mouse button to continue.";
    int xpos = (width - TextLength(rp, text, strlen(text))) / 2;
    Move(rp, xpos, 40);
    Text(rp, text, strlen(text));
    text = "Guru Meditation #80000004.01040104";
    xpos = (width - TextLength(rp, text, strlen(text))) / 2;
    Move(rp, xpos, 80);
    Text(rp, text, strlen(text));

    // blinking of red boarder
    for (i = 0 ; i < 10 ; i++)
    {
	if (i%2 == 0)
	    SetAPen(rp, 0);
	else
	    SetAPen(rp, 1);
	
	RectFill(rp, 0, 0, width - 1, 10);
	RectFill(rp, 0, 110, width - 1, 120);
	RectFill(rp, 0, 10, 10, 110);
	RectFill(rp, width - 11, 10, width - 1, 110);
	Delay(40);
    }

    BltBitMapRastPort(pubscreen->RastPort.BitMap, 0, 0, rp, 0, 0, width, height, 0xC0);
    SetAPen(rp, 0);

    for (y = 0 ; y < height / 2 ; y++)
    {
	BltBitMapRastPort(pubscreen->RastPort.BitMap, 0, y, rp, 0, y, width, 1, 0xC0);
	ScrollRaster(rp, 0, -2, 0, 0, width, y * 2 );
	Delay(1);
    }

    Delay(100);
    cleanexit(NULL);
    return EXIT_SUCCESS;
}

