  )                                    ;======================================================================
;=== Vector Color Fill Routive V1.2 === (C)1996 by Vlastimil Knotek ===
;======================================================================
>EXTERN 'DF0:wdemo/MirBlue',MirrorTab
>EXTERN 'DF0:BSVectors.RAW',Pic
;---------------------------------------------------------
MAXPOINTS1	=	156
MAXPOINTS2	=	8
MAXPOINTS3	=	8
MAXPOINTS4	=	8
SUMAPLANES	=	56+12
RESOLUTION	=	320
INTERLACE	=	256
DEPTH		=	3
;---------------------------------------------------------
Start:
	movem.l	d0-d7/a0-a6,-(a7)
	bsr	SaveAll
	bsr	InitAll
	bsr	MakeMulsList

	lea	Scene1(pc),a1
	bsr	InitAnim
	bsr	StartCopper
	bsr	MainLoop

	lea	Scene2(pc),a1
	bsr	InitAnim
	bsr	MainLoop

	lea	Scene3(pc),a1
	bsr	InitAnim
	bsr	MainLoop

	bsr	SpecialS4
	lea	Scene4(pc),a1
	bsr	InitAnim
	bsr	MainLoop

	lea	Scene5(pc),a1
	bsr	InitAnim
	bsr	MainLoop

	move.l	#AnimRot6,anim
	lea	Scene6(pc),a1
	bsr	InitAnim
	bsr	MainLoop
	move.l	#0,anim

	move.l	#AnimRot7,anim
	lea	Scene7(pc),a1
	bsr	InitAnim
	bsr	MainLoop
	move.l	#0,anim

	lea	Scene8(pc),a1
	bsr	InitAnim
	bsr	MainLoop

	lea	Scene9(pc),a1
	bsr	InitAnim
	bsr	MainLoop

	bsr	RestoreAll
	movem.l	(a7)+,d0-d7/a0-a6
	rts

SaveAll:
	move.l	$4.w,a6
	lea.l	GfxName(pc),a1
	moveq	#0,D0
	jsr	-408(a6)	;OldOpenLibrary
	move.l	d0,a1
	lea	OldCopper1(pc),a0
	move.l	$26(a1),(a0)
	lea	OldCopper2(pc),a0
	move.l	$32(a1),(a0)
	jsr	-414(a6)	;CloseLibrary

	move.l	chipbase(pc),a6
	lea	OldDMACON(pc),a0
	move.w	$002(a6),(a0)+
	move.w	$01c(a6),(a0)+
	move.l	$64.w,(a0)+
	rts

InitAll:
	move.l	TMapAddress(pc),a5
	move.l	#((RESOLUTION/8)*INTERLACE)/2-1,d0
.clrbuf	move.w	#0,(a5)+
	dbf	d0,.clrbuf
	
	lea	SpritesPtr(pc),a0
	move.l	(a0)+,a1
	move.l	(a0)+,a2
	move.l	(a0)+,a3
	move.l	#200-1,d0
.cloop	move.w	(a1),40(a1)
	move.w	(a2),40(a2)
	move.w	(a3),40(a3)
	addq.l	#2,a1
	addq.l	#2,a2
	addq.l	#2,a3
	dbf	d0,.cloop

	lea	SpritesPtr(pc),a0
	lea	SpritesPos(pc),a2
	moveq	#3-1,d0
.setc1	move.l	(a0)+,a1
	moveq	#11-1,d1
.setc2	move.w	(a2),(a1)
	move.b	(a2),2(a1)
	add.b	#9,2(a1)
	addq.l	#2,a2
	lea	40(a1),a1
	dbf	d1,.setc2
	dbf	d0,.setc1

	lea	CopperList+$2(pc),a0
	lea	SpritesPtr(pc),a1
	moveq	#3-1,d1
.ints	move.l	(a1)+,d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	addq.l	#$8,a0
	dbf	d1,.ints

	move.l	(a1),d0
	moveq	#5-1,d1
.sloop	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	swap	d0
	addq.l	#$8,a0
	dbf	d1,.sloop

	lea	BMaps+$2(pc),a0
	move.l	PicPtr(pc),d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)

	lea	Top(pc),a0
	move.l	#$2c07fffe,d0
	move.l	#$018000f0,d1
	move.l	#$01820000,d2
	moveq	#15,d3
.tset	move.l	d0,(a0)+
	addi.l	#$01000000,d0
	move.l	d1,(a0)+
	move.l	d2,(a0)+
	subi.l	#$00000010,d1
	addi.l	#$00000010,d2
	dbf	d3,.tset

	lea	Mirror(pc),a0
	lea	MirrorTab(pc),a1
	moveq	#11-1,d1
	move.l	#$f507fffe,d0
.scol1	move.l	d0,(a0)+
	addi.l	#$01000000,d0
	move.w	#$0180,(a0)+
	move.w	(a1)+,(a0)+
	dbf	d1,.scol1

	lea	12(a0),a0
	moveq	#48-1,d1
	move.l	#$0007fffe,d0
.scol2	move.l	d0,(a0)+
	addi.l	#$01000000,d0
	move.w	#$0180,(a0)+
	move.w	(a1)+,(a0)+
	dbf	d1,.scol2

	lea	Interrupt(pc),a0
	move.l	a0,$64.w
	rts

MakeMulsList:
	move.l	MulsPtr(pc),a0
	moveq	#0,d0
	move.l	#INTERLACE-1,d1
mmloop:	move.w	d0,(a0)+
	addi.w	Width(pc),d0
	dbf	d1,mmloop
	rts

StartCopper:
	move.l	#CopperList,$80(a6)
	tst.w	$88(a6)
	move.w	#$7fff,$96(a6)
	move.w	#$82e0,$96(a6)
	move.w	#$7fff,$9a(a6)
	;move.w	OldINTENA(pc),d0
	;or.w	#$c004,d0
	move.w	#$c004,$9a(a6)
	rts

InitAnim:
	bsr	ClearNorm
	movem.l	PlaneH(pc),d0-d1
	move.l	d0,PlaneS
	move.l	d1,PlaneH
	bsr	ClearNorm	

	move.l	a1,ScenePtr
	move.l	RootPtr(pc),a2
	move.w	(a1)+,d0	; number of objects
	subq.w	#1,d0
IA_01:
	move.l	(a1)+,a0	; address of object
	move.l	4(a0),a3
	bsr	PMuls	
	move.l	8(a0),a3
	lea	-14(a3),a3
	move.l	a3,4(a2)	; adresa na cinnost
	move.w	#0,8(a2)
	move.w	#0,10(a2)
	lea	12(a2),a2
	dbf	d0,IA_01

	lea	24(a0),a0
	lea	CopCol+$2(pc),a1
	moveq	#7,d1
.scol	move.w	(a0)+,(a1)
	addq.l	#4,a1
	dbf	d1,.scol

	bsr	Move
	move.w	#0,ends
	rts
PMuls:
	move.l	d0,-(a7)
	move.w	(a3)+,d1
	subq.w	#1,d1
.loop1
	moveq	#0,d0
	move.b	1(a3),d0
	addq.l	#4,a3
.loop2	move.w	(a3),d2
	add.w	d2,d2
	add.w	d2,d2
	move.w	d2,(a3)+
	dbf	d0,.loop2
	dbf	d1,.loop1
	move.l	(a7)+,d0
	rts

SpecialS4:
	lea	Body41(pc),a0
	move.w	(a0)+,d1
	subq.w	#1,d1
.ss41	sub.w	#120,(a0)
	addq.l	#6,a0
	dbf	d1,.ss41

	lea	Body42(pc),a0
	move.w	(a0)+,d1
	subq.w	#1,d1
.ss42	sub.w	#40,(a0)
	addq.l	#6,a0
	dbf	d1,.ss42

	lea	Body43(pc),a0
	move.w	(a0)+,d1
	subq.w	#1,d1
.ss43	add.w	#40,(a0)
	addq.l	#6,a0
	dbf	d1,.ss43

	lea	Body44(pc),a0
	move.w	(a0)+,d1
	subq.w	#1,d1
.ss44	add.w	#120,(a0)
	addq.l	#6,a0
	dbf	d1,.ss44
	rts

MainLoop:
	cmp.b	#-1,$6(a6)
	bne.s	MainLoop
.ml	cmp.b	#$18,$6(a6)
	bne.s	.ml

	bsr	Show
	bsr	ClearNorm	;ClearBig
	bsr	DoAnim

	move.w	ends(pc),d0
	tst.w	d0
	bne.s	mlend

	btst	#6,$bfe001
	beq.s	mlend

	bra.s	MainLoop

mlend:	btst	#6,$bfe001
	beq.s	mlend
	rts

RestoreAll:
	move.l	chipbase(pc),a6
raw:	btst	#6,$dff002
	bne.s	raw
	move.l	OldCopper1(pc),$080(a6)
	tst.w	$88(a6)
	move.l	OldCopper2(pc),$084(a6)
	tst.w	$8a(a6)
	move.l	OldSOFT(pc),$64.w
	move.w	OldDMACON(pc),d0
	or.w	#$8000,d0
	move.w	OldINTENA(pc),d1
	or.w	#$8000,d1
	move.w	d0,$096(a6)
	move.w	d1,$09a(a6)
	rts
;=========================================================
GfxName		DC.B	'graphics.library',0
		even
OldCopper1:	DC.L	0
OldCopper2:	DC.L	0
OldDMACON:	DC.W	0
OldINTENA:	DC.W	0
OldSOFT:	DC.L	0
;=========================================================
Interrupt:
	movem.l	d0-d7/a0-a6,-(a7)
	bsr	Stars
	move.l	anim(pc),a0
	cmp.l	#0,a0
	beq.s	Inext
	jsr	(a0)
Inext	move.l	chipbase(pc),a6
	bsr	Move
InterEnd:
	move.w	#$4,$09c(a6)
	movem.l	(a7)+,d0-d7/a0-a6
	rte
;=========================================================
Stars:	lea	Sprite1(pc),a0
	lea	Sprite2(pc),a1
	lea	Sprite3(pc),a2
	moveq	#11-1,d0
	moveq	#0,d1
.sloop	addq.b	#3,1(a0)
	addq.b	#2,1(a1)
	addq.b	#1,1(a2)
	add.b	d1,1(a0)
	add.b	d1,1(a1)
	add.b	d1,1(a2)
	lea	40(a0),a0
	lea	40(a1),a1
	lea	40(a2),a2
	addq.l	#1,d1
	cmpi.b	#4,d1
	bne.s	.cont
	moveq	#1,d1
.cont	dbf	d0,.sloop
	rts
;---------------------------------------------------------
Show:
	movem.l	PlaneH(pc),d0-d1
	move.l	d0,PlaneS
	move.l	d1,PlaneH
	lea	BitMaps+$2(pc),a0
	moveq.l	#DEPTH-1,d1
	addi.l	#$618,d0
.clp:	swap	d0
	move.w	d0,(a0)
	swap	d0
	move.w	d0,4(a0)
	add.l	#(RESOLUTION/8)*INTERLACE,d0
	addq.l	#8,a0
	dbf	d1,.clp
	rts
;---------------------------------------------------------
ClearNorm:
	move.l	chipbase(pc),a6

w1	btst	#6,$dff002
	bne.s	w1
         
	moveq	#-1,d0
	move.l	d0,$44(a6)
	move.w	#0,$66(a6)
	move.l	#$1000000,$40(a6)
	move.l	PlaneH(pc),$54(a6)
	move.w	#DEPTH*INTERLACE*64+RESOLUTION/16,$58(a6)
	rts
;---------------------------------------------------------
ClearBig:
	move.l	chipbase(pc),a6

w2	btst	#6,$dff002
	bne.s	w2
  
	moveq	#-1,d0
	move.l	d0,$44(a6)
	move.w	#0,$66(a6)  
	move.l	#$1000000,$40(a6)
	move.l	PlaneH(pc),$54(a6)
	move.w	#DEPTH*INTERLACE,$5c(a6)
	move.w	#RESOLUTION/16,$5e(a6)
	rts
;---------------------------------------------------------
Move:
	movem.l	d2-d3/a2-a3,-(a7)
	move.l	ScenePtr(pc),a2		; scene struct
	move.l	RootPtr(pc),a3
	move.w	(a2)+,d2		; number of objects
	subq.w	#1,d2
.lab
	move.l	(a2)+,a1	; address of object
	tst.w	10(a3)
	bne.w	.end
	move.l	4(a3),a0
	subq.w	#1,8(a3)
	bge.s	.ok
	lea	14(a0),a0
.ok3:
	cmp.w	#-1,(a0)	; koniec tabulky cinnosti ?
	bgt.s	.ok2
	move.w	#1,10(a3)
	movem.l	(a7)+,d2-d3/a2-a3
	rts
.ok2:
	move.w	(a0),8(a3)
	subq.w	#1,8(a3)
	move.l	a0,4(a3)
.ok:
	addq.l	#2,a0
	move.w	(a0)+,d0
	add.w	d0,12(a1)	; addx
	move.w	(a0)+,d0
	add.w	d0,14(a1)	; addy
	move.w	(a0)+,d0
	add.w	d0,16(a1)	; addz
	move.w	#360,d1
	move.w	d1,d3
	neg.w	d3
	move.w	(a0)+,d0
	add.w	d0,18(a1)	; add alfa
	cmp.w	18(a1),d3	; menej nez -360 ?
	blt.s	.okx
	add.w	d1,18(a1)
.okx:
	cmp.w	18(a1),d1	; viac ako 360 ?
	bgt.s	.ok1x
	sub.w	d1,18(a1)
.ok1x:
	move.w	(a0)+,d0
	add.w	d0,20(a1)	; add beta
	cmp.w	20(a1),d3
	blt.s	.oky
	add.w	d1,20(a1)
.oky:
	cmp.w	20(a1),d1
	bgt.s	.ok1y
	sub.w	d1,20(a1)
.ok1y:
	move.w	(a0)+,d0	; add gama
	add.w	d0,22(a1)
	cmp.w	22(a1),d3
	blt.s	.okz
	add.w	d1,22(a1)
.okz:
	cmp.w	22(a1),d1
	bgt.s	.end
	sub.w	d1,22(a1)
.end:
	lea	12(a3),a3
	dbf	d2,.lab
	movem.l	(a7)+,d2-d3/a2-a3
	rts
;---------------------------------------------------------
DoAnim:
	move.l	zorgptr(pc),ztabptr
	move.l	dtorgptr(pc),dttabptr
	move.w	#-1,drawnum		; forbit drawing
	move.l	RootPtr(pc),a2
	move.l	(a2),tmom
	move.l	ScenePtr(pc),a1
	move.w	(a1)+,d0		; numbers of objects
	subq.w	#1,d0
.ok:
	move.l	(a1)+,a0		; address of object
	movem.l	d0/a1-a2,-(a7)
	move.l	(a0)+,pdptr		; pointer to points
	move.l	(a0)+,atabptr		; pointer to areas
	lea	addx(pc),a1
	addq.l	#4,a0			; set ptr to start coords (x,y,z)
	movem.w	(a0),d0-d5		; x,y,z,alfa,beta,gama
	add.w	d3,d3			; alfa*2
	bge.s	.ok1
	add.w	#720,d3			; angle correction
.ok1:
	add.w	d4,d4
	bge.s	.ok2
	add.w	#720,d4
.ok2:
	add.w	d5,d5
	bge.s	.ok3
	add.w	#720,d5
.ok3:
	ext.l	d0
	asl.l	#4,d0		;start x*16
	ext.l	d1
	asl.l	#4,d1		;start y*16
	ext.l	d2
	asl.l	#4,d2		;start z*16
	movem.l	d0-d2,(a1)	;addx,addy,addz
	lea	12(a1),a1	;rx addrress
	movem.w	d3-d5,(a1)	;write angles to rx,ry,rz

	bsr.w	transform
	move.l	backside(pc),a0
	jsr	(a0)

	movem.l	(a7)+,d0/a1-a2
.nocalc:
	lea	12(a2),a2
	move.l	(a2),tmom
	dbf	d0,.ok

	bsr.w	vector

	move.l	ScenePtr(pc),a1
	move.w	(a1),d2		;pocet objectov
	subq.w	#1,d2
	move.l	RootPtr(pc),a3
endlp:
	tst.w	10(a3)
	beq.w	.end
	lea	12(a3),a3
	dbf	d2,endlp
	move.w	#1,ends
.end	rts
;---------------------------------------------------------
transform:
	move.l	pdptr(pc),a2	; address of points tab
	move.l	tmom(pc),a3	; address of new 2D coords
	lea	sintab(pc),a0
	lea	costab(pc),a1
	move.l	z2orgptr(pc),a4	; address of Z coords
	move.w	(a2)+,d5	; number of points
	subq.w	#1,d5
lp7:
	movem.w	(a2)+,d0-d2	; read x,y,z
	moveq	#4,d4
	asl.w	d4,d0
	asl.w	d4,d1
	asl.w	d4,d2
	move.w	rx(pc),d3	; rotate x [x angle(alfa)]
	move.w	d1,d4
	move.w	d2,d7
	muls	(a1,d3.w),d1	; ny=y*cos(al)
	muls	(a0,d3.w),d2	; nz=z*sin(al)
	sub.l	d2,d1		; fy=ny-nz
	add.l	d1,d1
	swap	d1
	muls	(a0,d3.w),d4	; ny=y*sin(al)
	muls	(a1,d3.w),d7	; nz=z*cos(al)
	add.l	d7,d4		; fz=ny-nz
	add.l	d4,d4
	swap	d4
	move.w	d4,d2		; d2=z

	move.w	ry(pc),d3
	move.w	d0,d4
	move.w	d2,d7
	muls	(a1,d3.w),d0	; nx=x*cos(be)
	muls	(a0,d3.w),d2	; nz=z*sin(be)
	add.l	d2,d0		; fx=nx+nz
	add.l	d0,d0
	swap	d0
	neg.w	d4		; d4=-x
	muls	(a0,d3.w),d4	; nx=-x*sin(be)
	muls	(a1,d3.w),d7	; ny=y*cos(be)
	add.l	d7,d4		; fz=nx+ny
	add.l	d4,d4
	swap	d4
	move.w	d4,d2

	move.w	rz(pc),d3
	move.w	d0,d4
	move.w	d1,d7
	muls	(a1,d3.w),d0	; nx=x*cos(ga)
	muls	(a0,d3.w),d1	; ny=y*sin(ga)
	sub.l	d1,d0		; fx=nx-ny
	add.l	d0,d0
	swap	d0
	muls	(a0,d3.w),d4	; nx=x*sin(ga)
	muls	(a1,d3.w),d7	; ny=y*cos(ga)
	add.l	d7,d4		; fy=nx+ny
	add.l	d4,d4
	swap	d4
	move.w	d4,d1

;PERSPECTIVE
	move.w	d2,(a4)+	; Z coord
	ext.l	d0
	ext.l	d1
	ext.l	d2
	add.l	addx(pc),d0
	add.l	addy(pc),d1
	add.l	addz(pc),d2
	moveq	#10,d3
	asl.l	d3,d0
	asl.l	d3,d1
	asr.l	#3,d2
	beq.s	.pjtend
	divs	d2,d0
	divs	d2,d1
	neg.w	d0
	add.w	Midx(pc),d0
	add.w	Midy(pc),d1
.pjtend:
	movem.w	d0-d1,(a3)
	move.w	#0,(a4)+
	addq.l	#4,a3
	dbf	d5,lp7
	rts
;---------------------------------------------------------
backs:
	move.l	atabptr(pc),a2	; PLOCHY
	move.l	tmom(pc),a3	; 2D SUR
	move.l	z2orgptr(pc),a1	; Z SUR
	move.l	ztabptr(pc),a0	; Priemer Z
	move.l	dttabptr(pc),a4	; Pointer na plochu (4B) ; +6 Pointer na SUR 
	move.w	(a2)+,d7	; number of areas
	subq.w	#1,d7
lpb:
	tst.w	(a2)		; test number of points
	beq.w	olinb
	tst.b	(a2)
	bne.s	visib
vp3:
	move.w	4(a2),d5
	movem.w	(a3,d5.w),d0-d1
	move.w	6(a2),d5
	movem.w	(a3,d5.w),d2-d3
	move.w	8(a2),d5
	movem.w	(a3,d5.w),d4-d5
	sub.w	d0,d2		;=-
	sub.w	d1,d3		;  \
	sub.w	d0,d4		;   \
	sub.w	d1,d5		;   |=- z-coord of normal vector
	muls	d2,d5		;   /
	muls	d3,d4		;  /
	sub.l	d4,d5		;=-
	bmi.s	notvisib               
visib:
	moveq	#0,d6
	move.b	1(a2),d6	; pocita sa priemer Z pre Quicksort
	subq.w	#1,d6
	moveq	#4,d5		; preskoc pocet a farbu
	moveq	#0,d1
.slp:
	move.w	(a2,d5),d0
	add.w	(a1,d0),d1	; suma Z
	addq.w	#2,d5
	dbf	d6,.slp
	addq.w	#1,drawnum
	ext.l	d1
	divs	(a2),d1		; priemer Z
	ext.l	d1
	add.l	addz(pc),d1
	move.l	d1,(a0)+
	move.l	a2,(a4)+	; pointer na plochu
	move.l	a3,(a4)+	; pointer na 2D suradnice
notvisib:
	moveq	#0,d0
	move.b	1(a2),d0
	add.w	d0,d0
	addq.w	#6,d0
	lea	(a2,d0.w),a2
	dbf	d7,lpb		; vsetky plochy
	move.l	a0,ztabptr
	move.l	a4,dttabptr
	subq.l	#4,a0
	move.l	a0,zend    ; koniec ztab - pre Quicksort
	rts
olinb:
	move.w	4(a2),d0	; cislo bodu * 4
	move.w	(a1,d0),d1	; z
	move.w	6(a2),d0	; cislo dalsieho bodu * 4
	add.w	(a1,d0),d1	; z1+z2
	asr.w	#1,d1		; (z1+z2)/2 - priemer
	ext.l	d1
	add.l	addz(pc),d1
	move.l	d1,(a0)+
	move.l	a2,(a4)+
	move.l	a3,(a4)+
	addq.w	#1,drawnum
	bra.b	notvisib
;---------------------------------------------------------
wrbacks:
	move.l	atabptr(pc),a2
	move.l	tmom(pc),a3
	move.l	z2orgptr(pc),a1
	move.l	ztabptr(pc),a0
	move.l	dttabptr(pc),a4
	move.w	(a2)+,d7
	subq.w	#1,d7
lpb8:
	tst.w	(a2)
	beq.b	olinb
.vp3:
	move.w	(a2),d6
	subq.w	#1,d6
	moveq	#4,d5
	moveq	#0,d1
.slp:
	move.w	(a2,d5),d0
	add.w	(a1,d0),d1
	addq.w	#2,d5
	dbf	d6,.slp
	addq.w	#1,drawnum
	ext.l	d1
	divs	(a2),d1
	ext.l	d1
	add.l	addz(pc),d1
	move.l	d1,(a0)+
	move.l	a2,(a4)+
	move.l	a3,(a4)+
	moveq	#0,d0
	move.b	1(a2),d0
	add.w	d0,d0
	addq.w	#6,d0
	lea	(a2,d0.w),a2
	dbf	d7,lpb8
	move.l	a0,ztabptr
	move.l	a4,dttabptr
	subq.l	#4,a0
	move.l	a0,zend
	rts
;---------------------------------------------------------
vector:
	tst.w	drawnum		; ma sa nieco kreslit ?
	blt.w	end
	bsr.w	quicksort
	move.l	dtorgptr(pc),a5	; zotriedene
	move.w	drawnum(pc),d7
lp:
	move.l	(a5)+,a3	; adresa na plochu
	move.l	(a5),a2		; adresa na 2D suradnice
vp4:
	move.l	linrout(pc),liner
	moveq	#0,d5
	move.b	1(a3),d5	; pocet bodov v ploche
	addq.l	#2,a3
	tst.w	d5
	bne.s	nolin
	move.l	#WLine,liner
	moveq	#1,d5
nolin:
	addq.l	#$4,a5		; next pointer to next area
	subq.w	#1,d5
	move.w	(a3)+,-(a7)	; farba plochy
	moveq	#-1,d0
	lea	hix(pc),a1
	move.w	#320,2(a1)	; reset oblasti na kopirovanie,filovanie,...
	move.w	d0,(a1)
	move.w	#320,6(a1)
	move.w	d0,4(a1)
	move.w	#0,line
	lea	scx1(pc),a4
	move.l	d0,(a4)
	move.l	d0,4(a4)
.lnlp:
	move.w	(a3)+,d6	; cislo vrcholu * 4
	movem.w	(a2,d6),d0-d1	; x,y coords of points
	move.w	(a3),d6		; next point * 4
	movem.w	(a2,d6),d2-d3	; x,y,cords of point
	asr.w	#4,d0
	asr.w	#4,d1
	asr.w	#4,d2
	asr.w	#4,d3
	bsr.w	drawl
	dbf	d5,.lnlp
	cmp.l	#FLine,liner
	bne.s	nodr
	tst.w	scx1
	blt.s	noclip
	tst.w	scx2
	blt.s	noclip
	lea	scx1(pc),a4
	movem.w	(a4),d0-d3
	bsr.w	drawl		;uzatvara pravy okraj ak treba
noclip:
	tst.w	line
	beq.s	nodr
	bsr.w	CSize		; spocitaj velkost oblasti pre Copy/Fill
	move.w	(a7),d4		; farba
	bsr.w	Copy		; Fill, Copy, Buffer clear
nodr:
	addq.l	#2,a7		; zanechanie farby
vok:
	dbf	d7,lp		; vsetky plochy ?
end
	move.l	chipbase(pc),a6
	rts
;---------------------------------------------------------
quicksort:
	moveq	#0,d4
	move.l	zorgptr(pc),d5
	move.l	lrtabptr(pc),a0
	move.l	dtorgptr(pc),a1		; zosortovane cisla
	move.l	d5,(a0,d4.w)
	move.l	zend(pc),a5
	move.l	a5,4(a0,d4.w)
l20:
	move.l	(a0,d4.w),d5
	move.l	4(a0,d4.w),a5
	subq.w	#8,d4
l30:
	move.l	d5,a2
	move.l	a5,a3
	move.l	a2,d1
	sub.l	zorgptr(pc),d1
	add.w	d1,d1
	move.l	a3,d2
	sub.l	zorgptr(pc),d2
	add.w	d2,d2
	move.l	d5,d0
	add.l	a5,d0
	asr.l	#3,d0
	asl.l	#2,d0
	move.l	d0,a6
	move.l	(a6),d3
l40:
	cmp.l	(a2),d3
	ble.s	l41
	addq.l	#4,a2
	addq.w	#8,d1
	bra.s	l40
l41:
	cmp.l	(a3),d3
	bge.s	l42
	subq.l	#4,a3
	subq.w	#8,d2
	bra.s	l41
l42:
	cmp.l	a3,a2
	bgt.s	l50
	move.l	(a3),d0
	move.l	(a2),(a3)
	move.l	d0,(a2)
	exg.l	d0,d5
	movem.l	(a1,d1.w),d5-d6
	move.l	(a1,d2.w),(a1,d1.w)
	move.l	4(a1,d2.w),4(a1,d1.w)
	movem.l	d5-d6,(a1,d2.w)
	exg.l	d0,d5
	addq.l	#4,a2
	subq.l	#4,a3
	addq.w	#8,d1
	subq.w	#8,d2
	cmp.l	a3,a2
	ble.s	l40
l50:
	cmp.l	a5,a2
	blt.s	l52
l51:
	move.l	a3,a5
	cmp.l	a5,d5
	blt.w	l30
	tst.w	d4
	bge.w	l20
	rts
l52:
	addq.w	#8,d4
	move.l	a2,(a0,d4.w)
	move.l	a5,4(a0,d4.w)
	bra.s	l51
;---------------------------------------------------------
drawl:
	movem.l	d4-d7/a5-a6,-(a7)
	cmp.w	d1,d3
	bge.s	.ec
	exg.l	d0,d2
	exg.l	d1,d3
.ec
	cmp.w	6(a1),d1	; loy
	bge.s	.lyk
	move.w	d1,6(a1)
.lyk:
	cmp.w	4(a1),d3	; hiy
	ble.s	.hyk
	move.w	d3,4(a1)
.hyk:
	move.w	d0,d4
	move.w	d2,d5
	cmp.w	d4,d5
	bge.s	.ok
	exg.l	d4,d5
.ok
	cmp.w	2(a1),d4	; lox
	bge.s	.lxk0
	move.w	d4,2(a1)
.lxk0:
	cmp.w	(a1),d5		; hix
	ble.s	chky
	move.w	d5,(a1)
chky:				;clipping
;	move.w	PWidth(pc),d6
;	cmp.w	d6,d0		; point1 napravo za okrajom ?
;	bgt.s	ctx21
;	cmp.w	d6,d2		; point2 napravo za okrajom ?
;	bgt.s	ctx22
;	moveq	#0,d6
;	tst.w	d1
;	bmi.s	cty11		; point1 nad hornym okrajom ?
;	tst.w	d3
;	bmi.s	cty12		; point2 nad hornym okrajom ?
;	move.w	HeightM1(pc),d6
;	cmp.w	d6,d1		; point1 pod spodnym okrajom ?
;	bgt.s	cty21
;	cmp.w	d6,d3		; point2 pod spodnym okrajom ?
;	bgt.s	cty22
;chkx:
;	moveq	#0,d6
;	tst.w	d0		; point1 nalavo za okrajom ?
;	bmi.s	ctx11
;	tst.w	d2		; point2 nalavo za okrajom  ?
;	bmi.s	ctx12
	move.l	liner(pc),a0
	jmp	(a0)
;cty11:				; Clip nad okrajom
;	tst.w	d3		; point2 ber Oberkante (-> ciaru
;	bmi.s	clpend		; nevidno) ?
;	bsr.s	clipy
;	move.w	d4,d0		; berechnete x-Koordinate
;	moveq	#0,d1		; y logischerweise = 0
;	bra.s	chky
;cty12:
;	bsr.s	clipy		; s.o.
;	move.w	d4,d2
;	moveq	#0,d3
;	bra.s	chky
;cty21:				; Clip Unterkante
;	cmp.w	d6,d3		; auch p2 unter Unterkante ?
;	bgt.s	clpend
;	bsr.s	clipy
;	move.w	d4,d0		; berechnete x-Koordinate
;	move.w	d6,d1		; y=255
;	bra.s	chky
;cty22:
;	bsr.s	clipy		; s.o.
;	move.w	d4,d2
;	move.w	d6,d3
;	bra.s	chky
;ctx11:				; Clip linke Kante
;	tst.w	d2		; auch p2 links von
;	bmi.s	clpend		; linker Kante ?
;	bsr.s	clipx
;	move.w	d4,d1		; berechnete y-Koordinate
;	moveq	#0,d0		; x logischerweise = 0
;	bra.s	chky		; noch einmal berprfen
;ctx12:				; s.o.
;	bsr.s	clipx
;	move.w	d4,d3
;	moveq	#0,d2
;	bra.s	chky		; noch einmal berprfen
;ctx21:				; Clip rechte Kante
;	cmp.w	d6,d2		; auch p2 rechts davon ?
;	bgt.s	clpend
;	bsr.s	clipx
;	move.w	d4,d1		; berechnete y-Koordinate
;	move.w	d6,d0		; x=319
;	cmp.l	#endsc,a4
;	beq.s	.ok
;	movem.w	d0-d1,(a4)
;	addq.l	#4,a4
;.ok:
;	bra.w	chky		; noch einmal berprfen
;ctx22:				; s.o.
;	bsr.s	clipx
;	move.w	d4,d3
;	move.w	d6,d2
;	cmp.l	#endsc,a4
;	beq.s	.ok
;	movem.w	d2-d3,(a4)
;	addq.l	#4,a4
;.ok:
;	bra.w	chky		; noch einmal berprfen
;clpend:
;	movem.l	(a7)+,d4-d7/a5-a6
;	rts
;clipy:				; y-Koord. bekannt, x berechnen
;	move.w	d0,d4
;	sub.w	d2,d4
;	move.w	d3,d5
;	move.w	d3,d7
;	sub.w	d6,d7
;	muls	d7,d4		; d4=(x2-x1) * (y bek. - y2)
;	sub.w	d1,d5
;	divs	d5,d4		; d4=d4 / (y2-y1)
;	add.w	d2,d4		; d4=d4 + y2
;	rts
;clipx:				; x-Koordinate bek., y berechnen
;	move.w	d1,d4
;	sub.w	d3,d4
;	move.w	d2,d5
;	move.w	d2,d7
;	sub.w	d6,d7
;	muls	d7,d4		; d4=(y2-y1) * (x bek. -x2)
;	sub.w	d0,d5
;	divs	d5,d4		; d4=d4 / (x2-x1)
;	add.w	d3,d4		; d4=d4 + y2
;	rts
;---------------------------------------------------------
FLine:
	cmp.w	d1,d3
	beq.w	drawend
	move.w	d1,d5
	move.l	MulsPtr(pc),a5
	add.w	d5,d5
	move.w	(a5,d5.w),d5
	ext.l	d5
	move.l	TMapAddress(pc),a5
	add.l	d5,a5
	move.w	d0,d4
	asr.w	#4,d4
	add.w	d4,d4
	lea	(a5,d4.w),a5
	sub.w	d0,d2
	sub.w	d1,d3
	moveq	#15,d5
	and.l	d5,d0
	move.w	d0,d4
	ror.l	#4,d0
	eor.w	d5,d4
	moveq	#0,d5
	bset	d4,d5
	move.w	#4,d0
	tst.w	d2
	bpl.s	.l1
	addq.w	#1,d0
	neg.w	d2
.l1:
	cmp.w	d2,d3
	ble.s	.l2
	exg.l	d2,d3
	subq.w	#4,d0
	add.w	d0,d0
.l2:
	move.w	d3,d4
	sub.w	d2,d4
	add.w	d4,d4
	add.w	d4,d4
	add.w	d3,d3
	moveq	#0,d6
	move.w	d3,d6
	sub.w	d2,d6
	bpl.s	.l3
	or.w	#16,d0
.l3:
	add.w	d3,d3
	add.w	d0,d0
	add.w	d0,d0
	addq.w	#1,d2
	asl.w	#6,d2
	addq.w	#2,d2
	swap	d3
	move.w	d4,d3
	or.l	#$b4a0003,d0
	move.w	Width(pc),d1

	move.l	chipbase(pc),a6

w5	btst	#6,$dff002
	bne.s	w5

	move.w	d1,$60(a6)
	move.w	d1,$66(a6)
	moveq	#-1,d1
	move.l	d1,$44(a6)
	move.w	d1,$72(a6)
	move.w	#$8000,$74(a6)
	move.l	d3,$62(a6)
	eor.w	d5,(a5)
	move.l	a5,$48(a6)
	move.l	a5,$54(a6)
	move.w	d6,$52(a6)
	move.l	d0,$40(a6)
	move.w	d2,$58(a6)
	addq.w	#1,line
drawend:
	movem.l	(a7)+,d4-d7/a5-a6
	rts
;---------------------------------------------------------
WLine:
	move.w	d1,d5
	move.l	MulsPtr(pc),a5
	add.w	d5,d5
	move.w	(a5,d5.w),d5
	ext.l	d5
	move.l	PlaneH(pc),a5
	add.l	d5,a5
	move.w	d0,d4
	asr.w	#4,d4
	add.w	d4,d4
	lea	(a5,d4.w),a5
	sub.w	d0,d2
	sub.w	d1,d3
	moveq	#15,d5
	and.l	d5,d0
	ror.l	#4,d0
	move.w	#4,d0
	tst.w	d2
	bpl.s	.l1
	addq.w	#1,d0
	neg.w	d2
.l1:
	cmp.w	d2,d3
	ble.s	.l2
	exg.l	d2,d3
	subq.w	#4,d0
	add.w	d0,d0
.l2:
	move.w	d3,d4
	sub.w	d2,d4
	add.w	d4,d4
	add.w	d4,d4
	add.w	d3,d3
	moveq	#0,d6
	move.w	d3,d6
	sub.w	d2,d6
	bpl.s	.l3
	or.w	#16,d0
.l3:
	add.w	d3,d3
	add.w	d0,d0
	add.w	d0,d0
	addq.w	#1,d2
	asl.w	#6,d2
	addq.w	#2,d2
	swap	d3
	move.w	d4,d3
	or.l	#$bca0001,d0
	move.w	Width(pc),d1

	move.l	chipbase(pc),a6

w6	btst	#6,$dff002
	bne.s	w6

	move.w	d1,$60(a6)
	move.w	d1,$66(a6)
	moveq	#-1,d1
	move.l	d1,$44(a6)
	move.w	d1,$72(a6)
	move.w	#$8000,$74(a6)
	move.l	d3,$62(a6)
	move.w	28(a7),d1
	moveq	#0,d3
lp6:
	btst	d3,d1
	bne.s	.ok
	and.l	#$ff0fffff,d0
.ok:

w7	btst	#6,$dff002
	bne.s	w7

	move.l	a5,$48(a6)
	move.l	a5,$54(a6)
	move.w	d6,$52(a6)
	move.l	d0,$40(a6)
	move.w	d2,$58(a6)
	or.l	#$00c00000,d0
	add.l	#(RESOLUTION/8)*INTERLACE,a5
	addq.w	#1,d3
	cmp.w	#DEPTH,d3
	blt.s	lp6
	addq.w	#1,line
	movem.l	(a7)+,d4-d7/a5-a6
	rts
;---------------------------------------------------------
CSize:
	move.w	PWidth(pc),d0
	cmp.w	(a1),d0
	bge.s	.ok1
	move.w	d0,(a1)
.ok1:
	tst.w	2(a1)
	bge.s	.ok2
	move.w	#0,2(a1)
.ok2:
	move.w	HeightM1(pc),d0
	cmp.w	4(a1),d0
	bge.s	.ok3
	move.w	d0,4(a1)
.ok3:
	tst.w	6(a1)
	bge.s	.ok4
	move.w	#0,6(a1)
.ok4:
	move.w	(a1),d0
	asr.w	#4,d0
	asl.w	#1,d0
	move.w	d0,woffx
	asr.w	#1,d0
	move.w	2(a1),d1
	asr.w	#4,d1
	sub.w	d1,d0
	addq.w	#1,d0
	move.w	d0,wsizex
	asl.w	#1,d0
	move.w	Width(pc),d1
	sub.w	d0,d1
	move.w	d1,tmpmod
	move.w	4(a1),d0
	sub.w	6(a1),d0
	addq.w	#1,d0
	move.w	d0,wsizey
	move.w	4(a1),d0
	mulu	Width(pc),d0
	move.w	d0,woffy
	rts
;---------------------------------------------------------
Copy:
	move.l	chipbase(pc),a6
	move.l	TMapAddress(pc),a0
	move.l	PlaneH(pc),a1
	moveq	#0,d2
	move.w	woffx(pc),d2
	add.w	woffy(pc),d2
	add.l	d2,a0
	add.l	d2,a1
	move.w	wsizey(pc),d2
	asl.w	#6,d2
	add.w	wsizex(pc),d2
	move.w	tmpmod(pc),d0
	moveq	#-1,d1

w8	btst	#6,$dff002
	bne.s	w8

	move.w	d0,$62(a6)		; BMOD
	move.w	d0,$64(a6)		; AMOD
	move.w	d0,$66(a6)		; DMOD
	move.l	d1,$44(a6)		; AFWM
	move.l	a0,$50(a6)		; APTH
	move.l	a0,$54(a6)		; DPTH
	move.l	#$9f00012,$40(a6)	; CON0	
	move.w	d2,$58(a6)        ; Fllen	; SIZE
	move.l	#$dfc0002,d1
	moveq	#0,d0
	move.l	#$f00000,d3
loop1:
	btst	d0,d4
	bne.s	.ok
	sub.l	d3,d1
.ok:

w9	btst	#6,$dff002
	bne.s	w9

	move.l	d1,$40(a6)	; CON0		A*B	USE A,B,D
	move.l	a0,$50(a6)	; APTH
	move.l	a1,$4c(a6)	; BPTH
	move.l	a1,$54(a6)	; DPTH
	move.w	d2,$58(a6)	; nach Farb-Werten kopieren	; SIZE
	or.l	d3,d1
	add.l	#(RESOLUTION/8)*INTERLACE,a1
	addq.w	#1,d0
	cmp.w	#DEPTH,d0
	blt.s	loop1

w10	btst	#6,$dff002
	bne.s	w10

	move.l	#$1000002,$40(a6)		; CON0		USED
	move.l	a0,$54(a6)			; DPTH
	move.w	d2,$58(a6)   ; Window lschen	; SIZE
	rts
;---------------------------------------------------------
RotateX:
	movem.l	d5/d7,-(a7)
	asl.w	#1,d6
	bge.s	.ok
	add.w	#720,d6
.ok:
	sub.w	d3,d0
	sub.w	d4,d1
	sub.w	d5,d2
	lea	sintab(pc),a0
	lea	costab(pc),a1
	move.w	d1,d5
	move.w	d2,d7
	muls	(a1,d6.w),d1	; ny=y*cos(al)
	muls	(a0,d6.w),d2	; nz=z*sin(al)
	sub.l	d2,d1		; fy=ny-nz
	add.l	d1,d1
	swap	d1
	muls	(a0,d6.w),d5	; ny=y*sin(al)
	muls	(a1,d6.w),d7	; nz=z*cos(al)
	add.l	d7,d5		; fz=ny-nz
	add.l	d5,d5
	swap	d5
	move.w	d5,d2		;d2=z
	movem.l	(a7)+,d5/d7
	add.w	d3,d0
	add.w	d4,d1
	add.w	d5,d2
	rts

RotateY: 
	movem.l	d5/d7,-(a7)
	asl.w	#1,d6
	bge.s	.ok
	add.w	#720,d6
.ok:
	sub.w	d3,d0
	sub.w	d4,d1
	sub.w	d5,d2
	lea	sintab(pc),a0
	lea	costab(pc),a1
	move.w	d0,d5
	move.w	d2,d7
	muls	(a1,d6.w),d0	; nx=x*cos(be)
	muls	(a0,d6.w),d2	; nz=z*sin(be)
	add.l	d2,d0		; fx=nx+nz
	add.l	d0,d0
	swap	d0
	neg.w	d5		; d5=-x
	muls	(a0,d6.w),d5	; nx=-x*sin(be)
	muls	(a1,d6.w),d7	; ny=y*cos(be)
	add.l	d7,d5		; fz=nx+ny
	add.l	d5,d5
	swap	d5
	move.w	d5,d2
	movem.l	(a7)+,d5/d7
	add.w	d3,d0
	add.w	d4,d1
	add.w	d5,d2
	rts
 
RotateZ:
	movem.l	d5/d7,-(a7)
	asl.w	#1,d6
	bge.s	.ok
	add.w	#720,d6
.ok:
	sub.w	d3,d0
	sub.w	d4,d1
	sub.w	d5,d2
	lea	sintab(pc),a0
	lea	costab(pc),a1
	move.w	d0,d5
	move.w	d1,d7
	muls	(a1,d6.w),d0	; nx=x*cos(ga)
	muls	(a0,d6.w),d1	; ny=y*sin(ga)
	sub.l	d1,d0		; fx=nx-ny
	add.l	d0,d0
	swap	d0
	muls	(a0,d6.w),d5	; nx=x*sin(ga)
	muls	(a1,d6.w),d7	; ny=y*cos(ga)
	add.l	d7,d5		; fy=nx+ny
	add.l	d5,d5
	swap	d5
	move.w	d5,d1
	movem.l	(a7)+,d5/d7
	add.w	d3,d0
	add.w	d4,d1
	add.w	d5,d2
	rts
;---------------------------------------------------------
AnimRot6:
	lea	Rot6(pc),a2
	lea	Rot61(pc),a3
	moveq	#6,d7
	move.w	animcnt6(pc),d6
	subq.w	#6,d6
.arloop	movem.w	(a3)+,d0-d2
	moveq	#10,d3
	moveq	#25,d4
	moveq	#0,d5
	bsr	RotateZ
	movem.w	d0-d2,(a2)
	addq.l	#6,a2
	asr.w	#1,d6
	move.w	d6,animcnt6
	dbf	d7,.arloop

	moveq	#6,d7
	move.w	animcnt6(pc),d6
.arlop	movem.w	(a3)+,d0-d2
	moveq	#10,d3
	moveq	#-65,d4
	moveq	#0,d5
	bsr	RotateZ
	movem.w	d0-d2,(a2)
	addq.l	#6,a2
	asr.w	#1,d6
	dbf	d7,.arlop
	rts

animcnt6: dc.w	0
;---------------------------------------------------------
AnimRot7:
	lea	Body71(pc),a2
	move.w	animcnt7(pc),d6
	moveq	#110,d0
	moveq	#50,d1
	moveq	#5,d2
	moveq	#0,d3
	moveq	#0,d4
	moveq	#0,d5
	bsr	RotateX
	movem.w	d0-d2,(a2)
	moveq	#0,d3
	moveq	#0,d4
	moveq	#0,d5
	move.w	#120,d6
	bsr	RotateX
	movem.w	d0-d2,12(a2)
	moveq	#0,d3
	moveq	#0,d4
	moveq	#0,d5
	move.w	#120,d6
	bsr	RotateX
	movem.w	d0-d2,24(a2)
	move.w	animcnt7(pc),d6
	moveq	#116,d0
	moveq	#50,d1
	moveq	#-5,d2
	moveq	#0,d3
	moveq	#0,d4
	moveq	#0,d5
	bsr	RotateX
	movem.w	d0-d2,6(a2)
	move.w	#120,d6
	moveq	#0,d3
	moveq	#0,d4
	moveq	#0,d5
	bsr	RotateX
	movem.w	d0-d2,18(a2)
	move.w	#120,d6
	moveq	#0,d3
	moveq	#0,d4
	moveq	#0,d5
	bsr	RotateX
	movem.w	d0-d2,30(a2)
	subq.w	#4,animcnt7
	tst.w	animcnt7
	bge.s	.ok
	add.w	#360,animcnt7
.ok:
	rts

animcnt7: dc.w 0
a;---------------------------------------------------------
sintab:	DC.W	$0000,$023B,$0475,$06AF,$08E9,$0B22,$0D5A,$0F90,$11C6,$13FB
	DC.W	$162D,$185F,$1A8E,$1CBB,$1EE6,$210E,$2334,$2557,$2778,$2995
	DC.W	$2BAF,$2DC6,$2FD9,$31E8,$33F4,$35FB,$37FE,$39FD,$3BF8,$3DEE
	DC.W	$3FDE,$41CA,$43B1,$4593,$476F,$4946,$4B17,$4CE2,$4EA7,$5066
	DC.W	$521F,$53D2,$557E,$5723,$58C2,$5A59,$5BEA,$5D73,$5EF6,$6071
	DC.W	$61E4,$6350,$64B4,$6610,$6765,$68B1,$69F5,$6B31,$6C65,$6D90
	DC.W	$6EB3,$6FCD,$70DE,$71E7,$72E7,$73DE,$74CC,$75B1,$768D,$775F
	DC.W	$7828,$78E8,$799F,$7A4C,$7AF0,$7B8A,$7C1A,$7CA1,$7D1E,$7D92
	DC.W	$7DFB,$7E5B,$7EB1,$7EFE,$7F40,$7F79,$7FA7,$7FCC,$7FE7,$7FF8
costab:	DC.W	$7FFF,$7FFC,$7FEF,$7FD8,$7FB7,$7F8D,$7F58,$7F1A,$7ED1,$7E7F
	DC.W	$7E23,$7DBD,$7D4E,$7CD4,$7C51,$7BC5,$7B2F,$7A8F,$79E5,$7933
	DC.W	$7876,$77B1,$76E2,$760A,$7529,$743F,$734B,$724F,$714A,$703C
	DC.W	$6F25,$6E06,$6CDE,$6BAE,$6A75,$6934,$67EB,$669A,$6541,$63E0
	DC.W	$6277,$6107,$5F8F,$5E0F,$5C89,$5AFB,$5966,$57CA,$5627,$547E
	DC.W	$52CE,$5118,$4F5B,$4D99,$4BD0,$4A01,$482D,$4653,$4473,$428E
	DC.W	$40A4,$3EB5,$3CC1,$3AC9,$38CC,$36CA,$34C4,$32BB,$30AD,$2E9B
	DC.W	$2C86,$2A6D,$2851,$2632,$2410,$21EB,$1FC4,$1D9A,$1B6D,$193F
	DC.W	$170F,$14DC,$12A9,$1073,$0E3D,$0C05,$09CD,$0793,$055A,$031F
	DC.W	$00E5,$FEAA,$FC70,$FA35,$F7FC,$F5C2,$F38A,$F153,$EF1C,$ECE7
	DC.W	$EAB4,$E882,$E652,$E424,$E1F8,$DFCF,$DDA8,$DB83,$D962,$D743
	DC.W	$D528,$D310,$D0FC,$CEEB,$CCDE,$CAD5,$C8D0,$C6CF,$C4D3,$C2DB
	DC.W	$C0E8,$BEFA,$BD11,$BB2D,$B94F,$B776,$B5A3,$B3D5,$B20E,$B04C
	DC.W	$AE91,$ACDC,$AB2D,$A985,$A7E4,$A649,$A4B6,$A329,$A1A4,$A026
	DC.W	$9EB0,$9D41,$9BDA,$9A7A,$9923,$97D3,$968C,$954C,$9415,$92E7
	DC.W	$91C1,$90A3,$8F8E,$8E82,$8D7E,$8C84,$8B92,$8AAA,$89CA,$88F4
	DC.W	$8827,$8763,$86A9,$85F8,$8551,$84B3,$841F,$8394,$8313,$829B
	DC.W	$822E,$81CA,$8170,$8120,$80D9,$809D,$806A,$8041,$8023,$800E
	DC.W	$8003,$8002,$800B,$801E,$803A,$8061,$8092,$80CC,$8111,$815F
	DC.W	$81B7,$8219,$8284,$82FA,$8379,$8402,$8494,$8530,$85D6,$8685
	DC.W	$873D,$87FF,$88CA,$899E,$8A7C,$8B63,$8C52,$8D4B,$8E4D,$8F57
	DC.W	$906A,$9186,$92AB,$93D8,$950D,$964B,$9790,$98DE,$9A34,$9B92
	DC.W	$9CF8,$9E65,$9FDA,$A156,$A2DA,$A465,$A5F7,$A790,$A930,$AAD7
	DC.W	$AC84,$AE38,$AFF2,$B1B2,$B379,$B545,$B717,$B8EF,$BACC,$BCAF
	DC.W	$BE97,$C084,$C276,$C46D,$C668,$C868,$CA6C,$CC74,$CE80,$D090
	DC.W	$D2A4,$D4BC,$D6D6,$D8F4,$DB15,$DD39,$DF5F,$E188,$E3B4,$E5E1
	DC.W	$E811,$EA42,$EC76,$EEAA,$F0E0,$F317,$F550,$F789,$F9C2,$FBFC
	DC.W	$FE37,$0072,$02AC,$04E6,$0720,$095A,$0B93,$0DCA,$1001,$1237
	DC.W	$146B,$169D,$18CE,$1AFD,$1D29,$1F54,$217C,$23A1,$25C4,$27E4
	DC.W	$2A00,$2C1A,$2E30,$3042,$3251,$345B,$3662,$3864,$3A62,$3C5C
	DC.W	$3E51,$4041,$422C,$4412,$45F2,$47CD,$49A3,$4B73,$4D3D,$4F01
	DC.W	$50BF,$5276,$5427,$55D2,$5776,$5913,$5AAA,$5C39,$5DC1,$5F42
	DC.W	$60BB,$622D,$6397,$64FA,$6655,$67A7,$68F2,$6A35,$6B6F,$6CA1
	DC.W	$6DCB,$6EEC,$7004,$7114,$721B,$7319,$740E,$74FA,$75DD,$76B7
	DC.W	$7788,$784F,$790D,$79C2,$7A6D,$7B0F,$7BA7,$7C36,$7CBB,$7D36
	DC.W	$7DA8,$7E0F,$7E6D,$7EC1,$7F0C,$7F4C,$7F83,$7FAF,$7FD2,$7FEB
;---------------------------------------------------------
PWidth:		dc.w	RESOLUTION-1
Width:		dc.w	RESOLUTION/8
WWidth:		dc.w	RESOLUTION/16
Height:		dc.w	INTERLACE
HeightM1:	dc.w	INTERLACE-1
Midx:		dc.w	(RESOLUTION/2)<<4
Midy:		dc.w	(INTERLACE/2)<<4
PicPtr:		dc.l	Pic
PlaneH:		dc.l	Screen1
PlaneS:		dc.l	Screen2
TMapAddress:	dc.l	Buffer
ends:		dc.w	0

addx     dc.l 0
addy     dc.l 0
addz     dc.l 0
rx       dc.w 0
ry       dc.w 0
rz       dc.w 0
         dc.w 0
pdptr    dc.l 0
anptr    dc.l 0
atabptr  dc.l 0
zend     dc.l 0
hix      dc.w 0
lox      dc.w 0
hiy      dc.w 0
loy      dc.w 0
wsizex   dc.w 1
wsizey   dc.w 1
woffx    dc.w 0
woffy    dc.w 0
tmpmod   dc.w 0
scx1     dc.w 0
scy1     dc.w 0
scx2     dc.w 0
scy2     dc.w 0
endsc
drawnum  dc.w 0
line     dc.w 0
liner    dc.l 0
linrout  dc.l FLine
backside dc.l backs
anim	 dc.l 0
dttabptr dc.l 0
ztabptr  dc.l 0
zorgptr  dc.l zorg
z2orgptr dc.l z2org
dtorgptr dc.l dtorg
lrtabptr dc.l lrtab
tmom:	 dc.l 0
ScenePtr dc.l 0
RootPtr  dc.l Root
chipbase dc.l $dff000
MulsPtr  dc.l MulsList
ColPtr:	 dc.l 0
	cnop	0,2
;=========================================================
Scene1:
	dc.w 1
	dc.l Object1
Object1:
	dc.l Body1
	dc.l Plochy1
	dc.l Anim1
	dc.w 0,0,-1600
	dc.w 0,0,0
	dc.w $0000,$0888,$0AAA,$0CCC,$0FFF,$0F0F,$000F,$0F00
Body1:
	dc.w 10
	dc.w 0,0,-20
	dc.w 30,0,10
	dc.w 0,0,40
	dc.w 21,21,10
	dc.w 0,30,10
	dc.w -21,21,10
	dc.w -30,0,10
	dc.w -21,-21,10
	dc.w 0,-30,10
	dc.w 21,-21,10

Plochy1:
	dc.w 16
	dc.w 3,1,0,1,3,0
	dc.w 3,2,1,2,3,1
	dc.w 3,3,0,3,4,0
	dc.w 3,4,3,2,4,3
	dc.w 3,1,0,4,5,0
	dc.w 3,2,4,2,5,4
	dc.w 3,3,0,5,6,0
	dc.w 3,4,5,2,6,5
	dc.w 3,1,0,6,7,0
	dc.w 3,2,6,2,7,6
	dc.w 3,3,0,7,8,0
	dc.w 3,4,7,2,8,7
	dc.w 3,1,0,8,9,0
	dc.w 3,2,8,2,9,8
	dc.w 3,3,0,9,1,0
	dc.w 3,4,9,2,1,9
Anim1:
 	dc.w 130,  0,0,10,   0,0,-3
 	dc.w 100,  0,0,0,    0,0,-3
	dc.w 450,  0,0,0,   -2,0,3
	dc.w 100,  0,0,-20, 3,4,2
 	dc.w -1				;end of table
 	even
;=========================================================
Scene2:
	dc.w 1
	dc.l Object2
Object2:
	dc.l Body2
	dc.l Plochy2
	dc.l Anim2
	dc.w 0,0,-2600
	dc.w 0,0,0
	dc.w $0000,$0F44,$0C22,$0800,$0448,$044A,$044C,$044F
Body2:
	dc.w 48
	dc.w 40,40,-40
	dc.w -40,40,-40
	dc.w -40,-40,-40
	dc.w 40,-40,-40
	dc.w 40,40,-140
	dc.w -40,40,-140
	dc.w -40,-40,-140
	dc.w 40,-40,-140
	dc.w 40,40,40
	dc.w -40,40,40
	dc.w -40,-40,40
	dc.w 40,-40,40
	dc.w 40,40,140
	dc.w -40,40,140
	dc.w -40,-40,140
	dc.w 40,-40,140
	dc.w 40,40,-40
	dc.w -40,40,-40
	dc.w -40,40,40
	dc.w 40,40,40
	dc.w 40,140,-40
	dc.w -40,140,-40
	dc.w -40,140,40
	dc.w 40,140,40
	dc.w 40,-40,-40
	dc.w -40,-40,-40
	dc.w -40,-40,40
	dc.w 40,-40,40
	dc.w 40,-140,-40
	dc.w -40,-140,-40
	dc.w -40,-140,40
	dc.w 40,-140,40
	dc.w -40,40,40
	dc.w -40,-40,40
	dc.w -40,-40,-40
	dc.w -40,40,-40
	dc.w -140,40,40
	dc.w -140,-40,40
	dc.w -140,-40,-40
	dc.w -140,40,-40
	dc.w 40,40,40
	dc.w 40,-40,40
	dc.w 40,-40,-40
	dc.w 40,40,-40
	dc.w 140,40,40
	dc.w 140,-40,40
	dc.w 140,-40,-40
	dc.w 140,40,-40
Plochy2:
	dc.w 30
	dc.w 4,7,4,5,6,7,4
	dc.w 4,5,5,4,0,1,5
	dc.w 4,4,6,5,1,2,6
	dc.w 4,5,7,6,2,3,7
	dc.w 4,4,4,7,3,0,4
	dc.w 4,7,12,15,14,13,12
	dc.w 4,4,13,9,8,12,13
	dc.w 4,5,14,10,9,13,14
	dc.w 4,4,15,11,10,14,15
	dc.w 4,5,12,8,11,15,12
	dc.w 4,7,20,23,22,21,20
	dc.w 4,6,21,17,16,20,21
	dc.w 4,4,22,18,17,21,22
	dc.w 4,6,23,19,18,22,23
	dc.w 4,4,20,16,19,23,20
	dc.w 4,1,28,29,30,31,28
	dc.w 4,2,29,28,24,25,29
	dc.w 4,3,30,29,25,26,30
	dc.w 4,2,31,30,26,27,31
	dc.w 4,3,28,31,27,24,28
	dc.w 4,1,36,37,38,39,36
	dc.w 4,3,37,36,32,33,37
	dc.w 4,2,38,37,33,34,38
	dc.w 4,3,39,38,34,35,39
	dc.w 4,2,36,39,35,32,36
	dc.w 4,1,44,47,46,45,44
	dc.w 4,3,45,41,40,44,45
	dc.w 4,2,46,42,41,45,46
	dc.w 4,3,47,43,42,46,47
	dc.w 4,2,44,40,43,47,44
Anim2:
 	dc.w 130,  0,0,10,   0,0,-3
 	dc.w 100,  0,0,0,    0,0,-3
	dc.w 450,  0,0,0,    2,0,-3
	dc.w 300,  0,0,-20, -3,4,-2
 	dc.w -1				;end of table
	even
;=========================================================
Scene3:
	dc.w 1
	dc.l Object3
Object3:
	dc.l Body3
	dc.l Plochy3
	dc.l Anim3
	dc.w 0,0,-2600
	dc.w 0,0,0
	dc.w $0000,$044F,$022C,$0008,$0848,$0A4A,$0C4C,$0F4F
Body3:
	dc.w 16
	dc.w 40,0,-10
	dc.w 60,0,-10
	dc.w 60,0,10
	dc.w 40,0,10
	dc.w 0,40,-10
	dc.w 0,60,-10
	dc.w 0,60,10
	dc.w 0,40,10
	dc.w -40,0,-10
	dc.w -60,0,-10
	dc.w -60,0,10
	dc.w -40,0,10
	dc.w 0,-40,-10
	dc.w 0,-60,-10
	dc.w 0,-60,10
	dc.w 0,-40,10
	
Plochy3:
	dc.w 16
	dc.w 4,1,0,1,5,4,0
	dc.w 4,2,1,2,6,5,1
	dc.w 4,1,2,3,7,6,2
	dc.w 4,2,3,0,4,7,3
	dc.w 4,2,4,5,9,8,4
	dc.w 4,3,5,6,10,9,5
	dc.w 4,2,6,7,11,10,6
	dc.w 4,3,7,4,8,11,7
	dc.w 4,1,8,9,13,12,8
	dc.w 4,2,9,10,14,13,9
	dc.w 4,1,10,11,15,14,10
	dc.w 4,2,11,8,12,15,11
	dc.w 4,2,12,13,1,0,12
	dc.w 4,3,13,14,2,1,13
	dc.w 4,2,14,15,3,2,14
	dc.w 4,3,15,12,0,3,15
Anim3:
 	dc.w 185,  0,0,12,   2,1,3
	dc.w 400,  0,0,0,    1,-2,3
	dc.w 200,  0,0,-20,  -3,4,2
 	dc.w -1				;end of table
 	even
;=========================================================
Scene4:
	dc.w 4
	dc.l Object41
	dc.l Object42
	dc.l Object43
	dc.l Object44

Object41:
	dc.l Body41
	dc.l Plochy41
	dc.l Anim41
	dc.w 0,0,-3600
	dc.w 0,0,0
Body41:
	dc.w 8
	dc.w 40,-40,40
	dc.w -40,-40,40
	dc.w -40,40,40
	dc.w 40,40,40
	dc.w 40,-40,-40
	dc.w -40,-40,-40
	dc.w -40,40,-40
	dc.w 40,40,-40
Plochy41:
	dc.w 6
	dc.w 4,4,0,1,2,3,0
	dc.w 4,4,4,7,6,5,4
	dc.w 4,5,5,1,0,4,5
	dc.w 4,6,6,2,1,5,6
	dc.w 4,5,7,3,2,6,7
	dc.w 4,6,4,0,3,7,4
Anim41:
 	dc.w 190,  0,0,12,   3,0,0
 	dc.w 40,   -4,0,0,   3,0,0
 	dc.w 550,  0,0,0,    3,-3,-2
 	dc.w 300,  0,0,-10,   -3,-3,-2
 	dc.w -1				;end of table
;-----------------------
Object42:
	dc.l Body42
	dc.l Plochy42
	dc.l Anim42
	dc.w 0,0,-3600
	dc.w 0,0,0
Body42:
	dc.w 8
	dc.w 40,-40,40
	dc.w -40,-40,40
	dc.w -40,40,40
	dc.w 40,40,40
	dc.w 40,-40,-40
	dc.w -40,-40,-40
	dc.w -40,40,-40
	dc.w 40,40,-40
Plochy42:
	dc.w 6
	dc.w 4,1,0,1,2,3,0
	dc.w 4,1,4,7,6,5,4
	dc.w 4,2,5,1,0,4,5
	dc.w 4,3,6,2,1,5,6
	dc.w 4,2,7,3,2,6,7
	dc.w 4,3,4,0,3,7,4
Anim42:
 	dc.w 190,  0,0,12,   3,0,0
 	dc.w 40,   -1,0,0,   3,0,0
	dc.w 550,  0,0,0,   -3,2,4
	dc.w 300,  0,0,-10,   3,2,4
 	dc.w -1				;end of table
;----------------------
Object43:
	dc.l Body43
	dc.l Plochy43
	dc.l Anim43
	dc.w 0,0,-3600
	dc.w 0,0,0
Body43:
	dc.w 8
	dc.w 40,-40,40
	dc.w -40,-40,40
	dc.w -40,40,40
	dc.w 40,40,40
	dc.w 40,-40,-40
	dc.w -40,-40,-40
	dc.w -40,40,-40
	dc.w 40,40,-40
Plochy43:
	dc.w 6
	dc.w 4,4,0,1,2,3,0
	dc.w 4,4,4,7,6,5,4
	dc.w 4,5,5,1,0,4,5
	dc.w 4,6,6,2,1,5,6
	dc.w 4,5,7,3,2,6,7
	dc.w 4,6,4,0,3,7,4
Anim43:
 	dc.w 190,  0,0,12,   3,0,0
 	dc.w 40,   1,0,0,    -2,0,0
	dc.w 550,  0,0,0,   -2,3,-3
	dc.w 300,  0,0,-10,   -2,-3,-3
 	dc.w -1				;end of table
;-----------------------
Object44:
	dc.l Body44
	dc.l Plochy44
	dc.l Anim44
	dc.w 0,0,-3600
	dc.w 0,0,0
	dc.w $0000,$03E3,$01B0,$0060,$0066,$00AA,$00FF,$0F00
Body44:
	dc.w 8
	dc.w 40,-40,40
	dc.w -40,-40,40
	dc.w -40,40,40
	dc.w 40,40,40
	dc.w 40,-40,-40
	dc.w -40,-40,-40
	dc.w -40,40,-40
	dc.w 40,40,-40
Plochy44:
	dc.w 6
	dc.w 4,1,0,1,2,3,0
	dc.w 4,1,4,7,6,5,4
	dc.w 4,2,5,1,0,4,5
	dc.w 4,3,6,2,1,5,6
	dc.w 4,2,7,3,2,6,7
	dc.w 4,3,4,0,3,7,4
Anim44:
 	dc.w 190,  0,0,12,   3,0,0
 	dc.w 40,   4,0,0,    3,0,0
	dc.w 550,  0,0,0,    4,-2,3
	dc.w 300,  0,0,-10,  -4,-2,3
 	dc.w -1				;end of table
	even
;=========================================================
Scene5:
	dc.w 1
	dc.l Object5
Object5:
	dc.l Body5
	dc.l Plochy5
	dc.l Anim5
	dc.w 0,0,-3000
	dc.w 0,0,0
	dc.w $0000,$644F,$022C,$0007,$2FFF,$4CCC,$2999,$0F00
Body5:
	dc.w 92
	dc.w -80,-20,60
	dc.w -80,-20,-100
	dc.w -60,-20,-100
	dc.w 50,-20,-100
	dc.w 70,-20,-100
	dc.w 70,-20,50
	dc.w 60,-20,60
	dc.w 50,-20,60
	dc.w -60,-20,60
	dc.w -80,0,60
	dc.w -80,0,-100
	dc.w -60,0,-100
	dc.w 50,0,-100
	dc.w 70,0,-100
	dc.w 70,0,50
	dc.w 60,0,60
	dc.w 50,0,60
	dc.w -60,0,60
	dc.w 50,-20,60
	dc.w -60,-20,60
	dc.w -60,0,60
	dc.w 50,0,60
	dc.w -60,0,-40
	dc.w 50,0,-40
	dc.w 50,0,-90
	dc.w -60,0,-90
	dc.w -60,-20,-40
	dc.w 50,-20,-40
	dc.w 50,-20,-90
	dc.w -60,-20,-90
	dc.w -60,0,-90
	dc.w 50,0,-90
	dc.w 50,0,-100
	dc.w -60,0,-100
	dc.w -60,-20,-90
	dc.w 50,-20,-90
	dc.w 50,-20,-100
	dc.w -60,-20,-100
	dc.w -40,0,10
	dc.w -10,0,10
	dc.w -10,0,50
	dc.w -40,0,50
	dc.w -40,-20,10
	dc.w -10,-20,10
	dc.w -10,-20,50
	dc.w -40,-20,50
	dc.w -80,0,60
	dc.w -80,0,-100
	dc.w -60,0,-100
	dc.w -60,0,-40
	dc.w 50,0,-40
	dc.w 50,0,-100
	dc.w 70,0,-100
	dc.w 70,0,50
	dc.w 60,0,60
	dc.w 50,0,60
	dc.w 50,0,0
	dc.w -50,0,0
	dc.w -50,0,60
	dc.w -80,-20,60
	dc.w -80,-20,-100
	dc.w -60,-20,-100
	dc.w -60,-20,-40
	dc.w 50,-20,-40
	dc.w 50,-20,-100
	dc.w 70,-20,-100
	dc.w 70,-20,50
	dc.w 60,-20,60
	dc.w 50,-20,60
	dc.w 50,-20,0
	dc.w -50,-20,0
	dc.w -50,-20,60
	dc.w -50,0,60
	dc.w -50,0,0
	dc.w 50,0,0
	dc.w 50,0,60
	dc.w -10,0,60
	dc.w -10,0,10
	dc.w -40,0,10
	dc.w -40,0,50
	dc.w -10,0,50
	dc.w -10,0,60
	dc.w -50,-20,60
	dc.w -50,-20,0
	dc.w 50,-20,0
	dc.w 50,-20,60
	dc.w -10,-20,60
	dc.w -10,-20,10
	dc.w -40,-20,10
	dc.w -40,-20,50
	dc.w -10,-20,50
	dc.w -10,-20,60
Plochy5:
	dc.w 19
	dc.w 4,2,10,9,0,1,10
	dc.w 4,3,11,10,1,2,11
	dc.w 4,3,13,12,3,4,13
	dc.w 4,2,14,13,4,5,14
	dc.w 4,3,15,14,5,6,15
	dc.w 4,2,16,15,6,7,16
	dc.w 4,2,9,17,8,0,9
	dc.w 4,5,18,19,20,21,18
	dc.w 4,5,22,25,24,23,22
	dc.w 4,4,26,27,28,29,26
	dc.w 4,7,30,33,32,31,30
	dc.w 4,7,34,35,36,37,34
	dc.w 4,7,37,36,32,33,37
	dc.w 4,1,38,39,40,41,38
	dc.w 4,1,42,45,44,43,42
	dc.w 13,1,46,47,48,49,50,51,52,53,54,55,56,57,58,46
	dc.w 13,1,59,71,70,69,68,67,66,65,64,63,62,61,60,59
	dc.w 10,6,72,73,74,75,76,77,78,79,80,81,72
	dc.w 10,4,82,91,90,89,88,87,86,85,84,83,82
Anim5:
	dc.w 190,  0,0,12,   3,0,0
 	dc.w 450,  0,0,0,    1,0,3
 	dc.w 300,  0,0,-15,   3,2,4
 	dc.w -1				;end of table
	even
;=========================================================
Scene6:
	dc.w 1
	dc.l Object6
Object6:
	dc.l Body6
	dc.l Plochy6
	dc.l Anim6
	dc.w 0,0,-3000
	dc.w 70,180,0
	dc.w $0000,$0008,$000C,$033F,$0CCC,$0888,$0FF0,$0F00
Body6:
	dc.w 44
	dc.w -10,-60,20
	dc.w 30,-60,20
	dc.w 30,0,20
	dc.w -10,0,20
	dc.w -10,-60,50
	dc.w 30,-60,50
	dc.w 30,0,50
	dc.w -10,0,50
	dc.w 30,40,30
	dc.w -10,40,30
	dc.w 30,40,20
	dc.w -10,40,20
	dc.w 5,20,0
	dc.w 15,20,0
	dc.w 15,30,0
	dc.w 5,30,0
	dc.w -10,-90,50
	dc.w 30,-90,50
	dc.w -10,-100,40
	dc.w 30,-100,40
	dc.w 30,-60,40
	dc.w -10,-60,40
	dc.w 0,-80,20
	dc.w 20,-80,20
	dc.w 20,-60,20
	dc.w 0,-60,20
	dc.w 5,-70,10
	dc.w 15,-70,10
	dc.w 15,-60,10
	dc.w 5,-60,10
Rot6:	dc.w 10,25,0
	dc.w -12,-21,0
	dc.w 6,-25,0
	dc.w -29,58,0
	dc.w -39,41,0
	dc.w 58,38,0
	dc.w 49,56,0
	dc.w 10,-65,10
	dc.w 58,-52,10
	dc.w 49,-34,10
	dc.w -29,-32,10
	dc.w -39,-49,10
	dc.w -13,-112,10
	dc.w 6,-116,10

Rot61:	dc.w 10,25,0
	dc.w -12,-21,0
	dc.w 6,-25,0
	dc.w -29,58,0
	dc.w -39,41,0
	dc.w 58,38,0
	dc.w 49,56,0
	dc.w 10,-65,10
	dc.w 58,-52,10
	dc.w 49,-34,10
	dc.w -29,-32,10
	dc.w -39,-49,10
	dc.w -13,-112,10
	dc.w 6,-116,10
Plochy6:
	dc.w 32
	dc.w 4,1,0,1,2,3,0
	dc.w 4,1,4,7,6,5,4
	dc.w 4,2,0,4,5,1,0
	dc.w 4,3,1,5,6,2,1
	dc.w 4,3,3,7,4,0,3
	dc.w 4,1,12,13,14,15,12
	dc.w 4,2,6,8,10,2,6
	dc.w 4,3,6,7,9,8,6
	dc.w 4,3,8,9,11,10,8
	dc.w 4,2,9,7,3,11,9
	dc.w 4,2,3,2,13,12,3
	dc.w 4,3,2,10,14,13,2
	dc.w 4,2,10,11,15,14,10
	dc.w 4,3,11,3,12,15,11
	dc.w 4,1,16,4,5,17,16
	dc.w 4,2,16,17,19,18,16
	dc.w 4,4,17,5,20,19,17
	dc.w 4,4,4,16,18,21,4
	dc.w 4,4,22,18,19,23,22
	dc.w 4,5,23,19,20,24,23
	dc.w 4,5,25,21,18,22,25
	dc.w 4,1,26,27,28,29,26
	dc.w 4,2,26,22,23,27,26
	dc.w 4,3,27,23,24,28,27
	dc.w 4,2,28,24,25,29,28
	dc.w 4,3,29,25,22,26,29
	dc.w $1003,7,30,31,32,30
	dc.w $1003,7,30,33,34,30
	dc.w $1003,7,30,35,36,30
	dc.w $1003,7,37,38,39,37
	dc.w $1003,7,37,40,41,37
	dc.w $1003,7,37,42,43,37
Anim6:
	dc.w 200,  1,0,11,   0,0,0
	dc.w 100,  -1,0,1,   1,0,1
 	dc.w 150,  -1,0,-1,  1,0,1
 	dc.w 100,  -1,0,1,   2,0,1
 	dc.w 100,   1,0,-1,  1,0,-1
 	dc.w 200,  0,0,-15,  0,0,-1
 	dc.w -1
	even
;=========================================================
Scene7:
	dc.w 1
	dc.l Object7
Object7:
	dc.l Body7
	dc.l Plochy7
	dc.l Cinnost7
	dc.w 0,0,-13500
	dc.w 0,0,0
	dc.w $0000,$0777,$0222,$0555,$0666,$0444,$0079,$008a
Body7:
	dc.w 48+7
	dc.w 115,-15,-18
	dc.w 115,15,-18
	dc.w 94,15,-18
	dc.w 94,-15,-18
	dc.w 94,-15,-25
	dc.w 94,15,-25
	dc.w -20,-15,-25
	dc.w -20,15,-25
	dc.w -193,0,0
	dc.w -135,0,15  ;10
	dc.w -26,-7,22
	dc.w -26,7,22
	dc.w -14,-15,6
	dc.w -14,15,6
	dc.w 11,-7,22
	dc.w 11,7,22
	dc.w 11,-15,6
	dc.w 11,15,6
	dc.w 23,-7,15
	dc.w 23,7,15    ;20
	dc.w 113,-7,15
	dc.w 113,7,15
	dc.w 113,-15,0
	dc.w 113,15,0
	dc.w -155,0,48
	dc.w -172,0,48
	dc.w 60,15,-25
	dc.w 48,15,-13
	dc.w 23,15,-13
	dc.w 48,190,-13
	dc.w 23,190,-13
	dc.w 60,-15,-25
	dc.w 48,-15,-13
	dc.w 23,-15,-13
	dc.w 48,-190,-13
	dc.w 23,-190,-13
	dc.w 137,0,-5
	dc.w -145,0,24
	dc.w -160,62,24
	dc.w -177,62,24   ;40
	dc.w -180,13,24
	dc.w -170,0,24
	dc.w -160,-62,24
	dc.w -177,-62,24
	dc.w -180,-13,24
	dc.w -155,0,27
	dc.w -165,0,27
	dc.w -185,0,35
	dc.w 113,0,0
Body71:
	dc.w 113,50,-5
	dc.w 113,50,5
	dc.w 113,-29,-5
	dc.w 113,-21,5
	dc.w 113,20,-5
	dc.w 113,20,5

Plochy7:
	dc.w 54
	dc.w 4,1,0,1,2,3,0
	dc.w 4,1,4,5,7,6,4
	dc.w 3,1,6,7,8,6
	dc.w 6,3,1,23,13,7,5,2,1
	dc.w 3,3,7,13,8,7
	dc.w 3,3,8,13,11,8
	dc.w 4,3,0,3,12,22,0
	dc.w 3,3,3,8,12,3
	dc.w 4,3,3,4,6,8,3
	dc.w 4,3,8,9,10,12,8
	dc.w 3,4,8,11,9,8
	dc.w 3,4,8,9,10,8
	dc.w 3,4,9,11,10,9
	dc.w 4,6,10,11,15,14,10
	dc.w 4,7,14,15,19,18,14
	dc.w 4,1,18,19,21,20,18
	dc.w 3,6,15,17,19,15
	dc.w 3,6,14,18,16,14
	dc.w 4,7,11,13,17,15,11
	dc.w 4,7,10,14,16,12,10
	dc.w 5,4,13,23,21,19,17,13
	dc.w 4,4,16,18,20,22,16
	dc.w 3,4,12,16,22,12
	dc.w 5,3,8,9,24,25,47,8
	dc.w 5,3,8,47,25,24,9,8
	dc.w 4,1,7,26,29,30,7
	dc.w 3,5,26,27,29,26
	dc.w 4,3,27,28,30,29,27
	dc.w 3,5,7,30,28,7
	dc.w 4,1,6,35,34,31,6
	dc.w 3,5,31,34,32,31
	dc.w 4,3,32,34,35,33,32
	dc.w 3,5,6,33,35,6
	dc.w 3,1,20,21,36,20
	dc.w 3,4,21,23,36,21
	dc.w 3,4,1,36,23,1
	dc.w 3,1,0,36,1,0
	dc.w 3,4,0,22,36,0
	dc.w 3,4,20,36,22,20
	dc.w 5,1,37,41,44,43,42,37
	dc.w 5,1,37,38,39,40,41,37
	dc.w 3,5,37,45,38,37
	dc.w 4,5,38,45,46,39,38
	dc.w 4,5,39,46,41,40,39
	dc.w 3,5,37,42,45,37
	dc.w 4,5,42,43,46,45,42
	dc.w 4,5,41,45,43,44,41
	dc.w 4,2,2,5,4,3,2
	dc.w 3,1,48,50,49,48
	dc.w 3,1,48,52,51,48
	dc.w 3,1,48,54,53,48
	dc.w 3,1,48,49,50,48
	dc.w 3,1,48,51,52,48
	dc.w 3,1,48,53,54,48
Cinnost7:
	dc.w 1, 0,0,0, -90,0,0
	dc.w 1, 0,0,0, 0,-90,0
	dc.w 150, 0,0,42, 0,0,0
	dc.w 150, 0,0,42, 0,1,0
	dc.w 400, 0,0,0, 0,1,0
	dc.w 300, 0,0,0, 0,1,1
	dc.w 300, 0,0,-42, 1,1,0
	dc.w -1
	even
;=========================================================
Scene8:
	dc.w 1
	dc.l Object8
Object8:
	dc.l Body8
	dc.l Plochy8
	dc.l Cinnost8
	dc.w 0,0,-3500
	dc.w 0,0,0
	dc.w $0000,$0F44,$0C22,$0800,$0884,$0AA4,$0CC4,$0FF4
Body8:
	dc.w 40
	dc.w 60,-60,60
	dc.w 60,60,60
	dc.w -60,60,60
	dc.w -60,-60,60
	dc.w -40,-40,60
	dc.w -40,40,60
	dc.w 40,40,60
	dc.w 40,-40,60
	dc.w 60,-60,-60
	dc.w 60,60,-60
	dc.w -60,60,-60
	dc.w -60,-60,-60
	dc.w -40,-40,-60
	dc.w -40,40,-60
	dc.w 40,40,-60
	dc.w 40,-40,-60
	dc.w -40,-60,40
	dc.w -40,-60,-40
	dc.w 40,-60,-40
	dc.w 40,-60,40
	dc.w -40,60,40
	dc.w -40,60,-40
	dc.w 40,60,-40
	dc.w 40,60,40
	dc.w -60,-40,-40
	dc.w -60,40,-40
	dc.w -60,40,40
	dc.w -60,-40,40
	dc.w 60,-40,-40
	dc.w 60,40,-40
	dc.w 60,40,40
	dc.w 60,-40,40
	dc.w 40,40,-40
	dc.w 40,-40,-40
	dc.w 40,40,40
	dc.w 40,-40,40
	dc.w -40,40,40
	dc.w -40,-40,40
	dc.w -40,40,-40
	dc.w -40,-40,-40

Plochy8:
	dc.w 30
	dc.w 10,1,0,3,4,7,6,5,4,3,2,1,0
	dc.w 10,1,8,9,10,11,12,13,14,15,12,11,8
	dc.w 10,2,0,8,11,3,16,17,18,19,16,3,0
	dc.w 10,2,1,2,20,23,22,21,20,2,10,9,1
	dc.w 10,3,3,11,24,27,26,25,24,11,10,2,3
	dc.w 10,3,0,1,9,8,28,29,30,31,28,8,0
	dc.w 4,1,29,28,33,32,29
	dc.w 4,1,30,34,35,31,30
	dc.w 4,1,36,26,27,37,36
	dc.w 4,1,38,39,24,25,38
	dc.w 4,1,32,38,21,22,32
	dc.w 4,1,34,23,20,36,34
	dc.w 4,1,19,35,37,16,19
	dc.w 4,1,18,17,39,33,18
	dc.w 4,2,30,29,32,34,30
	dc.w 4,2,31,35,33,28,31
	dc.w 4,1,37,27,24,39,37
	dc.w 4,1,36,38,25,26,36
	dc.w 4,2,32,14,13,38,32
	dc.w 4,2,33,39,12,15,33
	dc.w 4,2,7,4,37,35,7
	dc.w 4,2,6,34,36,5,6
	dc.w 4,3,4,5,36,37,4
	dc.w 4,3,7,35,34,6,7
	dc.w 4,3,33,15,14,32,33
	dc.w 4,3,39,38,13,12,39
	dc.w 4,3,34,32,22,23,34
	dc.w 4,3,36,20,21,38,36
	dc.w 4,3,16,37,39,17,16
	dc.w 4,3,19,18,33,35,19

Cinnost8:
	dc.w 200, 0,0,13,  2,-1,0
	dc.w 400, 0,0,0,   1,0,-2
	dc.w 250, 0,0,-20, 3,-2,-3
	dc.w -1
	even
;=========================================================
Scene9:
	dc.w 1
	dc.l Object9
Object9:
	dc.l Body9
	dc.l Plochy9
	dc.l Cinnost9
	dc.w 0,0,-3000
	dc.w 0,0,0
	dc.w $0000,$0FF0,$0CC3,$0992,$0660,$2F00,$0C12,$0933
Body9:
	dc.w 104
	dc.w 40,40,40
	dc.w -40,40,40
	dc.w -40,-40,40
	dc.w 40,-40,40
	dc.w 40,40,-40
	dc.w -40,40,-40
	dc.w -40,-40,-40
	dc.w 40,-40,-40
	dc.w 10,-10,-40
	dc.w -10,-10,-40
	dc.w -10,10,-40
	dc.w 10,10,-40
	dc.w 10,-10,-110
	dc.w -10,-10,-110
	dc.w -10,10,-110
	dc.w 10,10,-110
	dc.w 10,10,40
	dc.w -10,10,40
	dc.w -10,-10,40
	dc.w 10,-10,40
	dc.w 10,10,110
	dc.w -10,10,110
	dc.w -10,-10,110
	dc.w 10,-10,110
	dc.w 10,40,-10
	dc.w -10,40,-10
	dc.w -10,40,10
	dc.w 10,40,10
	dc.w 10,110,-10
	dc.w -10,110,-10
	dc.w -10,110,10
	dc.w 10,110,10
	dc.w 10,-40,-10
	dc.w -10,-40,-10
	dc.w -10,-40,10
	dc.w 10,-40,10
	dc.w 10,-110,-10
	dc.w -10,-110,-10
	dc.w -10,-110,10
	dc.w 10,-110,10
	dc.w 40,10,10
	dc.w 40,-10,10
	dc.w 40,-10,-10
	dc.w 40,10,-10
	dc.w 110,10,10
	dc.w 110,-10,10
	dc.w 110,-10,-10
	dc.w 110,10,-10
	dc.w -40,10,10
	dc.w -40,-10,10
	dc.w -40,-10,-10
	dc.w -40,10,-10
	dc.w -110,10,10
	dc.w -110,-10,10
	dc.w -110,-10,-10
	dc.w -110,10,-10
	dc.w 20,20,-110
	dc.w -20,20,-110
	dc.w -20,-20,-110
	dc.w 20,-20,-110
	dc.w 20,20,-150
	dc.w -20,20,-150
	dc.w -20,-20,-150
	dc.w 20,-20,-150
	dc.w 20,20,110
	dc.w -20,20,110
	dc.w -20,-20,110
	dc.w 20,-20,110
	dc.w 20,20,150
	dc.w -20,20,150
	dc.w -20,-20,150
	dc.w 20,-20,150
	dc.w 20,110,-20
	dc.w -20,110,-20
	dc.w -20,110,20
	dc.w 20,110,20
	dc.w 20,150,-20
	dc.w -20,150,-20
	dc.w -20,150,20
	dc.w 20,150,20
	dc.w 20,-110,-20
	dc.w -20,-110,-20
	dc.w -20,-110,20
	dc.w 20,-110,20
	dc.w 20,-150,-20
	dc.w -20,-150,-20
	dc.w -20,-150,20
	dc.w 20,-150,20
	dc.w -110,20,20
	dc.w -110,-20,20
	dc.w -110,-20,-20
	dc.w -110,20,-20
	dc.w -150,20,20
	dc.w -150,-20,20
	dc.w -150,-20,-20
	dc.w -150,20,-20

	dc.w 110,20,20
	dc.w 110,-20,20
	dc.w 110,-20,-20
	dc.w 110,20,-20
	dc.w 150,20,20
	dc.w 150,-20,20
	dc.w 150,-20,-20
	dc.w 150,20,-20

Plochy9:
	dc.w 66
	dc.w 4,1,0,3,2,1,0
	dc.w 4,1,4,5,6,7,4
	dc.w 4,2,5,4,0,1,5
	dc.w 4,3,6,5,1,2,6
	dc.w 4,2,7,6,2,3,7
	dc.w 4,3,4,7,3,0,4
	dc.w 4,6,13,9,8,12,13
	dc.w 4,7,14,10,9,13,14
	dc.w 4,6,15,11,10,14,15
	dc.w 4,7,12,8,11,15,12
	dc.w 4,6,21,17,16,20,21
	dc.w 4,7,22,18,17,21,22
	dc.w 4,6,23,19,18,22,23
	dc.w 4,7,20,16,19,23,20
	dc.w 4,6,29,25,24,28,29
	dc.w 4,5,30,26,25,29,30
	dc.w 4,6,31,27,26,30,31
	dc.w 4,5,28,24,27,31,28
	dc.w 4,6,37,36,32,33,37
	dc.w 4,5,38,37,33,34,38
	dc.w 4,6,39,38,34,35,39
	dc.w 4,5,36,39,35,32,36
	dc.w 4,5,45,41,40,44,45
	dc.w 4,6,46,42,41,45,46
	dc.w 4,5,47,43,42,46,47
	dc.w 4,6,44,40,43,47,44
	dc.w 4,5,53,52,48,49,53
	dc.w 4,6,54,53,49,50,54
	dc.w 4,5,55,54,50,51,55
	dc.w 4,6,52,55,51,48,52
	dc.w 4,1,56,59,58,57,56
	dc.w 4,1,60,61,62,63,60
	dc.w 4,3,61,60,56,57,61
	dc.w 4,2,62,61,57,58,62
	dc.w 4,3,63,62,58,59,63
	dc.w 4,2,60,63,59,56,60
	dc.w 4,1,64,65,66,67,64
	dc.w 4,1,68,71,70,69,68
	dc.w 4,2,69,65,64,68,69
	dc.w 4,3,70,66,65,69,70
	dc.w 4,2,71,67,66,70,71
	dc.w 4,3,68,64,67,71,68
	dc.w 4,1,72,73,74,75,72
	dc.w 4,1,76,79,78,77,76
	dc.w 4,3,77,73,72,76,77
	dc.w 4,2,78,74,73,77,78
	dc.w 4,3,79,75,74,78,79
	dc.w 4,2,76,72,75,79,76
	dc.w 4,1,80,83,82,81,80
	dc.w 4,1,84,85,86,87,84
	dc.w 4,2,85,84,80,81,85
	dc.w 4,3,86,85,81,82,86
	dc.w 4,2,87,86,82,83,87
	dc.w 4,3,84,87,83,80,84
	dc.w 4,1,88,91,90,89,88
	dc.w 4,1,92,93,94,95,92
	dc.w 4,3,93,92,88,89,93
	dc.w 4,2,94,93,89,90,94
	dc.w 4,3,95,94,90,91,95
	dc.w 4,1,92,95,91,88,92

	dc.w 4,1,96,97,98,99,96
	dc.w 4,1,100,103,102,101,100
	dc.w 4,2,101,97,96,100,101
	dc.w 4,3,102,98,97,101,102
	dc.w 4,2,103,99,98,102,103
	dc.w 4,3,100,96,99,103,100

Cinnost9:
	dc.w 200, 0,0,10,  -2,3,1
	dc.w 400, 0,0,0,   1,1,1
	dc.w 250, 0,0,-20, 3,-1,4
	dc.w -1
	even
;=========================================================
Root:	dc.l	Coords2DP1
	dc.l	0
	dc.w	0
	dc.w	0
	dc.l	Coords2DP2
	dc.l	0
	dc.w	0
	dc.w	0
	dc.l	Coords2DP3
	dc.l	0
	dc.w	0
	dc.w	0
	dc.l	Coords2DP4
	dc.l	0
	dc.w	0
	dc.w	0
Coords2DP1:
	dcb.b	MAXPOINTS1*4,0
Coords2DP2:
	dcb.b	MAXPOINTS2*4,0
Coords2DP3:
	dcb.b	MAXPOINTS3*4,0
Coords2DP4:
	dcb.b	MAXPOINTS4*4,0
MulsList:
	dcb.w	INTERLACE,0
Sprite1:
	dc.w	$0,$0
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0400,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
spr1	dcb.w	20*10,0
	dc.l	0
Sprite2:
	dc.w	$0,$0
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0100
	dc.w	$0000,$0000
	dc.w	$0000,$0000
spr2	dcb.w	20*10,0
	dc.l	0
Sprite3:
	dc.w	$0,$0
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0800,$0800
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
	dc.w	$0000,$0000
spr3	dcb.w	20*10,0
	dc.l	0
SpriteFalse:
	dc.l	0
SpritesPtr:
	dc.l	Sprite1,Sprite2,Sprite3,SpriteFalse
SpritesPos:
	dc.w	$30e1,$40a0,$5030,$60f0,$7060,$803a,$90d3,$a015
	dc.w	$b0b0,$c075,$d0cd
	dc.w	$3572,$4533,$55c0,$6505,$7567,$85b3,$95fd,$a592
	dc.w	$b526,$c588,$d5bb
	dc.w	$3225,$42fa,$5264,$62a6,$7248,$82bd,$9219,$a2a1
	dc.w	$b23a,$c2cc,$d255
MirrorTab:
	dcb.b	118,0
Pic:	dcb.b	40*16,0
	even
;---------------------------------------------------------
CopperList:
	dc.w	$0120,$0000,$0122,$0000
	dc.w	$0124,$0000,$0126,$0000
	dc.w	$0128,$0000,$012A,$0000
	dc.w	$012C,$0000,$012E,$0000
	dc.w	$0130,$0000,$0132,$0000
	dc.w	$0134,$0000,$0136,$0000
	dc.w	$0138,$0000,$013A,$0000
	dc.w	$013C,$0000,$013E,$0000
	dc.w	$008E,$2C81,$0090,$2CC1
	dc.w	$0092,$0038,$0094,$00D0
	dc.w	$01A0,$0000,$01A2,$0eee,$01A4,$0888,$01A6,$0555  ;spr0&1
	dc.w	$01A8,$0000,$01AA,$0eee,$01AC,$0888,$01AE,$0555  ;spr2&3
	dc.w	$0180,$00f0,$0182,$0000,$0108,$0000,$010A,$0000
BMaps:	dc.w	$00e0,$0000,$00e2,$0000
	dc.w	$0100,$1200
	dc.w	$2c01,$fffe,$0096,$8100
Top:	dcb.w	16*2*2+16*2,0
	dc.w	$3c01,$fffe,$0096,$0100
CopCol:	dc.w	$0180,$0000,$0182,$0000,$0184,$0000,$0186,$0000  ;plf1
	dc.w	$0188,$0000,$018A,$0000,$018C,$0000,$018E,$0000
BitMaps:
	dc.w	$00E0,$0000,$00E2,$0000
	dc.w	$00E4,$0000,$00E6,$0000
	dc.w	$00E8,$0000,$00EA,$0000
	dc.w	$0100,$3200,$0102,$0000,$0104,$0000
	dc.w	$0108,$0000,$010A,$0000
	dc.w	$3d01,$fffe,$0096,$8100
	dc.w	$e001,$fffe
	dc.w	$009c,$8004
Mirror:	dcb.w	11*2*2,0
	dc.w	$ffdf,$fffe
	dc.w	$0108,-160,$010A,-160
	dcb.w	48*2*2,0
	dc.w	$ffff,$fffe
	even
;------------------------------------
Screen1:	dcb.b	40*256*3,0
Screen2:	dcb.b	40*256*3,0
Buffer:		dcb.b	40*256,0

	cnop	0,4
zorg:	dcb.l	68,0		; sum of areas
z2org:	dcb.l	156,0		; max amount of points in scene
lrtab:	dcb.l	68,0		; sum of areas
dtorg:	dcb.b	68*14,0		; sum of areas * 14
