  
?                                    ;======================================================================
;=== Vector Color Fill Routive V1.2 === (C)1996 by Vlastimil Knotek ===
;======================================================================
StartPart2:
	movem.l	d0-d7/a0-a6,-(a7)
	bsr	SaveAllPart2
	bsr	InitAllPart2
	bsr	MakeMulsListPart2
	bsr	StartCopperPart2
	bsr	MainLoopPart2
	bsr	RestoreAllPart2
	movem.l	(a7)+,d0-d7/a0-a6
	rts

SaveAllPart2:
	move.l	$4.w,a6
	lea.l	GfxNamePart2(pc),a1
	moveq	#0,D0
	jsr	-408(a6)	;OldOpenLibrary
	move.l	d0,a1
	lea	OldCopper1Part2(pc),a0
	move.l	$26(a1),(a0)
	lea	OldCopper2Part2(pc),a0
	move.l	$32(a1),(a0)
	jsr	-414(a6)	;CloseLibrary

	move.l	chipbasePart2(pc),a6
	lea	OldDMACONPart2(pc),a0
	move.w	$002(a6),(a0)+
	move.w	$01c(a6),(a0)+
	rts

InitAllPart2:
	lea	BitMapsPart2+$2,a0
	move.l	PlaneSPart2(pc),d0
	adda.l	#64*56+8,d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	rts

MakeMulsListPart2:
	move.l	MulsPtrPart2(pc),a0
	moveq	#0,d0
	move.l	#384-1,d1
mmloopPart2:	move.w	d0,(a0)+
	addi.w	#56,d0
	dbf	d1,mmloopPart2
	rts

StartCopperPart2:
	move.l	#CopperListPart2,$80(a6)
	tst.w	$88(a6)
	move.w	#$7fff,$96(a6)
	move.w	#$83c0,$96(a6)
	move.w	#$7fff,$9a(a6)
	;move.w	OldINTENAPart2(pc),d0
	;or.w	#$c000,d0
	move.w	#$c000,$9a(a6)
	rts

MainLoopPart2:
	cmp.b	#-1,$6(a6)
	bne.s	MainLoopPart2

	bsr	DoubleBufferPart2
	bsr	TunnelPart2

	move.l	chipbasePart2(pc),a6


wlmPart2:	btst	#6,$bfe001
	bne.s	MainLoopPart2
	rts

RestoreAllPart2:
	move.l	chipbasePart2(pc),a6
rawPart2:	btst	#6,$dff002
	bne.s	rawPart2
	move.l	OldCopper1Part2(pc),$080(a6)
	tst.w	$88(a6)
	move.l	OldCopper2Part2(pc),$084(a6)
	tst.w	$8a(a6)
	move.w	OldDMACONPart2(pc),d0
	or.w	#$8000,d0
	move.w	OldINTENAPart2(pc),d1
	or.w	#$8000,d1
	move.w	d0,$096(a6)
	move.w	d1,$09a(a6)
	rts
;=========================================================
GfxNamePart2:	DC.B	'graphics.library',0
		even
OldCopper1Part2:	DC.L	0
OldCopper2Part2:	DC.L	0
OldDMACONPart2:	DC.W	0
OldINTENAPart2:	DC.W	0
;=========================================================
DoubleBufferPart2:
	movem.l	PlaneHPart2(pc),d0-d2	; H S C
	move.l	d0,PlaneSPart2
	move.l	d1,PlaneCPart2
	move.l	d2,PlaneHPart2
	lea	BitMapsPart2+$2,a0
	addi.l	#64*56+8,d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
;---------------------------------------------------------
ClearNormPart2:
	move.l	chipbasePart2(pc),a6

w1Part2:	btst	#6,$dff002
	bne.s	w1Part2
         
	moveq	#-1,d0
	move.l	d0,$44(a6)
	move.w	#16,$66(a6)
	move.l	#$1000000,$40(a6)
	move.l	PlaneCPart2(pc),d0
	addi.l	#64*56+8,d0
	move.l	d0,$54(a6)
	move.w	#256*64+20,$58(a6)
	rts
;---------------------------------------------------------
TunnelPart2:
	lea	PersPart2(pc),a2
	move.l	PlaneHPart2(pc),a3
	move.l	MulsPtrPart2(pc),a4
	lea	zcPart2(pc),a5
	lea	jvPart2(pc),a6

	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3

	move.w	#24,zcntPart2

z_loopPart2:
	lea	sintab2Part2(pc),a0
	lea	sintab2Part2+90*2(pc),a1

	move.w	(a6),d0			; J
	lsr.w	#2,d0
	add.w	d0,d0
	move.w	(a0,d0.w),d0		; Sin(J/2)
	move.w	(a6)+,d1
	lsr.w	#3,d1
	add.w	d1,d1
	move.w	(a1,d1.w),d1		; Cos(J/4)

	move.w	(a5)+,d6
	add.w	d6,d6

	lea	sintabPart2(pc),a0
	lea	sintabPart2+90*2(pc),a1

	move.w	#36,ccntPart2
	move.w	#0,d5			; I
circle_loopPart2:
	move.w	(a0,d5.w),d2		; Sin(I)
	move.w	(a1,d5.w),d3		; Cos(I)
	add.w	d0,d2			; Sin(I)+Sin(J/2)
	add.w	d1,d3			; Cos(I)+Sin(J/2)
	muls	(a2,d6.w),d2
	muls	(a2,d6.w),d3
	asr.l	#7,d2
	asr.l	#6,d2
	asr.l	#7,d3
	asr.l	#6,d3
	sub.w	d0,d2
	sub.w	d1,d3
	add.w	MidxPart2(pc),d2
	cmpi.w	#64,d2
	blt.s	not_drawPart2
	cmpi.w	#384,d2
	bgt.s	not_drawPart2
	add.w	MidyPart2(pc),d3
	cmpi.w	#64,d3
	blt.s	not_drawPart2
	cmpi.w	#320,d3
	bgt.s	not_drawPart2
	add.w	d3,d3
	move.w	(a4,d3.w),d3		; y * 56
	move.w	d2,d7
	lsr.w	#3,d2
	add.w	d2,d3
	eori.w	#7,d7
	bset	d7,(a3,d3.w)		; drawPart2 point
not_drawPart2:
	addi.w	#20,d5			; I
	subq.w	#1,ccntPart2
	bne.s	circle_loopPart2
	subq.w	#1,zcntPart2
	bne.w	z_loopPart2

	lea	zcPart2(pc),a0
	lea	jvPart2(pc),a1
	moveq	#24-1,d0
ztstPart2:	subi.w	#60,(a0)
	bge.s	zokPart2
	addi.w	#1200,(a0)+
	addi.w	#246,(a1)
jvtstPart2:	cmpi.w	#720*4,(a1)
	blt.s	jvokPart2
	subi.w	#720*4,(a1)
jvokPart2:	addq.w	#2,a1
	dbf	d0,ztstPart2
	rts

zokPart2:	addq.w	#2,a0
	addi.w	#6,(a1)
	bra.s	jvtstPart2

ccntPart2:	dc.w	0
zcntPart2:	dc.w	0

zcPart2:	dc.w	0,50,100,150,200,250,300,350,400,450
	dc.w	500,550,600,650,700,750,800,850,900,950
	dc.w	1000,1050,1100,1150
jvPart2:	dc.w	0,10,20,30,40,50,60,70,80,90
	dc.w	100,110,120,130,140,150,160,170,180,190
	dc.w	200,210,220,230

MidxPart2:		dc.w	224
MidyPart2:		dc.w	192
PlaneHPart2:		dc.l	Screen1Part2
PlaneSPart2:		dc.l	Screen2Part2
PlaneCPart2:		dc.l	Screen3Part2

chipbasePart2:	dc.l $dff000
MulsPtrPart2:	dc.l MulsListPart2
;---------------------------------------------------------
sintabPart2:		incbin	'sin.data'
sintab2Part2:	incbin	'sin2.data'
PersPart2:		incbin	'tunel.data'
;=========================================================
MulsListPart2:	dcb.w	384,0
;=========================================================
	section	'copper',data_c
CopperListPart2:
	dc.w	$008E,$2C81,$0090,$2CC1
	dc.w	$0092,$0038,$0094,$00D0
	dc.w	$0180,$0000,$0182,$0FFF
BitMapsPart2:
	dc.w	$00e0,$0000,$00e2,$0000
	dc.w	$0100,$1200,$0108,$0010,$010A,$0010
	dc.w	$ffff,$fffe
	even
;------------------------------------
	section	'screens',BSS_C

Screen1Part2:	ds.b	56*384
Screen2Part2:	ds.b	56*384
Screen3Part2:	ds.b	56*384
