  f                                    ;======================================================================
;=== Vector Color Fill Routive V1.2 === (C)1996 by Vlastimil Knotek ===
;======================================================================
Start:
	movem.l	d0-d7/a0-a6,-(a7)
	bsr	SaveAll
	bsr	InitAll
	bsr	MakeMulsList
	move.l	#module,tp_data
	jsr	tp_init
	bsr	StartCopper
	bsr	MainLoop
;	bsr	RestoreAll
	movem.l	(a7)+,d0-d7/a0-a6
	jmp	StartPart2

SaveAll:
;	move.l	$4.w,a6
;	lea.l	GfxName(pc),a1
;	moveq	#0,D0
;	jsr	-408(a6)	;OldOpenLibrary
;	move.l	d0,a1
	lea	OldCopper1(pc),a0
	move.l	$100,(a0)
;	move.l	$26(a1),(a0)
	lea	OldCopper2(pc),a0
	move.l	$104,(a0)
;	move.l	$32(a1),(a0)
;	jsr	-414(a6)	;CloseLibrary

	move.l	chipbase(pc),a6
	lea	OldDMACON(pc),a0
	move.w	$002(a6),(a0)+
	move.w	$01c(a6),(a0)+
	move.l	$6c.w,(a0)
	rts

InitAll:
	lea	BitMaps+$2,a0
	move.l	PlaneS(pc),d0
	adda.l	#64*56+8,d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	rts

MakeMulsList:
	move.l	MulsPtr(pc),a0
	moveq	#0,d0
	move.l	#384-1,d1
mmloop:	move.w	d0,(a0)+
	addi.w	#56,d0
	dbf	d1,mmloop
	rts

StartCopper:
	cmpi.b	#-1,$6(a6)
	bne.s	StartCopper
	move.w	#$24,$9a(a6)
scwb:	btst	#6,$2(a6)
	bne.s	scwb
	move.w	#$40,$96(a6)
scwvb:	cmpi.b	#-1,$6(a6)
	bne.s	scwvb
	move.w	#$7fff,$96(a6)
	move.w	#$3fff,$9a(a6)
	move.l	#CopperList,$80(a6)
	tst.w	$88(a6)
	move.w	#$83c0,$96(a6)
	lea	NewVB(pc),a0
	move.l	a0,$6c.w
	move.w	#$c020,$9a(a6)
	rts

MainLoop:
	cmp.b	#-1,$6(a6)
	bne.s	MainLoop

	bsr	DoubleBuffer
	bsr	Tunnel

	move.l	chipbase(pc),a6

	lea	cnt1(pc),a0
	subq.w	#1,(a0)
	bne.s	MainLoop
	rts

cnt1:	dc.w	360

RestoreAll:
	move.l	chipbase(pc),a6
ra_wvb:	cmpi.b	#-1,$6(a6)
	bne.s	ra_wvb
	move.w	#$7fff,$9a(a6)
raw:	btst	#6,$dff002
	bne.s	raw
	move.w	#$7fff,$96(a6)
	move.l	OldCopper1(pc),$080(a6)
	tst.w	$88(a6)
	move.l	OldCopper2(pc),$084(a6)
	tst.w	$8a(a6)
	move.l	OldVB(pc),$6c.w
	move.w	OldDMACON(pc),d0
	or.w	#$8000,d0
	move.w	OldINTENA(pc),d1
	or.w	#$8000,d1
	move.w	d0,$096(a6)
	move.w	d1,$09a(a6)
	rts
;=========================================================
GfxName:	DC.B	'graphics.library',0
		even
OldCopper1:	DC.L	0
OldCopper2:	DC.L	0
OldDMACON:	DC.W	0
OldINTENA:	DC.W	0
OldVB:		dc.l	0
;=========================================================
NewVB:	movem.l	d0-d7/a0-a6,-(sp)
	jsr	tp_play
	movem.l	(sp)+,d0-d7/a0-a6
	move.w	#$20,$dff09c
	rte
;=========================================================
DoubleBuffer:
	movem.l	PlaneH(pc),d0-d2	; H S C
	move.l	d0,PlaneS
	move.l	d1,PlaneC
	move.l	d2,PlaneH
	lea	BitMaps+$2,a0
	addi.l	#64*56+8,d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
;---------------------------------------------------------
ClearNorm:
	move.l	chipbase(pc),a6

w1:	btst	#6,$dff002
	bne.s	w1
         
	moveq	#-1,d0
	move.l	d0,$44(a6)
	move.w	#16,$66(a6)
	move.l	#$1000000,$40(a6)
	move.l	PlaneC(pc),d0
	addi.l	#64*56+8,d0
	move.l	d0,$54(a6)
	move.w	#256*64+20,$58(a6)
	rts
;---------------------------------------------------------
Tunnel:
	lea	Pers(pc),a2
	move.l	PlaneH(pc),a3
	move.l	MulsPtr(pc),a4
	lea	zc(pc),a5
	lea	jv(pc),a6

	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3

	move.w	#24,zcnt

z_loop:
	lea	sintab2(pc),a0
	lea	sintab2+90*2(pc),a1

	move.w	(a6),d0			; J
	lsr.w	#2,d0
	add.w	d0,d0
	move.w	(a0,d0.w),d0		; Sin(J/2)
	move.w	(a6)+,d1
	lsr.w	#3,d1
	add.w	d1,d1
	move.w	(a1,d1.w),d1		; Cos(J/4)

	move.w	(a5)+,d6
	add.w	d6,d6

	lea	sintab(pc),a0
	lea	sintab+90*2(pc),a1

	move.w	#36,ccnt
	move.w	#0,d5			; I
circle_loop:
	move.w	(a0,d5.w),d2		; Sin(I)
	move.w	(a1,d5.w),d3		; Cos(I)
	add.w	d0,d2			; Sin(I)+Sin(J/2)
	add.w	d1,d3			; Cos(I)+Sin(J/2)
	muls	(a2,d6.w),d2
	muls	(a2,d6.w),d3
	asr.l	#7,d2
	asr.l	#7,d2
	asr.l	#7,d3
	asr.l	#7,d3
	sub.w	d0,d2
	sub.w	d1,d3
	add.w	Midx(pc),d2
	add.w	Midy(pc),d3
	add.w	d3,d3
	move.w	(a4,d3.w),d3		; y * 56
	move.w	d2,d7
	lsr.w	#3,d2
	add.w	d2,d3
	eori.w	#7,d7
	bset	d7,(a3,d3.w)		; draw point
	addi.w	#20,d5			; I
	subq.w	#1,ccnt
	bne.s	circle_loop
	subq.w	#1,zcnt
	bne.w	z_loop

	lea	zc(pc),a0
	lea	jv(pc),a1
	moveq	#24-1,d0
ztst:	subi.w	#60,(a0)
	bge.s	zok
	addi.w	#1200,(a0)+
	addi.w	#242,(a1)
jvtst:	cmpi.w	#720*4,(a1)
	blt.s	jvok
	subi.w	#720*4,(a1)
jvok:	addq.w	#2,a1
	dbf	d0,ztst
	rts

zok:	addq.w	#2,a0
	addi.w	#2,(a1)
	bra.s	jvtst

ccnt:	dc.w	0
zcnt:	dc.w	0

zc:	dc.w	0,50,100,150,200,250,300,350,400,450
	dc.w	500,550,600,650,700,750,800,850,900,950
	dc.w	1000,1050,1100,1150
jv:	dc.w	0,10,20,30,40,50,60,70,80,90
	dc.w	100,110,120,130,140,150,160,170,180,190
	dc.w	200,210,220,230

Midx:		dc.w	224
Midy:		dc.w	192
PlaneH:		dc.l	Screen1
PlaneS:		dc.l	Screen2
PlaneC:		dc.l	Screen3

chipbase:	dc.l $dff000
MulsPtr:	dc.l MulsList
;---------------------------------------------------------
		incdir	'tbsd:tunnel_sphere/'
sintab:		incbin	'tunnel/sin.data'
sintab2:	incbin	'tunnel/sin2.data'
Pers:		incbin	'tunnel/tunel.data'
;=========================================================
MulsList:	dcb.w	384,0
;=========================================================
CopperList:
	dc.w	$008E,$2C81,$0090,$2CC1
	dc.w	$0092,$0038,$0094,$00D0
	dc.w	$0180,$0000,$0182,$0FFF
BitMaps:
	dc.w	$00e0,$0000,$00e2,$0000
	dc.w	$0100,$1200,$0108,$0010,$010A,$0010
	dc.w	$ffff,$fffe
	even
;------------------------------------
Screen1:	dcb.b	56*384,0
Screen2:	dcb.b	56*384,0
Screen3:	dcb.b	56*384,0

;**********************************************
;**********************************************
;**********************************************
;**********************************************
;**********************************************

;======================================================================
;=== Vector Color Fill Routive V1.2 === (C)1996 by Vlastimil Knotek ===
;======================================================================
StartPart2:
	movem.l	d0-d7/a0-a6,-(a7)
	bsr	InitAllPart2
	bsr	MakeMulsListPart2
	lea	$dff000,a6
	bsr	StartCopperPart2
	bsr	MainLoopPart2
	movem.l	(a7)+,d0-d7/a0-a6
	jmp	StartPart3

InitAllPart2:
	lea	BitMapsPart2+$2,a0
	move.l	PlaneS,d0
	adda.l	#64*56+8,d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	rts

MakeMulsListPart2:
	move.l	MulsPtrPart2(pc),a0
	moveq	#0,d0
	move.l	#384-1,d1
mmloopPart2:	move.w	d0,(a0)+
	addi.w	#56,d0
	dbf	d1,mmloopPart2
	rts

StartCopperPart2:
	cmpi.b	#-1,$6(a6)
	bne.s	StartCopperPart2
	move.w	#$24,$9a(a6)
sc2wb:	btst	#6,$2(a6)
	bne.s	sc2wb
	move.w	#$40,$96(a6)
sc2wvb:	cmpi.b	#-1,$6(a6)
	bne.s	sc2wvb
	move.w	#$7ff0,$96(a6)
	move.w	#$3fdf,$9a(a6)
	move.l	#CopperListPart2,$80(a6)
	tst.w	$88(a6)
	move.w	#$83c0,$96(a6)
	move.w	#$c020,$9a(a6)
	rts

MainLoopPart2:
	cmp.b	#-1,$6(a6)
	bne.s	MainLoopPart2

	bsr	DoubleBufferPart2
	bsr	TunnelPart2

	move.l	chipbasePart2(pc),a6
	lea	cnt2(pc),a0
	subq.w	#1,(a0)
	bne.w	MainLoopPart2
	rts

cnt2:	dc.w	360

;=========================================================
DoubleBufferPart2:
	movem.l	PlaneH,d0-d2	; H S C
	move.l	d0,PlaneS
	move.l	d1,PlaneC
	move.l	d2,PlaneH
	lea	BitMapsPart2+$2,a0
	addi.l	#64*56+8,d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
;---------------------------------------------------------
ClearNormPart2:
	move.l	chipbasePart2(pc),a6

w1Part2:	btst	#6,$dff002
	bne.s	w1Part2
         
	moveq	#-1,d0
	move.l	d0,$44(a6)
	move.w	#16,$66(a6)
	move.l	#$1000000,$40(a6)
	move.l	PlaneC,d0
	addi.l	#64*56+8,d0
	move.l	d0,$54(a6)
	move.w	#256*64+20,$58(a6)
	rts
;---------------------------------------------------------
TunnelPart2:
	lea	Pers,a2
	move.l	PlaneH,a3
	move.l	MulsPtrPart2(pc),a4
	lea	zcPart2(pc),a5
	lea	jvPart2(pc),a6

	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3

	move.w	#24,zcntPart2

z_loopPart2:
	lea	sintab2,a0
	lea	sintab2+90*2,a1

	move.w	(a6),d0			; J
	lsr.w	#2,d0
	add.w	d0,d0
	move.w	(a0,d0.w),d0		; Sin(J/2)
	move.w	(a6)+,d1
	lsr.w	#3,d1
	add.w	d1,d1
	move.w	(a1,d1.w),d1		; Cos(J/4)

	move.w	(a5)+,d6
	add.w	d6,d6

	lea	sintab,a0
	lea	sintab+90*2,a1

	move.w	#36,ccntPart2
	move.w	#0,d5			; I
circle_loopPart2:
	move.w	(a0,d5.w),d2		; Sin(I)
	move.w	(a1,d5.w),d3		; Cos(I)
	add.w	d0,d2			; Sin(I)+Sin(J/2)
	add.w	d1,d3			; Cos(I)+Sin(J/2)
	muls	(a2,d6.w),d2
	muls	(a2,d6.w),d3
	asr.l	#7,d2
	asr.l	#6,d2
	asr.l	#7,d3
	asr.l	#6,d3
	sub.w	d0,d2
	sub.w	d1,d3
	add.w	MidxPart2(pc),d2
	cmpi.w	#64,d2
	blt.s	not_drawPart2
	cmpi.w	#384,d2
	bgt.s	not_drawPart2
	add.w	MidyPart2(pc),d3
	cmpi.w	#64,d3
	blt.s	not_drawPart2
	cmpi.w	#320,d3
	bgt.s	not_drawPart2
	add.w	d3,d3
	move.w	(a4,d3.w),d3		; y * 56
	move.w	d2,d7
	lsr.w	#3,d2
	add.w	d2,d3
	eori.w	#7,d7
	bset	d7,(a3,d3.w)		; drawPart2 point
not_drawPart2:
	addi.w	#20,d5			; I
	subq.w	#1,ccntPart2
	bne.s	circle_loopPart2
	subq.w	#1,zcntPart2
	bne.w	z_loopPart2

	lea	zcPart2(pc),a0
	lea	jvPart2(pc),a1
	moveq	#24-1,d0
ztstPart2:	subi.w	#60,(a0)
	bge.s	zokPart2
	addi.w	#1200,(a0)+
	addi.w	#246,(a1)
jvtstPart2:	cmpi.w	#720*4,(a1)
	blt.s	jvokPart2
	subi.w	#720*4,(a1)
jvokPart2:	addq.w	#2,a1
	dbf	d0,ztstPart2
	rts

zokPart2:	addq.w	#2,a0
	addi.w	#6,(a1)
	bra.s	jvtstPart2

ccntPart2:	dc.w	0
zcntPart2:	dc.w	0

zcPart2:	dc.w	0,50,100,150,200,250,300,350,400,450
	dc.w	500,550,600,650,700,750,800,850,900,950
	dc.w	1000,1050,1100,1150
jvPart2:	dc.w	0,10,20,30,40,50,60,70,80,90
	dc.w	100,110,120,130,140,150,160,170,180,190
	dc.w	200,210,220,230

MidxPart2:		dc.w	224
MidyPart2:		dc.w	192

chipbasePart2:	dc.l $dff000
MulsPtrPart2:	dc.l MulsListPart2
;=========================================================
MulsListPart2:	dcb.w	384,0
;=========================================================
CopperListPart2:
	dc.w	$008E,$2C81,$0090,$2CC1
	dc.w	$0092,$0038,$0094,$00D0
	dc.w	$0180,$0000,$0182,$0FFF
BitMapsPart2:
	dc.w	$00e0,$0000,$00e2,$0000
	dc.w	$0100,$1200,$0108,$0010,$010A,$0010
	dc.w	$ffff,$fffe
	even
;------------------------------------
;**********************************************
;**********************************************
;**********************************************
;**********************************************
;**********************************************

;===========================================================
;=== Sphere Routive V0.0 === (C)1999 by Vlastimil Knotek ===
;=== 20*13*4 = 1040 points rotated around 2 axis	 ===
;===========================================================
StartPart3:
	movem.l	d0-d7/a0-a6,-(a7)
	bsr	InitAllPart3
	bsr	MakeMulsListPart3
	lea	$dff000,a6
	bsr	StartCopperPart3
	bsr	MainLoopPart3
	jsr	RestoreAll
	movem.l	(a7)+,d0-d7/a0-a6
	rts

InitAllPart3:
	lea	BitMapsPart3+$2(pc),a0
	move.l	PlaneSPart3(pc),d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)

	lea	CopperListPart3+2,a0
	move.l	#Spr1Part3,d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	addq.w	#8,a0
	move.l	#Spr2Part3,d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	addq.w	#8,a0
	move.l	#Spr3Part3,d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	addq.w	#8,a0
	move.l	#Spr4Part3,d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	addq.w	#8,a0
	move.l	#Spr5Part3,d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	addq.w	#8,a0
	move.l	#Spr6Part3,d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	addq.w	#8,a0
	move.l	#Spr7Part3,d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	addq.w	#8,a0
	move.l	#Spr8Part3,d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)

	move.w	SprPos1Part3,d0
	move.w	SprPos1Part3+2,d1
	move.w	#45,d2
	lea	Spr1Part3(pc),a0
	bsr	MoveSpritePart3

	move.w	SprPos2Part3,d0
	move.w	SprPos2Part3+2,d1
	move.w	#45,d2
	lea	Spr2Part3(pc),a0
	bsr	MoveSpritePart3

	move.w	SprPos3Part3,d0
	move.w	SprPos3Part3+2,d1
	move.w	#45,d2
	lea	Spr3Part3(pc),a0
	bsr	MoveSpritePart3

	move.w	SprPos4Part3,d0
	move.w	SprPos4Part3+2,d1
	move.w	#45,d2
	lea	Spr4Part3(pc),a0
	bsr	MoveSpritePart3

	move.w	SprPos5Part3,d0
	move.w	SprPos5Part3+2,d1
	move.w	#45,d2
	lea	Spr5Part3(pc),a0
	bsr	MoveSpritePart3

	move.w	SprPos6Part3,d0
	move.w	SprPos6Part3+2,d1
	move.w	#45,d2
	lea	Spr6Part3(pc),a0
	bsr	MoveSpritePart3

	move.w	SprPos7Part3,d0
	move.w	SprPos7Part3+2,d1
	move.w	#45,d2
	lea	Spr7Part3(pc),a0
	bsr	MoveSpritePart3

	move.w	SprPos8Part3,d0
	move.w	SprPos8Part3+2,d1
	move.w	#45,d2
	lea	Spr8Part3(pc),a0
	bsr	MoveSpritePart3

	lea	Coords3DPart3,a0
	lea	sintab2Part3,a1
	lea	costab2Part3,a2
	lea	Roots3DPart3+4,a3
	moveq	#2,d3
.ilp1:	moveq	#0,d4
.ilp2:	move.w	d3,d0
	move.w	d4,d1
	add.w	d0,d0
	add.w	d1,d1
	move.w	(a1,d0.w),d2
	muls	(a2,d1.w),d2
	lsr.l	#8,d2
	move.w	d2,(a0)+
	move.w	(a1,d0.w),d2
	muls	(a1,d1.w),d2
	lsr.l	#8,d2
	move.w	d2,(a0)+
	move.w	(a2,d0.w),d2
	move.w	d2,(a0)+
	addi.w	#9,d4
	cmpi.w	#180,d4
	bne.s	.ilp2
	move.w	d2,(a3)
	addq.w	#6,a3
	addi.w	#7,d3
	cmpi.w	#93,d3
	bne.s	.ilp1

	lea	RainPart3,a0
	lea	RainbowPart3+45*2-2,a1
	moveq	#45-1,d0
	move.l	#$3407fffe,d1
rblPart3:	move.l	d1,(a0)+
	move.w	#$01a2,(a0)+
	move.w	(a1),(a0)+
	move.w	#$01aa,(a0)+
	move.w	(a1),(a0)+
	move.w	#$01b2,(a0)+
	move.w	(a1),(a0)+
	move.w	#$01ba,(a0)+
	move.w	(a1),(a0)+
	subq.l	#2,a1
	addi.l	#$01000000,d1
	dbf	d0,rblPart3
	rts

MakeMulsListPart3:
	move.l	MulsPtrPart3(pc),a0
	moveq	#0,d0
	move.l	#256-1,d1
mmloopPart3:	move.w	d0,(a0)+
	addi.w	#40,d0
	dbf	d1,mmloopPart3
	rts

StartCopperPart3:
	cmpi.b	#-1,$6(a6)
	bne.s	StartCopperPart3
	move.w	#$24,$9a(a6)
sc3wb:	btst	#6,$2(a6)
	bne.s	sc3wb
	move.w	#$40,$96(a6)
sc3wvb:	cmpi.b	#-1,$6(a6)
	bne.s	sc3wvb
	move.w	#$7ff0,$96(a6)
	move.w	#$3fdf,$9a(a6)
	move.l	#CopperListPart3,$80(a6)
	tst.w	$88(a6)
	move.w	#$83e0,$96(a6)
	move.w	#$c020,$9a(a6)
	rts

MainLoopPart3:
	cmp.b	#-1,$6(a6)
	bne.s	MainLoopPart3

	bsr	DoubleBufferPart3
	bsr	rotatePart3
	bsr	transformPart3
	bsr	DrawPointsPart3

	subq.w	#1,scntPart3
	bne.s	.nms
	bsr	MoveSprPart3
.nms:	cmpi.w	#150,scntPart3
	ble.s	MainLoopPart3
	subq.w	#1,fcntPart3
	beq.s	emlPart3
	bsr	FadeOutPart3
	bra.s	MainLoopPart3

emlPart3:
	rts

scntPart3:	dc.w	150
fcntPart3:	dc.w	16
;=========================================================
FadeOutPart3:
	lea	ColorsPart3+2,a0
	moveq	#16-1,d2
flPart3:	move.w	(a0),d0
	move.w	d0,d1
	andi.w	#$0ff,d1
	andi.w	#$f00,d0
	beq.s	.nfo1
	subi.w	#$100,d0
	or.w	d0,d1
.nfo1:	move.w	d1,d0
	andi.w	#$f0f,d1
	andi.w	#$0f0,d0
	beq.s	.nfo2
	subi.w	#$010,d0
	or.w	d0,d1
.nfo2:	move.w	d1,d0
	andi.w	#$ff0,d1
	andi.w	#$00f,d0
	beq.s	.nfo3
	subq.w	#$001,d0
	or.w	d0,d1
.nfo3:	move.w	d1,(a0)
	addq.w	#4,a0
	dbf	d2,flPart3
	rts
;---------------------------------------------------------
MoveSprPart3:
	move.w	#1,scntPart3
	move.l	SprMPosPart3,a1
	move.w	(a1)+,d3
	cmpa.l	#SprMPosPart3,a1
	bne.s	.nores
	move.l	#SprMPart3,a1
	move.w	#$7fff,scntPart3
.nores:	move.l	a1,SprMPosPart3

	add.w	d3,SprPos1Part3
	move.w	SprPos1Part3,d0
	move.w	SprPos1Part3+2,d1
	move.w	#45,d2
	lea	Spr1Part3(pc),a0
	bsr	MoveSpritePart3

	add.w	d3,SprPos2Part3
	move.w	SprPos2Part3,d0
	move.w	SprPos2Part3+2,d1
	move.w	#45,d2
	lea	Spr2Part3(pc),a0
	bsr	MoveSpritePart3

	add.w	d3,SprPos3Part3
	move.w	SprPos3Part3,d0
	move.w	SprPos3Part3+2,d1
	move.w	#45,d2
	lea	Spr3Part3(pc),a0
	bsr	MoveSpritePart3

	add.w	d3,SprPos4Part3
	move.w	SprPos4Part3,d0
	move.w	SprPos4Part3+2,d1
	move.w	#45,d2
	lea	Spr4Part3(pc),a0
	bsr	MoveSpritePart3

	add.w	d3,SprPos5Part3
	move.w	SprPos5Part3,d0
	move.w	SprPos5Part3+2,d1
	move.w	#45,d2
	lea	Spr5Part3(pc),a0
	bsr	MoveSpritePart3

	add.w	d3,SprPos6Part3
	move.w	SprPos6Part3,d0
	move.w	SprPos6Part3+2,d1
	move.w	#45,d2
	lea	Spr6Part3(pc),a0
	bsr	MoveSpritePart3

	add.w	d3,SprPos7Part3
	move.w	SprPos7Part3,d0
	move.w	SprPos7Part3+2,d1
	move.w	#45,d2
	lea	Spr7Part3(pc),a0
	bsr	MoveSpritePart3

	add.w	d3,SprPos8Part3
	move.w	SprPos8Part3,d0
	move.w	SprPos8Part3+2,d1
	move.w	#45,d2
	lea	Spr8Part3(pc),a0
	bsr	MoveSpritePart3

	rts

;-------------------------------------------------
MoveSpritePart3:
	move.b	d1,(a0)
	btst	#8,d1
	bne.s	MSP_01Part3
	bclr	#2,3(a0)
	bra.s	MSP_10Part3
MSP_01Part3:	bset	#2,3(a0)
MSP_10Part3:	add.w	d2,d1
	move.b	d1,2(a0)
	btst	#8,d1
	bne.s	MSP_11Part3
	bclr	#1,3(a0)
	bra.s	MSP_20Part3
MSP_11Part3:	bset	#1,3(a0)
MSP_20Part3:	lsr.w	#1,d0
	bcs.s	MSP_21Part3
	bclr	#0,3(a0)
	bra.s	MSP_22Part3
MSP_21Part3:	bset	#0,3(a0)
MSP_22Part3:	move.b	d0,1(a0)
	rts
;--------------------------------------
rotatePart3:
	move.w	rxPart3(pc),d0
	addq.w	#4,d0
	cmpi.w	#720,d0
	blt.s	.xok
	subi.w	#720,d0
.xok:	move.w	d0,rxPart3
	move.w	ryPart3(pc),d0
	addq.w	#2,d0
	cmpi.w	#720,d0
	blt.s	.yok
	subi.w	#720,d0
.yok:	move.w	d0,ryPart3
	rts
;---------------------------
DoubleBufferPart3:
	movem.l	PlaneSPart3(pc),d0-d3
	move.l	d0,PlaneEPart3
	move.l	d1,PlaneSPart3
	move.l	d2,PlaneDPart3
	move.l	d3,PlaneCPart3
	lea	BitMapsPart3+$2(pc),a0
	move.w	d1,4(a0)
	swap	d1
	move.w	d1,(a0)
	swap	d1
	addq.w	#8,a0
	subi.l	#40,d1
	move.w	d1,4(a0)
	swap	d1
	move.w	d1,(a0)
	addq.w	#8,a0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
	swap	d0
	addq.w	#8,a0
	subi.l	#40,d0
	move.w	d0,4(a0)
	swap	d0
	move.w	d0,(a0)
;---------------------------------------------------------
ClearNormPart3:
	move.l	chipbasePart3(pc),a6

w1Part3:	btst	#6,$dff002
	bne.s	w1Part3
         
	moveq	#-1,d1
	move.l	d1,$44(a6)
	move.w	#12,$66(a6)
	move.l	#$1000000,$40(a6)
	addi.l	#6,d3
	move.l	d3,$54(a6)
	move.w	#256*64+14,$58(a6)
	rts
;---------------------------------------------------------
transformPart3:
	lea	sintabPart3(pc),a0
	lea	costabPart3(pc),a1

	lea	CalcUpPart3(pc),a2
	lea	rxPart3(pc),a3
	move.w	(a3)+,d0
	move.w	(a1,d0.w),(a2)+	; cos(al)
	move.w	(a0,d0.w),(a2)+	; sin(al)
	move.w	(a3),d0
	move.w	(a1,d0.w),(a2)+	; cos(be)
	move.w	(a0,d0.w),(a2)	; sin(be)

	lea	CalcUpPart3(pc),a1
	lea	Roots3DPart3(pc),a2	; address of roots
	lea	Roots3D2Part3(pc),a3	; address of new 3D coords
	moveq	#13-1,d5

lp5Part3:	move.w	(a2)+,d0	; x
	move.w	(a2)+,d1	; y
	move.w	(a2)+,d2	; z
	move.w	d1,d4
	move.w	d2,d7
	move.w	(a1)+,d3	; cos
	move.w	(a1)+,d6	; sin
	muls	d3,d1		; ny=y*cos(al)
	muls	d6,d2		; nz=z*sin(al)
	sub.l	d2,d1		; fy=ny-nz
	add.l	d1,d1
	swap	d1
	muls	d6,d4		; ny=y*sin(al)
	muls	d3,d7		; nz=z*cos(al)
	add.l	d7,d4		; fz=ny-nz
	add.l	d4,d4
	swap	d4
	move.w	d4,d2		; d2=z

	move.w	d0,d4
	move.w	d2,d7
	move.w	(a1)+,d3	; cos
	move.w	(a1),d6		; sin
	muls	d3,d0		; nx=x*cos(be)
	muls	d6,d2		; nz=z*sin(be)
	add.l	d2,d0		; fx=nx+nz
	add.l	d0,d0
	swap	d0
	neg.w	d4		; d4=-x
	muls	d6,d4		; nx=-x*sin(be)
	muls	d3,d7		; ny=y*cos(be)
	add.l	d7,d4		; fz=nx+ny
	add.l	d4,d4
	swap	d4
	move.w	d4,d2

	ext.l	d0
	ext.l	d1
	ext.l	d2
	add.l	d0,d0
	add.l	d1,d1
	add.l	d2,d2
	move.l	d0,(a3)+
	move.l	d1,(a3)+
	move.l	d2,(a3)+
	neg.l	d0
	neg.l	d1
	neg.l	d2
	move.l	d0,(a3)+
	move.l	d1,(a3)+
	move.l	d2,(a3)+
	lea	-6(a1),a1
	dbf	d5,lp5Part3

transform2Part3:
	lea	CalcUpPart3(pc),a1
	lea	Coords3DPart3(pc),a2	; address of sphere
	lea	Coords2DPart3(pc),a3	; address of new 2D coords
	lea	Roots3D2Part3(pc),a4
	lea	PerspectivePart3(pc),a5

	moveq	#13-1,d6
lp6Part3:	moveq	#20-1,d7
lp7Part3:	movem.l	d6/d7,-(sp)
	move.w	(a2)+,d0	; x
	move.w	(a2)+,d1	; y
	move.w	(a2)+,d2	; z
	move.w	d1,d4
	move.w	d2,d7
	move.w	(a1)+,d3	; cos
	move.w	(a1)+,d6	; sin
	muls	d3,d1		; ny=y*cos(al)
	muls	d6,d2		; nz=z*sin(al)
	sub.l	d2,d1		; fy=ny-nz
	add.l	d1,d1
	swap	d1
	muls	d6,d4		; ny=y*sin(al)
	muls	d3,d7		; nz=z*cos(al)
	add.l	d7,d4		; fz=ny-nz
	add.l	d4,d4
	swap	d4
	move.w	d4,d2		; d2=z

	move.w	d0,d4
	move.w	d2,d7
	move.w	(a1)+,d3	; cos
	move.w	(a1),d6		; sin
	muls	d3,d0		; nx=x*cos(be)
	muls	d6,d2		; nz=z*sin(be)
	add.l	d2,d0		; fx=nx+nz
	add.l	d0,d0
	swap	d0
	neg.w	d4		; d4=-x
	muls	d6,d4		; nx=-x*sin(be)
	muls	d3,d7		; ny=y*cos(be)
	add.l	d7,d4		; fz=nx+ny
	add.l	d4,d4
	swap	d4
	move.w	d4,d2

;PerspectivePart3
	ext.l	d0
	ext.l	d1
	ext.l	d2
	move.l	d0,d4
	move.l	d1,d5
	move.l	d2,d6
	movem.l	d0-d2/d4-d6,-(sp)
	neg.l	d4
	neg.l	d5
	neg.l	d6

	cmpi.l	#20,d2
	ble.s	.nop1
	add.l	#256,d2
	add.w	d2,d2
	muls	(a5,d2.w),d0
	add.l	d0,d0
	swap	d0
	muls	(a5,d2.w),d1
	add.l	d1,d1
	swap	d1

	add.w	MidxPart3(pc),d0
	add.w	MidyPart3(pc),d1
	move.w	d0,(a3)+
	move.w	d1,(a3)+
	addq.w	#1,cntPart3

.nop1:	cmpi.l	#20,d6
	ble.s	.nop2
	add.l	#256,d6
	add.w	d6,d6
	muls	(a5,d6.w),d4
	add.l	d4,d4
	swap	d4
	muls	(a5,d6.w),d5
	add.l	d5,d5
	swap	d5

	add.w	MidxPart3(pc),d4
	add.w	MidyPart3(pc),d5
	move.w	d4,(a3)+
	move.w	d5,(a3)+
	addq.w	#1,cntPart3

.nop2:	movem.l	(sp)+,d0-d2/d4-d6
	neg.l	d0
	neg.l	d1
	neg.l	d2
	add.l	(a4),d0
	add.l	4(a4),d1
	add.l	8(a4),d2
	add.l	12(a4),d4
	add.l	16(a4),d5
	add.l	20(a4),d6

	cmpi.l	#20,d2
	ble.s	.nop3
	add.l	#256,d2
	add.w	d2,d2
	muls	(a5,d2.w),d0
	add.l	d0,d0
	swap	d0
	muls	(a5,d2.w),d1
	add.l	d1,d1
	swap	d1

	add.w	MidxPart3(pc),d0
	add.w	MidyPart3(pc),d1
	move.w	d0,(a3)+
	move.w	d1,(a3)+
	addq.w	#1,cntPart3

.nop3:	cmpi.l	#20,d6
	ble.s	.nop4
	add.l	#256,d6
	add.w	d6,d6
	muls	(a5,d6.w),d4
	add.l	d4,d4
	swap	d4
	muls	(a5,d6.w),d5
	add.l	d5,d5
	swap	d5

	add.w	MidxPart3(pc),d4
	add.w	MidyPart3(pc),d5
	move.w	d4,(a3)+
	move.w	d5,(a3)+
	addq.w	#1,cntPart3

.nop4:	movem.l	(sp)+,d6/d7
	lea	-6(a1),a1
	dbf	d7,lp7Part3
	lea	24(a4),a4
	dbf	d6,lp6Part3
	rts

;---------------------------------------------------------
DrawPointsPart3:
	move.l	PlaneDPart3(pc),a0
	lea	Coords2DPart3(pc),a1
	move.l	MulsPtrPart3(pc),a2
	move.w	cntPart3(pc),d4
	subq.w	#1,d4

.drawPart3:	move.w	(a1)+,d0
	move.w	(a1)+,d1
	move.w	d0,d2
	add.w	d1,d1
	move.w	(a2,d1.w),d1
	lsr.w	#3,d2
	add.w	d2,d1
	eori.b	#7,d0		; 8
	bset	d0,(a0,d1.w)
	dbf	d4,.drawPart3
	move.w	#0,cntPart3
	rts

cntPart3:	dc.w	0
;---------------------------------------------------------
rxPart3:		dc.w	90
ryPart3:		dc.w	60
MidxPart3:		dc.w	160
MidyPart3:		dc.w	128
PlaneSPart3:		dc.l	Screen1Part3
PlaneDPart3:		dc.l	Screen2Part3
PlaneCPart3:		dc.l	Screen3Part3
PlaneEPart3:		dc.l	Screen4Part3

chipbasePart3:	dc.l	$dff000
MulsPtrPart3:	dc.l	MulsListPart3
CalcUpPart3:		dcb.w	4,0
*	cnop	0,2
;=========================================================
Roots3DPart3:	dcb.w	13*3,0
Roots3D2Part3:	dcb.l	13*3*2,0
Coords3DPart3:	dcb.w	20*13*3,0
Coords2DPart3:	dcb.w	20*13*2*4,0
MulsListPart3:	dcb.w	256,0
;=========================================================
CopperListPart3:
	dc.w	$0120,$0000,$0122,$0000
	dc.w	$0124,$0000,$0126,$0000
	dc.w	$0128,$0000,$012a,$0000
	dc.w	$012c,$0000,$012e,$0000
	dc.w	$0130,$0000,$0132,$0000
	dc.w	$0134,$0000,$0136,$0000
	dc.w	$0138,$0000,$013a,$0000
	dc.w	$013c,$0000,$013e,$0000
	dc.w	$008E,$2C81,$0090,$2CC1
	dc.w	$0092,$0038,$0094,$00D0
ColorsPart3:	dc.w	$0180,$0000,$0182,$0a88,$0184,$0a88,$0186,$0a88
	dc.w	$0188,$0544,$018a,$0fcc,$018c,$0fcc,$018e,$0fcc
	dc.w	$0190,$0544,$0192,$0fcc,$0194,$0fcc,$0196,$0fcc
	dc.w	$0198,$0544,$019a,$0fcc,$019c,$0fcc,$019e,$0fcc
BitMapsPart3:
	dc.w	$00e0,$0000,$00e2,$0000
	dc.w	$00e4,$0000,$00e6,$0000
	dc.w	$00e8,$0000,$00ea,$0000
	dc.w	$00ec,$0000,$00ee,$0000
	dc.w	$0100,$4200,$0108,$0000,$010A,$0000
	dc.w	$0102,$0000,$0104,$003f
RainPart3:	dcb.w	45*4*2+45*2,0
	dc.w	$ffff,$fffe
	even
;------------------------------------
RainbowPart3:
	dc.w $0F00,$0F00,$0F00,$0F10,$0F10,$0F10,$0F20,$0F20,$0F20,$0F30
	dc.w $0F30,$0F30,$0F40,$0F40,$0F40,$0F50,$0F50,$0F50,$0F60,$0F60
	dc.w $0F60,$0F70,$0F70,$0F70,$0F80,$0F80,$0F80,$0F90,$0F90,$0F90
	dc.w $0FA0,$0FA0,$0FA0,$0FB0,$0FB0,$0FB0,$0FC0,$0FC0,$0FC0,$0FD0
	dc.w $0FD0,$0FD0,$0FE0,$0FE0,$0FF0
;------------------------------------
Spr1Part3:	dc.w	0,0
	incbin	'sphere/text.spr1'
	dc.l	0
Spr2Part3:	dc.w	0,0
	incbin	'sphere/text.spr2'
	dc.l	0
Spr3Part3:	dc.w	0,0
	incbin	'sphere/text.spr3'
	dc.l	0
Spr4Part3:	dc.w	0,0
	incbin	'sphere/text.spr4'
	dc.l	0
Spr5Part3:	dc.w	0,0
	incbin	'sphere/text.spr5'
	dc.l	0
Spr6Part3:	dc.w	0,0
	incbin	'sphere/text.spr6'
	dc.l	0
Spr7Part3:	dc.w	0,0
	incbin	'sphere/text.spr7'
	dc.l	0
Spr8Part3:	dc.w	0,0
	incbin	'sphere/text.spr8'
	dc.l	0

SprPos1Part3:	dc.w	450,50
SprPos2Part3:	dc.w	450+16,50
SprPos3Part3:	dc.w	450+16*2,50
SprPos4Part3:	dc.w	450+16*3,50
SprPos5Part3:	dc.w	450+16*4,50
SprPos6Part3:	dc.w	450+16*5,50
SprPos7Part3:	dc.w	450+16*6,50
SprPos8Part3:	dc.w	450+16*7,50

SprMPart3:
	DC.W	$FFFB,$FFFB,$FFFB,$FFFB,$FFFB,$FFFB,$FFFB,$FFFB,$FFFB,$FFFB
	DC.W	$FFFB,$FFFB,$FFFC,$FFFC,$FFFC,$FFFC,$FFFC,$FFFC,$FFFC,$FFFC
	DC.W	$FFFC,$FFFC,$FFFD,$FFFD,$FFFD,$FFFD,$FFFD,$FFFD,$FFFE,$FFFE
	DC.W	$FFFE,$FFFE,$FFFE,$FFFE,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF
	DCB.W	90,0
	DC.W	$0000,$0000,$0000,$0000,$0000,$0001,$0001,$0001,$0001,$0001
	DC.W	$0001,$0002,$0002,$0002,$0002,$0002,$0002,$0003,$0003,$0003
	DC.W	$0003,$0003,$0003,$0004,$0004,$0004,$0004,$0004,$0004,$0004
	DC.W	$0004,$0004,$0004,$0005,$0005,$0005,$0005,$0005,$0005,$0005
	DC.W	$0005,$0005,$0005,$0005,$0005,0,0

SprMPosPart3:	dc.l	SprMPart3
;------------------------------------
sintabPart3:	DC.W	$0000,$023A,$0475,$06AF,$08E8,$0B21,$0D59,$0F90,$11C6,$13FA
	DC.W	$162D,$185E,$1A8D,$1CBA,$1EE5,$210E,$2334,$2557,$2777,$2995
	DC.W	$2BAF,$2DC5,$2FD8,$31E8,$33F3,$35FB,$37FE,$39FD,$3BF7,$3DED
	DC.W	$3FDE,$41CA,$43B1,$4593,$476F,$4945,$4B16,$4CE2,$4EA7,$5066
	DC.W	$521F,$53D1,$557D,$5723,$58C1,$5A59,$5BE9,$5D73,$5EF5,$6070
	DC.W	$61E4,$634F,$64B4,$6610,$6764,$68B1,$69F5,$6B31,$6C64,$6D90
	DC.W	$6EB2,$6FCD,$70DE,$71E7,$72E7,$73DD,$74CB,$75B0,$768C,$775F
	DC.W	$7828,$78E8,$799E,$7A4B,$7AEF,$7B89,$7C1A,$7CA1,$7D1E,$7D91
	DC.W	$7DFB,$7E5B,$7EB1,$7EFD,$7F40,$7F78,$7FA7,$7FCC,$7FE6,$7FF7
costabPart3:	DC.W	$7FFE,$7FFB,$7FEE,$7FD8,$7FB7,$7F8C,$7F58,$7F19,$7ED1,$7E7F
	DC.W	$7E23,$7DBD,$7D4D,$7CD4,$7C51,$7BC4,$7B2E,$7A8E,$79E5,$7932
	DC.W	$7876,$77B0,$76E2,$760A,$7528,$743E,$734B,$724E,$7149,$703B
	DC.W	$6F25,$6E05,$6CDD,$6BAD,$6A74,$6934,$67EA,$6699,$6540,$63DF
	DC.W	$6276,$6106,$5F8E,$5E0F,$5C88,$5AFA,$5965,$57CA,$5627,$547E
	DC.W	$52CE,$5117,$4F5B,$4D98,$4BCF,$4A01,$482C,$4652,$4473,$428E
	DC.W	$40A4,$3EB5,$3CC1,$3AC8,$38CB,$36CA,$34C4,$32BA,$30AC,$2E9B
	DC.W	$2C85,$2A6D,$2851,$2632,$240F,$21EB,$1FC3,$1D99,$1B6D,$193E
	DC.W	$170E,$14DC,$12A8,$1073,$0E3C,$0C05,$09CC,$0793,$0559,$031F
	DC.W	$00E4,$FEAB,$FC70,$FA36,$F7FC,$F5C3,$F38B,$F153,$EF1D,$ECE8
	DC.W	$EAB4,$E883,$E653,$E425,$E1F9,$DFCF,$DDA8,$DB84,$D962,$D744
	DC.W	$D529,$D311,$D0FC,$CEEB,$CCDE,$CAD5,$C8D0,$C6CF,$C4D3,$C2DB
	DC.W	$C0E9,$BEFB,$BD12,$BB2E,$B94F,$B777,$B5A3,$B3D6,$B20E,$B04D
	DC.W	$AE91,$ACDC,$AB2D,$A985,$A7E4,$A64A,$A4B6,$A32A,$A1A5,$A027
	DC.W	$9EB0,$9D41,$9BDA,$9A7B,$9923,$97D4,$968C,$954D,$9416,$92E7
	DC.W	$91C1,$90A3,$8F8F,$8E82,$8D7F,$8C84,$8B93,$8AAA,$89CB,$88F5
	DC.W	$8828,$8764,$86AA,$85F9,$8551,$84B3,$841F,$8394,$8313,$829C
	DC.W	$822E,$81CA,$8170,$8120,$80DA,$809D,$806B,$8042,$8023,$800E
	DC.W	$8003,$8002,$800B,$801E,$803B,$8062,$8092,$80CD,$8111,$815F
	DC.W	$81B7,$8219,$8285,$82FA,$8379,$8402,$8495,$8531,$85D6,$8685
	DC.W	$873E,$87FF,$88CA,$899F,$8A7C,$8B63,$8C53,$8D4C,$8E4D,$8F58
	DC.W	$906B,$9187,$92AB,$93D8,$950D,$964B,$9791,$98DF,$9A35,$9B93
	DC.W	$9CF8,$9E66,$9FDB,$A157,$A2DB,$A466,$A5F8,$A791,$A931,$AAD7
	DC.W	$AC85,$AE38,$AFF2,$B1B3,$B379,$B546,$B718,$B8EF,$BACD,$BCB0
	DC.W	$BE97,$C084,$C276,$C46D,$C668,$C868,$CA6C,$CC75,$CE81,$D091
	DC.W	$D2A5,$D4BC,$D6D7,$D8F5,$DB16,$DD39,$DF60,$E189,$E3B4,$E5E2
	DC.W	$E811,$EA43,$EC76,$EEAB,$F0E1,$F318,$F550,$F789,$F9C3,$FBFD
	DC.W	$FE37,$0071,$02AC,$04E6,$0720,$0959,$0B92,$0DCA,$1001,$1236
	DC.W	$146A,$169D,$18CD,$1AFC,$1D29,$1F53,$217B,$23A1,$25C4,$27E3
	DC.W	$2A00,$2C19,$2E2F,$3042,$3250,$345B,$3662,$3864,$3A62,$3C5B
	DC.W	$3E50,$4040,$422B,$4411,$45F2,$47CD,$49A2,$4B72,$4D3C,$4F00
	DC.W	$50BE,$5276,$5427,$55D2,$5776,$5913,$5AA9,$5C38,$5DC0,$5F41
	DC.W	$60BB,$622D,$6397,$64F9,$6654,$67A7,$68F2,$6A34,$6B6F,$6CA1
	DC.W	$6DCA,$6EEB,$7004,$7113,$721A,$7318,$740E,$74FA,$75DD,$76B7
	DC.W	$7787,$784F,$790D,$79C2,$7A6D,$7B0F,$7BA7,$7C35,$7CBA,$7D35
	DC.W	$7DA7,$7E0F,$7E6D,$7EC1,$7F0B,$7F4C,$7F82,$7FAF,$7FD2,$7FEB

sintab2Part3:
	DC.W	$0002,$0007,$000B,$0010,$0014,$0018,$001D,$0021,$0026,$002A
	DC.W	$002E,$0033,$0037,$003B,$0040,$0044,$0048,$004D,$0051,$0055
	DC.W	$0059,$005D,$0061,$0065,$006A,$006E,$0072,$0076,$0079,$007D
	DC.W	$0081,$0085,$0089,$008C,$0090,$0094,$0097,$009B,$009E,$00A2
	DC.W	$00A5,$00A9,$00AC,$00AF,$00B2,$00B6,$00B9,$00BC,$00BF,$00C2
	DC.W	$00C4,$00C7,$00CA,$00CD,$00CF,$00D2,$00D4,$00D7,$00D9,$00DB
	DC.W	$00DE,$00E0,$00E2,$00E4,$00E6,$00E8,$00EA,$00EB,$00ED,$00EF
	DC.W	$00F0,$00F2,$00F3,$00F4,$00F6,$00F7,$00F8,$00F9,$00FA,$00FB
	DC.W	$00FB,$00FC,$00FD,$00FD,$00FE,$00FE,$00FE,$00FF,$00FF,$00FF
costab2Part3:
	DC.W	$00FF,$00FF,$00FF,$00FF,$00FE,$00FE,$00FD,$00FD,$00FC,$00FC
	DC.W	$00FB,$00FA,$00F9,$00F8,$00F7,$00F6,$00F5,$00F4,$00F2,$00F1
	DC.W	$00EF,$00EE,$00EC,$00EA,$00E9,$00E7,$00E5,$00E3,$00E1,$00DF
	DC.W	$00DC,$00DA,$00D8,$00D5,$00D3,$00D0,$00CE,$00CB,$00C8,$00C6
	DC.W	$00C3,$00C0,$00BD,$00BA,$00B7,$00B4,$00B1,$00AD,$00AA,$00A7
	DC.W	$00A3,$00A0,$009C,$0099,$0095,$0092,$008E,$008A,$0086,$0083
	DC.W	$007F,$007B,$0077,$0073,$006F,$006B,$0067,$0063,$005F,$005B
	DC.W	$0057,$0052,$004E,$004A,$0046,$0041,$003D,$0039,$0034,$0030
	DC.W	$002C,$0027,$0023,$001F,$001A,$0016,$0011,$000D,$0008,$0004
	DC.W	$0000,$FFFB,$FFF7,$FFF2,$FFEE,$FFE9,$FFE5,$FFE1,$FFDC,$FFD8
	DC.W	$FFD3,$FFCF,$FFCB,$FFC6,$FFC2,$FFBE,$FFB9,$FFB5,$FFB1,$FFAD
	DC.W	$FFA9,$FFA4,$FFA0,$FF9C,$FF98,$FF94,$FF90,$FF8C,$FF88,$FF84
	DC.W	$FF80,$FF7D,$FF79,$FF75,$FF71,$FF6E,$FF6A,$FF66,$FF63,$FF5F
	DC.W	$FF5C,$FF59,$FF55,$FF52,$FF4F,$FF4C,$FF49,$FF46,$FF43,$FF40
	DC.W	$FF3D,$FF3A,$FF37,$FF34,$FF32,$FF2F,$FF2D,$FF2A,$FF28,$FF25
	DC.W	$FF23,$FF21,$FF1F,$FF1D,$FF1B,$FF19,$FF17,$FF15,$FF14,$FF12
	DC.W	$FF10,$FF0F,$FF0E,$FF0C,$FF0B,$FF0A,$FF09,$FF08,$FF07,$FF06
	DC.W	$FF05,$FF04,$FF04,$FF03,$FF02,$FF02,$FF02,$FF01,$FF01,$FF01
	DC.W	$FF01,$FF01,$FF01,$FF01,$FF02,$FF02,$FF02,$FF03,$FF03,$FF04
	DC.W	$FF05,$FF06,$FF06,$FF07,$FF08,$FF0A,$FF0B,$FF0C,$FF0D,$FF0F
	DC.W	$FF10,$FF12,$FF13,$FF15,$FF17,$FF19,$FF1A,$FF1C,$FF1F,$FF21
	DC.W	$FF23,$FF25,$FF27,$FF2A,$FF2C,$FF2F,$FF31,$FF34,$FF37,$FF39
	DC.W	$FF3C,$FF3F,$FF42,$FF45,$FF48,$FF4B,$FF4E,$FF51,$FF55,$FF58
	DC.W	$FF5B,$FF5F,$FF62,$FF66,$FF69,$FF6D,$FF71,$FF74,$FF78,$FF7C
	DC.W	$FF80,$FF83,$FF87,$FF8B,$FF8F,$FF93,$FF97,$FF9B,$FF9F,$FFA4
	DC.W	$FFA8,$FFAC,$FFB0,$FFB4,$FFB9,$FFBD,$FFC1,$FFC5,$FFCA,$FFCE
	DC.W	$FFD3,$FFD7,$FFDB,$FFE0,$FFE4,$FFE8,$FFED,$FFF1,$FFF6,$FFFA
	DC.W	$FFFF,$0003,$0008,$000C,$0010,$0015,$0019,$001E,$0022,$0026
	DC.W	$002B,$002F,$0034,$0038,$003C,$0041,$0045,$0049,$004D,$0052
	DC.W	$0056,$005A,$005E,$0062,$0066,$006A,$006E,$0072,$0076,$007A
	DC.W	$007E,$0082,$0086,$0089,$008D,$0091,$0095,$0098,$009C,$009F
	DC.W	$00A3,$00A6,$00A9,$00AD,$00B0,$00B3,$00B6,$00B9,$00BC,$00BF
	DC.W	$00C2,$00C5,$00C8,$00CB,$00CD,$00D0,$00D2,$00D5,$00D7,$00DA
	DC.W	$00DC,$00DE,$00E0,$00E2,$00E4,$00E6,$00E8,$00EA,$00EC,$00ED
	DC.W	$00EF,$00F0,$00F2,$00F3,$00F5,$00F6,$00F7,$00F8,$00F9,$00FA
	DC.W	$00FB,$00FC,$00FC,$00FD,$00FD,$00FE,$00FE,$00FF,$00FF,$00FF


;---------------------------------------------------------
PerspectivePart3:
  DC.W  11096, 11103, 11110, 11118, 11125, 11132, 11140, 11147, 11155, 11162
  DC.W  11169, 11177, 11184, 11192, 11199, 11207, 11214, 11222, 11229, 11237
  DC.W  11244, 11252, 11259, 11267, 11275, 11282, 11290, 11297, 11305, 11313
  DC.W  11320, 11328, 11335, 11343, 11351, 11358, 11366, 11374, 11382, 11389
  DC.W  11397, 11405, 11413, 11420, 11428, 11436, 11444, 11452, 11459, 11467
  DC.W  11475, 11483, 11491, 11499, 11507, 11514, 11522, 11530, 11538, 11546
  DC.W  11554, 11562, 11570, 11578, 11586, 11594, 11602, 11610, 11618, 11626
  DC.W  11634, 11642, 11650, 11658, 11667, 11675, 11683, 11691, 11699, 11707
  DC.W  11715, 11724, 11732, 11740, 11748, 11756, 11765, 11773, 11781, 11790
  DC.W  11798, 11806, 11814, 11823, 11831, 11839, 11848, 11856, 11865, 11873
  DC.W  11881, 11890, 11898, 11907, 11915, 11924, 11932, 11941, 11949, 11958
  DC.W  11966, 11975, 11983, 11992, 12000, 12009, 12018, 12026, 12035, 12043
  DC.W  12052, 12061, 12069, 12078, 12087, 12096, 12104, 12113, 12122, 12131
  DC.W  12139, 12148, 12157, 12166, 12175, 12183, 12192, 12201, 12210, 12219
  DC.W  12228, 12237, 12246, 12255, 12264, 12273, 12282, 12291, 12300, 12309
  DC.W  12318, 12327, 12336, 12345, 12354, 12363, 12372, 12381, 12390, 12400
  DC.W  12409, 12418, 12427, 12436, 12446, 12455, 12464, 12473, 12483, 12492
  DC.W  12501, 12510, 12520, 12529, 12539, 12548, 12557, 12567, 12576, 12586
  DC.W  12595, 12604, 12614, 12623, 12633, 12642, 12652, 12662, 12671, 12681
  DC.W  12690, 12700, 12710, 12719, 12729, 12738, 12748, 12758, 12768, 12777
  DC.W  12787, 12797, 12807, 12816, 12826, 12836, 12846, 12856, 12865, 12875
  DC.W  12885, 12895, 12905, 12915, 12925, 12935, 12945, 12955, 12965, 12975
  DC.W  12985, 12995, 13005, 13015, 13025, 13035, 13046, 13056, 13066, 13076
  DC.W  13086, 13096, 13107, 13117, 13127, 13137, 13148, 13158, 13168, 13179
  DC.W  13189, 13200, 13210, 13220, 13231, 13241, 13252, 13262, 13273, 13283
  DC.W  13294, 13304, 13315, 13325, 13336, 13347, 13357, 13368, 13378, 13389
  DC.W  13400, 13411, 13421, 13432, 13443, 13454, 13464, 13475, 13486, 13497
  DC.W  13508, 13519, 13530, 13540, 13551, 13562, 13573, 13584, 13595, 13606
  DC.W  13617, 13628, 13640, 13651, 13662, 13673, 13684, 13695, 13706, 13718
  DC.W  13729, 13740, 13751, 13763, 13774, 13785, 13797, 13808, 13819, 13831
  DC.W  13842, 13854, 13865, 13876, 13888, 13899, 13911, 13923, 13934, 13946
  DC.W  13957, 13969, 13981, 13992, 14004, 14016, 14027, 14039, 14051, 14063
  DC.W  14074, 14086, 14098, 14110, 14122, 14134, 14146, 14157, 14169, 14181
  DC.W  14193, 14205, 14217, 14230, 14242, 14254, 14266, 14278, 14290, 14302
  DC.W  14315, 14327, 14339, 14351, 14364, 14376, 14388, 14401, 14413, 14425
  DC.W  14438, 14450, 14463, 14475, 14488, 14500, 14513, 14525, 14538, 14550
  DC.W  14563, 14576, 14588, 14601, 14614, 14627, 14639, 14652, 14665, 14678
  DC.W  14691, 14703, 14716, 14729, 14742, 14755, 14768, 14781, 14794, 14807
  DC.W  14820, 14833, 14847, 14860, 14873, 14886, 14899, 14913, 14926, 14939
  DC.W  14952, 14966, 14979, 14993, 15006, 15019, 15033, 15046, 15060, 15073
  DC.W  15087, 15101, 15114, 15128, 15141, 15155, 15169, 15183, 15196, 15210
  DC.W  15224, 15238, 15252, 15265, 15279, 15293, 15307, 15321, 15335, 15349
  DC.W  15363, 15377, 15391, 15406, 15420, 15434, 15448, 15462, 15477, 15491
  DC.W  15505, 15520, 15534, 15548, 15563, 15577, 15592, 15606, 15621, 15635
  DC.W  15650, 15665, 15679, 15694, 15709, 15723, 15738, 15753, 15768, 15782
  DC.W  15797, 15812, 15827, 15842, 15857, 15872, 15887, 15902, 15917, 15932
  DC.W  15947, 15963, 15978, 15993, 16008, 16024, 16039, 16054, 16070, 16085
  DC.W  16100, 16116, 16131, 16147, 16163, 16178, 16194, 16209, 16225, 16241
  DC.W  16256, 16272, 16288, 16304, 16320, 16336, 16352, 16368, 16384, 16400
  DC.W  16416, 16432, 16448, 16464, 16480, 16496, 16513, 16529, 16545, 16561
  DC.W  16578, 16594, 16611, 16627, 16644, 16660, 16677, 16693, 16710, 16727
  DC.W  16743, 16760, 16777
;---------------------------------------------------------
		dcb.b	40,0
Screen1Part3:	dcb.b	40*256,0
Screen2Part3:	dcb.b	40*256,0
Screen3Part3:	dcb.b	40*256,0
Screen4Part3:	dcb.b	40*256,0
;************************************************
;************************************************
;************************************************
	include	'tbsd:trackerpackerreplayv3.1.s'

module:	incbin	'tunnel/tunnel.tp3'
